/*
 * Decompiled with CFR 0.152.
 */
package gnu.rfb;

import gnu.rfb.PixelFormat;
import gnu.rfb.Rect;
import gnu.rfb.RectLibrary;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;

public class RectFont
extends RectLibrary {
    private Dimension charSize = new Dimension();
    private PixelFormat pixelFormat;
    private DirectColorModel colorModel;

    public RectFont(Font font, Dimension charSize, char[] chars, PixelFormat pixelFormat, int encoding, DirectColorModel colorModel) {
        this.init(font, charSize, chars, pixelFormat, encoding, colorModel);
    }

    public RectFont(Font font, Dimension charSize, PixelFormat pixelFormat, int encoding, DirectColorModel colorModel) {
        char[] chars = new char[256];
        int c = 0;
        while (c < chars.length) {
            chars[c] = (char)c;
            ++c;
        }
        this.init(font, charSize, chars, pixelFormat, encoding, colorModel);
    }

    public RectFont(Font font, Dimension charSize, PixelFormat pixelFormat, int encoding) {
        this(font, charSize, pixelFormat, encoding, new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, true, 3));
    }

    public RectFont(Dimension charSize, PixelFormat pixelFormat, int encoding) {
        this(new Font("monospaced", 0, charSize.height), charSize, pixelFormat, encoding);
    }

    public DirectColorModel getDirectColorModel() {
        return this.colorModel;
    }

    public Rect getRect(char c) {
        return super.getRect(c);
    }

    public Rect getRect(char c, int originX, int originY) {
        return super.getRect(c, originX, originY);
    }

    public Rect[] getRects(String string, int originX, int originY) {
        int length = string.length();
        Rect[] rects = new Rect[length];
        int i = 0;
        while (i < length) {
            rects[i] = this.getRect(string.charAt(i), originX, originY);
            originX += this.charSize.width;
            ++i;
        }
        return rects;
    }

    public Rect[] getRects(char[] chars, int offset, int length, int originX, int originY, int xLimit) {
        Rect[] rects = new Rect[length];
        int x = originX;
        int y = originY;
        int i = offset;
        while (i < offset + length) {
            rects[i] = this.getRect(chars[i], x, y);
            if ((x += this.charSize.width) >= xLimit) {
                x = originX;
                y += this.charSize.height;
            }
            ++i;
        }
        return rects;
    }

    public Rect[] getRects(char[] chars, boolean[] valid, int offset, int length, int originX, int originY, int xLimit) {
        Vector<Rect> rects = new Vector<Rect>();
        int x = originX;
        int y = originY;
        int i = offset;
        while (i < offset + length) {
            if (!valid[i]) {
                Rect rect = this.getRect(chars[i], x, y);
                if (rect != null) {
                    rects.addElement(rect);
                }
                valid[i] = true;
            }
            if ((x += this.charSize.width) >= xLimit) {
                x = originX;
                y += this.charSize.height;
            }
            ++i;
        }
        Rect[] array = new Rect[rects.size()];
        rects.toArray(array);
        return array;
    }

    public void putRect(char c, Rect rect) {
        super.putRect(c, rect);
    }

    public Dimension getCharSize() {
        return this.charSize;
    }

    private void init(Font font, Dimension charSize, char[] chars, PixelFormat pixelFormat, int encoding, DirectColorModel colorModel) {
        this.charSize = charSize;
        this.pixelFormat = pixelFormat;
        this.colorModel = colorModel;
        int[] pixels = new int[charSize.width * charSize.height];
        DataBufferInt dataBuffer = new DataBufferInt(pixels, pixels.length);
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, charSize.width, charSize.height, colorModel.getMasks());
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
        BufferedImage image = new BufferedImage(colorModel, raster, true, null);
        Graphics g = image.getGraphics();
        g.setFont(font);
        g.setColor(Color.yellow);
        FontMetrics fontMetrics = g.getFontMetrics();
        int baseline = charSize.height - fontMetrics.getDescent();
        int i = 0;
        while (i < chars.length) {
            if (font.canDisplay(chars[i])) {
                int ii = 0;
                while (ii < pixels.length) {
                    pixels[ii] = 0;
                    ++ii;
                }
                g.drawChars(chars, i, 1, 0, baseline);
                Rect rect = Rect.encode(encoding, pixels, pixelFormat, charSize.width, 0, 0, charSize.width, charSize.height);
                this.putRect(chars[i], rect);
            }
            ++i;
        }
        this.putRect(0, this.getRect(' '));
        this.putDefaultRect(this.getRect('?'));
    }
}

