/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instruction_INCDEC_GRP4
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = false;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte addressByte = 0;
    byte[] sourceValue = new byte[2];
    byte[] oldSource = new byte[2];
    byte registerHighLow = 0;
    private static final Logger logger = Logger.getLogger(Instruction_INCDEC_GRP4.class.getName());

    public Instruction_INCDEC_GRP4() {
    }

    public Instruction_INCDEC_GRP4(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.sourceValue = new byte[2];
        switch ((this.addressByte & 0x38) >> 3) {
            case 0: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 1;
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                System.arraycopy(this.sourceValue, 0, this.oldSource, 0, this.sourceValue.length);
                byte by = this.registerHighLow;
                this.sourceValue[by] = (byte)(this.sourceValue[by] + 1);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                this.cpu.flags[4] = Util.test_AF_ADD(this.oldSource[this.registerHighLow], this.sourceValue[this.registerHighLow]);
                this.cpu.flags[11] = Util.test_OF_ADD(this.oldSource[this.registerHighLow], (byte)1, this.sourceValue[this.registerHighLow], 0);
                this.cpu.flags[6] = this.sourceValue[this.registerHighLow] == 0;
                this.cpu.flags[7] = this.sourceValue[this.registerHighLow] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[this.registerHighLow]);
                break;
            }
            case 1: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 1;
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                System.arraycopy(this.sourceValue, 0, this.oldSource, 0, this.sourceValue.length);
                byte by = this.registerHighLow;
                this.sourceValue[by] = (byte)(this.sourceValue[by] - 1);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                this.cpu.flags[4] = Util.test_AF_SUB(this.oldSource[this.registerHighLow], this.sourceValue[this.registerHighLow]);
                this.cpu.flags[11] = Util.test_OF_SUB(this.oldSource[this.registerHighLow], (byte)1, this.sourceValue[this.registerHighLow], 0);
                this.cpu.flags[6] = this.sourceValue[this.registerHighLow] == 0;
                this.cpu.flags[7] = this.sourceValue[this.registerHighLow] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[this.registerHighLow]);
                break;
            }
            default: {
                logger.log(Level.SEVERE, (Object)((Object)this.cpu.getType()) + " -> Instruction INCDEC_GRP4 (0xFE): no group instruction match.");
            }
        }
    }
}

