/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;

public class Instruction_MOV_GbEb
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = false;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte sourceValue = 0;
    byte[] destinationRegister = new byte[2];
    byte registerHighLow = 0;

    public Instruction_MOV_GbEb() {
    }

    public Instruction_MOV_GbEb(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        if ((this.addressByte >> 6 & 3) == 3) {
            this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
            this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7)[this.registerHighLow];
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.sourceValue = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        }
        this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        this.registerHighLow = (this.addressByte & 0x20) >> 5 == 0 ? (byte)1 : 0;
        this.destinationRegister[this.registerHighLow] = this.sourceValue;
    }
}

