/*
 * Decompiled with CFR 0.152.
 */
package gnu.vnc;

import gnu.awt.PixelsOwner;
import gnu.awt.Point;
import gnu.awt.Rectangle;
import gnu.rfb.PixelFormat;
import gnu.rfb.Rect;
import gnu.rfb.server.RFBClient;
import gnu.rfb.server.RFBClients;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class VNCQueue {
    int[] snapshot;
    int scanline;
    Object snapshotSemaphor = new Object();
    private RFBClients clients;

    public VNCQueue(RFBClients clients) {
        this.clients = clients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameBufferUpdate(RFBClient client, boolean incremental, int x, int y, int w, int h) throws IOException {
        if (this.snapshot == null) {
            System.out.println("None:snapshot");
            return;
        }
        Object object = this.snapshotSemaphor;
        synchronized (object) {
            Rect[] rects = incremental ? this.popEncoded(client, x, y, w, h, this.snapshot, this.scanline) : new Rect[]{Rect.encode(client.getPreferredEncoding(), this.snapshot, client.getPixelFormat(), this.scanline, x, y, w, h)};
            client.writeFrameBufferUpdate(rects);
        }
    }

    public Rect[] popEncoded(RFBClient client, int x, int y, int w, int h, int[] pixels, int scanline) throws IOException {
        return this.popEncoded(client, new Rectangle(x, y, w, h), pixels, scanline);
    }

    public Rect[] popEncoded(RFBClient client, Rectangle clip, int[] pixels, int scanline) throws IOException {
        Rectangle[] rectangles = this.pop(client, clip);
        PixelFormat pixelFormat = client.getPixelFormat();
        int encoding = client.getPreferredEncoding();
        Rect[] rects = new Rect[rectangles.length];
        int i = 0;
        while (i < rectangles.length) {
            rects[i] = Rect.encode(encoding, pixels, pixelFormat, scanline, rectangles[i].x, rectangles[i].y, rectangles[i].width, rectangles[i].height);
            ++i;
        }
        if (rects.length == 0) {
            throw new IOException("rects.length == 0, encoding an empty raw rect would cause blue screen on the official VNC-client (not a Windows(tm)-BlueScreen(tm)).");
        }
        return rects;
    }

    public void addRectangle(int x, int y, int w, int h, PixelsOwner pixelsOwner) {
        this.addRectangle(new Rectangle(x, y, w, h), pixelsOwner);
    }

    public void addRectangle(Rectangle addition, PixelsOwner pixelsOwner) {
        addition = new Rectangle(0, 0, pixelsOwner.getPixelWidth(), pixelsOwner.getPixelHeight()).intersection(addition);
        Enumeration e = this.clients.elements();
        while (e.hasMoreElements()) {
            Vector queue = this.getQueue((RFBClient)e.nextElement());
            this.addRectangle(queue, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRectangle(PixelsOwner pixelsOwner) {
        Rectangle addition = new Rectangle(0, 0, pixelsOwner.getPixelWidth(), pixelsOwner.getPixelHeight());
        Enumeration e = this.clients.elements();
        while (e.hasMoreElements()) {
            Vector queue;
            Vector vector = queue = this.getQueue((RFBClient)e.nextElement());
            synchronized (vector) {
                queue.removeAllElements();
                queue.addElement(addition);
            }
        }
    }

    public Rectangle[] pop(RFBClient client, int x, int y, int w, int h) {
        return this.pop(client, new Rectangle(x, y, w, h));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle[] pop(RFBClient client, Rectangle clip) {
        Vector queue = this.getQueue(client);
        Vector<Rectangle> v = new Vector<Rectangle>();
        Vector vector = queue;
        synchronized (vector) {
            Enumeration e = queue.elements();
            while (e.hasMoreElements()) {
                Rectangle r = (Rectangle)e.nextElement();
                if (!clip.contains(r.getLocation()) && !clip.contains(new Point(r.x + r.width, r.y + r.height))) continue;
                queue.removeElement(r);
                v.addElement(r);
                e = queue.elements();
            }
        }
        Rectangle[] array = new Rectangle[v.size()];
        v.toArray(array);
        return array;
    }

    private Vector getQueue(RFBClient client) {
        Vector queue = (Vector)this.clients.getProperty(client, "queue");
        if (queue == null) {
            queue = new Vector();
            this.clients.setProperty(client, "queue", queue);
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRectangle(Vector queue, Rectangle addition) {
        if (addition.width <= 0 || addition.height <= 0) {
            return;
        }
        Vector vector = queue;
        synchronized (vector) {
            Rectangle r;
            Enumeration e = queue.elements();
            while (e.hasMoreElements()) {
                r = (Rectangle)e.nextElement();
                if (!r.contains(addition)) continue;
                return;
            }
            e = queue.elements();
            while (e.hasMoreElements()) {
                r = (Rectangle)e.nextElement();
                if (!addition.contains(r)) continue;
                queue.removeElement(r);
                e = queue.elements();
            }
            Rectangle[] union = null;
            e = queue.elements();
            while (e.hasMoreElements()) {
                r = (Rectangle)e.nextElement();
                if (addition.contains(r.getLocation())) {
                    union = VNCQueue.nonOverlappedUnion(addition, r);
                } else if (r.contains(addition.getLocation())) {
                    union = VNCQueue.nonOverlappedUnion(r, addition);
                }
                if (union == null) continue;
                queue.removeElement(r);
                int i = 0;
                while (i < union.length) {
                    this.addRectangle(queue, union[i]);
                    ++i;
                }
                return;
            }
            queue.addElement(addition);
        }
    }

    private static Rectangle[] nonOverlappedUnion(Rectangle r1, Rectangle r2) {
        Rectangle[] s = null;
        s = r2.y + r2.height <= r1.y + r1.height ? new Rectangle[]{r1, new Rectangle(r1.x + r1.width, r2.y, r2.x + r2.width - r1.x - r1.width, r2.height)} : (r2.x + r2.width <= r1.x + r1.width ? new Rectangle[]{r1, new Rectangle(r2.x, r1.y + r1.height, r2.width, r2.y + r2.height - r1.y - r1.height)} : new Rectangle[]{new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y), new Rectangle(r1.x, r2.y, r2.x + r2.width - r1.x, r1.y + r1.height - r2.y), new Rectangle(r2.x, r1.y + r1.height, r2.width, r2.y + r2.height - r1.y - r1.height)});
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeSnapshot(PixelsOwner p) {
        if (p == null || p.getPixels() == null) {
            System.out.println("Empty:" + p);
            return;
        }
        Object object = this.snapshotSemaphor;
        synchronized (object) {
            if (this.snapshot == null) {
                this.snapshot = new int[p.getPixels().length];
            }
            System.arraycopy(p.getPixels(), 0, this.snapshot, 0, p.getPixels().length);
            this.scanline = p.getPixelWidth();
            Enumeration enumerate = this.clients.elements();
            while (enumerate.hasMoreElements()) {
                ((RFBClient)enumerate.nextElement()).setUpdateIsAvailable(true);
            }
        }
    }
}

