/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.clock.Clock;
import dioscuri.module.cpu32.AbstractHardwareComponent;
import dioscuri.module.cpu32.EPROMMemory;
import dioscuri.module.cpu32.HardwareComponent;
import dioscuri.module.cpu32.IOPortCapable;
import dioscuri.module.cpu32.IOPortHandler;
import dioscuri.module.cpu32.PhysicalAddressSpace;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;

public class VGABIOS
extends AbstractHardwareComponent
implements IOPortCapable {
    private byte[] imageData;
    private boolean ioportRegistered;
    private boolean loaded;
    private Clock clock;

    public VGABIOS(byte[] byArray, Clock clock) {
        this.loaded = false;
        this.ioportRegistered = false;
        this.clock = clock;
        this.imageData = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.imageData, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VGABIOS(String string) throws IOException {
        InputStream inputStream = null;
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = this.getClass().getResourceAsStream("/" + string);
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write((byte)n);
            }
            this.imageData = byteArrayOutputStream.toByteArray();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void dumpState(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.imageData.length);
        dataOutput.write(this.imageData);
    }

    @Override
    public void loadState(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        this.imageData = new byte[n];
        dataInput.readFully(this.imageData, 0, n);
    }

    @Override
    public int[] ioPortsRequested() {
        return new int[]{1280, 1281, 1282, 1283};
    }

    @Override
    public int ioPortReadByte(int n) {
        return 255;
    }

    @Override
    public int ioPortReadWord(int n) {
        return 65535;
    }

    @Override
    public int ioPortReadLong(int n) {
        return -1;
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        switch (n) {
            case 1280: 
            case 1283: {
                try {
                    System.out.print(new String(new byte[]{(byte)n2}, "US-ASCII"));
                }
                catch (Exception exception) {
                    System.out.print(new String(new byte[]{(byte)n2}));
                }
                break;
            }
        }
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        switch (n) {
            case 1281: 
            case 1282: {
                System.err.println("VGA-BIOS panic line " + n2);
            }
        }
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
    }

    public void load(PhysicalAddressSpace physicalAddressSpace) {
        int n = 4096;
        int n2 = ((this.imageData.length - 1) / n + 1) * n;
        for (int i = 0; i < n2 / n; ++i) {
            EPROMMemory ePROMMemory = new EPROMMemory(n, 0, this.imageData, i * n, n, this.clock);
            physicalAddressSpace.allocateMemory(786432 + i * n, ePROMMemory);
        }
    }

    public byte[] getImage() {
        return (byte[])this.imageData.clone();
    }

    @Override
    public boolean updated() {
        return this.loaded && this.ioportRegistered;
    }

    @Override
    public void updateComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PhysicalAddressSpace && hardwareComponent.updated()) {
            this.load((PhysicalAddressSpace)hardwareComponent);
            this.loaded = true;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.updated()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    @Override
    public boolean initialised() {
        return this.loaded && this.ioportRegistered;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PhysicalAddressSpace && hardwareComponent.initialised()) {
            this.load((PhysicalAddressSpace)hardwareComponent);
            this.loaded = true;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    @Override
    public boolean reset() {
        this.ioportRegistered = false;
        this.loaded = false;
        return true;
    }
}

