/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_XOR_EvGv
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] eSourceValue = new byte[2];
    byte[] destinationRegister = new byte[2];
    byte[] eDestinationRegister = new byte[2];
    byte[] logicalXORResult = new byte[2];

    public Instruction_XOR_EvGv() {
    }

    public Instruction_XOR_EvGv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.cpu.flags[11] = false;
        this.cpu.flags[0] = false;
        this.cpu.flags[4] = false;
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        if (this.cpu.doubleWord) {
            this.eSourceValue = this.cpu.decodeExtraRegister((this.addressByte & 0x38) >> 3);
        }
        if ((this.addressByte >> 6 & 3) == 3) {
            this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
            if (this.cpu.doubleWord) {
                this.eDestinationRegister = this.cpu.decodeExtraRegister(this.addressByte & 7);
            }
            this.destinationRegister[0] = (byte)(this.destinationRegister[0] ^ this.sourceValue[0]);
            this.destinationRegister[1] = (byte)(this.destinationRegister[1] ^ this.sourceValue[1]);
            if (this.cpu.doubleWord) {
                this.eDestinationRegister[0] = (byte)(this.eDestinationRegister[0] ^ this.eSourceValue[0]);
                this.eDestinationRegister[1] = (byte)(this.eDestinationRegister[1] ^ this.eSourceValue[1]);
            }
            if (!this.cpu.doubleWord) {
                this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
                this.cpu.flags[7] = this.destinationRegister[0] < 0;
            } else {
                this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0 && this.eDestinationRegister[0] == 0 && this.eDestinationRegister[1] == 0;
                this.cpu.flags[7] = this.eDestinationRegister[0] < 0;
            }
            this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            byte[] byArray = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
            this.logicalXORResult[0] = (byte)(byArray[0] ^ this.sourceValue[0]);
            this.logicalXORResult[1] = (byte)(byArray[1] ^ this.sourceValue[1]);
            this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.logicalXORResult);
            this.cpu.flags[6] = this.logicalXORResult[0] == 0 && this.logicalXORResult[1] == 0;
            boolean bl = this.cpu.flags[7] = this.logicalXORResult[0] < 0;
            if (this.cpu.doubleWord) {
                this.memoryReferenceLocation = Util.addWords(this.memoryReferenceLocation, new byte[]{0, 2}, 0);
                byArray = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.logicalXORResult[0] = (byte)(byArray[0] ^ this.eSourceValue[0]);
                this.logicalXORResult[1] = (byte)(byArray[1] ^ this.eSourceValue[1]);
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.logicalXORResult);
                this.cpu.flags[6] = this.cpu.flags[6] && this.logicalXORResult[0] == 0 && this.logicalXORResult[1] == 0;
                this.cpu.flags[7] = this.logicalXORResult[0] < 0;
            }
            this.cpu.flags[2] = Util.checkParityOfByte(this.logicalXORResult[1]);
        }
    }
}

