/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

public class ModeSwitchException
extends RuntimeException {
    public static final int REAL_MODE = 0;
    public static final int PROTECTED_MODE = 1;
    public static final int VIRTUAL8086_MODE = 2;
    public static final ModeSwitchException PROTECTED_MODE_EXCEPTION = new ModeSwitchException(1);
    public static final ModeSwitchException REAL_MODE_EXCEPTION = new ModeSwitchException(0);
    public static final ModeSwitchException VIRTUAL8086_MODE_EXCEPTION = new ModeSwitchException(2);
    private int mode;

    public ModeSwitchException(int n) {
        this.mode = n;
    }

    public int getNewMode() {
        return this.mode;
    }

    @Override
    public String toString() {
        if (this.mode == 0) {
            return "Switched to REAL mode";
        }
        if (this.mode == 1) {
            return "Switched to PROTECTED mode";
        }
        if (this.mode == 2) {
            return "Switched to VIRTUAL 8086 mode";
        }
        return "Switched to unknown mode " + this.mode;
    }
}

