/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.AbstractCodeBlockWrapper;
import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.CodeBlockCompiler;
import dioscuri.module.cpu32.InstructionSource;
import dioscuri.module.cpu32.PriorityDeque;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.ProtectedModeCodeBlock;
import dioscuri.module.cpu32.ProtectedModeUBlock;
import dioscuri.module.cpu32.RealModeCodeBlock;
import dioscuri.module.cpu32.RealModeUBlock;
import dioscuri.module.cpu32.Virtual8086ModeCodeBlock;

public class BackgroundCompiler
implements CodeBlockCompiler {
    private static final int COMPILER_QUEUE_SIZE = 20;
    private static final int COMPILE_REQUEST_THRESHOLD = 64;
    private CodeBlockCompiler immediate;
    private CodeBlockCompiler delayed;
    private CodeBlockCompiler testing;
    private CompilerQueue compilerQueue;
    private boolean running;

    public BackgroundCompiler(CodeBlockCompiler codeBlockCompiler, CodeBlockCompiler codeBlockCompiler2) {
        this.immediate = codeBlockCompiler;
        this.delayed = codeBlockCompiler2;
        this.compilerQueue = new CompilerQueue(20);
        this.running = true;
        new CompilerThread();
    }

    public void stop() {
        this.running = false;
    }

    @Override
    public RealModeCodeBlock getRealModeCodeBlock(InstructionSource instructionSource) {
        RealModeCodeBlock realModeCodeBlock = this.immediate.getRealModeCodeBlock(instructionSource);
        return new RealModeCodeBlockWrapper(realModeCodeBlock);
    }

    @Override
    public ProtectedModeCodeBlock getProtectedModeCodeBlock(InstructionSource instructionSource) {
        ProtectedModeCodeBlock protectedModeCodeBlock = this.immediate.getProtectedModeCodeBlock(instructionSource);
        return new ProtectedModeCodeBlockWrapper(protectedModeCodeBlock);
    }

    @Override
    public Virtual8086ModeCodeBlock getVirtual8086ModeCodeBlock(InstructionSource instructionSource) {
        return this.immediate.getVirtual8086ModeCodeBlock(instructionSource);
    }

    protected void finalize() {
        this.stop();
    }

    static class CompilerQueue {
        private final PriorityDeque queue;
        private final int capacity;
        private final Object lock = new Object();

        CompilerQueue(int n) {
            this.queue = new PriorityDeque(n);
            this.capacity = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addBlock(ExecuteCountingCodeBlockWrapper executeCountingCodeBlockWrapper) {
            Object object = this.lock;
            synchronized (object) {
                this.queue.remove(executeCountingCodeBlockWrapper);
                this.queue.offer(executeCountingCodeBlockWrapper);
                while (this.queue.size() >= this.capacity) {
                    this.queue.pollFirst();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ExecuteCountingCodeBlockWrapper getBlock() {
            Object object = this.lock;
            synchronized (object) {
                return (ExecuteCountingCodeBlockWrapper)this.queue.pollLast();
            }
        }
    }

    class ProtectedModeCodeBlockWrapper
    extends ExecuteCountingCodeBlockWrapper
    implements ProtectedModeCodeBlock {
        public ProtectedModeCodeBlockWrapper(ProtectedModeCodeBlock protectedModeCodeBlock) {
            super(protectedModeCodeBlock);
        }
    }

    class RealModeCodeBlockWrapper
    extends ExecuteCountingCodeBlockWrapper
    implements RealModeCodeBlock {
        public RealModeCodeBlockWrapper(RealModeCodeBlock realModeCodeBlock) {
            super(realModeCodeBlock);
        }
    }

    abstract class ExecuteCountingCodeBlockWrapper
    extends AbstractCodeBlockWrapper
    implements Comparable<ExecuteCountingCodeBlockWrapper> {
        int executeCount;
        int diff;
        int loadedExecuteCount;

        public ExecuteCountingCodeBlockWrapper(CodeBlock codeBlock) {
            super(codeBlock);
        }

        @Override
        public int execute(Processor processor) {
            if ((++this.executeCount & 0x40) == 0) {
                this.loadedExecuteCount = this.executeCount;
                BackgroundCompiler.this.compilerQueue.addBlock(this);
            }
            return super.execute(processor);
        }

        @Override
        public int compareTo(ExecuteCountingCodeBlockWrapper executeCountingCodeBlockWrapper) {
            if (this.loadedExecuteCount > executeCountingCodeBlockWrapper.loadedExecuteCount) {
                return 1;
            }
            return -1;
        }
    }

    class CompilerThread
    extends Thread {
        CompilerThread() {
            super("Background CodeBlock Compiler Task");
            this.start();
            this.setPriority(Math.max(1, Thread.currentThread().getPriority() - 1));
        }

        @Override
        public void run() {
            while (BackgroundCompiler.this.running) {
                ExecuteCountingCodeBlockWrapper executeCountingCodeBlockWrapper = BackgroundCompiler.this.compilerQueue.getBlock();
                try {
                    CodeBlock codeBlock;
                    if (executeCountingCodeBlockWrapper == null) {
                        Thread.sleep(100L);
                        continue;
                    }
                    CodeBlock codeBlock2 = executeCountingCodeBlockWrapper.getBlock();
                    if (codeBlock2 instanceof RealModeUBlock) {
                        codeBlock = BackgroundCompiler.this.delayed.getRealModeCodeBlock(((RealModeUBlock)codeBlock2).getAsInstructionSource());
                        executeCountingCodeBlockWrapper.replaceInOwner(codeBlock);
                        continue;
                    }
                    if (!(codeBlock2 instanceof ProtectedModeUBlock)) continue;
                    codeBlock = BackgroundCompiler.this.delayed.getProtectedModeCodeBlock(((ProtectedModeUBlock)codeBlock2).getAsInstructionSource());
                    executeCountingCodeBlockWrapper.replaceInOwner(codeBlock);
                }
                catch (ClassFormatError classFormatError) {
                    System.out.println(classFormatError);
                    executeCountingCodeBlockWrapper.replaceInOwner(executeCountingCodeBlockWrapper.getBlock());
                }
                catch (IllegalStateException illegalStateException) {
                    executeCountingCodeBlockWrapper.replaceInOwner(executeCountingCodeBlockWrapper.getBlock());
                }
                catch (Throwable throwable) {
                    System.out.println(throwable);
                    executeCountingCodeBlockWrapper.replaceInOwner(executeCountingCodeBlockWrapper.getBlock());
                }
            }
        }
    }
}

