/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.parallelport;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.UnknownPortException;
import dioscuri.exception.WriteOnlyPortException;
import dioscuri.interfaces.Module;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModuleParallelPort;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParallelPort
extends ModuleParallelPort {
    private static final Logger logger = Logger.getLogger(ParallelPort.class.getName());
    private static final int DATA_PORT = 888;
    private static final int STATUS_PORT = 889;
    private static final int CONTROL_PORT = 890;
    private static final int DATA_PORT2 = 632;
    private static final int STATUS_PORT2 = 633;
    private static final int CONTROL_PORT2 = 634;

    public ParallelPort(Emulator emulator) {
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] " + this.getClass().getName() + " -> AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        moduleMotherboard.setIOPort(888, this);
        moduleMotherboard.setIOPort(889, this);
        moduleMotherboard.setIOPort(890, this);
        moduleMotherboard.setIOPort(632, this);
        moduleMotherboard.setIOPort(633, this);
        moduleMotherboard.setIOPort(634, this);
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] AbstractModule has been reset.");
        return true;
    }

    @Override
    public byte getIOPortByte(int n) throws UnknownPortException, WriteOnlyPortException {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IO read from " + n);
        switch (n) {
            case 888: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] returning default value 'available'");
                return -86;
            }
            case 632: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] returning default value 'not available'");
                return -1;
            }
            case 633: 
            case 889: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] returning default value 0x58");
                return 88;
            }
            case 890: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] returning default value 'available'");
                return 12;
            }
            case 634: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] returning default value 'not available'");
                return -1;
            }
        }
        throw new UnknownPortException("[" + (Object)((Object)super.getType()) + "] Unknown I/O port requested");
    }

    @Override
    public void setIOPortByte(int n, byte by) throws UnknownPortException {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IO write to " + n + " = " + by);
        switch (n) {
            case 888: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] OUT on port " + Integer.toHexString(888).toUpperCase() + " received, not handled");
                return;
            }
            case 632: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] OUT on port " + Integer.toHexString(n).toUpperCase() + " received, not handled");
                return;
            }
            case 633: 
            case 889: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] OUT on port " + Integer.toHexString(n).toUpperCase() + " received, not handled");
                return;
            }
            case 890: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] OUT on port " + Integer.toHexString(890).toUpperCase() + " received, not handled");
                return;
            }
            case 634: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] OUT on port " + Integer.toHexString(634).toUpperCase() + " received, not handled");
                return;
            }
        }
        throw new UnknownPortException("[" + (Object)((Object)super.getType()) + "] Unknown I/O port requested");
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, UnknownPortException, WriteOnlyPortException {
        return null;
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException, UnknownPortException {
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, UnknownPortException, WriteOnlyPortException {
        return null;
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException, UnknownPortException {
    }
}

