/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.CPUInstructionException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_ShiftGRP2_Eb1
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = false;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte registerHighLow;
    byte[] sourceValue = new byte[2];
    int tempValue = 0;
    int bitShift = 0;
    int carryBit = 0;
    int newCarryBit = 0;
    byte[] tempResult = new byte[2];

    public Instruction_ShiftGRP2_Eb1() {
    }

    public Instruction_ShiftGRP2_Eb1(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() throws CPUInstructionException {
        this.sourceValue = new byte[2];
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.bitShift = 1;
        switch ((this.addressByte & 0x38) >> 3) {
            case 0: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.carryBit = (this.sourceValue[this.registerHighLow] & 0x80) == 128 ? 1 : 0;
                this.sourceValue[this.registerHighLow] = (byte)(this.sourceValue[this.registerHighLow] << this.bitShift | this.carryBit);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                this.cpu.flags[0] = this.carryBit == 1;
                this.cpu.flags[11] = (this.carryBit ^ ((this.sourceValue[this.registerHighLow] & 0x80) == 128 ? 1 : 0)) == 1;
                break;
            }
            case 1: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.sourceValue[this.registerHighLow] = (byte)(this.sourceValue[this.registerHighLow] >> this.bitShift & 0x7F | this.sourceValue[this.registerHighLow] << 8 - this.bitShift);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                this.cpu.flags[0] = (this.sourceValue[this.registerHighLow] & 0x80) == 128;
                this.cpu.flags[11] = this.cpu.flags[0] ^ (this.sourceValue[this.registerHighLow] & 0x40) == 64;
                break;
            }
            case 2: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.carryBit = this.cpu.flags[0] ? 1 : 0;
                this.newCarryBit = (this.sourceValue[this.registerHighLow] & 0x80) == 128 ? 1 : 0;
                this.sourceValue[this.registerHighLow] = (byte)(this.sourceValue[this.registerHighLow] << this.bitShift | this.carryBit);
                this.carryBit = this.newCarryBit;
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                this.cpu.flags[0] = this.carryBit == 1;
                this.cpu.flags[11] = (this.carryBit ^ ((this.sourceValue[this.registerHighLow] & 0x80) == 128 ? 1 : 0)) == 1;
                break;
            }
            case 3: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.carryBit = this.cpu.flags[0] ? 1 : 0;
                this.newCarryBit = (this.sourceValue[this.registerHighLow] & 1) == 1 ? 1 : 0;
                this.sourceValue[this.registerHighLow] = (byte)(this.sourceValue[this.registerHighLow] >> this.bitShift & 0x7F | this.carryBit << 8 - this.bitShift);
                this.carryBit = this.newCarryBit;
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                this.cpu.flags[0] = this.carryBit == 1;
                this.cpu.flags[11] = ((this.sourceValue[this.registerHighLow] << 1 ^ this.sourceValue[this.registerHighLow]) & 0x80) == 128;
                break;
            }
            case 4: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.cpu.flags[0] = (this.sourceValue[this.registerHighLow] & 0x80) == 128;
                this.sourceValue[this.registerHighLow] = (byte)(this.sourceValue[this.registerHighLow] << this.bitShift);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                this.cpu.flags[4] = false;
                this.cpu.flags[11] = !(this.cpu.flags[0] && this.sourceValue[this.registerHighLow] >> 7 == 1 || !this.cpu.flags[0] && this.sourceValue[this.registerHighLow] >> 7 == 0);
                this.cpu.flags[6] = this.sourceValue[this.registerHighLow] == 0;
                this.cpu.flags[7] = this.sourceValue[this.registerHighLow] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[this.registerHighLow]);
                break;
            }
            case 5: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.cpu.flags[0] = (this.sourceValue[this.registerHighLow] & 1) == 1;
                this.cpu.flags[11] = (this.sourceValue[this.registerHighLow] & 0x80) == 128;
                this.tempValue = this.sourceValue[this.registerHighLow] & 0xFF;
                this.tempValue = this.tempValue >> this.bitShift & 0x7F;
                this.sourceValue[this.registerHighLow] = (byte)this.tempValue;
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                this.cpu.flags[4] = false;
                this.cpu.flags[6] = this.sourceValue[this.registerHighLow] == 0;
                this.cpu.flags[7] = this.sourceValue[this.registerHighLow] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[this.registerHighLow]);
                break;
            }
            case 6: {
                throw new CPUInstructionException("Shift Group 2 (0xD0/6) illegal reg bits");
            }
            case 7: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.cpu.flags[0] = (this.sourceValue[this.registerHighLow] & 1) == 1;
                this.cpu.flags[11] = (this.sourceValue[this.registerHighLow] & 0x80) == 128;
                this.sourceValue[this.registerHighLow] = (byte)(this.sourceValue[this.registerHighLow] >> this.bitShift & 0x7F);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                this.cpu.flags[4] = false;
                this.cpu.flags[6] = this.sourceValue[this.registerHighLow] == 0;
                this.cpu.flags[7] = this.sourceValue[this.registerHighLow] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[this.registerHighLow]);
                break;
            }
            default: {
                throw new CPUInstructionException("Shift Group 2 (0xD0/6) no case match");
            }
        }
    }
}

