/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.CPUInstructionException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instruction_UnaryGrp3_Ev
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] eSourceValue = new byte[2];
    byte[] sourceValue2 = new byte[2];
    byte[] eSourceValue2 = new byte[2];
    byte[] destinationRegister = new byte[2];
    byte[] destinationRegister2 = new byte[2];
    byte[] eDestinationRegister = new byte[2];
    byte[] eDestinationRegister2 = new byte[2];
    long result = 0L;
    byte[] tempResult = new byte[2];
    private static final Logger logger = Logger.getLogger(Instruction_UnaryGrp3_Ev.class.getName());

    public Instruction_UnaryGrp3_Ev() {
    }

    public Instruction_UnaryGrp3_Ev(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() throws CPUInstructionException {
        this.sourceValue = new byte[2];
        this.sourceValue2 = new byte[2];
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        switch ((this.addressByte & 0x38) >> 3) {
            case 0: {
                this.cpu.flags[11] = false;
                this.cpu.flags[0] = false;
                this.cpu.flags[4] = false;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.sourceValue2 = this.cpu.getWordFromCode();
                this.tempResult[0] = (byte)(this.sourceValue2[0] & this.sourceValue[0]);
                this.tempResult[1] = (byte)(this.sourceValue2[1] & this.sourceValue[1]);
                this.cpu.flags[6] = this.tempResult[0] == 0 && this.tempResult[1] == 0;
                this.cpu.flags[7] = this.tempResult[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult[1]);
                break;
            }
            case 1: {
                throw new CPUInstructionException("Unary Group 3 (0xF6) illegal reg bits");
            }
            case 2: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.sourceValue[1] = ~this.sourceValue[1];
                    this.sourceValue[0] = ~this.sourceValue[0];
                    if (!this.cpu.doubleWord) break;
                    this.eSourceValue = this.cpu.decodeExtraRegister(this.addressByte & 7);
                    this.eSourceValue[1] = ~this.eSourceValue[1];
                    this.eSourceValue[0] = ~this.eSourceValue[0];
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.sourceValue[1] = ~this.sourceValue[1];
                this.sourceValue[0] = ~this.sourceValue[0];
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                if (!this.cpu.doubleWord) break;
                this.memoryReferenceLocation[1] = (byte)(this.memoryReferenceLocation[1] + 2);
                if (this.memoryReferenceLocation[1] == 0 || this.memoryReferenceLocation[1] == 1) {
                    this.memoryReferenceLocation[0] = (byte)(this.memoryReferenceLocation[0] + 1);
                }
                this.eSourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.eSourceValue[1] = ~this.eSourceValue[1];
                this.eSourceValue[0] = ~this.eSourceValue[0];
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.eSourceValue);
                break;
            }
            case 3: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                System.arraycopy(this.sourceValue, 0, this.tempResult, 0, this.sourceValue.length);
                this.destinationRegister = Util.subtractWords(new byte[]{0, 0}, this.sourceValue, 0);
                System.arraycopy(this.destinationRegister, 0, this.sourceValue, 0, this.destinationRegister.length);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                }
                this.cpu.flags[0] = this.sourceValue[1] != 0 || this.sourceValue[0] != 0;
                this.cpu.flags[11] = Util.test_OF_SUB(new byte[]{0, 0}, this.tempResult, this.sourceValue, 0);
                this.cpu.flags[4] = (this.sourceValue[1] & 0xF) != 0;
                this.cpu.flags[6] = this.sourceValue[0] == 0 && this.sourceValue[1] == 0;
                this.cpu.flags[7] = this.sourceValue[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[1]);
                break;
            }
            case 4: {
                this.destinationRegister = this.cpu.ax;
                this.destinationRegister2 = this.cpu.dx;
                if (this.cpu.doubleWord) {
                    this.eDestinationRegister = this.cpu.eax;
                    this.eDestinationRegister2 = this.cpu.edx;
                }
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    if (this.cpu.doubleWord) {
                        this.eSourceValue = this.cpu.decodeExtraRegister(this.addressByte & 7);
                    }
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    if (this.cpu.doubleWord) {
                        this.memoryReferenceLocation = Util.addWords(this.memoryReferenceLocation, new byte[]{0, 2}, 0);
                        this.eSourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    }
                }
                this.result = ((((long)this.destinationRegister[0] & 0xFFL) << 8) + ((long)this.destinationRegister[1] & 0xFFL)) * ((((long)this.sourceValue[0] & 0xFFL) << 8) + ((long)this.sourceValue[1] & 0xFFL));
                if (this.cpu.doubleWord) {
                    this.result += (long)((((this.eDestinationRegister[0] & 0xFF) << 8) + (this.eDestinationRegister[1] & 0xFF)) * (((this.sourceValue[0] & 0xFF) << 8) + (this.sourceValue[1] & 0xFF)) << 16);
                    this.result += (long)((((this.destinationRegister[0] & 0xFF) << 8) + (this.destinationRegister[1] & 0xFF)) * (((this.eSourceValue[0] & 0xFF) << 8) + (this.eSourceValue[1] & 0xFF)) << 16);
                    this.result += (long)((((this.eDestinationRegister[0] & 0xFF) << 8) + (this.eDestinationRegister[1] & 0xFF)) * (((this.eSourceValue[0] & 0xFF) << 8) + (this.eSourceValue[1] & 0xFF)) << 32);
                }
                this.destinationRegister[1] = (byte)this.result;
                this.destinationRegister[0] = (byte)(this.result >> 8);
                this.destinationRegister2[1] = (byte)(this.result >> 16);
                this.destinationRegister2[0] = (byte)(this.result >> 24);
                if (this.cpu.doubleWord) {
                    this.eDestinationRegister[1] = (byte)(this.result >> 16);
                    this.eDestinationRegister[0] = (byte)(this.result >> 24);
                    this.destinationRegister2[1] = (byte)(this.result >> 32);
                    this.destinationRegister2[0] = (byte)(this.result >> 40);
                    this.eDestinationRegister2[1] = (byte)(this.result >> 48);
                    this.eDestinationRegister2[0] = (byte)(this.result >> 56);
                }
                if (this.cpu.doubleWord) {
                    this.cpu.flags[0] = this.eDestinationRegister2[0] != 0 || this.eDestinationRegister2[1] != 0;
                    this.cpu.flags[11] = this.cpu.flags[0];
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
                    this.cpu.flags[4] = false;
                    this.cpu.flags[6] = this.eDestinationRegister[0] == 0 && this.eDestinationRegister[1] == 0 && this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
                    this.cpu.flags[7] = this.eDestinationRegister2[0] < 0;
                    break;
                }
                this.cpu.flags[0] = this.destinationRegister2[0] != 0 || this.destinationRegister2[1] != 0;
                this.cpu.flags[11] = this.cpu.flags[0];
                this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
                this.cpu.flags[4] = false;
                this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
                this.cpu.flags[7] = this.destinationRegister[0] < 0;
                break;
            }
            case 5: {
                this.destinationRegister = this.cpu.ax;
                this.destinationRegister2 = this.cpu.dx;
                if (this.cpu.doubleWord) {
                    this.eDestinationRegister = this.cpu.eax;
                    this.eDestinationRegister2 = this.cpu.edx;
                }
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    if (this.cpu.doubleWord) {
                        this.eSourceValue = this.cpu.decodeExtraRegister(this.addressByte & 7);
                    }
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    if (this.cpu.doubleWord) {
                        this.memoryReferenceLocation[1] = (byte)(this.memoryReferenceLocation[1] + 2);
                        if (this.memoryReferenceLocation[1] == 0 || this.memoryReferenceLocation[1] == 1) {
                            this.memoryReferenceLocation[0] = (byte)(this.memoryReferenceLocation[0] + 1);
                        }
                        this.eSourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    }
                }
                this.result = (((long)this.destinationRegister[0] << 8) + ((long)this.destinationRegister[1] & 0xFFL)) * (((long)this.sourceValue[0] << 8) + ((long)this.sourceValue[1] & 0xFFL));
                if (this.cpu.doubleWord) {
                    this.result += (long)(((this.eDestinationRegister[0] << 8) + (this.eDestinationRegister[1] & 0xFF)) * ((this.sourceValue[0] << 8) + (this.sourceValue[1] & 0xFF)) << 16);
                    this.result += (long)(((this.destinationRegister[0] << 8) + (this.destinationRegister[1] & 0xFF)) * ((this.eSourceValue[0] << 8) + (this.eSourceValue[1] & 0xFF)) << 16);
                    this.result += (long)(((this.eDestinationRegister[0] << 8) + (this.eDestinationRegister[1] & 0xFF)) * ((this.eSourceValue[0] << 8) + (this.eSourceValue[1] & 0xFF)) << 32);
                }
                this.destinationRegister[1] = (byte)this.result;
                this.destinationRegister[0] = (byte)(this.result >> 8);
                this.destinationRegister2[1] = (byte)(this.result >> 16);
                this.destinationRegister2[0] = (byte)(this.result >> 24);
                if (this.cpu.doubleWord) {
                    this.eDestinationRegister[1] = (byte)(this.result >> 16);
                    this.eDestinationRegister[0] = (byte)(this.result >> 24);
                    this.destinationRegister2[1] = (byte)(this.result >> 32);
                    this.destinationRegister2[0] = (byte)(this.result >> 40);
                    this.eDestinationRegister2[1] = (byte)(this.result >> 48);
                    this.eDestinationRegister2[0] = (byte)(this.result >> 56);
                }
                if (this.cpu.doubleWord) {
                    this.cpu.flags[0] = this.eDestinationRegister2[0] != 0 || this.eDestinationRegister2[1] != 0;
                    this.cpu.flags[11] = this.cpu.flags[0];
                } else {
                    this.cpu.flags[0] = this.destinationRegister2[0] != 0 || this.destinationRegister2[1] != 0;
                    this.cpu.flags[11] = this.cpu.flags[0];
                }
                this.cpu.flags[4] = false;
                this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
                this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
                this.cpu.flags[7] = this.destinationRegister[0] < 0;
                break;
            }
            case 6: {
                this.destinationRegister = this.cpu.ax;
                this.destinationRegister2 = this.cpu.dx;
                if (this.cpu.doubleWord) {
                    this.eDestinationRegister = this.cpu.eax;
                    this.eDestinationRegister2 = this.cpu.edx;
                }
                if ((this.addressByte & 0xC0) >> 6 == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    if (this.cpu.doubleWord) {
                        this.eSourceValue = this.cpu.decodeExtraRegister(this.addressByte & 7);
                    }
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    if (this.cpu.doubleWord) {
                        this.memoryReferenceLocation[1] = (byte)(this.memoryReferenceLocation[1] + 2);
                        if (this.memoryReferenceLocation[1] == 0 || this.memoryReferenceLocation[1] == 1) {
                            this.memoryReferenceLocation[0] = (byte)(this.memoryReferenceLocation[0] + 1);
                        }
                        this.eSourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    }
                }
                if (!this.cpu.doubleWord) {
                    long l = (((long)this.destinationRegister2[0] & 0xFFL) << 24) + (((long)this.destinationRegister2[1] & 0xFFL) << 16) + (((long)this.destinationRegister[0] & 0xFFL) << 8) + ((long)this.destinationRegister[1] & 0xFFL);
                    long l2 = (((long)this.sourceValue[0] & 0xFFL) << 8) + ((long)this.sourceValue[1] & 0xFFL);
                    long l3 = l / l2;
                    long l4 = l % l2;
                    this.destinationRegister[1] = (byte)l3;
                    this.destinationRegister[0] = (byte)(l3 >> 8);
                    this.destinationRegister2[1] = (byte)l4;
                    this.destinationRegister2[0] = (byte)(l4 >> 8);
                    break;
                }
                logger.log(Level.WARNING, "[" + (Object)((Object)this.cpu.getType()) + "] Unary Group 3 (0xF7|6) not (properly) implemented");
                long l = (((long)this.eDestinationRegister2[0] & 0xFFL) << 56) + (((long)this.eDestinationRegister2[1] & 0xFFL) << 48) + (((long)this.destinationRegister2[0] & 0xFFL) << 40) + (((long)this.destinationRegister2[1] & 0xFFL) << 32) + (long)((this.eDestinationRegister[0] & 0xFF) << 24) + (long)((this.eDestinationRegister[1] & 0xFF) << 16) + (long)((this.destinationRegister[0] & 0xFF) << 8) + (long)(this.destinationRegister[1] & 0xFF);
                long l5 = (((long)this.eSourceValue[0] & 0xFFL) << 24) + (((long)this.eSourceValue[1] & 0xFFL) << 16) + (((long)this.sourceValue[0] & 0xFFL) << 8) + ((long)this.sourceValue[1] & 0xFFL);
                long l6 = l / l5;
                long l7 = l % l5;
                this.destinationRegister[1] = (byte)l6;
                this.destinationRegister[0] = (byte)(l6 >> 8);
                this.eDestinationRegister[1] = (byte)(l6 >> 16);
                this.eDestinationRegister[0] = (byte)(l6 >> 24);
                this.destinationRegister2[1] = (byte)l7;
                this.destinationRegister2[0] = (byte)(l7 >> 8);
                this.eDestinationRegister2[1] = (byte)(l7 >> 16);
                this.eDestinationRegister2[0] = (byte)(l7 >> 24);
                break;
            }
            case 7: {
                this.destinationRegister = this.cpu.ax;
                this.destinationRegister2 = this.cpu.dx;
                if (this.cpu.doubleWord) {
                    this.eDestinationRegister = this.cpu.eax;
                    this.eDestinationRegister2 = this.cpu.edx;
                }
                if ((this.addressByte & 0xC0) >> 6 == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    if (this.cpu.doubleWord) {
                        this.eSourceValue = this.cpu.decodeExtraRegister(this.addressByte & 7);
                    }
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    if (this.cpu.doubleWord) {
                        this.memoryReferenceLocation[1] = (byte)(this.memoryReferenceLocation[1] + 2);
                        if (this.memoryReferenceLocation[1] == 0 || this.memoryReferenceLocation[1] == 1) {
                            this.memoryReferenceLocation[0] = (byte)(this.memoryReferenceLocation[0] + 1);
                        }
                        this.eSourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    }
                }
                if (!this.cpu.doubleWord) {
                    long l = ((this.destinationRegister2[0] & 0xFF) << 24) + ((this.destinationRegister2[1] & 0xFF) << 16) + ((this.destinationRegister[0] & 0xFF) << 8) + (this.destinationRegister[1] & 0xFF);
                    long l8 = ((this.sourceValue[0] & 0xFF) << 8) + (this.sourceValue[1] & 0xFF);
                    long l9 = l / l8;
                    long l10 = l % l8;
                    this.destinationRegister[1] = (byte)l9;
                    this.destinationRegister[0] = (byte)(l9 >> 8);
                    this.destinationRegister2[1] = (byte)l10;
                    this.destinationRegister2[0] = (byte)(l10 >> 8);
                    break;
                }
                throw new CPUInstructionException("Unary Group 3 (0xF6|6) not (properly) implemented");
            }
            default: {
                throw new CPUInstructionException("Unary Group 3 (0xF6) illegal reg bits");
            }
        }
    }
}

