/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.fdc;

import dioscuri.exception.StorageDeviceException;
import dioscuri.module.fdc.Floppy;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class Drive {
    private int driveType = 0;
    private boolean motorRunning;
    protected int eot = 0;
    protected int hds = 0;
    protected int cylinder = 0;
    protected int sector = 0;
    private Floppy floppy = null;
    protected int floppyType = 0;
    protected int tracks = 0;
    protected int heads = 0;
    protected int cylinders = 0;
    protected int sectorsPerTrack = 0;
    protected int sectors = 0;
    protected boolean writeProtected = false;
    protected boolean multiTrack = false;
    protected byte dir = (byte)-128;

    protected boolean reset() {
        this.dir = (byte)(this.dir | 0x80);
        this.eot = 0;
        this.hds = 0;
        this.cylinder = 0;
        this.sector = 0;
        return true;
    }

    protected boolean containsFloppy() {
        return this.floppy != null;
    }

    protected int getDriveType() {
        return this.driveType;
    }

    protected void setDriveType(byte by) {
        this.driveType = by;
    }

    protected void setMotor(boolean bl) {
        this.motorRunning = bl;
    }

    protected boolean isMotorRunning() {
        return this.motorRunning;
    }

    protected int getFloppyType() {
        return this.floppyType;
    }

    protected int getFloppySize() {
        if (this.containsFloppy()) {
            return this.floppy.getSize();
        }
        return -1;
    }

    protected void insertFloppy(byte by, File file, boolean bl) throws StorageDeviceException {
        try {
            this.floppy = new Floppy(by, file);
            this.floppyType = by;
            if (this.floppy.getSize() <= 1474560) {
                FloppyType floppyType = FloppyType.fromId(by);
                this.tracks = floppyType.getTracks();
                this.heads = floppyType.getHeads();
                this.sectorsPerTrack = floppyType.getSectorsPerTrack();
            } else if (this.floppy.getSize() == 1720320) {
                this.tracks = 80;
                this.heads = 2;
                this.sectorsPerTrack = 21;
            } else if (this.floppy.getSize() == 1763328) {
                this.tracks = 82;
                this.heads = 2;
                this.sectorsPerTrack = 21;
            } else if (this.floppy.getSize() == 0x1CC000) {
                this.tracks = 80;
                this.heads = 2;
                this.sectorsPerTrack = 23;
            }
            this.sectors = this.heads * this.tracks * this.sectorsPerTrack;
            if (this.floppy.getSize() > this.sectors * 512) {
                throw new StorageDeviceException("Error: size of file too large for selected type");
            }
            this.writeProtected = bl;
        }
        catch (IOException iOException) {
            throw new StorageDeviceException("Floppy could not be inserted.");
        }
    }

    protected void ejectFloppy() throws StorageDeviceException {
        try {
            this.floppy.storeImageToFile();
        }
        catch (IOException iOException) {
            throw new StorageDeviceException("Floppy data could not be stored to disk image. Data may be lost.");
        }
        finally {
            this.floppy = null;
            this.driveType = 0;
            this.floppyType = 0;
            this.tracks = 0;
            this.heads = 0;
            this.sectorsPerTrack = 0;
            this.sectors = 0;
            this.writeProtected = false;
            this.resetChangeline();
        }
    }

    protected void readData(int n, int n2, byte[] byArray) throws StorageDeviceException {
        block5: {
            if (this.containsFloppy()) {
                try {
                    System.arraycopy(this.floppy.bytes, n, byArray, 0, n2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (n < this.floppy.bytes.length) {
                        int n3 = this.floppy.bytes.length - n;
                        System.arraycopy(this.floppy.bytes, n, byArray, 0, n3);
                        Arrays.fill(byArray, n3, n2, (byte)0);
                        break block5;
                    }
                    Arrays.fill(byArray, 0, n2, (byte)0);
                }
            } else {
                throw new StorageDeviceException("Error: drive does not contain a floppy");
            }
        }
    }

    protected void writeData(int n, int n2, byte[] byArray) throws StorageDeviceException {
        if (!this.containsFloppy() || this.writeProtected) {
            throw new StorageDeviceException("Error: drive does not contain a floppy or is write protected");
        }
        System.arraycopy(byArray, 0, this.floppy.bytes, n, n2);
    }

    protected void incrementSector() {
        ++this.sector;
        if (this.sector > this.eot || this.sector > this.sectorsPerTrack) {
            this.sector = 1;
            if (this.multiTrack) {
                ++this.hds;
                if (this.hds > 1) {
                    this.hds = 0;
                    ++this.cylinder;
                    this.resetChangeline();
                }
            } else {
                ++this.cylinder;
                this.resetChangeline();
            }
            if (this.cylinder >= this.tracks) {
                this.cylinder = this.tracks;
            }
        }
    }

    protected void resetChangeline() {
        if (this.containsFloppy()) {
            this.dir = (byte)(this.dir & 0xFFFFFF7F);
        }
    }

    public String toString() {
        String string = "\r\n";
        String string2 = "\t";
        String string3 = "drivetype=" + this.driveType + ", motorRunning=" + this.motorRunning + ", eot=" + this.eot + ", hds=" + this.hds + ", cylinder=" + this.cylinder + ", sector=" + this.sector;
        String string4 = "floppy=";
        string4 = this.containsFloppy() ? string4 + "inserted, floppytype=" + this.floppyType + ", floppysize=" + this.floppy.getSize() + ", tracks=" + this.tracks + ", heads=" + this.heads + ", cylinders=" + this.cylinders + ", sectorsPerTrack=" + this.sectorsPerTrack + ", sectors=" + this.sectors + ", writeProtected=" + this.writeProtected + ", multiTrack=" + this.multiTrack : string4 + "none";
        return string3 + string + string2 + string2 + string4;
    }

    private static enum FloppyType {
        TYPE_NONE(0, 0, 0, 0, 0, 0),
        TYPE_360K(1, 40, 2, 9, 720, 5),
        TYPE_1_2(2, 80, 2, 15, 2400, 4),
        TYPE_720K(3, 80, 2, 9, 1440, 31),
        TYPE_1_44(4, 80, 2, 18, 2880, 24),
        TYPE_2_88(5, 80, 2, 36, 5760, 16),
        TYPE_160K(6, 40, 1, 8, 320, 5),
        TYPE_180K(7, 40, 1, 9, 360, 5),
        TYPE_320K(8, 40, 2, 8, 640, 5);

        private final byte id;
        private final int tracks;
        private final int heads;
        private final int sectorsPerTrack;
        private final int sectors;
        private final int value;

        private FloppyType(byte by, int n2, int n3, int n4, int n5, int n6) {
            this.id = by;
            this.tracks = n2;
            this.heads = n3;
            this.sectorsPerTrack = n4;
            this.sectors = n5;
            this.value = n6;
        }

        public byte getId() {
            return this.id;
        }

        public int getTracks() {
            return this.tracks;
        }

        public int getHeads() {
            return this.heads;
        }

        public int getSectorsPerTrack() {
            return this.sectorsPerTrack;
        }

        public int getSectors() {
            return this.sectors;
        }

        public static FloppyType fromId(byte by) {
            FloppyType floppyType = TYPE_NONE;
            for (FloppyType floppyType2 : FloppyType.values()) {
                if (floppyType2.getId() != by) continue;
                floppyType = floppyType2;
                break;
            }
            return floppyType;
        }
    }
}

