/*
 * Decompiled with CFR 0.152.
 */
package vncjdemo;

import gnu.rfb.server.RFBClient;
import gnu.vnc.awt.VNCFrame;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;

public class LightweightModelTest
extends VNCFrame
implements MouseListener,
MouseMotionListener {
    int fromX = -1;
    int fromY = -1;
    int toX = -1;
    int toY = -1;
    int cursorX = -1;
    int cursorY = -1;
    int cursorR = 8;

    public LightweightModelTest(int display, String displayName) {
        super(displayName, 400, 300);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.clean(false);
    }

    @Override
    public void setEncodings(RFBClient client, int[] encodings) throws IOException {
        client.setPreferredEncoding(2);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0) {
            this.cursor();
            this.fromX = e.getX();
            this.fromY = e.getY();
        } else {
            this.clean(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0) {
            Graphics g = this.getGraphics();
            if (this.toX != -1) {
                g.setXORMode(Color.gray);
                g.drawLine(this.fromX, this.fromY, this.toX, this.toY);
                this.queueRectangle(this.fromX, this.fromY, this.toX, this.toY);
                g.setPaintMode();
                g.setColor(Color.blue);
                g.drawLine(this.fromX, this.fromY, this.toX, this.toY);
                this.queueRectangle(this.fromX, this.fromY, this.toX, this.toY);
            }
            this.fromX = -1;
            this.fromY = -1;
            this.toX = -1;
            this.toY = -1;
            this.cursorX = -1;
            this.cursorY = -1;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0) {
            Graphics g = this.getGraphics();
            g.setXORMode(Color.gray);
            if (this.toX != -1) {
                g.drawLine(this.fromX, this.fromY, this.toX, this.toY);
                this.queueRectangle(this.fromX, this.fromY, this.toX, this.toY);
            }
            this.toX = e.getX();
            this.toY = e.getY();
            g.drawLine(this.fromX, this.fromY, this.toX, this.toY);
            this.queueRectangle(this.fromX, this.fromY, this.toX, this.toY);
            g.setPaintMode();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.cursorX != -1) {
            this.cursor();
        }
        this.cursorX = e.getX();
        this.cursorY = e.getY();
        this.cursor();
    }

    private void clean(boolean queue) {
        Graphics g = this.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (queue) {
            this.queue.addRectangle(this);
        }
        this.cursorX = -1;
        this.cursorY = -1;
    }

    private void cursor() {
        Graphics g = this.getGraphics();
        g.setXORMode(Color.black);
        g.drawOval(this.cursorX - this.cursorR, this.cursorY - this.cursorR, this.cursorR * 2 + 1, this.cursorR * 2 + 1);
        g.drawLine(this.cursorX - this.cursorR, this.cursorY, this.cursorX + this.cursorR, this.cursorY);
        g.drawLine(this.cursorX, this.cursorY - this.cursorR, this.cursorX, this.cursorY + this.cursorR);
        this.queueRectangle(this.cursorX - this.cursorR, this.cursorY - this.cursorR, this.cursorX + this.cursorR + 1, this.cursorY + this.cursorR + 1);
        g.setPaintMode();
    }

    private void queueRectangle(int x1, int y1, int x2, int y2) {
        int t;
        if (x2 < x1) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y2 < y1) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        this.queue.addRectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1, this);
        try {
            this.updateAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

