/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.pci;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.WriteOnlyPortException;
import dioscuri.interfaces.Addressable;
import dioscuri.interfaces.Module;
import dioscuri.module.AbstractModule;
import dioscuri.module.ModuleMotherboard;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PCI
extends AbstractModule
implements Addressable {
    private static final Logger logger = Logger.getLogger(PCI.class.getName());
    private static final int PORT_PCI1_ADDRESS = 3320;
    private static final int PORT_PCI1_DATA = 3324;

    public PCI(Emulator emulator) {
        super(Module.Type.PCI, new Module.Type[0]);
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        moduleMotherboard.setIOPort(3320, this);
        moduleMotherboard.setIOPort(3321, this);
        moduleMotherboard.setIOPort(3322, this);
        moduleMotherboard.setIOPort(3323, this);
        moduleMotherboard.setIOPort(3324, this);
        moduleMotherboard.setIOPort(3325, this);
        moduleMotherboard.setIOPort(3326, this);
        moduleMotherboard.setIOPort(3327, this);
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] AbstractModule has been reset.");
        return true;
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " IN command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Returned default value 0xFF");
        return -1;
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " OUT command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, WriteOnlyPortException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " IN command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Returned default value 0xFFFF");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, WriteOnlyPortException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " IN command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Returned default value 0xFFFFFFFF");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }
}

