/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.CPUInstructionException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;

public class Instruction_GRP11_MOV_EbIb
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = false;
    byte addressByte = 0;
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] memoryReferenceLocation = new byte[2];
    byte[] destinationRegister = new byte[2];
    int intermediateResult = 0;
    byte displacement = 0;
    byte registerHighLow = 0;

    public Instruction_GRP11_MOV_EbIb() {
    }

    public Instruction_GRP11_MOV_EbIb(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() throws CPUInstructionException {
        this.addressByte = this.cpu.getByteFromCode();
        if ((this.addressByte & 0x38) >> 3 == 0) {
            if ((this.addressByte >> 6 & 3) == 3) {
                this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                this.destinationRegister[this.registerHighLow] = this.cpu.getByteFromCode();
            } else {
                this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.cpu.getByteFromCode());
            }
        } else {
            throw new CPUInstructionException("Group 11 (0xC6) instruction illegal nnn bits.");
        }
    }
}

