/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.AddressSpace;
import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.Memory;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.ProcessorException;

public class AlignmentCheckedAddressSpace
extends AddressSpace {
    private static final ProcessorException ALIGNMENT_CHECK_EXCEPTION = new ProcessorException(17, 0, true);
    private static final ProcessorException ALIGNMENT_CHECK_EXCEPTION_GP = new ProcessorException(13, 0, true);
    private AddressSpace addressSpace;

    public AlignmentCheckedAddressSpace(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
    }

    @Override
    public Memory getReadMemoryBlockAt(int n) {
        return this.addressSpace.getReadMemoryBlockAt(n);
    }

    @Override
    public Memory getWriteMemoryBlockAt(int n) {
        return this.addressSpace.getWriteMemoryBlockAt(n);
    }

    @Override
    void replaceBlocks(Memory memory, Memory memory2) {
        throw new IllegalStateException("Invalid Operation");
    }

    @Override
    public int execute(Processor processor, int n) {
        throw new IllegalStateException("Invalid Operation");
    }

    @Override
    public CodeBlock decodeCodeBlockAt(Processor processor, int n) {
        throw new IllegalStateException("Invalid Operation");
    }

    @Override
    public boolean updated() {
        return true;
    }

    @Override
    public void clear() {
        this.addressSpace.clear();
    }

    @Override
    public byte getByte(int n) {
        return this.addressSpace.getByte(n);
    }

    @Override
    public void setByte(int n, byte by) {
        this.addressSpace.setByte(n, by);
    }

    @Override
    public short getWord(int n) {
        if ((n & 1) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        return this.addressSpace.getWord(n);
    }

    @Override
    public int getDoubleWord(int n) {
        if ((n & 3) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        return this.addressSpace.getDoubleWord(n);
    }

    @Override
    public long getQuadWord(int n) {
        if ((n & 7) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        return this.addressSpace.getQuadWord(n);
    }

    @Override
    public long getLowerDoubleQuadWord(int n) {
        if ((n & 0xF) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        return this.addressSpace.getLowerDoubleQuadWord(n);
    }

    @Override
    public long getUpperDoubleQuadWord(int n) {
        return this.addressSpace.getUpperDoubleQuadWord(n);
    }

    @Override
    public void setWord(int n, short s) {
        if ((n & 1) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        this.addressSpace.setWord(n, s);
    }

    @Override
    public void setDoubleWord(int n, int n2) {
        if ((n & 3) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        this.addressSpace.setDoubleWord(n, n2);
    }

    @Override
    public void setQuadWord(int n, long l) {
        if ((n & 7) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION;
        }
        this.addressSpace.setQuadWord(n, l);
    }

    @Override
    public void setLowerDoubleQuadWord(int n, long l) {
        if ((n & 0xF) != 0) {
            throw ALIGNMENT_CHECK_EXCEPTION_GP;
        }
        this.addressSpace.setLowerDoubleQuadWord(n, l);
    }

    @Override
    public void setUpperDoubleQuadWord(int n, long l) {
        this.addressSpace.setUpperDoubleQuadWord(n, l);
    }

    @Override
    public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
        this.addressSpace.copyContentsFrom(n, byArray, n2, n3);
    }

    @Override
    public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
        this.addressSpace.copyContentsInto(n, byArray, n2, n3);
    }
}

