/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.ata;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.StorageDeviceException;
import dioscuri.exception.UnknownPortException;
import dioscuri.exception.WriteOnlyPortException;
import dioscuri.interfaces.Module;
import dioscuri.module.ModuleATA;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModulePIC;
import dioscuri.module.ModuleRTC;
import dioscuri.module.ata.ATAChannel;
import dioscuri.module.ata.ATACommand;
import dioscuri.module.ata.ATAConstants;
import dioscuri.module.ata.ATADrive;
import dioscuri.module.ata.ATADriveController;
import dioscuri.module.ata.ATADriveType;
import dioscuri.module.ata.ATATranslationType;
import dioscuri.module.ata.AscType;
import dioscuri.module.ata.SenseType;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ATA
extends ModuleATA {
    private static final Logger logger = Logger.getLogger(ATA.class.getName());
    private static int hdDriveCount = 0;
    private Emulator emu;
    private int updateInterval;
    private ATAChannel[] channels = new ATAChannel[4];
    private int curChannelIndex;
    private int bulkIOHostAddr = 0;
    private int bulkIOQuantumsRequested = 0;
    private int bulkIOQuantumsTransferred = 0;
    private int cdromCount;

    public ATA(Emulator emulator) {
        this.emu = emulator;
        this.updateInterval = -1;
        this.cdromCount = 0;
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = new ATAChannel(this, ATAConstants.DEFAULT_IO_ADDR_1[i], ATAConstants.DEFAULT_IO_ADDR_2[i]);
        }
        this.curChannelIndex = 0;
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        if (moduleMotherboard.requestTimer(this, this.updateInterval, false)) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " Timer requested successfully.");
        } else {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Failed to request a timer.");
        }
        this.curChannelIndex = 0;
        while (this.curChannelIndex < this.channels.length) {
            this.getSelectedChannel().reset();
            ++this.curChannelIndex;
        }
        this.curChannelIndex = 0;
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  AbstractModule has been reset.");
        return true;
    }

    @Override
    public String getDump() {
        String string = "";
        string = "ATA dump:\n";
        int n = this.getNumDrives();
        string = string + "In total " + n + " IDE drive(s) exist:\n";
        for (int i = 0; i < this.channels.length; ++i) {
            ATAChannel aTAChannel = this.channels[i];
            ATADrive[] aTADriveArray = aTAChannel.getDrives();
            for (int j = 0; j < aTADriveArray.length; ++j) {
                if (aTADriveArray[j] != null && aTADriveArray[j].driveType != ATADriveType.NONE) {
                    string = string + "Drive " + j + ": type '" + (Object)((Object)aTADriveArray[j].getDriveType()) + "'";
                    if (aTADriveArray[j].containsDisk()) {
                        string = string + "; drive present, type=" + aTADriveArray[j].getDriveType().toString() + ", size=" + aTADriveArray[j].getDiskImageSize() + " bytes\n";
                        continue;
                    }
                    string = string + ", empty\n";
                    continue;
                }
                string = string + "Drive " + j + ": not present\n";
            }
        }
        return string;
    }

    @Override
    public void setUpdateInterval(int n) {
        this.updateInterval = n > 0 ? n : 100000;
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        moduleMotherboard.resetTimer(this, this.updateInterval);
    }

    @Override
    public void update() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (this.channels[i].getDrives()[j].getIoLightCounter() <= 0) continue;
                int n = this.channels[i].getDrives()[j].getIoLightCounter();
                this.channels[i].getDrives()[j].setIoLightCounter(--n);
                if (n <= 0) continue;
                moduleMotherboard.resetTimer(this, this.updateInterval);
                moduleMotherboard.setTimerActiveState(this, true);
            }
        }
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleException, UnknownPortException, WriteOnlyPortException {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  IN command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received");
        return this.read(n, 1)[0];
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleException, UnknownPortException {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  OUT command (byte: " + Integer.toHexString(by).toUpperCase() + ") to port " + Integer.toHexString(n).toUpperCase() + " received.");
        byte[] byArray = new byte[]{by};
        this.write(n, byArray, 1);
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, UnknownPortException, WriteOnlyPortException {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  IN command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        return this.read(n, 2);
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException, UnknownPortException {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received.");
        this.write(n, byArray, 2);
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, UnknownPortException, WriteOnlyPortException {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  IN command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        return this.read(n, 4);
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException, UnknownPortException {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received.");
        this.write(n, byArray, 4);
    }

    @Override
    public void initConfig(int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, ATATranslationType aTATranslationType, String string) {
        ATADrive aTADrive;
        if (bl2) {
            aTADrive = new ATADrive(ATADriveType.HARD_DISK, this, true);
            aTADrive.hdNumber = ++hdDriveCount;
        } else {
            aTADrive = new ATADrive(ATADriveType.CDROM, this, true, this.cdromCount);
        }
        aTADrive.setWriteProtected(bl3);
        int n5 = 128;
        aTADrive.setDiskCapacity(n2, n3, n4, n5);
        aTADrive.setIsMaster(bl);
        aTADrive.setTranslationType(aTATranslationType);
        this.loadDiskImage(string, aTADrive);
        this.channels[n].setDisk(aTADrive);
        if (n3 == 0 || n4 == 0) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " cannot have zero heads, or sectors/track");
        }
        if (n2 > 0) {
            if (aTADrive.getDiskImageSize() != aTADrive.getDiskCapacity()) {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Image size doesn't match specified geometry.");
            }
        } else {
            n2 = (int)(aTADrive.getDiskImageSize() / (long)(n3 * n4 * 512));
            aTADrive.setTotalNumCylinders(n2);
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " Autodetect geometry: Number Cylinders set to " + n2);
        }
    }

    @Override
    public void setCmosSettings(int[] nArray, boolean bl) {
        int n;
        ModuleRTC moduleRTC = (ModuleRTC)super.getConnection(Module.Type.RTC);
        moduleRTC.setCMOSRegister(18, (byte)0);
        int n2 = 0;
        if (this.channels[n2].getDrives()[0].getDriveType() == ATADriveType.HARD_DISK) {
            moduleRTC.setCMOSRegister(18, (byte)(moduleRTC.getCMOSRegister(18) & 0xF | 0xF0));
            moduleRTC.setCMOSRegister(25, (byte)47);
            moduleRTC.setCMOSRegister(27, (byte)(this.channels[n2].getSelectedDrive().getTotalNumCylinders() & 0xFF));
            moduleRTC.setCMOSRegister(28, (byte)((this.channels[n2].getSelectedDrive().getTotalNumCylinders() & 0xFF00) >> 8));
            moduleRTC.setCMOSRegister(29, (byte)this.channels[n2].getSelectedDrive().getTotalNumHeads());
            moduleRTC.setCMOSRegister(30, (byte)-1);
            moduleRTC.setCMOSRegister(31, (byte)-1);
            n = this.channels[n2].getSelectedDrive().getTotalNumHeads() > 8 ? 1 : 0;
            int n3 = 0;
            if (n != 0) {
                n3 = 1;
            }
            moduleRTC.setCMOSRegister(32, (byte)(0xC0 | n3 << 3));
            moduleRTC.setCMOSRegister(33, moduleRTC.getCMOSRegister(27));
            moduleRTC.setCMOSRegister(34, moduleRTC.getCMOSRegister(28));
            moduleRTC.setCMOSRegister(35, (byte)this.channels[n2].getSelectedDrive().getTotalNumSectors());
        }
        if (this.channels[n2].getDrives()[1].getDriveType() == ATADriveType.HARD_DISK) {
            moduleRTC.setCMOSRegister(18, (byte)(moduleRTC.getCMOSRegister(18) & 0xF0 | 0xF));
            moduleRTC.setCMOSRegister(26, (byte)47);
            moduleRTC.setCMOSRegister(36, (byte)(this.channels[n2].getSelectedDrive().getTotalNumCylinders() & 0xFF));
            moduleRTC.setCMOSRegister(37, (byte)((this.channels[n2].getSelectedDrive().getTotalNumCylinders() & 0xFF00) >> 8));
            moduleRTC.setCMOSRegister(38, (byte)this.channels[n2].getSelectedDrive().getTotalNumHeads());
            moduleRTC.setCMOSRegister(39, (byte)-1);
            moduleRTC.setCMOSRegister(40, (byte)-1);
            moduleRTC.setCMOSRegister(41, (byte)(this.channels[n2].getSelectedDrive().getTotalNumHeads() > 8 ? 128 : 0));
            moduleRTC.setCMOSRegister(42, moduleRTC.getCMOSRegister(36));
            moduleRTC.setCMOSRegister(43, moduleRTC.getCMOSRegister(37));
            moduleRTC.setCMOSRegister(44, (byte)this.channels[n2].getSelectedDrive().getTotalNumSectors());
        }
        moduleRTC.setCMOSRegister(57, (byte)0);
        moduleRTC.setCMOSRegister(58, (byte)0);
        for (n = 0; n < this.channels.length; ++n) {
            ATAChannel aTAChannel = this.channels[n];
            for (int i = 0; i < aTAChannel.getDrives().length; ++i) {
                ATADrive aTADrive = aTAChannel.getDrives()[i];
                if (aTADrive.getDriveType() != ATADriveType.HARD_DISK) continue;
                int n4 = aTADrive.getTotalNumCylinders();
                int n5 = aTADrive.getTotalNumHeads();
                int n6 = aTADrive.getTotalNumSectors();
                int n7 = 57 + n / 2;
                int n8 = 2 * (i + 2 * (n % 2));
                ATATranslationType aTATranslationType = aTADrive.getTranslationType();
                if (aTATranslationType == ATATranslationType.AUTO) {
                    aTATranslationType = n4 <= 1024 && n5 <= 16 && n6 <= 63 ? ATATranslationType.NONE : (n4 * n5 <= 131072 ? ATATranslationType.LARGE : ATATranslationType.LBA);
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " Translation on IDE drive, channel = " + n + " , drive index " + i + " , set to " + aTATranslationType.toString());
                }
                if (aTATranslationType == ATATranslationType.NONE) {
                    moduleRTC.setCMOSRegister(n7, (byte)(moduleRTC.getCMOSRegister(n7) | 0 << n8));
                    continue;
                }
                if (aTATranslationType == ATATranslationType.LBA) {
                    moduleRTC.setCMOSRegister(n7, (byte)(moduleRTC.getCMOSRegister(n7) | 1 << n8));
                    continue;
                }
                if (aTATranslationType == ATATranslationType.LARGE) {
                    moduleRTC.setCMOSRegister(n7, (byte)(moduleRTC.getCMOSRegister(n7) | 2 << n8));
                    continue;
                }
                if (aTATranslationType != ATATranslationType.RECHS) continue;
                moduleRTC.setCMOSRegister(n7, (byte)(moduleRTC.getCMOSRegister(n7) | 3 << n8));
            }
        }
        if (nArray[0] != 1) {
            n = moduleRTC.getCMOSRegister(45) & 0xDF;
            moduleRTC.setCMOSRegister(45, (byte)n);
        } else {
            n = moduleRTC.getCMOSRegister(45) | 0x20;
            moduleRTC.setCMOSRegister(45, (byte)n);
        }
        moduleRTC.setCMOSRegister(61, (byte)(nArray[0] | nArray[1] << 4));
        n = 0;
        if (bl) {
            n = 1;
        }
        moduleRTC.setCMOSRegister(56, (byte)(n | nArray[2] << 4));
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Floppy boot signature check is set to " + bl);
    }

    @Override
    public int getCurrentChannelIndex() {
        return this.curChannelIndex;
    }

    private ATAChannel getSelectedChannel() {
        return this.channels[this.curChannelIndex];
    }

    private ATADrive getSelectedDrive() {
        return this.getSelectedChannel().getSelectedDrive();
    }

    private ATADriveController getSelectedDriveController() {
        return this.getSelectedDrive().getControl();
    }

    private boolean loadDiskImage(String string, ATADrive aTADrive) {
        try {
            File file = new File(string);
            aTADrive.loadImage(file);
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Disk \"" + file.getName() + "\" is successfully loaded.");
            return true;
        }
        catch (StorageDeviceException storageDeviceException) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  Error: " + storageDeviceException.getMessage());
            return false;
        }
    }

    private int getNumDrives() {
        int n = 0;
        for (int i = 0; i < this.channels.length; ++i) {
            for (int j = 0; j < this.channels[i].getDrives().length; ++j) {
                if (this.channels[i].getDrives()[j].driveType == ATADriveType.NONE) continue;
                ++n;
            }
        }
        return n;
    }

    private byte[] read(int n, int n2) throws ModuleException, UnknownPortException, WriteOnlyPortException {
        int n3;
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            byArray[n3] = 0;
        }
        n3 = 4;
        int n4 = 255;
        for (n3 = 0; n3 < 4; ++n3) {
            if ((n & 0xFFF8) == this.channels[n3].getIoAddress1()) {
                n4 = n - this.channels[n3].getIoAddress1();
                break;
            }
            if ((n & 0xFFF8) != this.channels[n3].getIoAddress2()) continue;
            n4 = n - this.channels[n3].getIoAddress2() + 16;
            break;
        }
        if (n3 == 4) {
            if (n < 1014 || n > 1015) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  read: unable to find ATA channel, ioport=0x%04x " + Integer.toHexString(n).toUpperCase());
                return byArray;
            }
            n3 = 0;
            n4 = n - 992;
        }
        this.curChannelIndex = n3;
        switch (n4) {
            case 0: {
                byArray = this.executeGetCommand(n, n2);
                break;
            }
            case 1: {
                this.channels[this.curChannelIndex].getSelectedController().getStatus().setErr(0);
                if (this.channels[this.curChannelIndex].isAnyDrivePresent()) {
                    byArray[0] = (byte)this.channels[this.curChannelIndex].getSelectedController().getErrorRegister();
                    break;
                }
                byArray[0] = 0;
                break;
            }
            case 2: {
                if (this.channels[this.curChannelIndex].isAnyDrivePresent()) {
                    byArray[0] = (byte)this.channels[this.curChannelIndex].getSelectedDrive().getSectorCount();
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Read sector count returned value " + byArray[0]);
                    break;
                }
                byArray[0] = 0;
                break;
            }
            case 3: {
                if (this.channels[this.curChannelIndex].isAnyDrivePresent()) {
                    byArray[0] = (byte)this.channels[this.curChannelIndex].getSelectedDrive().getCurrentSector();
                    break;
                }
                byArray[0] = 0;
                break;
            }
            case 4: {
                if (this.channels[this.curChannelIndex].isAnyDrivePresent()) {
                    byArray[0] = (byte)(this.channels[this.curChannelIndex].getSelectedDrive().getCurrentCylinder() & 0xFF);
                    break;
                }
                byArray[0] = 0;
                break;
            }
            case 5: {
                if (this.channels[this.curChannelIndex].isAnyDrivePresent()) {
                    byArray[0] = (byte)(this.channels[this.curChannelIndex].getSelectedDrive().getCurrentCylinder() >> 8);
                    break;
                }
                byArray[0] = 0;
                break;
            }
            case 6: {
                int n5 = 0;
                if (this.channels[this.curChannelIndex].getSelectedController().getLbaMode() > 0) {
                    n5 = 1;
                }
                byArray[0] = (byte)(0x80 | n5 << 6 | 0x20 | this.channels[this.curChannelIndex].getSelectedDriveIndex() << 4 | this.channels[this.curChannelIndex].getSelectedDrive().getCurrentHead() << 0);
                break;
            }
            case 7: 
            case 22: {
                if (!this.channels[this.curChannelIndex].isSelectedDrivePresent()) {
                    byArray[0] = 0;
                } else {
                    byArray[0] = (byte)(this.channels[this.curChannelIndex].getSelectedController().getStatus().getBusy() << 7 | this.channels[this.curChannelIndex].getSelectedController().getStatus().getDriveReady() << 6 | this.channels[this.curChannelIndex].getSelectedController().getStatus().getWriteFault() << 5 | this.channels[this.curChannelIndex].getSelectedController().getStatus().getSeekComplete() << 4 | this.channels[this.curChannelIndex].getSelectedController().getStatus().getDrq() << 3 | this.channels[this.curChannelIndex].getSelectedController().getStatus().getCorrectedData() << 2 | this.channels[this.curChannelIndex].getSelectedController().getStatus().getIndexPulse() << 1 | this.channels[this.curChannelIndex].getSelectedController().getStatus().getErr());
                    this.channels[this.curChannelIndex].getSelectedController().getStatus().incrementIndexPulseCount();
                    this.channels[this.curChannelIndex].getSelectedController().getStatus().setIndexPulse(0);
                    if (this.channels[this.curChannelIndex].getSelectedController().getStatus().getIndexPulseCount() >= 10) {
                        this.channels[this.curChannelIndex].getSelectedController().getStatus().setIndexPulse(1);
                        this.channels[this.curChannelIndex].getSelectedController().getStatus().setIndexPulseCount(0);
                    }
                }
                if (n4 != 7) break;
                ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
                modulePIC.clearIRQ(this.getSelectedChannel().getIrqNumber());
                break;
            }
            case 23: {
                byArray[0] = -1;
                break;
            }
            default: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Port [0x" + Integer.toHexString(n).toUpperCase() + "] returned default value 0xFF");
                return byArray;
            }
        }
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Read from Port [0x" + Integer.toHexString(n).toUpperCase() + "] returned value " + byArray[0]);
        return byArray;
    }

    private byte[] readSectors(int n, int n2) {
        int n3;
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            byArray[n3] = 0;
        }
        if (this.channels[this.curChannelIndex].getSelectedController().getBufferIndex() >= this.channels[this.curChannelIndex].getSelectedController().getBufferSize()) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  IO read buffer_index >= 512, for address " + n + ".");
            return byArray;
        }
        if (this.bulkIOQuantumsRequested > 0) {
            n3 = 0;
            int n4 = (this.channels[this.curChannelIndex].getSelectedController().getBufferSize() - this.getSelectedDriveController().getBufferIndex()) / n2;
            if (n4 == 0) {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  IO read not enough space for read for address " + n + ".");
            }
            this.bulkIOQuantumsTransferred = this.bulkIOQuantumsRequested;
            if (n4 < this.bulkIOQuantumsTransferred) {
                this.bulkIOQuantumsTransferred = n4;
            }
            n3 = n2 * this.bulkIOQuantumsTransferred;
            this.bulkIOHostAddr += n3;
            int n5 = this.channels[this.curChannelIndex].getSelectedController().getBufferIndex() + n3;
            this.channels[this.curChannelIndex].getSelectedController().setBufferIndex(n5);
        } else {
            byArray[0] = 0;
            if (n2 >= 2) {
                byArray[0] = this.channels[this.curChannelIndex].getSelectedController().getBuffer()[this.channels[this.curChannelIndex].getSelectedController().getBufferIndex()];
                byArray[1] = this.channels[this.curChannelIndex].getSelectedController().getBuffer()[this.channels[this.curChannelIndex].getSelectedController().getBufferIndex() + 1];
            }
            if (n2 == 4) {
                byArray[2] = this.channels[this.curChannelIndex].getSelectedController().getBuffer()[this.channels[this.curChannelIndex].getSelectedController().getBufferIndex() + 2];
                byArray[3] = this.channels[this.curChannelIndex].getSelectedController().getBuffer()[this.channels[this.curChannelIndex].getSelectedController().getBufferIndex() + 3];
                long l = ((long)byArray[0] & 0xFFL) + (((long)byArray[1] & 0xFFL) << 8) + (((long)byArray[2] & 0xFFL) << 16) + (((long)byArray[3] & 0xFFL) << 24);
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  IO read returns values for index " + this.channels[this.curChannelIndex].getSelectedController().getBufferIndex() + " " + byArray[0] + ", " + byArray[1] + ", " + byArray[2] + " and " + byArray[3] + " = " + l);
            }
            n3 = this.channels[this.curChannelIndex].getSelectedController().getBufferIndex() + n2;
            this.channels[this.curChannelIndex].getSelectedController().setBufferIndex(n3);
        }
        if (this.channels[this.curChannelIndex].getSelectedController().getBufferIndex() >= this.channels[this.curChannelIndex].getSelectedController().getBufferSize()) {
            if ((byte)this.channels[this.curChannelIndex].getSelectedController().getCurrentCommand() == -60) {
                if (this.channels[this.curChannelIndex].getSelectedDrive().getSectorCount() > this.channels[this.curChannelIndex].getSelectedController().getMultipleSectors()) {
                    this.channels[this.curChannelIndex].getSelectedController().setBufferSize(this.channels[this.curChannelIndex].getSelectedController().getMultipleSectors() * 512);
                } else {
                    this.channels[this.curChannelIndex].getSelectedController().setBufferSize(this.channels[this.curChannelIndex].getSelectedDrive().getSectorCount() * 512);
                }
            }
            this.getSelectedDriveController().getStatus().setBusy(0);
            this.getSelectedDriveController().getStatus().setDriveReady(1);
            this.getSelectedDriveController().getStatus().setWriteFault(0);
            this.getSelectedDriveController().getStatus().setSeekComplete(1);
            this.getSelectedDriveController().getStatus().setCorrectedData(0);
            this.getSelectedDriveController().getStatus().setErr(0);
            if (this.getSelectedDrive().getSectorCount() == 0) {
                this.getSelectedDriveController().getStatus().setDrq(0);
            } else {
                this.getSelectedDriveController().getStatus().setDrq(1);
                this.getSelectedDriveController().getStatus().setSeekComplete(1);
                if (this.ideReadData(this.curChannelIndex, this.getSelectedDriveController().getBuffer(), this.getSelectedDriveController().getBufferSize())) {
                    this.getSelectedDriveController().setBufferIndex(0);
                    this.raiseInterrupt(this.curChannelIndex);
                }
            }
        }
        return byArray;
    }

    private boolean write(int n, byte[] byArray, int n2) throws ModuleException, UnknownPortException {
        int n3 = 4;
        int n4 = 255;
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        Integer n5 = new Integer(0);
        int n6 = 0;
        boolean bl = false;
        for (n3 = 0; n3 < 4; ++n3) {
            if ((n & 0xFFF8) == this.channels[n3].getIoAddress1()) {
                n4 = n - this.channels[n3].getIoAddress1();
                break;
            }
            if ((n & 0xFFF8) != this.channels[n3].getIoAddress2()) continue;
            n4 = n - this.channels[n3].getIoAddress2() + 16;
            break;
        }
        if (n3 == 4) {
            if (n != 1014) {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  write: unable to find ATA channel, ioport " + n + ".");
                return false;
            }
            n3 = 0;
            n4 = n - 992;
        }
        this.curChannelIndex = n3;
        switch (n4) {
            case 0: {
                this.executeSetCommand(n, nArray, n2);
                break;
            }
            case 1: {
                this.getSelectedChannel().getDrives()[0].setFeatures(nArray[0]);
                this.getSelectedChannel().getDrives()[1].setFeatures(nArray[0]);
                break;
            }
            case 2: {
                this.getSelectedChannel().getDrives()[0].setSectorCount(nArray[0]);
                this.getSelectedChannel().getDrives()[1].setSectorCount(nArray[0]);
                break;
            }
            case 3: {
                this.getSelectedChannel().getDrives()[0].setCurrentSector(nArray[0]);
                this.getSelectedChannel().getDrives()[1].setCurrentSector(nArray[0]);
                break;
            }
            case 4: {
                int n7 = this.getSelectedChannel().getDrives()[0].getCurrentCylinder() & 0xFF00 | nArray[0];
                this.getSelectedChannel().getDrives()[0].setCurrentCylinder(n7);
                int n8 = this.getSelectedChannel().getDrives()[1].getCurrentCylinder() & 0xFF00 | nArray[0];
                this.getSelectedChannel().getDrives()[1].setCurrentCylinder(n8);
                break;
            }
            case 5: {
                int n9 = nArray[0] << 8 | this.getSelectedChannel().getDrives()[0].getCurrentCylinder() & 0xFF;
                this.getSelectedChannel().getDrives()[0].setCurrentCylinder(n9);
                int n10 = nArray[0] << 8 | this.getSelectedChannel().getDrives()[1].getCurrentCylinder() & 0xFF;
                this.getSelectedChannel().getDrives()[1].setCurrentCylinder(n10);
                break;
            }
            case 6: {
                this.setPortIdeDriveHead(n, nArray);
                break;
            }
            case 7: {
                this.setHardDiskCommand(n, nArray, n5, n6);
                break;
            }
            case 22: {
                this.setPortIdeAltStatusDevice(n, bl, nArray);
                break;
            }
            default: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Returned default value 0xFF");
                return false;
            }
        }
        return true;
    }

    private void writeSectors(int n, int[] nArray, int n2, int n3) {
        if (this.getSelectedDriveController().getBufferIndex() >= 512) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  IO write to address " + n + " buffer index >= 512.");
        }
        if (this.bulkIOQuantumsRequested > 0) {
            int n4 = 0;
            int n5 = 0;
            n5 = (512 - this.getSelectedDriveController().getBufferIndex()) / n3;
            if (n5 == 0) {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  IO write to address " + n + " not enough space for write.");
            }
            this.bulkIOQuantumsTransferred = this.bulkIOQuantumsRequested;
            if (n5 < this.bulkIOQuantumsTransferred) {
                this.bulkIOQuantumsTransferred = n5;
            }
            n4 = n3 * this.bulkIOQuantumsTransferred;
            this.bulkIOHostAddr += n4;
            int n6 = this.getSelectedDriveController().getBufferIndex();
            this.getSelectedDriveController().setBufferIndex(n6 += n4);
        } else {
            if (n3 >= 2) {
                this.getSelectedDriveController().setBuffer(this.getSelectedDriveController().getBufferIndex() + 1, (byte)nArray[1]);
                this.getSelectedDriveController().setBuffer(this.getSelectedDriveController().getBufferIndex(), (byte)nArray[0]);
            }
            if (n3 == 4) {
                this.getSelectedDriveController().setBuffer(this.getSelectedDriveController().getBufferIndex() + 3, (byte)nArray[3]);
                this.getSelectedDriveController().setBuffer(this.getSelectedDriveController().getBufferIndex() + 2, (byte)nArray[2]);
            }
            int n7 = this.getSelectedDriveController().getBufferIndex();
            this.getSelectedDriveController().setBufferIndex(n7 += n3);
        }
        if (this.getSelectedDriveController().getBufferIndex() >= this.getSelectedDriveController().getBufferSize() && this.ideWriteData(this.curChannelIndex, this.getSelectedDriveController().getBuffer(), this.getSelectedDriveController().getBufferSize())) {
            if (this.getSelectedDriveController().getCurrentCommand() == -59) {
                if (this.getSelectedDrive().getSectorCount() > this.getSelectedDriveController().getMultipleSectors()) {
                    this.getSelectedDriveController().setBufferSize(this.getSelectedDriveController().getMultipleSectors() * 512);
                } else {
                    this.getSelectedDriveController().setBufferSize(this.getSelectedDrive().getSectorCount() * 512);
                }
            }
            this.getSelectedDriveController().setBufferIndex(0);
            if (this.getSelectedDrive().getSectorCount() != 0) {
                this.getSelectedDriveController().getStatus().setBusy(0);
                this.getSelectedDriveController().getStatus().setDriveReady(1);
                this.getSelectedDriveController().getStatus().setDrq(1);
                this.getSelectedDriveController().getStatus().setCorrectedData(0);
                this.getSelectedDriveController().getStatus().setErr(0);
            } else {
                this.getSelectedDriveController().getStatus().setBusy(0);
                this.getSelectedDriveController().getStatus().setDriveReady(1);
                this.getSelectedDriveController().getStatus().setDrq(0);
                this.getSelectedDriveController().getStatus().setErr(0);
                this.getSelectedDriveController().getStatus().setCorrectedData(0);
            }
            this.raiseInterrupt(n2);
        }
    }

    private byte[] executeGetCommand(int n, int n2) {
        int n3;
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            byArray[n3] = 0;
        }
        n3 = this.getSelectedDriveController().getCurrentCommand();
        ATACommand aTACommand = ATACommand.getCommand((byte)n3);
        if (this.getSelectedDriveController().getStatus().getDrq() == 0) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  IO read(" + n + ") with drq == 0: last command was " + aTACommand.toString() + ", address " + aTACommand.getAddress() + " IO Length " + n2);
            return byArray;
        }
        if (aTACommand != null) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  IO read(" + n + ") current command is " + aTACommand.toString() + ",address " + aTACommand.getAddress() + " IO Length " + n2);
        }
        if (aTACommand == null) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  read cmd " + n3 + " not recognised");
            return byArray;
        }
        if (aTACommand == ATACommand.READ_SECTORS_WITH_RETRY || aTACommand == ATACommand.READ_SECTORS_WITHOUT_RETRY || aTACommand == ATACommand.READ_MULTIPLE) {
            byArray = this.readSectors(n, n2);
        } else if (aTACommand == ATACommand.IDENTIFY_DRIVE || aTACommand == ATACommand.PACKET_A1) {
            this.channels[this.curChannelIndex].getSelectedController().getStatus().setBusy(0);
            this.channels[this.curChannelIndex].getSelectedController().getStatus().setDriveReady(1);
            this.channels[this.curChannelIndex].getSelectedController().getStatus().setWriteFault(0);
            this.channels[this.curChannelIndex].getSelectedController().getStatus().setSeekComplete(1);
            this.channels[this.curChannelIndex].getSelectedController().getStatus().setCorrectedData(0);
            this.channels[this.curChannelIndex].getSelectedController().getStatus().setErr(0);
            int n4 = this.channels[this.curChannelIndex].getSelectedController().getBufferIndex();
            byArray[0] = this.channels[this.curChannelIndex].getSelectedController().getBuffer()[n4];
            ++n4;
            if (n2 >= 2) {
                byArray[1] = this.channels[this.curChannelIndex].getSelectedController().getBuffer()[n4];
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  IO identify drive for index " + (n4 - 1) + " returns values " + byArray[0] + " and " + byArray[1]);
                ++n4;
            }
            if (n2 == 4) {
                byArray[2] = this.channels[this.curChannelIndex].getSelectedController().getBuffer()[n4];
                byArray[3] = this.channels[this.curChannelIndex].getSelectedController().getBuffer()[n4 + 1];
                n4 += 2;
            }
            this.channels[this.curChannelIndex].getSelectedController().setBufferIndex(n4);
            if (this.channels[this.curChannelIndex].getSelectedController().getBufferIndex() >= 512) {
                this.channels[this.curChannelIndex].getSelectedController().getStatus().setDrq(0);
            }
        } else if (aTACommand == ATACommand.PACKET_A0) {
            int n5 = this.channels[this.curChannelIndex].getSelectedController().getBufferIndex();
            int n6 = 0;
            if (n5 >= this.channels[this.curChannelIndex].getSelectedController().getBufferSize()) {
                if (n5 > this.channels[this.curChannelIndex].getSelectedController().getBufferSize()) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Read IO Packet A0 - index is greater than the bufferr size.");
                }
                switch (this.getSelectedDrive().getAtpi().getCommand()) {
                    case 40: 
                    case 168: 
                    case 190: {
                        logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  Read with no LOWLEVEL_CDROM.");
                        break;
                    }
                }
            }
            byArray[0] = this.channels[this.curChannelIndex].getSelectedController().getBuffer()[n5 + n6];
            ++n6;
            if (n2 >= 2) {
                byArray[1] = this.channels[this.curChannelIndex].getSelectedController().getBuffer()[n5 + n6];
                ++n6;
            }
            if (n2 == 4) {
                byArray[2] = this.channels[this.curChannelIndex].getSelectedController().getBuffer()[n5 + n6];
                byArray[3] = this.channels[this.curChannelIndex].getSelectedController().getBuffer()[n5 + n6 + 1];
                n6 += 2;
            }
            this.channels[this.curChannelIndex].getSelectedController().setBufferIndex(n5 + n6);
            int n7 = this.channels[this.curChannelIndex].getSelectedController().getDrqIndex() + n6;
            this.channels[this.curChannelIndex].getSelectedController().setDrqIndex(n7);
            if (this.channels[this.curChannelIndex].getSelectedController().getDrqIndex() >= Math.abs(this.channels[this.curChannelIndex].getSelectedDrive().getAtpi().getDrqBytes())) {
                this.channels[this.curChannelIndex].getSelectedController().getStatus().setDrq(0);
                this.channels[this.curChannelIndex].getSelectedController().setDrqIndex(0);
                int n8 = this.channels[this.curChannelIndex].getSelectedDrive().getAtpi().getTotalBytesRemaining() - this.channels[this.curChannelIndex].getSelectedDrive().getAtpi().getDrqBytes();
                this.channels[this.curChannelIndex].getSelectedDrive().getAtpi().setTotalBytesRemaining(n8);
                if (this.channels[this.curChannelIndex].getSelectedDrive().getAtpi().getTotalBytesRemaining() > 0) {
                    int n9;
                    this.channels[this.curChannelIndex].getSelectedController().getInterruptReason().setIo(1);
                    this.channels[this.curChannelIndex].getSelectedController().getStatus().setBusy(0);
                    this.channels[this.curChannelIndex].getSelectedController().getStatus().setDrq(1);
                    this.channels[this.curChannelIndex].getSelectedController().getInterruptReason().setCd(0);
                    if (this.channels[this.curChannelIndex].getSelectedDrive().getAtpi().getTotalBytesRemaining() < this.channels[this.curChannelIndex].getSelectedController().getByteCount()) {
                        n9 = this.channels[this.curChannelIndex].getSelectedDrive().getAtpi().getTotalBytesRemaining();
                        this.channels[this.curChannelIndex].getSelectedController().setByteCount(n9);
                    }
                    n9 = this.channels[this.curChannelIndex].getSelectedController().getByteCount();
                    this.channels[this.curChannelIndex].getSelectedDrive().getAtpi().setDrqBytes(n9);
                    this.raiseInterrupt(this.curChannelIndex);
                } else {
                    this.channels[this.curChannelIndex].getSelectedController().getInterruptReason().setIo(1);
                    this.channels[this.curChannelIndex].getSelectedController().getInterruptReason().setCd(1);
                    this.channels[this.curChannelIndex].getSelectedController().getStatus().setDriveReady(1);
                    this.channels[this.curChannelIndex].getSelectedController().getInterruptReason().setRel(0);
                    this.channels[this.curChannelIndex].getSelectedController().getStatus().setBusy(0);
                    this.channels[this.curChannelIndex].getSelectedController().getStatus().setDrq(0);
                    this.channels[this.curChannelIndex].getSelectedController().getStatus().setErr(0);
                    this.raiseInterrupt(this.curChannelIndex);
                }
            }
        } else {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  IO read current command " + aTACommand.getAddress() + " (" + aTACommand.getName() + ") not supported.");
        }
        return byArray;
    }

    private void abortCommand(int n, int n2) {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  aborting: channel " + n + "data " + n2 + ".");
        this.getSelectedDriveController().setCurrentCommand(0);
        this.getSelectedDriveController().getStatus().setBusy(0);
        this.getSelectedDriveController().getStatus().setDriveReady(1);
        this.getSelectedDriveController().getStatus().setErr(1);
        this.getSelectedDriveController().setErrorRegister(4);
        this.getSelectedDriveController().getStatus().setDrq(0);
        this.getSelectedDriveController().getStatus().setSeekComplete(0);
        this.getSelectedDriveController().getStatus().setCorrectedData(0);
        this.getSelectedDriveController().setBufferIndex(0);
        this.raiseInterrupt(n);
    }

    private void raiseInterrupt(int n) {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  raise interrupt called, disable_irq = " + this.getSelectedDriveController().isDisableIrq() + ".");
        if (!this.getSelectedDriveController().isDisableIrq()) {
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  raising interrupt.");
        } else {
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  not raising interrupt.");
        }
        if (!this.getSelectedDriveController().isDisableIrq()) {
            int n2 = this.getSelectedChannel().getIrqNumber();
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  Raising interrupt " + n2 + " on channel " + n + ".");
            ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
            modulePIC.setIRQ(n2);
        }
    }

    private void setPortIdeDriveHead(int n, int[] nArray) {
        if ((nArray[0] & 0xA0) != 160) {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  IO write to address " + n + ", data " + nArray + " invalid as not 1x1xxxxxb.");
        }
        this.getSelectedChannel().setSelectedDriveIndex(nArray[0] >> 4 & 1);
        int n2 = this.getSelectedChannel().getSelectedDriveIndex();
        int n3 = nArray[0] & 0xF;
        this.getSelectedChannel().getDrives()[0].setCurrentHead(n3);
        this.getSelectedChannel().getDrives()[1].setCurrentHead(n3);
        if (this.getSelectedChannel().getSelectedController().getLbaMode() == 0 && (nArray[0] >> 6 & 1) == 1) {
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  Enabling LBA mode.");
        }
        int n4 = nArray[0] >> 6 & 1;
        this.getSelectedChannel().getDrives()[0].getControl().setLbaMode(n4);
        this.getSelectedChannel().getDrives()[1].getControl().setLbaMode(n4);
        if (this.getSelectedDrive().getDriveType() == ATADriveType.NONE) {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  ATA device for channel " + this.curChannelIndex + " set to " + n2 + " which does not exist.");
        }
    }

    private void setPortIdeAltStatusDevice(int n, boolean bl, int[] nArray) {
        block5: {
            block4: {
                bl = this.getSelectedDriveController().isReset();
                boolean bl2 = false;
                if ((nArray[0] & 4) > 0) {
                    bl2 = true;
                }
                this.getSelectedChannel().getDrives()[0].getControl().setReset(bl2);
                this.getSelectedChannel().getDrives()[1].getControl().setReset(bl2);
                boolean bl3 = false;
                if ((nArray[0] & 2) > 0) {
                    bl3 = true;
                }
                this.getSelectedChannel().getDrives()[0].getControl().setDisableIrq(bl3);
                this.getSelectedChannel().getDrives()[1].getControl().setDisableIrq(bl3);
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Adapter control reg: reset controller set to " + this.getSelectedDriveController().isReset() + " for channel " + this.curChannelIndex + ".");
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Adapter control reg: disable_irq(X) set to " + this.getSelectedDriveController().isDisableIrq() + " for channel " + this.curChannelIndex + ".");
                if (bl || !this.getSelectedDriveController().isReset()) break block4;
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Hard drive: RESET.");
                for (int i = 0; i < 2; ++i) {
                    this.getSelectedChannel().getDrives()[i].getControl().getStatus().setBusy(1);
                    this.getSelectedChannel().getDrives()[i].getControl().getStatus().setDriveReady(0);
                    this.getSelectedChannel().getDrives()[i].getControl().setResetInProgress(1);
                    this.getSelectedChannel().getDrives()[i].getControl().getStatus().setWriteFault(0);
                    this.getSelectedChannel().getDrives()[i].getControl().getStatus().setSeekComplete(1);
                    this.getSelectedChannel().getDrives()[i].getControl().getStatus().setDrq(0);
                    this.getSelectedChannel().getDrives()[i].getControl().getStatus().setCorrectedData(0);
                    this.getSelectedChannel().getDrives()[i].getControl().getStatus().setErr(0);
                    this.getSelectedChannel().getDrives()[i].getControl().setErrorRegister(1);
                    this.getSelectedChannel().getDrives()[i].getControl().setCurrentCommand(0);
                    this.getSelectedChannel().getDrives()[i].getControl().setBufferIndex(0);
                    this.getSelectedChannel().getDrives()[i].getControl().setMultipleSectors(0);
                    this.getSelectedChannel().getDrives()[i].getControl().setLbaMode(0);
                    this.getSelectedChannel().getDrives()[i].getControl().setDisableIrq(false);
                    ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
                    modulePIC.clearIRQ(this.getSelectedChannel().getIrqNumber());
                }
                break block5;
            }
            if (this.getSelectedDriveController().getResetInProgress() <= 0 || this.getSelectedDriveController().isReset()) break block5;
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  Reset complete for channel " + this.curChannelIndex);
            for (int i = 0; i < 2; ++i) {
                this.getSelectedChannel().getDrives()[i].getControl().getStatus().setBusy(0);
                this.getSelectedChannel().getDrives()[i].getControl().getStatus().setDriveReady(1);
                this.getSelectedChannel().getDrives()[i].getControl().setResetInProgress(0);
                this.setSignature(this.curChannelIndex);
            }
        }
    }

    private void executeSetCommand(int n, int[] nArray, int n2) {
        int n3 = this.getSelectedDriveController().getCurrentCommand();
        ATACommand aTACommand = ATACommand.getCommand((byte)n3);
        if (aTACommand == null) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  write cmd " + n3 + " not recognised");
            return;
        }
        if (aTACommand == ATACommand.WRITE_SECTORS_WITH_RETRY || aTACommand == ATACommand.WRITE_MULTIPLE) {
            this.writeSectors(n, nArray, this.curChannelIndex, n2);
        } else if (aTACommand == ATACommand.PACKET_A0) {
            this.setPacketA0(n, this.curChannelIndex, nArray, n2);
        } else {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  write cmd " + aTACommand.getAddress() + " (" + aTACommand.getName() + ") not supported");
        }
    }

    private boolean ideReadData(int n, byte[] byArray, int n2) {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        int n3 = 0;
        int n4 = n2 / 512;
        do {
            if (!this.getSelectedDrive().calculateLogicalAddress(n3)) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  read sector reached invalid sector " + n3 + " aborting.");
                this.abortCommand(n, this.channels[this.curChannelIndex].getSelectedController().getCurrentCommand());
                return false;
            }
            n3 = this.getSelectedDrive().calculateLogicalAddress();
            this.getSelectedDrive().setIoLightCounter(5);
            moduleMotherboard.resetTimer(this, this.updateInterval);
            moduleMotherboard.setTimerActiveState(this, true);
            try {
                int n5 = this.getSelectedDrive().hdNumber;
                if (n5 == 1) {
                    this.emu.statusChanged(2);
                }
                if (n5 == 2) {
                    this.emu.statusChanged(10);
                }
                byte[] byArray2 = this.getSelectedDrive().readData(this.getSelectedDriveController().getBuffer(), n3 * 512, 512);
                for (int i = 0; i < byArray2.length; ++i) {
                    this.getSelectedDriveController().setBuffer(i, byArray2[i]);
                }
                if (n5 == 1) {
                    this.emu.statusChanged(3);
                }
                if (n5 == 2) {
                    this.emu.statusChanged(11);
                }
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  logical sector was " + n3 + ".");
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  could not read() hard drive image file at byte " + n3 * 512 + ".");
                this.abortCommand(n, this.channels[n].getSelectedController().getCurrentCommand());
                return false;
            }
            this.channels[n].getSelectedDrive().incrementAddress();
        } while (--n4 > 0);
        return true;
    }

    private boolean ideWriteData(int n, byte[] byArray, int n2) {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        int n3 = 0;
        int n4 = n2 / 512;
        do {
            if (!this.getSelectedDrive().calculateLogicalAddress(n3)) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  IO write reached invalid sector " + n3 + ", aborting.");
                this.abortCommand(n, this.getSelectedDriveController().getCurrentCommand());
                return false;
            }
            n3 = this.getSelectedDrive().calculateLogicalAddress();
            this.getSelectedDrive().setIoLightCounter(5);
            moduleMotherboard.resetTimer(this, this.updateInterval);
            moduleMotherboard.setTimerActiveState(this, true);
            try {
                this.emu.statusChanged(2);
                this.getSelectedDrive().writeData(this.getSelectedDriveController().getBuffer(), n3 * 512, 512);
                this.emu.statusChanged(3);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  IO write could not write()hard drive image file at byte " + n3 * 512 + ", aborting.");
                this.abortCommand(n, this.getSelectedDriveController().getCurrentCommand());
                return false;
            }
            this.getSelectedDrive().incrementAddress();
        } while (--n4 > 0);
        return true;
    }

    private void setPacketA0(int n, int n2, int[] nArray, int n3) {
        if (this.getSelectedDriveController().getBufferIndex() >= 12) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  IO write to adress, " + n + " buffer_index >= PACKET_SIZE.");
            return;
        }
        if (n3 >= 2) {
            this.getSelectedDriveController().setBuffer(this.getSelectedDriveController().getBufferIndex() + 1, (byte)nArray[1]);
            this.getSelectedDriveController().setBuffer(this.getSelectedDriveController().getBufferIndex(), (byte)nArray[0]);
        }
        if (n3 == 4) {
            this.getSelectedDriveController().setBuffer(this.getSelectedDriveController().getBufferIndex() + 3, (byte)nArray[3]);
            this.getSelectedDriveController().setBuffer(this.getSelectedDriveController().getBufferIndex() + 2, (byte)nArray[2]);
        }
        int n4 = this.getSelectedDriveController().getBufferIndex();
        this.getSelectedDriveController().setBufferIndex(n4 += n3);
        if (this.getSelectedDriveController().getBufferIndex() >= 12) {
            byte by = this.getSelectedDriveController().getBuffer()[0];
            this.getSelectedDriveController().setBufferSize(2048);
            block0 : switch (by) {
                case 0: {
                    if (this.getSelectedDrive().getCdRom().isReady()) {
                        this.atapiCmdNop(n2);
                    } else {
                        this.atapiCmdError(n2, SenseType.NOT_READY, AscType.MEDIUM_NOT_PRESENT, false);
                    }
                    this.raiseInterrupt(n2);
                    break;
                }
                case 3: {
                    byte by2 = this.getSelectedDriveController().getBuffer()[4];
                    this.initSendAtapiCommand(n2, by, 18, by2, false);
                    this.getSelectedDriveController().setBuffer(0, (byte)-16);
                    this.getSelectedDriveController().setBuffer(1, (byte)0);
                    this.getSelectedDriveController().setBuffer(2, (byte)this.getSelectedDrive().getSenseInfo().getSenseKey().getValue());
                    this.getSelectedDriveController().setBuffer(3, this.getSelectedDrive().getSenseInfo().getInformation()[0]);
                    this.getSelectedDriveController().setBuffer(4, this.getSelectedDrive().getSenseInfo().getInformation()[1]);
                    this.getSelectedDriveController().setBuffer(5, this.getSelectedDrive().getSenseInfo().getInformation()[2]);
                    this.getSelectedDriveController().setBuffer(6, this.getSelectedDrive().getSenseInfo().getInformation()[3]);
                    this.getSelectedDriveController().setBuffer(7, (byte)10);
                    this.getSelectedDriveController().setBuffer(8, this.getSelectedDrive().getSenseInfo().getSpecificInf()[0]);
                    this.getSelectedDriveController().setBuffer(9, this.getSelectedDrive().getSenseInfo().getSpecificInf()[1]);
                    this.getSelectedDriveController().setBuffer(10, this.getSelectedDrive().getSenseInfo().getSpecificInf()[2]);
                    this.getSelectedDriveController().setBuffer(11, this.getSelectedDrive().getSenseInfo().getSpecificInf()[3]);
                    this.getSelectedDriveController().setBuffer(12, (byte)this.getSelectedDrive().getSenseInfo().getAsc().getValue());
                    this.getSelectedDriveController().setBuffer(13, this.getSelectedDrive().getSenseInfo().getAscq());
                    this.getSelectedDriveController().setBuffer(14, this.getSelectedDrive().getSenseInfo().getFruc());
                    this.getSelectedDriveController().setBuffer(15, this.getSelectedDrive().getSenseInfo().getKeySpec()[0]);
                    this.getSelectedDriveController().setBuffer(16, this.getSelectedDrive().getSenseInfo().getKeySpec()[1]);
                    this.getSelectedDriveController().setBuffer(17, this.getSelectedDrive().getSenseInfo().getKeySpec()[2]);
                    this.readyToSendAtapi(n2);
                    break;
                }
                case 27: {
                    int n5 = this.getSelectedDriveController().getBuffer()[4] >> 1 & 1;
                    int n6 = this.getSelectedDriveController().getBuffer()[4] >> 0 & 1;
                    if (n5 <= 0 && n6 <= 0) {
                        logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  Stop disc not implemented.");
                        this.atapiCmdNop(n2);
                        this.raiseInterrupt(n2);
                        break;
                    }
                    if (n5 <= 0 && n6 > 0) {
                        logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  ATAPI start disc not reading TOC.");
                        this.atapiCmdNop(n2);
                        this.raiseInterrupt(n2);
                        break;
                    }
                    if (n5 > 0 && n6 <= 0) {
                        this.atapiCmdNop(n2);
                        if (this.getSelectedDrive().getCdRom().isReady()) {
                            this.getSelectedDrive().getCdRom().setReady(false);
                        }
                        this.raiseInterrupt(n2);
                        break;
                    }
                    this.atapiCmdNop(n2);
                    this.raiseInterrupt(n2);
                    break;
                }
                case -67: {
                    int n7 = 0;
                    n7 = this.read16bit(this.getSelectedDriveController().getBuffer(), 8);
                    if (n7 == 0) {
                        logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  Not implemented: Zero allocation length to MECHANISM STATUS.");
                        return;
                    }
                    this.initSendAtapiCommand(n2, by, 8, n7, false);
                    this.getSelectedDriveController().setBuffer(0, (byte)0);
                    this.getSelectedDriveController().setBuffer(1, (byte)0);
                    this.getSelectedDriveController().setBuffer(2, (byte)0);
                    this.getSelectedDriveController().setBuffer(3, (byte)0);
                    this.getSelectedDriveController().setBuffer(4, (byte)0);
                    this.getSelectedDriveController().setBuffer(5, (byte)1);
                    this.getSelectedDriveController().setBuffer(6, (byte)0);
                    this.getSelectedDriveController().setBuffer(7, (byte)0);
                    this.readyToSendAtapi(n2);
                    break;
                }
                case 90: {
                    int n8 = 0;
                    n8 = this.read16bit(this.getSelectedDriveController().getBuffer(), 7);
                    int n9 = this.getSelectedDriveController().getBuffer()[2] >> 6;
                    int n10 = this.getSelectedDriveController().getBuffer()[2] & 0x3F;
                    switch (n9) {
                        case 0: {
                            switch (n10) {
                                case 1: {
                                    this.initSendAtapiCommand(n2, by, this.getSelectedDrive().getCdRom().getErrorRecovery().length + 8, n8, false);
                                    this.readyToSendAtapi(n2);
                                    break block0;
                                }
                                case 42: {
                                    this.initSendAtapiCommand(n2, by, 28, n8, false);
                                    Object[] objectArray = new Object[]{this.getSelectedDriveController().getBuffer()[8]};
                                    this.initModeSenseSingle(n2, objectArray, 28);
                                    this.getSelectedDriveController().setBuffer(8, (byte)42);
                                    this.getSelectedDriveController().setBuffer(9, (byte)18);
                                    this.getSelectedDriveController().setBuffer(10, (byte)0);
                                    this.getSelectedDriveController().setBuffer(11, (byte)0);
                                    this.getSelectedDriveController().setBuffer(12, (byte)112);
                                    this.getSelectedDriveController().setBuffer(13, (byte)96);
                                    this.getSelectedDriveController().setBuffer(14, (byte)(1 | (this.getSelectedDrive().getCdRom().isLocked() ? 2 : 0) | 8 | 0x20));
                                    this.getSelectedDriveController().setBuffer(15, (byte)0);
                                    this.getSelectedDriveController().setBuffer(16, (byte)2);
                                    this.getSelectedDriveController().setBuffer(17, (byte)-62);
                                    this.getSelectedDriveController().setBuffer(18, (byte)0);
                                    this.getSelectedDriveController().setBuffer(19, (byte)2);
                                    this.getSelectedDriveController().setBuffer(20, (byte)2);
                                    this.getSelectedDriveController().setBuffer(21, (byte)0);
                                    this.getSelectedDriveController().setBuffer(22, (byte)2);
                                    this.getSelectedDriveController().setBuffer(23, (byte)-62);
                                    this.getSelectedDriveController().setBuffer(24, (byte)0);
                                    this.getSelectedDriveController().setBuffer(25, (byte)0);
                                    this.getSelectedDriveController().setBuffer(26, (byte)0);
                                    this.getSelectedDriveController().setBuffer(27, (byte)0);
                                    this.readyToSendAtapi(n2);
                                    break block0;
                                }
                                case 13: 
                                case 14: 
                                case 63: {
                                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  cdrom: MODE SENSE (curr), page code " + n10 + ", not implemented yet.");
                                    this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.INV_FIELD_IN_CMD_PACKET, true);
                                    this.raiseInterrupt(n2);
                                    break block0;
                                }
                            }
                            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  cdrom: MODE SENSE pc " + n9 + ", page code, " + n10 + ", not implemented by device.");
                            this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.INV_FIELD_IN_CMD_PACKET, true);
                            this.raiseInterrupt(n2);
                            break block0;
                        }
                        case 1: {
                            switch (n10) {
                                case 1: 
                                case 13: 
                                case 14: 
                                case 42: 
                                case 63: {
                                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  cdrom: MODE SENSE (chg), page code " + n10 + ", not implemented yet.");
                                    this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.INV_FIELD_IN_CMD_PACKET, true);
                                    this.raiseInterrupt(n2);
                                    break block0;
                                }
                            }
                            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  cdrom: MODE SENSE PC " + n9 + ", page code " + n10 + ", not implemented by device.");
                            this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.INV_FIELD_IN_CMD_PACKET, true);
                            this.raiseInterrupt(n2);
                            break block0;
                        }
                        case 2: {
                            switch (n10) {
                                case 42: {
                                    this.initSendAtapiCommand(n2, by, 28, n8, false);
                                    Object[] objectArray = new Object[]{this.getSelectedDriveController().getBuffer()[8]};
                                    this.initModeSenseSingle(n2, objectArray, 28);
                                    this.getSelectedDriveController().setBuffer(8, (byte)42);
                                    this.getSelectedDriveController().setBuffer(9, (byte)18);
                                    this.getSelectedDriveController().setBuffer(10, (byte)0);
                                    this.getSelectedDriveController().setBuffer(11, (byte)0);
                                    this.getSelectedDriveController().setBuffer(12, (byte)112);
                                    this.getSelectedDriveController().setBuffer(13, (byte)96);
                                    this.getSelectedDriveController().setBuffer(14, (byte)(1 | (this.getSelectedDrive().getCdRom().isLocked() ? 2 : 0) | 8 | 0x20));
                                    this.getSelectedDriveController().setBuffer(15, (byte)0);
                                    this.getSelectedDriveController().setBuffer(16, (byte)2);
                                    this.getSelectedDriveController().setBuffer(17, (byte)-62);
                                    this.getSelectedDriveController().setBuffer(18, (byte)0);
                                    this.getSelectedDriveController().setBuffer(19, (byte)2);
                                    this.getSelectedDriveController().setBuffer(20, (byte)2);
                                    this.getSelectedDriveController().setBuffer(21, (byte)0);
                                    this.getSelectedDriveController().setBuffer(22, (byte)2);
                                    this.getSelectedDriveController().setBuffer(23, (byte)-62);
                                    this.getSelectedDriveController().setBuffer(24, (byte)0);
                                    this.getSelectedDriveController().setBuffer(25, (byte)0);
                                    this.getSelectedDriveController().setBuffer(26, (byte)0);
                                    this.getSelectedDriveController().setBuffer(27, (byte)0);
                                    this.readyToSendAtapi(n2);
                                    break block0;
                                }
                                case 1: 
                                case 13: 
                                case 14: 
                                case 63: {
                                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  cdrom: MODE SENSE (dflt), page code " + n10 + ", not implemented.");
                                    this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.INV_FIELD_IN_CMD_PACKET, true);
                                    this.raiseInterrupt(n2);
                                    break block0;
                                }
                            }
                            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  cdrom: MODE SENSE PC " + n9 + ", page code " + n10 + ", not implemented by device.");
                            this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.INV_FIELD_IN_CMD_PACKET, true);
                            this.raiseInterrupt(n2);
                            break block0;
                        }
                        case 3: {
                            this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.SAVING_PARAMETERS_NOT_SUPPORTED, true);
                            this.raiseInterrupt(n2);
                            break block0;
                        }
                    }
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  IO Write setPacketA0 pc value not recognised.");
                    break;
                }
                case 18: {
                    byte by3 = this.getSelectedDriveController().getBuffer()[4];
                    this.initSendAtapiCommand(n2, by, 36, by3, false);
                    this.getSelectedDriveController().setBuffer(0, (byte)5);
                    this.getSelectedDriveController().setBuffer(1, (byte)-128);
                    this.getSelectedDriveController().setBuffer(2, (byte)0);
                    this.getSelectedDriveController().setBuffer(3, (byte)33);
                    this.getSelectedDriveController().setBuffer(4, (byte)31);
                    this.getSelectedDriveController().setBuffer(5, (byte)0);
                    this.getSelectedDriveController().setBuffer(6, (byte)0);
                    this.getSelectedDriveController().setBuffer(7, (byte)0);
                    String string = "Undefined   ";
                    char[] cArray = string.toCharArray();
                    for (int i = 0; i < 8; ++i) {
                        this.getSelectedDriveController().setBuffer(8 + i, (byte)cArray[i]);
                    }
                    String string2 = "Compatible CD-ROM    ";
                    char[] cArray2 = string2.toCharArray();
                    for (int i = 0; i < 16; ++i) {
                        this.getSelectedDriveController().setBuffer(16 + i, (byte)cArray2[i]);
                    }
                    String string3 = "1.0 ";
                    char[] cArray3 = string3.toCharArray();
                    for (int i = 0; i < 4; ++i) {
                        this.getSelectedDriveController().setBuffer(32 + i, (byte)cArray3[i]);
                    }
                    this.readyToSendAtapi(n2);
                    break;
                }
                case 37: {
                    this.initSendAtapiCommand(n2, by, 8, 8, false);
                    if (this.getSelectedDrive().getCdRom().isReady()) {
                        int n11 = this.getSelectedDrive().getCdRom().getCapacity() - 1;
                        this.getSelectedDriveController().setBuffer(0, (byte)(n11 >> 24 & 0xFF));
                        this.getSelectedDriveController().setBuffer(1, (byte)(n11 >> 16 & 0xFF));
                        this.getSelectedDriveController().setBuffer(2, (byte)(n11 >> 8 & 0xFF));
                        this.getSelectedDriveController().setBuffer(3, (byte)(n11 >> 0 & 0xFF));
                        this.getSelectedDriveController().setBuffer(4, (byte)0);
                        this.getSelectedDriveController().setBuffer(5, (byte)0);
                        this.getSelectedDriveController().setBuffer(6, (byte)8);
                        this.getSelectedDriveController().setBuffer(7, (byte)0);
                        this.readyToSendAtapi(n2);
                        break;
                    }
                    this.atapiCmdError(n2, SenseType.NOT_READY, AscType.MEDIUM_NOT_PRESENT, true);
                    this.raiseInterrupt(n2);
                    break;
                }
                case -66: {
                    if (this.getSelectedDrive().getCdRom().isReady()) {
                        int n12 = 0;
                        n12 = this.read32bit(this.getSelectedDriveController().getBuffer(), 2);
                        int n13 = this.getSelectedDriveController().getBuffer()[8] | this.getSelectedDriveController().getBuffer()[7] << 8 | this.getSelectedDriveController().getBuffer()[6] << 16;
                        byte by4 = this.getSelectedDriveController().getBuffer()[9];
                        if (n13 == 0) {
                            this.atapiCmdNop(n2);
                            this.raiseInterrupt(n2);
                            break;
                        }
                        switch (by4 & 0xF8) {
                            case 0: {
                                this.atapiCmdNop(n2);
                                this.raiseInterrupt(n2);
                                break;
                            }
                            case 248: {
                                this.getSelectedDriveController().setBufferSize(2352);
                            }
                            case 16: {
                                this.initSendAtapiCommand(n2, by, n13 * this.getSelectedDriveController().getBufferSize(), n13 * this.getSelectedDriveController().getBufferSize(), true);
                                this.getSelectedDrive().getCdRom().setRemainingBlocks(n13);
                                this.getSelectedDrive().getCdRom().setNextLba(n12);
                                if (this.getSelectedDriveController().getPacketDma() != 0) break block0;
                                this.readyToSendAtapi(n2);
                                break;
                            }
                            default: {
                                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  Read CD: unknown format.");
                                this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.INV_FIELD_IN_CMD_PACKET, true);
                                this.raiseInterrupt(n2);
                                break;
                            }
                        }
                        break;
                    }
                    this.atapiCmdError(n2, SenseType.NOT_READY, AscType.MEDIUM_NOT_PRESENT, true);
                    this.raiseInterrupt(n2);
                    break;
                }
                case 67: {
                    boolean bl = false;
                    if (this.getSelectedDrive().getCdRom().isReady()) {
                        int n14 = 0;
                        n14 = this.read16bit(this.getSelectedDriveController().getBuffer(), 7);
                        int n15 = this.getSelectedDriveController().getBuffer()[9] >> 6;
                        logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  LOWLEVEL_CDROM not defined.");
                        break;
                    }
                    this.atapiCmdError(n2, SenseType.NOT_READY, AscType.MEDIUM_NOT_PRESENT, true);
                    this.raiseInterrupt(n2);
                    break;
                }
                case -88: 
                case 40: {
                    int n16 = 0;
                    n16 = by == 40 ? this.read16bit(this.getSelectedDriveController().getBuffer(), 7) : this.read32bit(this.getSelectedDriveController().getBuffer(), 6);
                    int n17 = 0;
                    n17 = this.read32bit(this.getSelectedDriveController().getBuffer(), 2);
                    if (!this.getSelectedDrive().getCdRom().isReady()) {
                        this.atapiCmdError(n2, SenseType.NOT_READY, AscType.MEDIUM_NOT_PRESENT, true);
                        this.raiseInterrupt(n2);
                        break;
                    }
                    if (n17 + n16 > this.getSelectedDrive().getCdRom().getCapacity()) {
                        n16 = this.getSelectedDrive().getCdRom().getCapacity() - n17;
                    }
                    if (n16 <= 0) {
                        this.atapiCmdNop(n2);
                        this.raiseInterrupt(n2);
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Read with transfer length <= 0, ok (" + n16 + ")");
                        break;
                    }
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  cdrom: READ LBA " + n17 + ", length " + n16 + ".");
                    this.initSendAtapiCommand(n2, by, n16 * 2048, n16 * 2048, true);
                    this.getSelectedDrive().getCdRom().setRemainingBlocks(n16);
                    this.getSelectedDrive().getCdRom().setNextLba(n17);
                    if (this.getSelectedDriveController().getPacketDma() != 0) break;
                    this.readyToSendAtapi(n2);
                    break;
                }
                case 43: {
                    int n18 = 0;
                    n18 = this.read32bit(this.getSelectedDriveController().getBuffer(), 2);
                    if (!this.getSelectedDrive().getCdRom().isReady()) {
                        this.atapiCmdError(n2, SenseType.NOT_READY, AscType.MEDIUM_NOT_PRESENT, true);
                        this.raiseInterrupt(n2);
                        break;
                    }
                    if (n18 > this.getSelectedDrive().getCdRom().getCapacity()) {
                        this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.LOGICAL_BLOCK_OOR, true);
                        this.raiseInterrupt(n2);
                        break;
                    }
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  Seek with no LOWLEVEL_CDROM.");
                    this.atapiCmdNop(n2);
                    this.raiseInterrupt(n2);
                    break;
                }
                case 30: {
                    if (this.getSelectedDrive().getCdRom().isReady()) {
                        boolean bl = (this.getSelectedDriveController().getBuffer()[4] & 1) > 0;
                        this.getSelectedDrive().getCdRom().setLocked(bl);
                        this.atapiCmdNop(n2);
                    } else {
                        this.atapiCmdError(n2, SenseType.NOT_READY, AscType.MEDIUM_NOT_PRESENT, true);
                    }
                    this.raiseInterrupt(n2);
                    break;
                }
                case 66: {
                    int n19 = this.getPacketField(n2, 1, 1, 1);
                    int n20 = this.getPacketField(n2, 2, 6, 1);
                    int n21 = this.getPacketByte(n2, 3);
                    int n22 = this.getPacketByte(n2, 6);
                    int n23 = this.getPacketWord(n2, 7);
                    int n24 = 4;
                    if (!this.getSelectedDrive().getCdRom().isReady()) {
                        this.atapiCmdError(n2, SenseType.NOT_READY, AscType.MEDIUM_NOT_PRESENT, true);
                        this.raiseInterrupt(n2);
                        break;
                    }
                    this.getSelectedDriveController().setBuffer(0, (byte)0);
                    this.getSelectedDriveController().setBuffer(1, (byte)0);
                    this.getSelectedDriveController().setBuffer(2, (byte)0);
                    this.getSelectedDriveController().setBuffer(3, (byte)0);
                    if (n20 > 0) {
                        if (n21 == 2 || n21 == 3) {
                            n24 = 24;
                            this.getSelectedDriveController().setBuffer(4, (byte)n21);
                            if (n21 == 3) {
                                this.getSelectedDriveController().setBuffer(5, (byte)20);
                                this.getSelectedDriveController().setBuffer(6, (byte)1);
                            }
                            this.getSelectedDriveController().setBuffer(8, (byte)0);
                        } else {
                            this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.INV_FIELD_IN_CMD_PACKET, true);
                            this.raiseInterrupt(n2);
                            break;
                        }
                    }
                    this.initSendAtapiCommand(n2, by, n24, n23, false);
                    this.readyToSendAtapi(n2);
                    break;
                }
                case 81: {
                    this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.INV_FIELD_IN_CMD_PACKET, true);
                    this.raiseInterrupt(n2);
                    break;
                }
                case -90: 
                case -71: 
                case -70: 
                case -69: 
                case -68: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 74: 
                case 75: 
                case 78: 
                case 85: {
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  ATAPI command " + by + " not implemented yet.");
                    this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.ILLEGAL_OPCODE, true);
                    this.raiseInterrupt(n2);
                    break;
                }
                default: {
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  Unknown ATAPI command " + by + ".");
                    this.atapiCmdError(n2, SenseType.ILLEGAL_REQUEST, AscType.ILLEGAL_OPCODE, true);
                    this.raiseInterrupt(n2);
                }
            }
        }
    }

    private void initModeSenseSingle(int n, Object[] objectArray, int n2) {
        this.getSelectedDriveController().setBuffer(0, (byte)(n2 + 6 >> 8));
        this.getSelectedDriveController().setBuffer(1, (byte)(n2 + 6 & 0xFF));
        this.getSelectedDriveController().setBuffer(2, (byte)112);
        this.getSelectedDriveController().setBuffer(3, (byte)0);
        this.getSelectedDriveController().setBuffer(4, (byte)0);
        this.getSelectedDriveController().setBuffer(5, (byte)0);
        this.getSelectedDriveController().setBuffer(6, (byte)0);
        this.getSelectedDriveController().setBuffer(7, (byte)0);
    }

    private void atapiCmdNop(int n) {
        this.getSelectedDriveController().getInterruptReason().setIo(1);
        this.getSelectedDriveController().getInterruptReason().setCd(1);
        this.getSelectedDriveController().getInterruptReason().setRel(0);
        this.getSelectedDriveController().getStatus().setBusy(0);
        this.getSelectedDriveController().getStatus().setDriveReady(1);
        this.getSelectedDriveController().getStatus().setDrq(0);
        this.getSelectedDriveController().getStatus().setErr(0);
    }

    private int getPacketField(int n, int n2, int n3, int n4) {
        int n5 = 0;
        byte[] byArray = this.channels[n].getSelectedController().getBuffer();
        n5 = byArray[n2] >> n3 & (1 << n4) - 1;
        return n5;
    }

    private int getPacketByte(int n, int n2) {
        byte by = this.channels[n].getSelectedController().getBuffer()[n2];
        return by;
    }

    private int getPacketWord(int n, int n2) {
        int n3 = this.channels[n].getSelectedController().getBuffer()[n] << 8 | this.channels[n].getSelectedController().getBuffer()[n + 1];
        return n3;
    }

    private void atapiCmdError(int n, SenseType senseType, AscType ascType, boolean bl) {
        if (bl) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  Atapi_cmd_error, for channel " + n + ", key " + senseType.toString() + ", asc " + ascType.toString() + ".");
        } else {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Atapi_cmd_error, for channel " + n + ", key " + senseType.toString() + ", asc " + ascType.toString() + ".");
        }
        this.getSelectedDriveController().setErrorRegister(senseType.getValue() << 4);
        this.getSelectedDriveController().getInterruptReason().setIo(1);
        this.getSelectedDriveController().getInterruptReason().setCd(1);
        this.getSelectedDriveController().getInterruptReason().setRel(0);
        this.getSelectedDriveController().getStatus().setBusy(0);
        this.getSelectedDriveController().getStatus().setDriveReady(1);
        this.getSelectedDriveController().getStatus().setWriteFault(0);
        this.getSelectedDriveController().getStatus().setDrq(0);
        this.getSelectedDriveController().getStatus().setErr(1);
        this.getSelectedDrive().getSenseInfo().setSenseKey(senseType);
        this.getSelectedDrive().getSenseInfo().setAsc(ascType);
        this.getSelectedDrive().getSenseInfo().setAscq((byte)0);
    }

    private void initSendAtapiCommand(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        if (this.getSelectedDriveController().getByteCount() == 65535) {
            this.getSelectedDriveController().setByteCount(65534);
        }
        if ((this.getSelectedDriveController().getByteCount() & 1) > 0 && n4 > this.getSelectedDriveController().getByteCount()) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Odd byte count, for channel " + n + ", to ATAPI command " + n2 + ",  using " + this.getSelectedDriveController().getByteCount() + ".");
            n5 = this.getSelectedDriveController().getByteCount();
            this.getSelectedDriveController().setByteCount(--n5);
        }
        if (this.getSelectedDriveController().getByteCount() == 0) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  ATAPI command with zero byte count.");
        }
        if (n4 < 0) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "  Allocation length < 0.");
        }
        if (n4 == 0) {
            n4 = this.getSelectedDriveController().getByteCount();
        }
        this.getSelectedDriveController().getInterruptReason().setIo(1);
        this.getSelectedDriveController().getInterruptReason().setCd(0);
        this.getSelectedDriveController().getStatus().setBusy(0);
        this.getSelectedDriveController().getStatus().setDrq(1);
        this.getSelectedDriveController().getStatus().setErr(0);
        if (bl) {
            this.getSelectedDriveController().setBufferIndex(this.getSelectedDriveController().getBufferSize());
        } else {
            this.getSelectedDriveController().setBufferIndex(0);
        }
        this.getSelectedDriveController().setDrqIndex(0);
        if (this.getSelectedDriveController().getByteCount() > n3) {
            this.getSelectedDriveController().setByteCount(n3);
        }
        if (this.getSelectedDriveController().getByteCount() > n4) {
            this.getSelectedDriveController().setByteCount(n4);
        }
        this.getSelectedDrive().getAtpi().setCommand(n2);
        this.getSelectedDrive().getAtpi().setDrqBytes(this.getSelectedDriveController().getByteCount());
        n5 = n3 < n4 ? n3 : n4;
        this.getSelectedDrive().getAtpi().setTotalBytesRemaining(n5);
    }

    private void readyToSendAtapi(int n) {
        this.raiseInterrupt(n);
    }

    private void setHardDiskCommand(int n, int[] nArray, Integer n2, int n3) {
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        if (this.getSelectedChannel().isSlaveSelected() && !this.getSelectedChannel().isSlaveDrivePresent()) {
            return;
        }
        modulePIC.clearIRQ(this.getSelectedChannel().getIrqNumber());
        if (this.getSelectedDriveController().getStatus().getBusy() > 0) {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  hard disk: command sent, controller BUSY.");
        }
        if ((nArray[0] & 0xF0) == 16) {
            nArray[0] = 16;
        }
        block0 : switch (nArray[0]) {
            case 16: {
                if (this.getSelectedDrive().getDriveType() != ATADriveType.HARD_DISK) {
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  Calibrate drive for channel " + this.curChannelIndex + ", issued to non-disk, with index " + this.getSelectedChannel().getSelectedDrive() + ".");
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                if (this.getSelectedDrive().getDriveType() == ATADriveType.NONE) {
                    this.getSelectedDriveController().setErrorRegister(2);
                    this.getSelectedDriveController().getStatus().setBusy(0);
                    this.getSelectedDriveController().getStatus().setDriveReady(1);
                    this.getSelectedDriveController().getStatus().setSeekComplete(0);
                    this.getSelectedDriveController().getStatus().setDrq(0);
                    this.getSelectedDriveController().getStatus().setErr(1);
                    this.raiseInterrupt(this.curChannelIndex);
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  Calibrate drive for channel " + this.curChannelIndex + ", not present, with index " + this.getSelectedChannel().getSelectedDrive() + ".");
                    break;
                }
                this.getSelectedDriveController().setErrorRegister(0);
                this.getSelectedDrive().setCurrentCylinder(0);
                this.getSelectedDriveController().getStatus().setBusy(0);
                this.getSelectedDriveController().getStatus().setDriveReady(1);
                this.getSelectedDriveController().getStatus().setSeekComplete(1);
                this.getSelectedDriveController().getStatus().setDrq(0);
                this.getSelectedDriveController().getStatus().setErr(0);
                this.raiseInterrupt(this.curChannelIndex);
                break;
            }
            case 32: 
            case 33: 
            case 196: {
                if (this.getSelectedDrive().getDriveType() != ATADriveType.HARD_DISK) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Read multiple for channel " + this.curChannelIndex + ", issued to non-disk, with index " + this.getSelectedChannel().getSelectedDrive() + ".");
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                if (this.getSelectedDriveController().getLbaMode() <= 0 && this.getSelectedDrive().getCurrentHead() <= 0 && this.getSelectedDrive().getCurrentCylinder() <= 0 && this.getSelectedDrive().getCurrentSector() <= 0) {
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  read from 0/0/0, for channel " + this.curChannelIndex + ", with device index " + this.getSelectedChannel().getSelectedDrive() + ", aborting command.");
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                if ((byte)this.channels[this.curChannelIndex].getSelectedController().getCurrentCommand() == -60) {
                    if (this.channels[this.curChannelIndex].getSelectedController().getMultipleSectors() == 0) {
                        this.abortCommand(this.curChannelIndex, nArray[0]);
                        break;
                    }
                    if (this.channels[this.curChannelIndex].getSelectedDrive().getSectorCount() > this.channels[this.curChannelIndex].getSelectedController().getMultipleSectors()) {
                        this.channels[this.curChannelIndex].getSelectedController().setBufferSize(this.channels[this.curChannelIndex].getSelectedController().getMultipleSectors() * 512);
                    } else {
                        this.channels[this.curChannelIndex].getSelectedController().setBufferSize(this.channels[this.curChannelIndex].getSelectedDrive().getSectorCount() * 512);
                    }
                } else {
                    this.channels[this.curChannelIndex].getSelectedController().setBufferSize(512);
                }
                this.getSelectedDriveController().setCurrentCommand(nArray[0]);
                if (!this.ideReadData(this.curChannelIndex, this.getSelectedDriveController().getBuffer(), this.getSelectedDriveController().getBufferSize())) break;
                this.getSelectedDriveController().setErrorRegister(0);
                this.getSelectedDriveController().getStatus().setBusy(0);
                this.getSelectedDriveController().getStatus().setDriveReady(1);
                this.getSelectedDriveController().getStatus().setSeekComplete(1);
                this.getSelectedDriveController().getStatus().setDrq(1);
                this.getSelectedDriveController().getStatus().setCorrectedData(0);
                this.getSelectedDriveController().setBufferIndex(0);
                this.raiseInterrupt(this.curChannelIndex);
                break;
            }
            case 48: 
            case 197: {
                if (this.getSelectedDrive().getDriveType() != ATADriveType.HARD_DISK) {
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  Write sectors, for channel " + this.curChannelIndex + ", issued to non-disk with device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                if (nArray[0] == -59) {
                    if (this.getSelectedDriveController().getMultipleSectors() == 0) {
                        this.abortCommand(this.curChannelIndex, nArray[0]);
                        break;
                    }
                    if (this.channels[this.curChannelIndex].getSelectedDrive().getSectorCount() > this.channels[this.curChannelIndex].getSelectedController().getMultipleSectors()) {
                        this.channels[this.curChannelIndex].getSelectedController().setBufferSize(this.channels[this.curChannelIndex].getSelectedController().getMultipleSectors() * 512);
                    } else {
                        this.channels[this.curChannelIndex].getSelectedController().setBufferSize(this.channels[this.curChannelIndex].getSelectedDrive().getSectorCount() * 512);
                    }
                } else {
                    this.channels[this.curChannelIndex].getSelectedController().setBufferSize(512);
                }
                this.getSelectedDriveController().setCurrentCommand(nArray[0]);
                this.getSelectedDriveController().setErrorRegister(0);
                this.getSelectedDriveController().getStatus().setBusy(0);
                this.getSelectedDriveController().getStatus().setSeekComplete(1);
                this.getSelectedDriveController().getStatus().setDrq(1);
                this.getSelectedDriveController().getStatus().setErr(0);
                this.getSelectedDriveController().setBufferIndex(0);
                break;
            }
            case 144: {
                if (this.getSelectedDriveController().getStatus().getBusy() > 0) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Diagnostic command, for channel " + this.curChannelIndex + ", BSY bit set, for disk with device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                this.setSignature(this.curChannelIndex);
                this.getSelectedDriveController().setErrorRegister(1);
                this.getSelectedDriveController().getStatus().setDrq(0);
                this.getSelectedDriveController().getStatus().setErr(0);
                break;
            }
            case 145: {
                if (this.getSelectedDriveController().getStatus().getBusy() > 0) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Init drive parameters command, for channel " + this.curChannelIndex + ", BSY bit set, for disk with device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                if (this.getSelectedDrive().getDriveType() != ATADriveType.HARD_DISK) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Initialize drive parameters, for channel " + this.curChannelIndex + ", issued to non-disk, with device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  Initialize drive parameters, for channel " + this.curChannelIndex + ", issued to disk, with device index " + this.getSelectedChannel().getSelectedDrive() + ", sector count= " + this.getSelectedDrive().getSectorCount() + ", current head= " + this.getSelectedDrive().getCurrentHead() + ".");
                if (this.getSelectedDrive().getDriveType() == ATADriveType.NONE) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Initialize drive parameters, for channel " + this.curChannelIndex + ", disk not present, with device index " + this.getSelectedChannel().getSelectedDrive());
                    this.getSelectedDriveController().getStatus().setBusy(0);
                    this.getSelectedDriveController().getStatus().setDriveReady(1);
                    this.getSelectedDriveController().getStatus().setDrq(0);
                    this.raiseInterrupt(this.curChannelIndex);
                    break;
                }
                if (this.getSelectedDrive().getSectorCount() != this.getSelectedDrive().getTotalNumSectors()) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Initialize drive parameters, for channel " + this.curChannelIndex + ", device index " + this.getSelectedChannel().getSelectedDrive() + " sector count doesn't match.");
                    this.getSelectedDrive().setSectorCount(this.getSelectedDrive().getTotalNumSectors());
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                if (this.getSelectedDrive().getCurrentHead() != this.getSelectedDrive().getTotalNumHeads() - 1) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Initialize drive parameters, for channel " + this.curChannelIndex + ", device index " + this.getSelectedChannel().getSelectedDrive() + " head number doesn't match.");
                    this.getSelectedDrive().setCurrentHead(this.getSelectedDrive().getTotalNumHeads() - 1);
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                this.getSelectedDriveController().getStatus().setBusy(0);
                this.getSelectedDriveController().getStatus().setDriveReady(1);
                this.getSelectedDriveController().getStatus().setDrq(0);
                this.getSelectedDriveController().getStatus().setErr(0);
                this.raiseInterrupt(this.curChannelIndex);
                break;
            }
            case 236: {
                if (this.getSelectedDrive().getDriveType() == ATADriveType.NONE) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Identify device, for channel " + this.curChannelIndex + ", disk not present, with device index " + this.getSelectedChannel().getSelectedDrive() + ", aborting.");
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                if (this.getSelectedDrive().getDriveType() == ATADriveType.CDROM) {
                    this.setSignature(this.curChannelIndex);
                    this.abortCommand(this.curChannelIndex, 236);
                    break;
                }
                this.getSelectedDriveController().setCurrentCommand(nArray[0]);
                this.getSelectedDriveController().setErrorRegister(0);
                this.getSelectedDriveController().getStatus().setBusy(0);
                this.getSelectedDriveController().getStatus().setDriveReady(1);
                this.getSelectedDriveController().getStatus().setWriteFault(0);
                this.getSelectedDriveController().getStatus().setDrq(1);
                this.getSelectedDriveController().getStatus().setSeekComplete(1);
                this.getSelectedDriveController().getStatus().setCorrectedData(0);
                this.getSelectedDriveController().setBufferIndex(0);
                this.raiseInterrupt(this.curChannelIndex);
                this.identifyDrive(this.curChannelIndex);
                break;
            }
            case 239: {
                switch (this.getSelectedDrive().getFeatures()) {
                    case 3: {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Set transfer mode, for channel " + this.curChannelIndex + ", device index " + this.getSelectedChannel().getSelectedDrive() + ", not supported for subcommand " + this.getSelectedDrive().getFeatures() + ", but returning success.");
                        this.getSelectedDriveController().getStatus().setDriveReady(1);
                        this.getSelectedDriveController().getStatus().setSeekComplete(1);
                        this.raiseInterrupt(this.curChannelIndex);
                        break block0;
                    }
                    case 2: 
                    case 85: 
                    case 102: 
                    case 130: 
                    case 170: 
                    case 204: {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  SET FEATURES, for channel " + this.curChannelIndex + ", device index " + this.getSelectedChannel().getSelectedDrive() + ", not supported for subcommand " + this.getSelectedDrive().getFeatures() + ", but returning success.");
                        this.getSelectedDriveController().getStatus().setDriveReady(1);
                        this.getSelectedDriveController().getStatus().setSeekComplete(1);
                        this.raiseInterrupt(this.curChannelIndex);
                        break block0;
                    }
                }
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  SET FEATURES, for channel " + this.curChannelIndex + ", device index " + this.getSelectedChannel().getSelectedDrive() + ", with unknown subcommand " + this.getSelectedDrive().getFeatures() + ".");
                this.abortCommand(this.curChannelIndex, nArray[0]);
                break;
            }
            case 64: {
                if (this.getSelectedDrive().getDriveType() != ATADriveType.HARD_DISK) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  read verify, for channel " + this.curChannelIndex + ", issued to non-disk with device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  verify command : 0x40, for channel " + this.curChannelIndex + ", issued to device with device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                this.getSelectedDriveController().getStatus().setBusy(0);
                this.getSelectedDriveController().getStatus().setDriveReady(1);
                this.getSelectedDriveController().getStatus().setDrq(0);
                this.getSelectedDriveController().getStatus().setErr(0);
                this.raiseInterrupt(this.curChannelIndex);
                break;
            }
            case 198: {
                if (this.getSelectedDrive().getDriveType() != ATADriveType.HARD_DISK) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Set multiple mode, for channel " + this.curChannelIndex + ", issued to non-hard disk, with device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                if (this.getSelectedDrive().getSectorCount() > 16 || (this.getSelectedDrive().getSectorCount() & this.getSelectedDrive().getSectorCount() - 1) != 0 || this.getSelectedDrive().getSectorCount() == 0) {
                    this.abortCommand(this.curChannelIndex, nArray[0]);
                    break;
                }
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  set multiple mode: sectors= " + this.getSelectedDrive().getSectorCount());
                this.getSelectedDriveController().setMultipleSectors(this.getSelectedDrive().getSectorCount());
                this.getSelectedDriveController().getStatus().setBusy(0);
                this.getSelectedDriveController().getStatus().setDriveReady(1);
                this.getSelectedDriveController().getStatus().setWriteFault(0);
                this.getSelectedDriveController().getStatus().setDrq(0);
                this.raiseInterrupt(this.curChannelIndex);
                break;
            }
            case 161: {
                if (this.getSelectedDrive().getDriveType() == ATADriveType.CDROM) {
                    this.getSelectedDriveController().setCurrentCommand(nArray[0]);
                    this.getSelectedDriveController().setErrorRegister(0);
                    this.getSelectedDriveController().getStatus().setBusy(0);
                    this.getSelectedDriveController().getStatus().setDriveReady(1);
                    this.getSelectedDriveController().getStatus().setWriteFault(0);
                    this.getSelectedDriveController().getStatus().setDrq(1);
                    this.getSelectedDriveController().getStatus().setErr(0);
                    this.getSelectedDriveController().getStatus().setSeekComplete(1);
                    this.getSelectedDriveController().getStatus().setCorrectedData(0);
                    this.getSelectedDriveController().setBufferIndex(0);
                    this.raiseInterrupt(this.curChannelIndex);
                    this.identifyAtapiDrive(this.curChannelIndex);
                    break;
                }
                this.abortCommand(this.curChannelIndex, 161);
                break;
            }
            case 8: {
                if (this.getSelectedDrive().getDriveType() == ATADriveType.CDROM) {
                    this.setSignature(this.curChannelIndex);
                    this.getSelectedDriveController().getStatus().setBusy(1);
                    int n4 = this.getSelectedDriveController().getErrorRegister();
                    this.getSelectedDriveController().setErrorRegister(n4 &= 0xFFFFFF7F);
                    this.getSelectedDriveController().getStatus().setWriteFault(0);
                    this.getSelectedDriveController().getStatus().setDrq(0);
                    this.getSelectedDriveController().getStatus().setCorrectedData(0);
                    this.getSelectedDriveController().getStatus().setErr(0);
                    this.getSelectedDriveController().getStatus().setBusy(0);
                    break;
                }
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  ATAPI Device Reset, for channel " + this.curChannelIndex + ", issued to on non-cd device, with device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                this.abortCommand(this.curChannelIndex, 8);
                break;
            }
            case 160: {
                if (this.getSelectedDrive().getDriveType() == ATADriveType.CDROM) {
                    this.getSelectedDriveController().setPacketDma(this.getSelectedDrive().getFeatures() & 1);
                    if ((this.getSelectedDrive().getFeatures() & 2) > 0) {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  PACKET-overlapped not supported, for channel " + this.curChannelIndex + ", issued to device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                        this.abortCommand(this.curChannelIndex, 160);
                        break;
                    }
                    this.getSelectedDrive().setSectorCount(1);
                    this.getSelectedDriveController().getStatus().setBusy(0);
                    this.getSelectedDriveController().getStatus().setWriteFault(0);
                    this.getSelectedDriveController().getStatus().setDrq(1);
                    this.getSelectedDriveController().getStatus().setErr(0);
                    this.getSelectedDriveController().setCurrentCommand(nArray[0]);
                    this.getSelectedDriveController().setBufferIndex(0);
                    break;
                }
                this.abortCommand(this.curChannelIndex, 160);
                break;
            }
            case 162: {
                if (this.getSelectedDrive().getDriveType() == ATADriveType.CDROM) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  ATAPI SERVICE not implemented, for channel " + this.curChannelIndex + ", issued to device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                    this.abortCommand(this.curChannelIndex, 162);
                    break;
                }
                this.abortCommand(this.curChannelIndex, 162);
                break;
            }
            case 229: {
                this.getSelectedDriveController().getStatus().setBusy(0);
                this.getSelectedDriveController().getStatus().setDriveReady(1);
                this.getSelectedDriveController().getStatus().setWriteFault(0);
                this.getSelectedDriveController().getStatus().setDrq(0);
                this.getSelectedDriveController().getStatus().setErr(0);
                this.getSelectedDrive().setSectorCount(255);
                this.raiseInterrupt(this.curChannelIndex);
                break;
            }
            case 112: {
                if (this.getSelectedDrive().getDriveType() == ATADriveType.HARD_DISK) {
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  write cmd 0x70 (SEEK) executing, for channel " + this.curChannelIndex + ", issued to device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                    if (!this.getSelectedDrive().calculateLogicalAddress(n2)) {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  seek, for channel " + this.curChannelIndex + ", issued to device index " + this.getSelectedChannel().getSelectedDrive() + "initial seek to sector " + n2 + "out of bounds, aborting.");
                        this.abortCommand(this.curChannelIndex, nArray[0]);
                        break;
                    }
                    n2 = this.getSelectedDrive().calculateLogicalAddress();
                    this.getSelectedDriveController().setErrorRegister(0);
                    this.getSelectedDriveController().getStatus().setBusy(0);
                    this.getSelectedDriveController().getStatus().setDriveReady(1);
                    this.getSelectedDriveController().getStatus().setSeekComplete(1);
                    this.getSelectedDriveController().getStatus().setDrq(0);
                    this.getSelectedDriveController().getStatus().setCorrectedData(0);
                    this.getSelectedDriveController().getStatus().setErr(0);
                    this.getSelectedDriveController().setBufferIndex(0);
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  SEEK disable ird set to " + this.getSelectedChannel().getDrives()[0].getControl().isDisableIrq() + ", for channel " + this.curChannelIndex + ", with device index " + 0 + ".");
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  SEEK disable ird set to " + this.getSelectedChannel().getDrives()[1].getControl().isDisableIrq() + ", for channel " + this.curChannelIndex + ", with device index " + 1 + ".");
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  SEEK completed. error_register " + this.getSelectedDriveController().getErrorRegister() + ", for channel " + this.curChannelIndex + ", with device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                    this.raiseInterrupt(this.curChannelIndex);
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  SEEK interrupt completed, for channel " + this.curChannelIndex + ", issued to device index " + this.getSelectedChannel().getSelectedDrive());
                    break;
                }
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  write cmd 0x70 (SEEK), for channel " + this.curChannelIndex + ", not supported for non-disk with device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                this.abortCommand(this.curChannelIndex, 112);
                break;
            }
            case 200: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  write cmd 0xC8 (READ DMA) not supported, for channel " + this.curChannelIndex + ", device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                this.abortCommand(this.curChannelIndex, 200);
                break;
            }
            case 202: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  write cmd 0xCA (WRITE DMA) not supported, for channel " + this.curChannelIndex + ", device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                this.abortCommand(this.curChannelIndex, 202);
                break;
            }
            default: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  IO write to " + n + ", unknown command " + nArray + " for channel " + this.curChannelIndex + ", device index " + this.getSelectedChannel().getSelectedDrive() + ".");
                this.abortCommand(this.curChannelIndex, nArray[0]);
            }
        }
    }

    private void identifyAtapiDrive(int n) {
        int n2;
        char c;
        int n3;
        int n4 = 0;
        char[] cArray = new char[21];
        this.getSelectedDrive().setIdDrive(0, 34240);
        for (n4 = 1; n4 <= 9; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        String string = "BXCD00000           ";
        cArray = string.toCharArray();
        cArray[7] = (char)(n + 49);
        cArray[8] = (char)(this.getSelectedChannel().getSelectedDriveIndex() + 49);
        for (n4 = 0; n4 < 10; ++n4) {
            char c2 = cArray[n4 * 2];
            char c3 = cArray[n4 * 2 + 1];
            n3 = c2 | c3 << 8;
            this.getSelectedDrive().setIdDrive(10 + n4, n3);
        }
        for (n4 = 20; n4 <= 22; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        String string2 = "ALPHA1  ";
        char[] cArray2 = string2.toCharArray();
        for (n4 = 0; n4 < cArray2.length / 2; ++n4) {
            n3 = cArray2[n4 * 2];
            c = cArray2[n4 * 2 + 1];
            n2 = n3 | c << 8;
            this.getSelectedDrive().setIdDrive(23 + n4, n2);
        }
        for (n4 = 0; n4 < this.getSelectedDrive().getModelNo().length / 2; ++n4) {
            n3 = this.getSelectedDrive().getModelNo()[n4 * 2];
            c = this.getSelectedDrive().getModelNo()[n4 * 2 + 1];
            n2 = n3 | c << 8;
            this.getSelectedDrive().setIdDrive(27 + n4, n2);
        }
        this.getSelectedDrive().setIdDrive(47, 0);
        this.getSelectedDrive().setIdDrive(47, 1);
        this.getSelectedDrive().setIdDrive(49, 512);
        this.getSelectedDrive().setIdDrive(50, 0);
        this.getSelectedDrive().setIdDrive(51, 0);
        this.getSelectedDrive().setIdDrive(52, 0);
        this.getSelectedDrive().setIdDrive(53, 3);
        for (n4 = 54; n4 <= 62; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        this.getSelectedDrive().setIdDrive(63, 259);
        this.getSelectedDrive().setIdDrive(64, 1);
        this.getSelectedDrive().setIdDrive(65, 180);
        this.getSelectedDrive().setIdDrive(66, 180);
        this.getSelectedDrive().setIdDrive(67, 300);
        this.getSelectedDrive().setIdDrive(68, 180);
        this.getSelectedDrive().setIdDrive(69, 0);
        this.getSelectedDrive().setIdDrive(70, 0);
        this.getSelectedDrive().setIdDrive(71, 30);
        this.getSelectedDrive().setIdDrive(72, 30);
        this.getSelectedDrive().setIdDrive(73, 0);
        this.getSelectedDrive().setIdDrive(74, 0);
        this.getSelectedDrive().setIdDrive(75, 0);
        for (n4 = 76; n4 <= 79; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        this.getSelectedDrive().setIdDrive(80, 30);
        this.getSelectedDrive().setIdDrive(81, 0);
        this.getSelectedDrive().setIdDrive(82, 0);
        this.getSelectedDrive().setIdDrive(83, 0);
        this.getSelectedDrive().setIdDrive(84, 0);
        this.getSelectedDrive().setIdDrive(85, 0);
        this.getSelectedDrive().setIdDrive(86, 0);
        this.getSelectedDrive().setIdDrive(87, 0);
        this.getSelectedDrive().setIdDrive(88, 0);
        for (n4 = 89; n4 <= 126; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        this.getSelectedDrive().setIdDrive(127, 0);
        this.getSelectedDrive().setIdDrive(128, 0);
        for (n4 = 129; n4 <= 159; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        for (n4 = 160; n4 <= 255; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        for (n4 = 0; n4 <= 255; ++n4) {
            n3 = this.getSelectedDrive().getIdDrive()[n4];
            this.getSelectedDriveController().setBuffer(n4 * 2, (byte)(n3 & 0xFF));
        }
    }

    private void identifyDrive(int n) {
        int n2;
        char c;
        int n3;
        int n4 = 0;
        char[] cArray = new char[21];
        int n5 = 0;
        int n6 = 0;
        this.getSelectedDrive().setIdDrive(0, 64);
        this.getSelectedDrive().setIdDrive(1, this.getSelectedDrive().getTotalNumCylinders());
        this.getSelectedDrive().setIdDrive(2, 0);
        this.getSelectedDrive().setIdDrive(3, this.getSelectedDrive().getTotalNumHeads());
        this.getSelectedDrive().setIdDrive(4, 512 * this.getSelectedDrive().getTotalNumSectors());
        this.getSelectedDrive().setIdDrive(5, 512);
        this.getSelectedDrive().setIdDrive(6, this.getSelectedDrive().getTotalNumSectors());
        for (n4 = 7; n4 <= 9; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        String string = "BXHD00000           ";
        cArray = string.toCharArray();
        cArray[7] = (char)(n + 49);
        cArray[8] = (char)(this.getSelectedChannel().getSelectedDriveIndex() + 49);
        for (n4 = 0; n4 < 10; ++n4) {
            n3 = cArray[n4 * 2];
            c = cArray[n4 * 2 + 1];
            n2 = n3 << 8 | c;
            this.getSelectedDrive().setIdDrive(10 + n4, n2);
        }
        this.getSelectedDrive().setIdDrive(20, 3);
        this.getSelectedDrive().setIdDrive(21, 512);
        this.getSelectedDrive().setIdDrive(22, 4);
        for (n4 = 23; n4 <= 26; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        for (n4 = 0; n4 < 20; ++n4) {
            n3 = this.getSelectedDrive().getModelNo()[n4 * 2];
            c = this.getSelectedDrive().getModelNo()[n4 * 2 + 1];
            n2 = n3 << 8 | c;
            this.getSelectedDrive().setIdDrive(27 + n4, n2);
        }
        this.getSelectedDrive().setIdDrive(47, 16);
        this.getSelectedDrive().setIdDrive(48, 1);
        this.getSelectedDrive().setIdDrive(49, 512);
        this.getSelectedDrive().setIdDrive(50, 0);
        this.getSelectedDrive().setIdDrive(51, 512);
        this.getSelectedDrive().setIdDrive(52, 512);
        this.getSelectedDrive().setIdDrive(53, 0);
        this.getSelectedDrive().setIdDrive(54, this.getSelectedDrive().getTotalNumCylinders());
        this.getSelectedDrive().setIdDrive(55, this.getSelectedDrive().getTotalNumHeads());
        this.getSelectedDrive().setIdDrive(56, this.getSelectedDrive().getTotalNumSectors());
        n5 = this.getSelectedDrive().getTotalNumCylinders() * this.getSelectedDrive().getTotalNumHeads() * this.getSelectedDrive().getTotalNumSectors();
        this.getSelectedDrive().setIdDrive(57, n5 & 0xFFFF);
        this.getSelectedDrive().setIdDrive(58, n5 >> 16);
        if (this.getSelectedDriveController().getMultipleSectors() > 0) {
            this.getSelectedDrive().setIdDrive(59, 0x100 | this.getSelectedDriveController().getMultipleSectors());
        } else {
            this.getSelectedDrive().setIdDrive(59, 0);
        }
        n3 = this.getSelectedDrive().getTotalNumCylinders() * this.getSelectedDrive().getTotalNumHeads() * this.getSelectedDrive().getTotalNumSectors();
        this.getSelectedDrive().setIdDrive(60, n3 & 0xFFFF);
        this.getSelectedDrive().setIdDrive(61, n3 >> 16);
        this.getSelectedDrive().setIdDrive(62, 0);
        this.getSelectedDrive().setIdDrive(63, 0);
        for (n4 = 64; n4 <= 79; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        this.getSelectedDrive().setIdDrive(80, 14);
        this.getSelectedDrive().setIdDrive(81, 0);
        this.getSelectedDrive().setIdDrive(82, 16384);
        this.getSelectedDrive().setIdDrive(83, 16384);
        this.getSelectedDrive().setIdDrive(84, 16384);
        this.getSelectedDrive().setIdDrive(85, 16384);
        this.getSelectedDrive().setIdDrive(86, 0);
        this.getSelectedDrive().setIdDrive(87, 16384);
        for (n4 = 88; n4 <= 127; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        for (n4 = 128; n4 <= 159; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        for (n4 = 160; n4 <= 255; ++n4) {
            this.getSelectedDrive().setIdDrive(n4, 0);
        }
        logger.log(Level.CONFIG, "ide -> Drive ID Info. initialized.");
        for (n4 = 0; n4 <= 255; ++n4) {
            n6 = this.getSelectedDrive().getIdDrive()[n4];
            this.getSelectedDriveController().setBuffer(n4 * 2 + 1, (byte)(n6 & 0xFF));
            this.getSelectedDriveController().setBuffer(n4 * 2, (byte)(n6 >> 8));
        }
    }

    private void setSignature(int n) {
        this.getSelectedDrive().setCurrentHead(0);
        this.getSelectedDrive().setSectorCount(1);
        this.getSelectedDrive().setCurrentSector(1);
        if (this.getSelectedDrive().getDriveType() == ATADriveType.HARD_DISK) {
            this.getSelectedDrive().setCurrentCylinder(0);
        } else if (this.getSelectedDrive().getDriveType() == ATADriveType.CDROM) {
            this.getSelectedDrive().setCurrentCylinder(60180);
        } else {
            this.getSelectedDrive().setCurrentCylinder(65535);
        }
    }

    private int read16bit(byte[] byArray, int n) {
        int n2 = byArray[0 + n] << 8 | byArray[1 + n];
        return n2;
    }

    private int read32bit(byte[] byArray, int n) {
        int n2 = byArray[0 + n] << 24 | byArray[1 + n] << 16 | byArray[2 + n] << 8 | byArray[3 + n];
        return n2;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }
}

