/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_IMUL_GvEvIb
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceWord1 = new byte[2];
    byte[] eSourceWord1 = new byte[2];
    byte[] sourceWord2 = new byte[2];
    byte[] eSourceWord2 = new byte[2];
    byte[] destinationRegister = new byte[2];
    byte[] eDestinationRegister = new byte[2];
    long result = 0L;
    byte tempByte = 0;

    public Instruction_IMUL_GvEvIb() {
    }

    public Instruction_IMUL_GvEvIb(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        if (this.cpu.doubleWord) {
            System.out.println("[cpu] Instruction 0x6B IMUL 32-bit not implemented");
        } else {
            this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
            if ((this.addressByte >> 6 & 3) == 3) {
                this.sourceWord1 = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
            } else {
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.sourceWord1 = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
            }
            this.tempByte = this.cpu.getByteFromCode();
            this.sourceWord2 = new byte[]{Util.signExtend(this.tempByte), this.tempByte};
        }
        this.result = (((long)this.sourceWord1[0] << 8) + ((long)this.sourceWord1[1] & 0xFFL)) * (((long)this.sourceWord2[0] << 8) + ((long)this.sourceWord2[1] & 0xFFL));
        this.destinationRegister[1] = (byte)this.result;
        this.destinationRegister[0] = (byte)(this.result >> 8);
        if (this.result > 65535L) {
            this.cpu.flags[0] = true;
            this.cpu.flags[11] = true;
        } else {
            this.cpu.flags[0] = false;
            this.cpu.flags[11] = false;
        }
        this.cpu.flags[4] = false;
        this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
        this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
        this.cpu.flags[7] = this.destinationRegister[0] < 0;
    }
}

