/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;

public class Instruction_MOV_SwEw
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceRegister = new byte[2];
    byte[] destinationRegister = new byte[2];

    public Instruction_MOV_SwEw() {
    }

    public Instruction_MOV_SwEw(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        if ((this.addressByte >> 6 & 3) == 3) {
            this.sourceRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.sourceRegister = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        }
        this.destinationRegister = this.cpu.decodeSegmentRegister((this.addressByte & 0x38) >> 3);
        System.arraycopy(this.sourceRegister, 0, this.destinationRegister, 0, this.sourceRegister.length);
    }
}

