/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.util.Deque;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class PriorityDeque
extends AbstractQueue<Object>
implements Deque<Object> {
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private transient Object[] queue;
    private int size = 0;
    private transient int modCount = 0;

    public PriorityDeque() {
        this(11);
    }

    public PriorityDeque(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new Object[n];
    }

    @Override
    public Iterator<Object> descendingIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Object> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.removeAt(n);
        return true;
    }

    @Override
    public Object pop() {
        return this.removeFirst();
    }

    @Override
    public void push(Object object) {
        this.add(object);
    }

    @Override
    public Object peek() {
        return this.peekFirst();
    }

    @Override
    public Object poll() {
        return this.pollFirst();
    }

    @Override
    public boolean offerLast(Object object) {
        return this.offer(object);
    }

    @Override
    public boolean offerFirst(Object object) {
        return this.offer(object);
    }

    @Override
    public void addLast(Object object) {
        this.add(object);
    }

    @Override
    public void addFirst(Object object) {
        this.add(object);
    }

    @Override
    public Object getFirst() {
        return this.element();
    }

    @Override
    public Object removeFirst() {
        return this.remove();
    }

    @Override
    public boolean offer(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        ++this.modCount;
        int n = this.size;
        if (n >= this.queue.length) {
            this.grow(n + 1);
        }
        this.size = n + 1;
        if (n == 0) {
            this.queue[0] = object;
        } else {
            int n2 = this.siftUp(n, object);
            this.siftDown(n2, object);
        }
        return true;
    }

    @Override
    public Object pollFirst() {
        if (this.size == 0) {
            return null;
        }
        int n = --this.size;
        ++this.modCount;
        Object object = this.queue[0];
        Object object2 = this.queue[n];
        this.queue[n] = null;
        if (n > 1) {
            this.siftDown(0, object2);
        } else {
            this.queue[0] = object2;
        }
        return object;
    }

    @Override
    public Object peekFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.queue[0];
    }

    @Override
    public Object pollLast() {
        if (this.size < 2) {
            return this.pollFirst();
        }
        int n = --this.size;
        ++this.modCount;
        Object object = this.queue[1];
        Object object2 = this.queue[n];
        this.queue[n] = null;
        if (n > 1) {
            this.siftUp(1, object2);
        }
        return object;
    }

    @Override
    public Object peekLast() {
        if (this.size == 0) {
            return null;
        }
        if (this.size == 1) {
            return this.peekFirst();
        }
        return this.queue[1];
    }

    @Override
    public Object getLast() {
        Object object = this.peek();
        if (object != null) {
            return object;
        }
        throw new NoSuchElementException();
    }

    @Override
    public Object removeLast() {
        Object object = this.pollLast();
        if (object != null) {
            return object;
        }
        throw new NoSuchElementException();
    }

    private void grow(int n) {
        int n2;
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        int n3 = this.queue.length;
        int n4 = n2 = n3 < 64 ? (n3 + 1) * 2 : n3 / 2 * 3;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        if (n2 < n) {
            n2 = n;
        }
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.queue, 0, objectArray, 0, this.queue.length);
        this.queue = objectArray;
    }

    private int indexOf(Object object) {
        if (object != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.queue[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private Object removeAt(int n) {
        int n2;
        assert (n >= 0 && n < this.size);
        ++this.modCount;
        if ((n2 = --this.size) == n) {
            this.queue[n] = null;
        } else {
            Object object = this.queue[n2];
            this.queue[n2] = null;
            if (n2 > 1) {
                this.siftDown(n, object);
                if (this.queue[n] == object) {
                    this.siftUp(n, object);
                    if (this.queue[n] != object) {
                        return object;
                    }
                }
            } else {
                this.queue[0] = object;
            }
        }
        return null;
    }

    private int siftUp(int n, Object object) {
        Comparable comparable = (Comparable)object;
        while (n != 0) {
            int n2 = this.findPredecessor(n);
            assert (n2 < this.size) : "Predecessor Outside Limit: " + n2;
            Object object2 = this.queue[n2];
            if (comparable.compareTo(object2) >= 0) break;
            this.queue[n] = object2;
            n = n2;
        }
        this.queue[n] = comparable;
        return n;
    }

    private int siftDown(int n, Object object) {
        Comparable comparable = (Comparable)object;
        while (n != 1) {
            int n2 = this.findSuccessor(n);
            assert (n2 < this.size) : "Successor Outside Limit: " + n2;
            Object object2 = this.queue[n2];
            if (comparable.compareTo(object2) <= 0) break;
            this.queue[n] = object2;
            n = n2;
        }
        this.queue[n] = comparable;
        return n;
    }

    private int findPredecessor(int n) {
        if (n == 0) {
            return 0;
        }
        if ((n & 1) == 0) {
            if ((n & 2) == 0) {
                return (n >>> 1) - 2;
            }
            return (n >>> 1) - 1;
        }
        int n2 = (n << 1) + 1;
        int n3 = n2 + 2;
        if (n3 < this.size) {
            Comparable comparable = (Comparable)this.queue[n2];
            if (comparable.compareTo(this.queue[n3]) >= 0) {
                return n2;
            }
            return n3;
        }
        if (n2 < this.size) {
            return n2;
        }
        return n - 1;
    }

    private int findSuccessor(int n) {
        if (n == 1) {
            return 1;
        }
        if ((n & 1) == 0) {
            int n2 = (n << 1) + 2;
            int n3 = n2 + 2;
            if (n3 < this.size) {
                Comparable comparable = (Comparable)this.queue[n2];
                if (comparable.compareTo(this.queue[n3]) <= 0) {
                    return n2;
                }
                return n3;
            }
            if (n2 < this.size) {
                return n2;
            }
            if (n + 1 < this.size) {
                return n + 1;
            }
            return this.findSuccessor(n + 1);
        }
        if ((n & 2) == 0) {
            return (n >>> 1) - 1;
        }
        return n >>> 1;
    }

    public static final void main(String[] stringArray) {
        Random random = new Random();
        PriorityDeque priorityDeque = new PriorityDeque();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        System.err.println("<===== Starting =====> S:" + priorityDeque.size());
        int n = 0;
        int n2 = 0;
        block5: while (true) {
            Object object;
            System.err.println("<===== 100k Operations =====> S:" + priorityDeque.size() + " A:" + n + " R:" + n2);
            if (random.nextBoolean()) {
                if (priorityDeque.size() > 20) continue;
                object = new Integer(random.nextInt());
                priorityDeque.offer(object);
                arrayList.add(object);
                ++n;
                continue;
            }
            if (priorityDeque.size() == 0) continue;
            switch (random.nextInt(3)) {
                case 0: {
                    object = arrayList.remove(random.nextInt(arrayList.size()));
                    boolean bl = priorityDeque.remove(object);
                    assert (bl) : "Couldn't remove " + object + " from Deque";
                    ++n2;
                    continue block5;
                }
                case 1: {
                    object = priorityDeque.pollFirst();
                    boolean bl = arrayList.remove(object);
                    assert (bl) : "Object " + object + " should not have been in the Deque";
                    ++n2;
                    continue block5;
                }
                case 2: {
                    object = priorityDeque.pollLast();
                    boolean bl = arrayList.remove(object);
                    assert (bl) : "Object " + object + " should not have been in the Deque";
                    ++n2;
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    @Override
    public String toString() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.queue, 0, objectArray, 0, objectArray.length);
        return Arrays.toString(objectArray);
    }
}

