/*
 * Decompiled with CFR 0.152.
 */
package gnu.vnc.console;

import gnu.rfb.Raw;
import gnu.rfb.Rect;
import gnu.rfb.RectFont;
import gnu.rfb.server.RFBClient;
import gnu.rfb.server.RFBClients;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

class VNCConsoleBuffer {
    private RFBClients clients;
    private int columns;
    private int rows;
    private Dimension charSize;
    private Point cursor = new Point();
    private Point home = new Point();
    private char[] outputBuffer;
    private boolean[] outputMaskWork;
    private Vector inputBuffer = new Vector();
    private int inputIndex = 0;
    private Object outputLock = new Object();
    private Object inputLock = new Object();

    public VNCConsoleBuffer(int columns, int rows, Dimension charSize, RFBClients clients) {
        this.columns = columns;
        this.rows = rows;
        this.charSize = charSize;
        this.clients = clients;
        this.outputBuffer = new char[columns * rows];
        this.outputMaskWork = new boolean[columns * rows];
    }

    public PrintStream printStream() {
        return new PrintStream(new ConsoleOutputStream());
    }

    public InputStream inputStream() {
        return new ConsoleInputStream();
    }

    public RectFont getFont(RFBClient client) {
        RectFont font = (RectFont)this.clients.getProperty(client, "font");
        if (font == null) {
            font = new RectFont(this.charSize, client.getPixelFormat(), client.getPreferredEncoding());
            this.clients.setProperty(client, "font", font);
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void input(int c) {
        this.output(c);
        Object object = this.inputLock;
        synchronized (object) {
            if (this.inputIndex < this.inputBuffer.size()) {
                this.inputBuffer.removeElementAt(this.inputIndex);
            }
            this.inputBuffer.insertElementAt(new Integer(c), this.inputIndex++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(int c) {
        Object object = this.outputLock;
        synchronized (object) {
            int p = this.columns * this.cursor.y + this.cursor.x;
            switch (c) {
                case 13: {
                    break;
                }
                case 10: {
                    this.cursor.x = 0;
                    if (++this.cursor.y != this.rows) break;
                    this.scrollDown();
                    this.cursor.y = this.rows - 1;
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    this.outputBuffer[p] = (char)c;
                    this.invalidateOutputMasks(p);
                    if (++this.cursor.x != this.columns) break;
                    this.cursor.x = 0;
                    if (++this.cursor.y != this.rows) break;
                    this.scrollDown();
                    this.cursor.y = this.rows - 1;
                }
            }
        }
        try {
            this.updateAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateAll() throws IOException {
        Enumeration e = this.clients.elements();
        while (e.hasMoreElements()) {
            RFBClient client = (RFBClient)e.nextElement();
            client.writeFrameBufferUpdate(this.getRects(client, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputVK(int vk) {
        Object object = this.outputLock;
        synchronized (object) {
            int p = this.columns * this.cursor.y + this.cursor.x;
            switch (vk) {
                case 10: {
                    this.cursor.x = 0;
                    if (++this.cursor.y != this.rows) break;
                    this.scrollDown();
                    this.cursor.y = this.rows - 1;
                    break;
                }
                case 8: {
                    if (this.cursor.equals(this.home)) break;
                    if (--p != -1) {
                        this.outputBuffer[p] = '\u0000';
                        this.invalidateOutputMasks(p);
                    }
                    if (--this.cursor.x != -1) break;
                    this.cursor.x = this.columns - 1;
                    if (--this.cursor.y != -1) break;
                    this.cursor.x = 0;
                    this.cursor.y = 0;
                    break;
                }
                case 36: {
                    this.cursor.x = this.home.x;
                    this.cursor.y = this.home.y;
                    break;
                }
                case 37: {
                    if (this.cursor.equals(this.home) || --this.cursor.x != -1) break;
                    this.cursor.x = this.columns - 1;
                    if (--this.cursor.y != -1) break;
                    this.cursor.x = 0;
                    this.cursor.y = 0;
                    break;
                }
                case 39: {
                    if (++this.cursor.x != this.columns) break;
                    this.cursor.x = 0;
                    if (++this.cursor.y != this.rows) break;
                    this.scrollDown();
                    this.cursor.y = this.rows - 1;
                }
            }
        }
        object = this.inputLock;
        synchronized (object) {
            switch (vk) {
                case 10: {
                    this.inputBuffer.addElement(new Integer(10));
                    this.inputBuffer.addElement(new Integer(-1));
                    this.inputLock.notifyAll();
                    this.inputIndex = 0;
                    break;
                }
                case 8: {
                    if (this.inputIndex <= 0) break;
                    this.inputBuffer.removeElementAt(--this.inputIndex);
                    break;
                }
                case 36: {
                    this.inputIndex = 0;
                    break;
                }
                case 37: {
                    if (this.inputIndex <= 0) break;
                    --this.inputIndex;
                    break;
                }
                case 39: {
                    if (this.inputIndex < this.inputBuffer.size()) {
                        ++this.inputIndex;
                        break;
                    }
                    this.inputBuffer.insertElementAt(new Integer(32), this.inputIndex++);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollDown() {
        Object object = this.outputLock;
        synchronized (object) {
            int i = 0;
            while (i < this.columns * (this.rows - 1)) {
                if (this.outputBuffer[i] != this.outputBuffer[i + this.columns]) {
                    this.outputBuffer[i] = this.outputBuffer[i + this.columns];
                    this.outputMaskWork[i] = false;
                } else {
                    this.outputMaskWork[i] = true;
                }
                ++i;
            }
            while (i < this.columns * this.rows) {
                if (this.outputBuffer[i] != ' ') {
                    this.outputBuffer[i] = 32;
                    this.outputMaskWork[i] = false;
                } else {
                    this.outputMaskWork[i] = true;
                }
                ++i;
            }
            this.updateOutputMasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rect[] getRects(RFBClient client, boolean incremental) {
        RectFont font = this.getFont(client);
        Object object = this.outputLock;
        synchronized (object) {
            Rect[] rects;
            boolean[] outputMask = this.getOutputMask(client);
            if (!incremental) {
                int i = 0;
                while (i < outputMask.length) {
                    outputMask[i] = false;
                    ++i;
                }
            }
            if ((rects = font.getRects(this.outputBuffer, outputMask, 0, this.outputBuffer.length, 0, 0, font.getCharSize().width * this.columns)).length == 0) {
                rects = new Rect[]{new Raw(0, 0, 0, 0, client.getPixelFormat(), new byte[0])};
            }
            return rects;
        }
    }

    private boolean[] getOutputMask(RFBClient client) {
        boolean[] outputMask = (boolean[])this.clients.getProperty(client, "mask");
        if (outputMask == null) {
            outputMask = new boolean[this.columns * this.rows];
            this.clients.setProperty(client, "mask", outputMask);
        }
        return outputMask;
    }

    private void updateOutputMasks() {
        Enumeration e = this.clients.elements();
        while (e.hasMoreElements()) {
            boolean[] outputMask = this.getOutputMask((RFBClient)e.nextElement());
            int i = 0;
            while (i < this.columns * this.rows) {
                if (!this.outputMaskWork[i]) {
                    outputMask[i] = false;
                }
                ++i;
            }
        }
    }

    private void invalidateOutputMasks(int p) {
        Enumeration e = this.clients.elements();
        while (e.hasMoreElements()) {
            boolean[] outputMask = this.getOutputMask((RFBClient)e.nextElement());
            outputMask[p] = false;
        }
    }

    private class ConsoleInputStream
    extends InputStream {
        private ConsoleInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            Object object = VNCConsoleBuffer.this.inputLock;
            synchronized (object) {
                return VNCConsoleBuffer.this.inputBuffer.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = VNCConsoleBuffer.this.inputLock;
            synchronized (object) {
                block6: {
                    if (VNCConsoleBuffer.this.inputBuffer.size() != 0) break block6;
                    ((VNCConsoleBuffer)VNCConsoleBuffer.this).home.x = ((VNCConsoleBuffer)VNCConsoleBuffer.this).cursor.x;
                    ((VNCConsoleBuffer)VNCConsoleBuffer.this).home.y = ((VNCConsoleBuffer)VNCConsoleBuffer.this).cursor.y;
                    VNCConsoleBuffer.this.inputIndex = 0;
                    try {
                        VNCConsoleBuffer.this.inputLock.wait();
                    }
                    catch (InterruptedException x) {
                        x.printStackTrace();
                        return -1;
                    }
                }
                Integer c = (Integer)VNCConsoleBuffer.this.inputBuffer.elementAt(0);
                VNCConsoleBuffer.this.inputBuffer.removeElementAt(0);
                return c;
            }
        }
    }

    private class ConsoleOutputStream
    extends OutputStream {
        private ConsoleOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            VNCConsoleBuffer.this.output((char)b);
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }
}

