/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.video;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.UnknownPortException;
import dioscuri.exception.WriteOnlyPortException;
import dioscuri.interfaces.Module;
import dioscuri.module.ModuleCPU;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModuleRTC;
import dioscuri.module.ModuleScreen;
import dioscuri.module.ModuleVideo;
import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.HardwareComponent;
import dioscuri.module.cpu32.Memory;
import dioscuri.module.cpu32.PhysicalAddressSpace;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.video.GraphicsController;
import dioscuri.module.video.SequencerRegister;
import dioscuri.module.video.TextModeAttributes;
import dioscuri.module.video.TextTranslation;
import dioscuri.module.video.VideoCard;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Video
extends ModuleVideo {
    static long counter = 0L;
    private VideoCard videocard;
    private TextModeAttributes textModeAttribs;
    private TextTranslation textTranslation;
    public DiosJPCVideoConnect vidMemConnect = new DiosJPCVideoConnect();
    private int updateInterval;
    private int initialScreenWidth = 640;
    private int initialScreenHeight = 480;
    int oldScreenWidth = 0;
    int oldScreenHeight = 0;
    int oldMaxScanLine = 0;
    private static final Logger logger = Logger.getLogger(Video.class.getName());
    private static final int MAX_TEXT_LINES = 100;

    public Video(Emulator emulator) {
        this.videocard = new VideoCard();
        this.videocard.vgaMemReqUpdate = false;
        this.textModeAttribs = new TextModeAttributes();
        this.textTranslation = new TextTranslation();
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] " + this.getClass().getName() + " -> AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModuleRTC moduleRTC = (ModuleRTC)super.getConnection(Module.Type.RTC);
        moduleMotherboard.setIOPort(948, this);
        moduleMotherboard.setIOPort(949, this);
        moduleMotherboard.setIOPort(954, this);
        for (int i = 960; i <= 975; ++i) {
            moduleMotherboard.setIOPort(i, this);
        }
        moduleMotherboard.setIOPort(980, this);
        moduleMotherboard.setIOPort(981, this);
        moduleMotherboard.setIOPort(986, this);
        if (!moduleMotherboard.requestTimer(this, this.updateInterval, true)) {
            return false;
        }
        moduleMotherboard.setTimerActiveState(this, true);
        this.videocard.reset();
        for (int i = 0; i < this.initialScreenHeight / 24; ++i) {
            for (int j = 0; j < this.initialScreenWidth / 16; ++j) {
                this.videocard.setTileUpdate(j, i, false);
            }
        }
        moduleRTC.setCMOSRegister(20, (byte)(moduleRTC.getCMOSRegister(20) & 0xCF | 0));
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " AbstractModule has been reset");
        return true;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setUpdateInterval(int n) {
        this.updateInterval = n > 0 ? n : 1000;
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        moduleMotherboard.resetTimer(this, this.updateInterval);
    }

    @Override
    public void update() {
        ModuleScreen moduleScreen = (ModuleScreen)super.getConnection(Module.Type.SCREEN);
        if (!this.videocard.vgaMemReqUpdate) {
            return;
        }
        if (!this.videocard.vgaEnabled || this.videocard.attributeController.paletteAddressSource == 0 || this.videocard.sequencer.synchReset == 0 || this.videocard.sequencer.aSynchReset == 0) {
            return;
        }
        if (this.videocard.graphicsController.alphaNumDisable != 0) {
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " update() in progress; graphics mode");
            int n = (this.videocard.crtControllerRegister.regArray[12] & 0xFF) << 8 | this.videocard.crtControllerRegister.regArray[13] & 0xFF;
            int[] nArray = new int[2];
            nArray = this.determineScreenSize();
            int n2 = nArray[0];
            int n3 = nArray[1];
            if (n3 != this.oldScreenWidth || n2 != this.oldScreenHeight) {
                moduleScreen.updateScreenSize(n3, n2, 0, 0);
                this.oldScreenWidth = n3;
                this.oldScreenHeight = n2;
            }
            switch (this.videocard.graphicsController.shift256Reg) {
                case 0: {
                    if (this.videocard.graphicsController.memoryMapSelect == 3) {
                        int n4 = 0;
                        int n5 = 0;
                        while (n4 < n2) {
                            int n6 = 0;
                            int n7 = 0;
                            while (n6 < n3) {
                                if (this.videocard.getTileUpdate(n7, n5)) {
                                    for (int i = 0; i < 24; ++i) {
                                        int n8 = n4 + i;
                                        if (this.videocard.crtControllerRegister.scanDoubling != 0) {
                                            n8 >>= 1;
                                        }
                                        for (int j = 0; j < 16; ++j) {
                                            byte by;
                                            int n9 = n6 + j;
                                            int n10 = n + ((n8 & 1) << 13);
                                            n10 += 80 * (n8 / 2);
                                            int n11 = 7 - n9 % 8;
                                            byte by2 = (byte)(this.videocard.vgaMemory[n10 += n9 / 8] >> n11 & 1);
                                            this.videocard.tile[i * 16 + j] = by = this.videocard.attributeController.paletteRegister[by2];
                                        }
                                    }
                                    this.videocard.setTileUpdate(n7, n5, false);
                                    moduleScreen.updateGraphicsTile(this.videocard.tile, n6, n4);
                                }
                                n6 += 16;
                                ++n7;
                            }
                            n4 += 24;
                            ++n5;
                        }
                    } else {
                        int n12 = 0;
                        int n13 = 65536;
                        int n14 = 131072;
                        int n15 = 196608;
                        int n16 = this.videocard.lineCompare;
                        if (this.videocard.crtControllerRegister.scanDoubling != 0) {
                            n16 >>= 1;
                        }
                        int n17 = 0;
                        int n18 = 0;
                        while (n17 < n2) {
                            int n19 = 0;
                            int n20 = 0;
                            while (n19 < n3) {
                                if (this.videocard.getTileUpdate(n20, n18)) {
                                    for (int i = 0; i < 24; ++i) {
                                        int n21 = n17 + i;
                                        if (this.videocard.crtControllerRegister.scanDoubling != 0) {
                                            n21 >>= 1;
                                        }
                                        for (int j = 0; j < 16; ++j) {
                                            int n22 = n19 + j;
                                            if (this.videocard.sequencer.dotClockRate != 0) {
                                                n22 >>= 1;
                                            }
                                            int n23 = 7 - n22 % 8;
                                            int n24 = n21 > n16 ? n22 / 8 + (n21 - n16 - 1) * this.videocard.lineOffset : n + n22 / 8 + n21 * this.videocard.lineOffset;
                                            byte by = (byte)((this.videocard.vgaMemory[n12 + n24] >> n23 & 1) << 0 | (this.videocard.vgaMemory[n13 + n24] >> n23 & 1) << 1 | (this.videocard.vgaMemory[n14 + n24] >> n23 & 1) << 2 | (this.videocard.vgaMemory[n15 + n24] >> n23 & 1) << 3);
                                            by = (byte)(by & this.videocard.attributeController.colourPlaneEnable);
                                            if (this.videocard.attributeController.modeControlReg.blinkIntensity != 0) {
                                                by = (byte)(by ^ 8);
                                            }
                                            byte by3 = this.videocard.attributeController.paletteRegister[by];
                                            byte by4 = this.videocard.attributeController.modeControlReg.paletteBitsSelect != 0 ? (byte)(by3 & 0xF | this.videocard.attributeController.colourSelect << 4) : (byte)(by3 & 0x3F | (this.videocard.attributeController.colourSelect & 0xC) << 4);
                                            this.videocard.tile[i * 16 + j] = by4;
                                        }
                                    }
                                    this.videocard.setTileUpdate(n20, n18, false);
                                    moduleScreen.updateGraphicsTile(this.videocard.tile, n19, n17);
                                }
                                n19 += 16;
                                ++n20;
                            }
                            n17 += 24;
                            ++n18;
                        }
                    }
                    break;
                }
                case 1: {
                    int n25 = 0;
                    int n26 = 0;
                    while (n25 < n2) {
                        int n27 = 0;
                        int n28 = 0;
                        while (n27 < n3) {
                            if (this.videocard.getTileUpdate(n28, n26)) {
                                for (int i = 0; i < 24; ++i) {
                                    int n29 = n25 + i;
                                    if (this.videocard.crtControllerRegister.scanDoubling != 0) {
                                        n29 >>= 1;
                                    }
                                    for (int j = 0; j < 16; ++j) {
                                        byte by;
                                        int n30 = n27 + j;
                                        if (this.videocard.sequencer.dotClockRate != 0) {
                                            n30 >>= 1;
                                        }
                                        int n31 = n + ((n29 & 1) << 13);
                                        n31 += 80 * (n29 / 2);
                                        byte by5 = (byte)(6 - 2 * (n30 % 4));
                                        byte by6 = (byte)(this.videocard.vgaMemory[n31 += n30 / 4] >> by5);
                                        by6 = (byte)(by6 & 3);
                                        this.videocard.tile[i * 16 + j] = by = this.videocard.attributeController.paletteRegister[by6];
                                    }
                                }
                                this.videocard.setTileUpdate(n28, n26, false);
                                moduleScreen.updateGraphicsTile(this.videocard.tile, n27, n25);
                            }
                            n27 += 16;
                            ++n28;
                        }
                        n25 += 24;
                        ++n26;
                    }
                    break;
                }
                case 2: 
                case 3: {
                    if (this.videocard.sequencer.chainFourEnable != 0) {
                        if (this.videocard.miscOutputRegister.lowHighPage != 1) {
                            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " update: select_high_bank != 1");
                        }
                        int n32 = 0;
                        int n33 = 0;
                        while (n32 < n2) {
                            int n34 = 0;
                            int n35 = 0;
                            while (n34 < n3) {
                                if (this.videocard.getTileUpdate(n35, n33)) {
                                    for (int i = 0; i < 24; ++i) {
                                        int n36 = n32 + i;
                                        if (this.videocard.crtControllerRegister.scanDoubling != 0) {
                                            n36 >>= 1;
                                        }
                                        for (int j = 0; j < 16; ++j) {
                                            byte by;
                                            int n37 = n34 + j >> 1;
                                            int n38 = n37 % 4;
                                            int n39 = n + n38 * 65536 + n36 * this.videocard.lineOffset + (n37 & 0xFFFFFFFC);
                                            this.videocard.tile[i * 16 + j] = by = this.videocard.vgaMemory[n39];
                                        }
                                    }
                                    this.videocard.setTileUpdate(n35, n33, false);
                                    moduleScreen.updateGraphicsTile(this.videocard.tile, n34, n32);
                                }
                                n34 += 16;
                                ++n35;
                            }
                            n32 += 24;
                            ++n33;
                        }
                    } else {
                        int n40 = 0;
                        int n41 = 0;
                        while (n40 < n2) {
                            int n42 = 0;
                            int n43 = 0;
                            while (n42 < n3) {
                                if (this.videocard.getTileUpdate(n43, n41)) {
                                    for (int i = 0; i < 24; ++i) {
                                        int n44 = n40 + i;
                                        if (this.videocard.crtControllerRegister.scanDoubling != 0) {
                                            n44 >>= 1;
                                        }
                                        for (int j = 0; j < 16; ++j) {
                                            byte by;
                                            int n45 = n42 + j >> 1;
                                            int n46 = n45 % 4;
                                            int n47 = n46 * 65536 + n44 * this.videocard.lineOffset + (n45 >> 2);
                                            this.videocard.tile[i * 16 + j] = by = this.videocard.vgaMemory[n + n47];
                                        }
                                    }
                                    this.videocard.setTileUpdate(n43, n41, false);
                                    moduleScreen.updateGraphicsTile(this.videocard.tile, n42, n40);
                                }
                                n42 += 16;
                                ++n43;
                            }
                            n40 += 24;
                            ++n41;
                        }
                    }
                    break;
                }
                default: {
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " update: shift_reg == " + this.videocard.graphicsController.shift256Reg);
                }
            }
            this.videocard.vgaMemReqUpdate = false;
        } else {
            int n;
            int n48;
            int n49;
            int n50 = (this.videocard.sequencer.clockingMode & 1) == 1 ? 8 : 9;
            int n51 = 2 * (((this.videocard.crtControllerRegister.regArray[14] & 0xFF) << 8) + (this.videocard.crtControllerRegister.regArray[15] & 0xFF));
            int n52 = this.videocard.crtControllerRegister.regArray[9] & 0x1F;
            int n53 = this.videocard.crtControllerRegister.regArray[1] + 1;
            int n54 = n50 * n53;
            int n55 = this.videocard.verticalDisplayEnd + 1;
            int n56 = 2 * ((this.videocard.crtControllerRegister.regArray[12] << 8) + this.videocard.crtControllerRegister.regArray[13]);
            logger.log(Level.INFO, "---------------------------------------------------------------------------");
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " update() in progress; text mode " + ++counter);
            this.textModeAttribs.fullStartAddress = (short)n56;
            this.textModeAttribs.cursorStartLine = (byte)(this.videocard.crtControllerRegister.regArray[10] & 0x3F);
            this.textModeAttribs.cursorEndLine = (byte)(this.videocard.crtControllerRegister.regArray[11] & 0x1F);
            this.textModeAttribs.lineOffset = (short)(this.videocard.crtControllerRegister.regArray[19] << 2);
            this.textModeAttribs.lineCompare = (short)this.videocard.lineCompare;
            this.textModeAttribs.horizPanning = (byte)(this.videocard.attributeController.horizPixelPanning & 0xF);
            this.textModeAttribs.vertPanning = (byte)(this.videocard.crtControllerRegister.regArray[8] & 0x1F);
            this.textModeAttribs.lineGraphics = this.videocard.attributeController.modeControlReg.lineGraphicsEnable;
            this.textModeAttribs.splitHorizPanning = this.videocard.attributeController.modeControlReg.pixelPanningMode;
            this.textModeAttribs.horizPanning = (this.videocard.sequencer.clockingMode & 1) == 0 ? (this.textModeAttribs.horizPanning >= 8 ? (byte)0 : (byte)(this.textModeAttribs.horizPanning + 1)) : (byte)(this.textModeAttribs.horizPanning & 7);
            if (n52 == 0) {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " character height = 1, skipping text update");
                return;
            }
            if (n52 == 1 && this.videocard.verticalDisplayEnd == 399) {
                n52 = 3;
            }
            if ((n49 = (this.videocard.verticalDisplayEnd + 1) / (n52 + 1)) > 100) {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Number of text rows (" + n49 + ") exceeds maximum (" + 100 + ")!");
                return;
            }
            if (n54 != this.oldScreenWidth || n55 != this.oldScreenHeight || n52 != this.oldMaxScanLine) {
                moduleScreen.updateScreenSize(n54, n55, n50, n52 + 1);
                this.oldScreenWidth = n54;
                this.oldScreenHeight = n55;
                this.oldMaxScanLine = n52;
            }
            if (n51 < n56) {
                n48 = 65535;
                n = 65535;
            } else {
                n48 = (n51 - n56) / 2 % (n54 / n50);
                n = (n51 - n56) / 2 / (n54 / n50);
            }
            moduleScreen.updateText(0, n56, n48, n, this.textModeAttribs.getAttributes(), n49);
            System.arraycopy(this.videocard.vgaMemory, n56, this.videocard.textSnapshot, 0, 2 * n53 * n49);
            this.videocard.vgaMemReqUpdate = false;
        }
    }

    void setAreaForUpdate(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        this.videocard.vgaMemReqUpdate = true;
        if (this.videocard.graphicsController.alphaNumDisable != 0) {
            int n5 = n / 16;
            int n6 = n2 / 24;
            int n7 = n < this.oldScreenWidth ? (n + n3 - 1) / 16 : (this.oldScreenWidth - 1) / 16;
            int n8 = n2 < this.oldScreenHeight ? (n2 + n4 - 1) / 24 : (this.oldScreenHeight - 1) / 24;
            for (int i = n6; i <= n8; ++i) {
                for (int j = n5; j <= n7; ++j) {
                    this.videocard.setTileUpdate(j, i, true);
                }
            }
        } else {
            Arrays.fill(this.videocard.textSnapshot, (byte)0);
        }
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleException, UnknownPortException, WriteOnlyPortException {
        ModuleCPU moduleCPU = (ModuleCPU)super.getConnection(Module.Type.CPU);
        byte by = 0;
        if (n >= 944 && n <= 959 && this.videocard.miscOutputRegister.ioAddressSelect != 0) {
            return -1;
        }
        if (n >= 976 && n <= 991 && this.videocard.miscOutputRegister.ioAddressSelect == 0) {
            return -1;
        }
        switch (n) {
            case 954: 
            case 970: 
            case 986: {
                int n2;
                this.videocard.attributeController.dataAddressFlipFlop = false;
                this.videocard.displayDisabled = 0;
                long l = (long)((double)moduleCPU.getCurrentInstructionNumber() / (double)moduleCPU.getIPS() * 1000000.0);
                switch (this.videocard.miscOutputRegister.verticalSyncPol << 1 | this.videocard.miscOutputRegister.horizontalSyncPol) {
                    case 0: {
                        n2 = 200;
                        break;
                    }
                    case 1: {
                        n2 = 400;
                        break;
                    }
                    case 2: {
                        n2 = 350;
                        break;
                    }
                    default: {
                        n2 = 480;
                    }
                }
                if (l % 13888L < 70L) {
                    this.videocard.vertRetrace = 1;
                    this.videocard.displayDisabled = 1;
                } else {
                    this.videocard.vertRetrace = 0;
                }
                if (l % (long)(13888 / n2) == 0L) {
                    this.videocard.horizRetrace = 1;
                    this.videocard.displayDisabled = 1;
                } else {
                    this.videocard.horizRetrace = 0;
                }
                return (byte)(this.videocard.vertRetrace << 3 | this.videocard.displayDisabled);
            }
            case 960: {
                if (!this.videocard.attributeController.dataAddressFlipFlop) {
                    return (byte)(this.videocard.attributeController.paletteAddressSource << 5 | this.videocard.attributeController.index);
                }
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Port [0x3C0] read, but flipflop not set to address mode");
                return 0;
            }
            case 961: {
                switch (this.videocard.attributeController.index) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        by = this.videocard.attributeController.paletteRegister[this.videocard.attributeController.index];
                        return by;
                    }
                    case 16: {
                        return (byte)(this.videocard.attributeController.modeControlReg.graphicsEnable << 0 | this.videocard.attributeController.modeControlReg.monoColourEmu << 1 | this.videocard.attributeController.modeControlReg.lineGraphicsEnable << 2 | this.videocard.attributeController.modeControlReg.blinkIntensity << 3 | this.videocard.attributeController.modeControlReg.pixelPanningMode << 5 | this.videocard.attributeController.modeControlReg.colour8Bit << 6 | this.videocard.attributeController.modeControlReg.paletteBitsSelect << 7);
                    }
                    case 17: {
                        return this.videocard.attributeController.overscanColour;
                    }
                    case 18: {
                        return this.videocard.attributeController.colourPlaneEnable;
                    }
                    case 19: {
                        return this.videocard.attributeController.horizPixelPanning;
                    }
                    case 20: {
                        return this.videocard.attributeController.colourSelect;
                    }
                }
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Port [0x3C1] reads unknown register 0x" + Integer.toHexString(this.videocard.attributeController.index).toUpperCase());
                return 0;
            }
            case 962: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Port [0x3C1] reads Input Status #0; ignored");
                return 0;
            }
            case 963: {
                return this.videocard.vgaEnabled ? (byte)1 : 0;
            }
            case 964: {
                return this.videocard.sequencer.index;
            }
            case 965: {
                switch (this.videocard.sequencer.index) {
                    case 0: {
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Port [0x3C5] reads sequencer reset");
                        return (byte)(this.videocard.sequencer.aSynchReset | this.videocard.sequencer.synchReset << 1);
                    }
                    case 1: {
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Port [0x3C5] reads sequencer clocking mode");
                        return this.videocard.sequencer.clockingMode;
                    }
                    case 2: {
                        return this.videocard.sequencer.mapMask;
                    }
                    case 3: {
                        return this.videocard.sequencer.characterMapSelect;
                    }
                    case 4: {
                        return (byte)(this.videocard.sequencer.extendedMemory << 1 | this.videocard.sequencer.oddEvenDisable << 2 | this.videocard.sequencer.chainFourEnable << 3);
                    }
                }
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Port [0x3C5] reads unknown register 0x" + Integer.toHexString(this.videocard.sequencer.index).toUpperCase());
                return 0;
            }
            case 966: {
                return this.videocard.colourRegister.pixelMask;
            }
            case 967: {
                return this.videocard.colourRegister.dacState;
            }
            case 968: {
                return this.videocard.colourRegister.dacWriteAddress;
            }
            case 969: {
                if (this.videocard.colourRegister.dacState == 3) {
                    switch (this.videocard.colourRegister.dacReadCounter) {
                        case 0: {
                            by = this.videocard.pixels[this.videocard.colourRegister.dacReadAddress & 0xFF].red;
                            break;
                        }
                        case 1: {
                            by = this.videocard.pixels[this.videocard.colourRegister.dacReadAddress & 0xFF].green;
                            break;
                        }
                        case 2: {
                            by = this.videocard.pixels[this.videocard.colourRegister.dacReadAddress & 0xFF].blue;
                            break;
                        }
                        default: {
                            by = 0;
                        }
                    }
                    ++this.videocard.colourRegister.dacReadCounter;
                    if (this.videocard.colourRegister.dacReadCounter >= 3) {
                        this.videocard.colourRegister.dacReadCounter = 0;
                        this.videocard.colourRegister.dacReadAddress = (byte)(this.videocard.colourRegister.dacReadAddress + 1);
                    }
                } else {
                    by = 63;
                }
                return by;
            }
            case 972: {
                return (byte)((this.videocard.miscOutputRegister.ioAddressSelect & 1) << 0 | (this.videocard.miscOutputRegister.ramEnable & 1) << 1 | (this.videocard.miscOutputRegister.clockSelect & 3) << 2 | (this.videocard.miscOutputRegister.lowHighPage & 1) << 5 | (this.videocard.miscOutputRegister.horizontalSyncPol & 1) << 6 | (this.videocard.miscOutputRegister.verticalSyncPol & 1) << 7);
            }
            case 973: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Port [0x3CD] read; unknown register, returned 0x00");
                return 0;
            }
            case 974: {
                return (byte)this.videocard.graphicsController.index;
            }
            case 975: {
                switch (this.videocard.graphicsController.index) {
                    case 0: {
                        return this.videocard.graphicsController.setReset;
                    }
                    case 1: {
                        return this.videocard.graphicsController.enableSetReset;
                    }
                    case 2: {
                        return this.videocard.graphicsController.colourCompare;
                    }
                    case 3: {
                        return (byte)((this.videocard.graphicsController.dataOperation & 3) << 3 | (this.videocard.graphicsController.dataRotate & 7) << 0);
                    }
                    case 4: {
                        return this.videocard.graphicsController.readMapSelect;
                    }
                    case 5: {
                        by = (byte)((this.videocard.graphicsController.shift256Reg & 3) << 5 | (this.videocard.graphicsController.hostOddEvenEnable & 1) << 4 | (this.videocard.graphicsController.readMode & 1) << 3 | (this.videocard.graphicsController.writeMode & 3) << 0);
                        if (this.videocard.graphicsController.hostOddEvenEnable != 0 || this.videocard.graphicsController.shift256Reg != 0) {
                            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " io read 0x3cf: reg 05 = " + by);
                        }
                        return by;
                    }
                    case 6: {
                        return (byte)((this.videocard.graphicsController.memoryMapSelect & 3) << 2 | (this.videocard.graphicsController.hostOddEvenEnable & 1) << 1 | (this.videocard.graphicsController.alphaNumDisable & 1) << 0);
                    }
                    case 7: {
                        return this.videocard.graphicsController.colourDontCare;
                    }
                    case 8: {
                        return this.videocard.graphicsController.bitMask;
                    }
                }
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Port [0x3CF] reads unknown register 0x" + Integer.toHexString(this.videocard.graphicsController.index).toUpperCase());
                return 0;
            }
            case 980: {
                return this.videocard.crtControllerRegister.index;
            }
            case 949: 
            case 981: {
                if (this.videocard.crtControllerRegister.index > 24) {
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Port [0x" + Integer.toHexString(n).toUpperCase() + "] reads unknown register 0x" + Integer.toHexString(this.videocard.crtControllerRegister.index).toUpperCase());
                    return 0;
                }
                return this.videocard.crtControllerRegister.regArray[this.videocard.crtControllerRegister.index];
            }
        }
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Port [0x" + Integer.toHexString(n).toUpperCase() + "] read; unknown register, returned 0x00");
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setIOPortByte(int n, byte by) throws ModuleException, UnknownPortException {
        ModuleScreen moduleScreen = (ModuleScreen)super.getConnection(Module.Type.SCREEN);
        boolean bl = false;
        if (this.videocard.miscOutputRegister.ioAddressSelect != 0 && n >= 944 && n <= 959) {
            return;
        }
        if (this.videocard.miscOutputRegister.ioAddressSelect == 0 && n >= 976 && n <= 991) {
            return;
        }
        switch (n) {
            case 954: {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " I/O write port 0x3BA (Feature Control Register, monochrome): reserved");
                break;
            }
            case 960: {
                if (this.videocard.attributeController.dataAddressFlipFlop) {
                    switch (this.videocard.attributeController.index) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            if (by == this.videocard.attributeController.paletteRegister[this.videocard.attributeController.index]) break;
                            this.videocard.attributeController.paletteRegister[this.videocard.attributeController.index] = by;
                            bl = true;
                            break;
                        }
                        case 16: {
                            byte by2 = this.videocard.attributeController.modeControlReg.lineGraphicsEnable;
                            byte by3 = this.videocard.attributeController.modeControlReg.paletteBitsSelect;
                            this.videocard.attributeController.modeControlReg.graphicsEnable = (byte)(by >> 0 & 1);
                            this.videocard.attributeController.modeControlReg.monoColourEmu = (byte)(by >> 1 & 1);
                            this.videocard.attributeController.modeControlReg.lineGraphicsEnable = (byte)(by >> 2 & 1);
                            this.videocard.attributeController.modeControlReg.blinkIntensity = (byte)(by >> 3 & 1);
                            this.videocard.attributeController.modeControlReg.pixelPanningMode = (byte)(by >> 5 & 1);
                            this.videocard.attributeController.modeControlReg.colour8Bit = (byte)(by >> 6 & 1);
                            this.videocard.attributeController.modeControlReg.paletteBitsSelect = (byte)(by >> 7 & 1);
                            if (this.videocard.attributeController.modeControlReg.lineGraphicsEnable != by2) {
                                moduleScreen.updateCodePage(131072 + this.videocard.sequencer.charMapAddress);
                                this.videocard.vgaMemReqUpdate = true;
                            }
                            if (this.videocard.attributeController.modeControlReg.paletteBitsSelect != by3) {
                                bl = true;
                            }
                            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3C0: Mode control: " + by);
                            break;
                        }
                        case 17: {
                            this.videocard.attributeController.overscanColour = (byte)(by & 0x3F);
                            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3C0: Overscan colour = " + by);
                            break;
                        }
                        case 18: {
                            this.videocard.attributeController.colourPlaneEnable = (byte)(by & 0xF);
                            bl = true;
                            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3C0: Colour plane enable = " + by);
                            break;
                        }
                        case 19: {
                            this.videocard.attributeController.horizPixelPanning = (byte)(by & 0xF);
                            bl = true;
                            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3C0: Horiz. pixel panning = " + by);
                            break;
                        }
                        case 20: {
                            this.videocard.attributeController.colourSelect = (byte)(by & 0xF);
                            bl = true;
                            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3C0: Colour select = " + this.videocard.attributeController.colourSelect);
                            break;
                        }
                        default: {
                            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3C0: Data mode (unknown register) " + this.videocard.attributeController.index);
                            break;
                        }
                    }
                } else {
                    int n2 = this.videocard.attributeController.paletteAddressSource;
                    this.videocard.attributeController.paletteAddressSource = (byte)(by >> 5 & 1);
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3C0: address mode = " + this.videocard.attributeController.paletteAddressSource);
                    if (this.videocard.attributeController.paletteAddressSource == 0) {
                        moduleScreen.clearScreen();
                    } else if (n2 == 0) {
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "found enable transition");
                        bl = true;
                    }
                    by = (byte)(by & 0x1F);
                    this.videocard.attributeController.index = by;
                    switch (by) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            break;
                        }
                        default: {
                            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3C0: Address mode reg = " + by);
                        }
                    }
                }
                this.videocard.attributeController.dataAddressFlipFlop = !this.videocard.attributeController.dataAddressFlipFlop;
                break;
            }
            case 962: {
                this.videocard.miscOutputRegister.ioAddressSelect = (byte)(by >> 0 & 1);
                this.videocard.miscOutputRegister.ramEnable = (byte)(by >> 1 & 1);
                this.videocard.miscOutputRegister.clockSelect = (byte)(by >> 2 & 3);
                this.videocard.miscOutputRegister.lowHighPage = (byte)(by >> 5 & 1);
                this.videocard.miscOutputRegister.horizontalSyncPol = (byte)(by >> 6 & 1);
                this.videocard.miscOutputRegister.verticalSyncPol = (byte)(by >> 7 & 1);
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " I/O write port 0x3C2:");
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  I/O Address select  = " + this.videocard.miscOutputRegister.ioAddressSelect);
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Ram Enable          = " + this.videocard.miscOutputRegister.ramEnable);
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Clock Select        = " + this.videocard.miscOutputRegister.clockSelect);
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Low/High Page       = " + this.videocard.miscOutputRegister.lowHighPage);
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Horiz Sync Polarity = " + this.videocard.miscOutputRegister.horizontalSyncPol);
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Vert Sync Polarity  = " + this.videocard.miscOutputRegister.verticalSyncPol);
                break;
            }
            case 963: {
                this.videocard.vgaEnabled = (by & 1) == 1;
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " set I/O port 0x3C3: VGA Enabled = " + this.videocard.vgaEnabled);
                break;
            }
            case 964: {
                if (by > 4) {
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " I/O write port 0x3C4: index > 4");
                }
                this.videocard.sequencer.index = by;
                break;
            }
            case 965: {
                switch (this.videocard.sequencer.index) {
                    case 0: {
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " I/O write 0x3C5: Sequencer reset:  " + by);
                        if (this.videocard.sequencer.aSynchReset != 0 && (by & 1) == 0) {
                            this.videocard.sequencer.characterMapSelect = 0;
                            this.videocard.sequencer.charMapAddress = 0;
                            moduleScreen.updateCodePage(131072 + this.videocard.sequencer.charMapAddress);
                            this.videocard.vgaMemReqUpdate = true;
                        }
                        this.videocard.sequencer.aSynchReset = (byte)(by >> 0 & 1);
                        this.videocard.sequencer.synchReset = (byte)(by >> 1 & 1);
                        break;
                    }
                    case 1: {
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3C5 (clocking mode): " + by);
                        this.videocard.sequencer.clockingMode = (byte)(by & 0x3D);
                        this.videocard.sequencer.dotClockRate = (by & 8) > 0 ? (byte)1 : 0;
                        break;
                    }
                    case 2: {
                        this.videocard.sequencer.mapMask = (byte)(by & 0xF);
                        for (int i = 0; i < 4; ++i) {
                            this.videocard.sequencer.mapMaskArray[i] = (byte)(by >> i & 1);
                        }
                        break;
                    }
                    case 3: {
                        byte by4;
                        this.videocard.sequencer.characterMapSelect = (byte)(by & 0x3F);
                        byte by5 = (byte)(by & 0x13);
                        if (by5 > 3) {
                            by5 = (byte)((by5 & 3) + 4);
                        }
                        if ((by4 = (byte)((by & 0x2C) >> 2)) > 3) {
                            by4 = (byte)((by4 & 3) + 4);
                        }
                        if (this.videocard.crtControllerRegister.regArray[9] != 0) {
                            this.videocard.sequencer.charMapAddress = SequencerRegister.charMapOffset[by5];
                            moduleScreen.updateCodePage(131072 + this.videocard.sequencer.charMapAddress);
                            this.videocard.vgaMemReqUpdate = true;
                        }
                        if (by4 == by5) break;
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "Character map select: map #2 in block " + by4 + " unused");
                        break;
                    }
                    case 4: {
                        this.videocard.sequencer.extendedMemory = (byte)(by >> 1 & 1);
                        this.videocard.sequencer.oddEvenDisable = (byte)(by >> 2 & 1);
                        this.videocard.sequencer.chainFourEnable = (byte)(by >> 3 & 1);
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " I/O write port 0x3C5 (memory mode):");
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Extended Memory  = " + this.videocard.sequencer.extendedMemory);
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Odd/Even disable = " + this.videocard.sequencer.oddEvenDisable);
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Chain 4 enable   = " + this.videocard.sequencer.chainFourEnable);
                        break;
                    }
                    default: {
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3C5: index " + this.videocard.sequencer.index + " unhandled");
                        break;
                    }
                }
                break;
            }
            case 966: {
                this.videocard.colourRegister.pixelMask = by;
                if (this.videocard.colourRegister.pixelMask == -1) break;
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " I/O write port 0x3C6: Pixel mask= " + by + " != 0xFF");
                break;
            }
            case 967: {
                this.videocard.colourRegister.dacReadAddress = by;
                this.videocard.colourRegister.dacReadCounter = 0;
                this.videocard.colourRegister.dacState = (byte)3;
                break;
            }
            case 968: {
                this.videocard.colourRegister.dacWriteAddress = by;
                this.videocard.colourRegister.dacWriteCounter = 0;
                this.videocard.colourRegister.dacState = 0;
                break;
            }
            case 969: {
                switch (this.videocard.colourRegister.dacWriteCounter) {
                    case 0: {
                        this.videocard.pixels[this.videocard.colourRegister.dacWriteAddress & 0xFF].red = by;
                        break;
                    }
                    case 1: {
                        this.videocard.pixels[this.videocard.colourRegister.dacWriteAddress & 0xFF].green = by;
                        break;
                    }
                    case 2: {
                        this.videocard.pixels[this.videocard.colourRegister.dacWriteAddress & 0xFF].blue = by;
                        bl |= moduleScreen.setPaletteColour(this.videocard.colourRegister.dacWriteAddress, this.videocard.pixels[this.videocard.colourRegister.dacWriteAddress & 0xFF].red << 2, this.videocard.pixels[this.videocard.colourRegister.dacWriteAddress & 0xFF].green << 2, this.videocard.pixels[this.videocard.colourRegister.dacWriteAddress & 0xFF].blue << 2);
                        break;
                    }
                }
                ++this.videocard.colourRegister.dacWriteCounter;
                if (this.videocard.colourRegister.dacWriteCounter < 3) break;
                this.videocard.colourRegister.dacWriteCounter = 0;
                this.videocard.colourRegister.dacWriteAddress = (byte)(this.videocard.colourRegister.dacWriteAddress + 1);
                break;
            }
            case 970: {
                break;
            }
            case 972: {
                break;
            }
            case 973: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " I/O write to unknown port 0x3CD = " + by);
                break;
            }
            case 974: {
                if (by > 8) {
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " /O write port 0x3CE: index > 8");
                }
                this.videocard.graphicsController.index = by;
                break;
            }
            case 975: {
                switch (this.videocard.graphicsController.index) {
                    case 0: {
                        this.videocard.graphicsController.setReset = (byte)(by & 0xF);
                        break;
                    }
                    case 1: {
                        this.videocard.graphicsController.enableSetReset = (byte)(by & 0xF);
                        break;
                    }
                    case 2: {
                        this.videocard.graphicsController.colourCompare = (byte)(by & 0xF);
                        break;
                    }
                    case 3: {
                        this.videocard.graphicsController.dataRotate = (byte)(by & 7);
                        this.videocard.graphicsController.dataOperation = (byte)(by >> 3 & 3);
                        break;
                    }
                    case 4: {
                        this.videocard.graphicsController.readMapSelect = (byte)(by & 3);
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3CF (Read Map Select): " + by);
                        break;
                    }
                    case 5: {
                        this.videocard.graphicsController.writeMode = (byte)(by & 3);
                        this.videocard.graphicsController.readMode = (byte)(by >> 3 & 1);
                        this.videocard.graphicsController.hostOddEvenEnable = (byte)(by >> 4 & 1);
                        this.videocard.graphicsController.shift256Reg = (byte)(by >> 5 & 3);
                        if (this.videocard.graphicsController.hostOddEvenEnable != 0) {
                            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3CF (graphics mode): value = " + by);
                        }
                        if (this.videocard.graphicsController.shift256Reg == 0) break;
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "I/O write port 0x3CF (graphics mode): value = " + by);
                        break;
                    }
                    case 6: {
                        byte by6 = this.videocard.graphicsController.alphaNumDisable;
                        byte by7 = this.videocard.graphicsController.memoryMapSelect;
                        this.videocard.graphicsController.alphaNumDisable = (byte)(by & 1);
                        this.videocard.graphicsController.chainOddEvenEnable = (byte)(by >> 1 & 1);
                        this.videocard.graphicsController.memoryMapSelect = (byte)(by >> 2 & 3);
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " I/O write port 0x3CF (Miscellaneous): " + by);
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Alpha Num Disable: " + this.videocard.graphicsController.alphaNumDisable);
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Memory map select: " + this.videocard.graphicsController.memoryMapSelect);
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "  Odd/Even enable  : " + this.videocard.graphicsController.hostOddEvenEnable);
                        if (by7 != this.videocard.graphicsController.memoryMapSelect) {
                            bl = true;
                        }
                        if (by6 == this.videocard.graphicsController.alphaNumDisable) break;
                        bl = true;
                        this.oldScreenHeight = 0;
                        break;
                    }
                    case 7: {
                        this.videocard.graphicsController.colourDontCare = (byte)(by & 0xF);
                        break;
                    }
                    case 8: {
                        this.videocard.graphicsController.bitMask = by;
                        break;
                    }
                    default: {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " I/O write port 0x3CF: index " + this.videocard.graphicsController.index + " unhandled");
                        break;
                    }
                }
                break;
            }
            case 948: 
            case 980: {
                this.videocard.crtControllerRegister.index = (byte)(by & 0x7F);
                if (this.videocard.crtControllerRegister.index <= 24) break;
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " I/O write port 0x3(B|D)4: invalid CRTC register " + this.videocard.crtControllerRegister.index + " selected");
                break;
            }
            case 949: 
            case 981: {
                if (this.videocard.crtControllerRegister.index > 24) {
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  I/O write port 0x3(B|D)5: invalid CRTC Register (" + this.videocard.crtControllerRegister.index + "); ignored");
                    return;
                }
                if (this.videocard.crtControllerRegister.protectEnable && this.videocard.crtControllerRegister.index < 8) {
                    if (this.videocard.crtControllerRegister.index != 7) {
                        return;
                    }
                    byte by8 = this.videocard.crtControllerRegister.index;
                    this.videocard.crtControllerRegister.regArray[by8] = (byte)(this.videocard.crtControllerRegister.regArray[by8] & 0xFFFFFFEF);
                    this.videocard.lineCompare &= 0x2FF;
                    byte by9 = this.videocard.crtControllerRegister.index;
                    this.videocard.crtControllerRegister.regArray[by9] = (byte)(this.videocard.crtControllerRegister.regArray[by9] | by & 0x10);
                    if ((this.videocard.crtControllerRegister.regArray[7] & 0x10) != 0) {
                        this.videocard.lineCompare |= 0x100;
                    }
                    bl = true;
                    break;
                }
                if (by == this.videocard.crtControllerRegister.regArray[this.videocard.crtControllerRegister.index]) break;
                this.videocard.crtControllerRegister.regArray[this.videocard.crtControllerRegister.index] = by;
                switch (this.videocard.crtControllerRegister.index) {
                    case 7: {
                        this.videocard.verticalDisplayEnd &= 0xFF;
                        this.videocard.lineCompare &= 0x2FF;
                        if ((this.videocard.crtControllerRegister.regArray[7] & 2) != 0) {
                            this.videocard.verticalDisplayEnd |= 0x100;
                        }
                        if ((this.videocard.crtControllerRegister.regArray[7] & 0x40) != 0) {
                            this.videocard.verticalDisplayEnd |= 0x200;
                        }
                        if ((this.videocard.crtControllerRegister.regArray[7] & 0x10) != 0) {
                            this.videocard.lineCompare |= 0x100;
                        }
                        bl = true;
                        break;
                    }
                    case 8: {
                        bl = true;
                        break;
                    }
                    case 9: {
                        this.videocard.crtControllerRegister.scanDoubling = (by & 0x9F) > 0 ? (byte)1 : 0;
                        this.videocard.lineCompare &= 0x1FF;
                        if ((this.videocard.crtControllerRegister.regArray[9] & 0x40) != 0) {
                            this.videocard.lineCompare |= 0x200;
                        }
                        bl = true;
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 14: 
                    case 15: {
                        this.videocard.vgaMemReqUpdate = true;
                        break;
                    }
                    case 12: 
                    case 13: {
                        if (this.videocard.graphicsController.alphaNumDisable != 0) {
                            bl = true;
                            break;
                        }
                        this.videocard.vgaMemReqUpdate = true;
                        break;
                    }
                    case 17: {
                        this.videocard.crtControllerRegister.protectEnable = (this.videocard.crtControllerRegister.regArray[17] & 0x80) > 0;
                        break;
                    }
                    case 18: {
                        this.videocard.verticalDisplayEnd &= 0x300;
                        this.videocard.verticalDisplayEnd |= this.videocard.crtControllerRegister.regArray[18] & 0xFF;
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 23: {
                        this.videocard.lineOffset = this.videocard.crtControllerRegister.regArray[19] << 1;
                        if ((this.videocard.crtControllerRegister.regArray[20] & 0x40) != 0) {
                            this.videocard.lineOffset <<= 2;
                        } else if ((this.videocard.crtControllerRegister.regArray[23] & 0x40) == 0) {
                            this.videocard.lineOffset <<= 1;
                        }
                        bl = true;
                        break;
                    }
                    case 24: {
                        this.videocard.lineCompare &= 0x300;
                        this.videocard.lineCompare |= (short)this.videocard.crtControllerRegister.regArray[24] & 0xFF;
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 986: {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " I/O write port 0x3DA (Feature Control Register, colour): reserved");
                break;
            }
            case 961: {
                break;
            }
            default: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " unsupported I/O write to port " + n + ", data =" + by);
            }
        }
        if (bl) {
            this.setAreaForUpdate(0, 0, this.oldScreenWidth, this.oldScreenHeight);
        }
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, UnknownPortException, WriteOnlyPortException {
        return null;
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException, UnknownPortException {
        this.setIOPortByte(n, (byte)(byArray[1] & 0xFF));
        this.setIOPortByte(n + 1, (byte)(byArray[0] & 0xFF));
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, UnknownPortException, WriteOnlyPortException {
        return null;
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException, UnknownPortException {
    }

    @Override
    public byte[] getVideoBuffer() {
        return this.videocard.vgaMemory;
    }

    @Override
    public byte getVideoBufferByte(int n) {
        return this.videocard.vgaMemory[n];
    }

    @Override
    public void setVideoBufferByte(int n, byte by) {
        this.videocard.vgaMemory[n] = by;
    }

    @Override
    public String getVideoBufferCharacters() {
        ModuleScreen moduleScreen = (ModuleScreen)super.getConnection(Module.Type.SCREEN);
        int n = moduleScreen.getScreenRows();
        int n2 = moduleScreen.getScreenColumns();
        StringBuffer stringBuffer = new StringBuffer(n * n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = this.videocard.textSnapshot[i * n2 * 2 + j * 2] & 0xFF;
                if (n3 >= 255) continue;
                stringBuffer.append(this.textTranslation.asciiToUnicode[n3]);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public byte getTextSnapshot(int n) {
        return this.videocard.textSnapshot[n];
    }

    @Override
    public void setTextSnapshot(int n, byte by) {
        this.videocard.textSnapshot[n] = by;
    }

    @Override
    public byte getAttributePaletteRegister(int n) {
        return this.videocard.attributeController.paletteRegister[n];
    }

    @Override
    public int[] determineScreenSize() {
        int n;
        int n2;
        int n3 = ((this.videocard.crtControllerRegister.regArray[1] & 0xFF) + 1) * 8;
        int n4 = (this.videocard.crtControllerRegister.regArray[18] & 0xFF | (this.videocard.crtControllerRegister.regArray[7] & 0xFF & 2) << 7 | (this.videocard.crtControllerRegister.regArray[7] & 0xFF & 0x40) << 3) + 1;
        if (this.videocard.graphicsController.shift256Reg == 0) {
            n2 = 640;
            n = 480;
            if (this.videocard.crtControllerRegister.regArray[6] == -65) {
                if (this.videocard.crtControllerRegister.regArray[23] == -93 && this.videocard.crtControllerRegister.regArray[20] == 64 && this.videocard.crtControllerRegister.regArray[9] == 65) {
                    n2 = 320;
                    n = 240;
                } else {
                    if (this.videocard.sequencer.dotClockRate != 0) {
                        n3 <<= 1;
                    }
                    n2 = n3;
                    n = n4;
                }
            } else if (n3 >= 640 && n4 >= 480) {
                n2 = n3;
                n = n4;
            }
        } else if (this.videocard.graphicsController.shift256Reg == 2) {
            if (this.videocard.sequencer.chainFourEnable != 0) {
                n2 = n3;
                n = n4;
            } else {
                n2 = n3;
                n = n4;
            }
        } else {
            if (this.videocard.sequencer.dotClockRate != 0) {
                n3 <<= 1;
            }
            n2 = n3;
            n = n4;
        }
        return new int[]{n, n2};
    }

    @Override
    public byte readMode(int n) {
        int n2;
        int n3;
        int[] nArray = new int[4];
        switch (this.videocard.graphicsController.memoryMapSelect) {
            case 1: {
                if (n > 720895) {
                    return -1;
                }
                n3 = n - 655360;
                break;
            }
            case 2: {
                if (n < 720896 || n > 753663) {
                    return -1;
                }
                return this.videocard.vgaMemory[n - 720896];
            }
            case 3: {
                if (n < 753664) {
                    return -1;
                }
                return this.videocard.vgaMemory[n - 753664];
            }
            default: {
                return this.videocard.vgaMemory[n - 655360];
            }
        }
        if (this.videocard.sequencer.chainFourEnable != 0) {
            return this.videocard.vgaMemory[(n3 & 0xFFFFFFFC) + n3 % 4 * 65536];
        }
        for (n2 = 0; n2 < 4; ++n2) {
            nArray[n2] = n2 << 16;
        }
        switch (this.videocard.graphicsController.readMode) {
            case 0: {
                for (n2 = 0; n2 < 4; ++n2) {
                    this.videocard.graphicsController.latch[n2] = this.videocard.vgaMemory[nArray[n2] + n3];
                }
                return this.videocard.graphicsController.latch[this.videocard.graphicsController.readMapSelect];
            }
            case 1: {
                byte[] byArray = new byte[4];
                byte by = (byte)(this.videocard.graphicsController.colourCompare & 0xF);
                byte by2 = (byte)(this.videocard.graphicsController.colourDontCare & 0xF);
                for (n2 = 0; n2 < 4; ++n2) {
                    byArray[n2] = this.videocard.graphicsController.latch[n2] = this.videocard.vgaMemory[nArray[n2] + n3];
                    int n4 = n2;
                    byArray[n4] = (byte)(byArray[n4] ^ GraphicsController.colourCompareTable[by][n2]);
                    int n5 = n2;
                    byArray[n5] = (byte)(byArray[n5] & GraphicsController.colourCompareTable[by2][n2]);
                }
                byte by3 = (byte)(~(byArray[0] | byArray[1] | byArray[2] | byArray[3]));
                return by3;
            }
        }
        return 0;
    }

    @Override
    public void writeMode(int n, byte by) {
        int n2;
        int n3;
        int n4;
        ModuleScreen moduleScreen = (ModuleScreen)super.getConnection(Module.Type.SCREEN);
        byte[] byArray = new byte[4];
        switch (this.videocard.graphicsController.memoryMapSelect) {
            case 1: {
                if (n > 720895) {
                    return;
                }
                n4 = n - 655360;
                break;
            }
            case 2: {
                if (n < 720896 || n > 753663) {
                    return;
                }
                n4 = n - 720896;
                break;
            }
            case 3: {
                if (n < 753664) {
                    return;
                }
                n4 = n - 753664;
                break;
            }
            default: {
                n4 = n - 655360;
            }
        }
        int n5 = this.videocard.crtControllerRegister.regArray[12] << 8 | this.videocard.crtControllerRegister.regArray[13];
        if (this.videocard.graphicsController.alphaNumDisable != 0) {
            if (this.videocard.graphicsController.memoryMapSelect == 3) {
                int n6;
                int n7;
                this.videocard.vgaMemory[n4] = by;
                if ((n4 -= n5) >= 8192) {
                    n7 = n4 - 8192;
                    n7 /= 80;
                    n7 <<= 1;
                    ++n7;
                    n6 = (n4 - 8192) % 80;
                    n6 <<= 2;
                } else {
                    n7 = n4 / 80;
                    n7 <<= 1;
                    n6 = n4 % 80;
                    n6 <<= 2;
                }
                int n8 = n6;
                if (this.videocard.graphicsController.shift256Reg == 0) {
                    n6 *= 2;
                    n8 += 7;
                } else {
                    n8 += 3;
                }
                if (this.videocard.sequencer.dotClockRate != 0) {
                    n6 /= 8;
                    n8 /= 8;
                } else {
                    n6 /= 16;
                    n8 /= 16;
                }
                n7 = this.videocard.crtControllerRegister.scanDoubling != 0 ? (n7 /= 12) : (n7 /= 24);
                this.videocard.vgaMemReqUpdate = true;
                this.videocard.setTileUpdate(n6, n7, true);
                if (n8 != n6) {
                    this.videocard.setTileUpdate(n8, n7, true);
                }
                return;
            }
            if (this.videocard.graphicsController.memoryMapSelect != 1) {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " mem_write: graphics: mapping = " + this.videocard.graphicsController.memoryMapSelect);
                return;
            }
            if (this.videocard.sequencer.chainFourEnable != 0) {
                this.videocard.vgaMemory[(n4 & 0xFFFFFFFC) + n4 % 4 * 65536] = by;
                if (this.videocard.lineOffset > 0) {
                    int n9 = (n4 -= n5) % this.videocard.lineOffset / 8;
                    int n10 = this.videocard.crtControllerRegister.scanDoubling != 0 ? n4 / this.videocard.lineOffset / 12 : n4 / this.videocard.lineOffset / 24;
                    this.videocard.vgaMemReqUpdate = true;
                    this.videocard.setTileUpdate(n9, n10, true);
                }
                return;
            }
        }
        int n11 = 0;
        int n12 = 65536;
        int n13 = 131072;
        int n14 = 196608;
        block5 : switch (this.videocard.graphicsController.writeMode) {
            case 0: {
                n3 = this.videocard.graphicsController.bitMask;
                n2 = this.videocard.graphicsController.setReset;
                byte by2 = this.videocard.graphicsController.enableSetReset;
                if (this.videocard.graphicsController.dataRotate != 0) {
                    by = (byte)(by >> this.videocard.graphicsController.dataRotate | by << 8 - this.videocard.graphicsController.dataRotate);
                }
                byArray[0] = (byte)(this.videocard.graphicsController.latch[0] & ~n3);
                byArray[1] = (byte)(this.videocard.graphicsController.latch[1] & ~n3);
                byArray[2] = (byte)(this.videocard.graphicsController.latch[2] & ~n3);
                byArray[3] = (byte)(this.videocard.graphicsController.latch[3] & ~n3);
                switch (this.videocard.graphicsController.dataOperation) {
                    case 0: {
                        byArray[0] = (byte)(byArray[0] | ((by2 & 1) != 0 ? ((n2 & 1) != 0 ? n3 : 0) : by & n3));
                        byArray[1] = (byte)(byArray[1] | ((by2 & 2) != 0 ? ((n2 & 2) != 0 ? n3 : 0) : by & n3));
                        byArray[2] = (byte)(byArray[2] | ((by2 & 4) != 0 ? ((n2 & 4) != 0 ? n3 : 0) : by & n3));
                        byArray[3] = (byte)(byArray[3] | ((by2 & 8) != 0 ? ((n2 & 8) != 0 ? n3 : 0) : by & n3));
                        break block5;
                    }
                    case 1: {
                        byArray[0] = (byte)(byArray[0] | ((by2 & 1) != 0 ? ((n2 & 1) != 0 ? this.videocard.graphicsController.latch[0] & n3 : 0) : by & this.videocard.graphicsController.latch[0] & n3));
                        byArray[1] = (byte)(byArray[1] | ((by2 & 2) != 0 ? ((n2 & 2) != 0 ? this.videocard.graphicsController.latch[1] & n3 : 0) : by & this.videocard.graphicsController.latch[1] & n3));
                        byArray[2] = (byte)(byArray[2] | ((by2 & 4) != 0 ? ((n2 & 4) != 0 ? this.videocard.graphicsController.latch[2] & n3 : 0) : by & this.videocard.graphicsController.latch[2] & n3));
                        byArray[3] = (byte)(byArray[3] | ((by2 & 8) != 0 ? ((n2 & 8) != 0 ? this.videocard.graphicsController.latch[3] & n3 : 0) : by & this.videocard.graphicsController.latch[3] & n3));
                        break block5;
                    }
                    case 2: {
                        byArray[0] = (byte)(byArray[0] | ((by2 & 1) != 0 ? ((n2 & 1) != 0 ? n3 : this.videocard.graphicsController.latch[0] & n3) : (by | this.videocard.graphicsController.latch[0]) & n3));
                        byArray[1] = (byte)(byArray[1] | ((by2 & 2) != 0 ? ((n2 & 2) != 0 ? n3 : this.videocard.graphicsController.latch[1] & n3) : (by | this.videocard.graphicsController.latch[1]) & n3));
                        byArray[2] = (byte)(byArray[2] | ((by2 & 4) != 0 ? ((n2 & 4) != 0 ? n3 : this.videocard.graphicsController.latch[2] & n3) : (by | this.videocard.graphicsController.latch[2]) & n3));
                        byArray[3] = (byte)(byArray[3] | ((by2 & 8) != 0 ? ((n2 & 8) != 0 ? n3 : this.videocard.graphicsController.latch[3] & n3) : (by | this.videocard.graphicsController.latch[3]) & n3));
                        break block5;
                    }
                    case 3: {
                        byArray[0] = (byte)(byArray[0] | ((by2 & 1) != 0 ? ((n2 & 1) != 0 ? ~this.videocard.graphicsController.latch[0] & n3 : this.videocard.graphicsController.latch[0] & n3) : (by ^ this.videocard.graphicsController.latch[0]) & n3));
                        byArray[1] = (byte)(byArray[1] | ((by2 & 2) != 0 ? ((n2 & 2) != 0 ? ~this.videocard.graphicsController.latch[1] & n3 : this.videocard.graphicsController.latch[1] & n3) : (by ^ this.videocard.graphicsController.latch[1]) & n3));
                        byArray[2] = (byte)(byArray[2] | ((by2 & 4) != 0 ? ((n2 & 4) != 0 ? ~this.videocard.graphicsController.latch[2] & n3 : this.videocard.graphicsController.latch[2] & n3) : (by ^ this.videocard.graphicsController.latch[2]) & n3));
                        byArray[3] = (byte)(byArray[3] | ((by2 & 8) != 0 ? ((n2 & 8) != 0 ? ~this.videocard.graphicsController.latch[3] & n3 : this.videocard.graphicsController.latch[3] & n3) : (by ^ this.videocard.graphicsController.latch[3]) & n3));
                        break block5;
                    }
                }
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " vga_mem_write: write mode 0: op = " + this.videocard.graphicsController.dataOperation);
                break;
            }
            case 1: {
                for (int i = 0; i < 4; ++i) {
                    byArray[i] = this.videocard.graphicsController.latch[i];
                }
                break;
            }
            case 2: {
                n3 = this.videocard.graphicsController.bitMask;
                byArray[0] = (byte)(this.videocard.graphicsController.latch[0] & ~n3);
                byArray[1] = (byte)(this.videocard.graphicsController.latch[1] & ~n3);
                byArray[2] = (byte)(this.videocard.graphicsController.latch[2] & ~n3);
                byArray[3] = (byte)(this.videocard.graphicsController.latch[3] & ~n3);
                switch (this.videocard.graphicsController.dataOperation) {
                    case 0: {
                        byArray[0] = (byte)(byArray[0] | ((by & 1) != 0 ? n3 : 0));
                        byArray[1] = (byte)(byArray[1] | ((by & 2) != 0 ? n3 : 0));
                        byArray[2] = (byte)(byArray[2] | ((by & 4) != 0 ? n3 : 0));
                        byArray[3] = (byte)(byArray[3] | ((by & 8) != 0 ? n3 : 0));
                        break;
                    }
                    case 1: {
                        byArray[0] = (byte)(byArray[0] | ((by & 1) != 0 ? this.videocard.graphicsController.latch[0] & n3 : 0));
                        byArray[1] = (byte)(byArray[1] | ((by & 2) != 0 ? this.videocard.graphicsController.latch[1] & n3 : 0));
                        byArray[2] = (byte)(byArray[2] | ((by & 4) != 0 ? this.videocard.graphicsController.latch[2] & n3 : 0));
                        byArray[3] = (byte)(byArray[3] | ((by & 8) != 0 ? this.videocard.graphicsController.latch[3] & n3 : 0));
                        break;
                    }
                    case 2: {
                        byArray[0] = (byte)(byArray[0] | ((by & 1) != 0 ? n3 : this.videocard.graphicsController.latch[0] & n3));
                        byArray[1] = (byte)(byArray[1] | ((by & 2) != 0 ? n3 : this.videocard.graphicsController.latch[1] & n3));
                        byArray[2] = (byte)(byArray[2] | ((by & 4) != 0 ? n3 : this.videocard.graphicsController.latch[2] & n3));
                        byArray[3] = (byte)(byArray[3] | ((by & 8) != 0 ? n3 : this.videocard.graphicsController.latch[3] & n3));
                        break;
                    }
                    case 3: {
                        byArray[0] = (byte)(byArray[0] | ((by & 1) != 0 ? ~this.videocard.graphicsController.latch[0] & n3 : this.videocard.graphicsController.latch[0] & n3));
                        byArray[1] = (byte)(byArray[1] | ((by & 2) != 0 ? ~this.videocard.graphicsController.latch[1] & n3 : this.videocard.graphicsController.latch[1] & n3));
                        byArray[2] = (byte)(byArray[2] | ((by & 4) != 0 ? ~this.videocard.graphicsController.latch[2] & n3 : this.videocard.graphicsController.latch[2] & n3));
                        byArray[3] = (byte)(byArray[3] | ((by & 8) != 0 ? ~this.videocard.graphicsController.latch[3] & n3 : this.videocard.graphicsController.latch[3] & n3));
                    }
                }
                break;
            }
            case 3: {
                n3 = (byte)(this.videocard.graphicsController.bitMask & by);
                n2 = this.videocard.graphicsController.setReset;
                if (this.videocard.graphicsController.dataRotate != 0) {
                    by = (byte)(by >> this.videocard.graphicsController.dataRotate | by << 8 - this.videocard.graphicsController.dataRotate);
                }
                byArray[0] = (byte)(this.videocard.graphicsController.latch[0] & ~n3);
                byArray[1] = (byte)(this.videocard.graphicsController.latch[1] & ~n3);
                byArray[2] = (byte)(this.videocard.graphicsController.latch[2] & ~n3);
                byArray[3] = (byte)(this.videocard.graphicsController.latch[3] & ~n3);
                by = (byte)(by & n3);
                switch (this.videocard.graphicsController.dataOperation) {
                    case 0: {
                        byArray[0] = (byte)(byArray[0] | ((n2 & 1) != 0 ? by : (byte)0));
                        byArray[1] = (byte)(byArray[1] | ((n2 & 2) != 0 ? by : (byte)0));
                        byArray[2] = (byte)(byArray[2] | ((n2 & 4) != 0 ? by : (byte)0));
                        byArray[3] = (byte)(byArray[3] | ((n2 & 8) != 0 ? by : (byte)0));
                        break;
                    }
                    case 1: {
                        byArray[0] = (byte)(byArray[0] | ((n2 & 1) != 0 ? by : (byte)0) & this.videocard.graphicsController.latch[0]);
                        byArray[1] = (byte)(byArray[1] | ((n2 & 2) != 0 ? by : (byte)0) & this.videocard.graphicsController.latch[1]);
                        byArray[2] = (byte)(byArray[2] | ((n2 & 4) != 0 ? by : (byte)0) & this.videocard.graphicsController.latch[2]);
                        byArray[3] = (byte)(byArray[3] | ((n2 & 8) != 0 ? by : (byte)0) & this.videocard.graphicsController.latch[3]);
                        break;
                    }
                    case 2: {
                        byArray[0] = (byte)(byArray[0] | (((n2 & 1) != 0 ? by : (byte)0) | this.videocard.graphicsController.latch[0]));
                        byArray[1] = (byte)(byArray[1] | (((n2 & 2) != 0 ? by : (byte)0) | this.videocard.graphicsController.latch[1]));
                        byArray[2] = (byte)(byArray[2] | (((n2 & 4) != 0 ? by : (byte)0) | this.videocard.graphicsController.latch[2]));
                        byArray[3] = (byte)(byArray[3] | (((n2 & 8) != 0 ? by : (byte)0) | this.videocard.graphicsController.latch[3]));
                        break;
                    }
                    case 3: {
                        byArray[0] = (byte)(byArray[0] | ((n2 & 1) != 0 ? by : (byte)0) ^ this.videocard.graphicsController.latch[0]);
                        byArray[1] = (byte)(byArray[1] | ((n2 & 2) != 0 ? by : (byte)0) ^ this.videocard.graphicsController.latch[1]);
                        byArray[2] = (byte)(byArray[2] | ((n2 & 4) != 0 ? by : (byte)0) ^ this.videocard.graphicsController.latch[2]);
                        byArray[3] = (byte)(byArray[3] | ((n2 & 8) != 0 ? by : (byte)0) ^ this.videocard.graphicsController.latch[3]);
                    }
                }
                break;
            }
            default: {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " vga_mem_write: write mode " + this.videocard.graphicsController.writeMode + " ?");
            }
        }
        if ((this.videocard.sequencer.mapMask & 0xF) != 0) {
            this.videocard.vgaMemReqUpdate = true;
            if (this.videocard.sequencer.mapMaskArray[0] != 0) {
                this.videocard.vgaMemory[n11 + n4] = byArray[0];
            }
            if (this.videocard.sequencer.mapMaskArray[1] != 0) {
                this.videocard.vgaMemory[n12 + n4] = byArray[1];
            }
            if (this.videocard.sequencer.mapMaskArray[2] != 0) {
                if ((n4 & 0xE000) == this.videocard.sequencer.charMapAddress) {
                    moduleScreen.setByteInCodePage(n4 & 0x1FFF, byArray[2]);
                }
                this.videocard.vgaMemory[n13 + n4] = byArray[2];
            }
            if (this.videocard.sequencer.mapMaskArray[3] != 0) {
                this.videocard.vgaMemory[n14 + n4] = byArray[3];
            }
            if (this.videocard.graphicsController.shift256Reg == 2) {
                n3 = (n4 -= n5) % this.videocard.lineOffset * 4 / 8;
                n2 = this.videocard.crtControllerRegister.scanDoubling != 0 ? n4 / this.videocard.lineOffset / 12 : n4 / this.videocard.lineOffset / 24;
                this.videocard.setTileUpdate(n3, n2, true);
            } else {
                if (this.videocard.lineCompare < this.videocard.verticalDisplayEnd && this.videocard.lineOffset > 0) {
                    n3 = this.videocard.sequencer.dotClockRate != 0 ? n4 % this.videocard.lineOffset / 1 : n4 % this.videocard.lineOffset / 2;
                    n2 = this.videocard.crtControllerRegister.scanDoubling != 0 ? (n4 / this.videocard.lineOffset * 2 + this.videocard.lineCompare + 1) / 24 : (n4 / this.videocard.lineOffset + this.videocard.lineCompare + 1) / 24;
                    this.videocard.setTileUpdate(n3, n2, true);
                }
                if (n4 >= n5) {
                    n4 -= n5;
                    if (this.videocard.lineOffset > 0) {
                        n3 = this.videocard.sequencer.dotClockRate != 0 ? n4 % this.videocard.lineOffset / 1 : n4 % this.videocard.lineOffset / 2;
                        n2 = this.videocard.crtControllerRegister.scanDoubling != 0 ? n4 / this.videocard.lineOffset / 12 : n4 / this.videocard.lineOffset / 24;
                        this.videocard.setTileUpdate(n3, n2, true);
                    }
                }
            }
        }
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PhysicalAddressSpace && hardwareComponent.initialised()) {
            ((PhysicalAddressSpace)hardwareComponent).mapMemoryRegion(this.vidMemConnect, 655360, 131072);
        }
    }

    public class DiosJPCVideoConnect
    extends Memory {
        private int bankOffset = 0;
        private int latch = 0;
        private final int[] mask16 = new int[]{0, 255, 65280, 65535, 0xFF0000, 0xFF00FF, 0xFFFF00, 0xFFFFFF, -16777216, -16776961, -16711936, -16711681, -65536, -65281, -256, -1};
        private int planeUpdated;

        public boolean isCacheable() {
            return false;
        }

        public boolean isVolatile() {
            return true;
        }

        @Override
        public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
            throw new IllegalStateException("copyContentsInto: Invalid Operation for VGA Card");
        }

        @Override
        public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
            throw new IllegalStateException("copyContentsFrom: Invalid Operation for VGA Card");
        }

        @Override
        public long getSize() {
            return 131072L;
        }

        @Override
        public boolean isAllocated() {
            return false;
        }

        @Override
        public byte getByte(int n) {
            return Video.this.readMode(n + 655360);
        }

        @Override
        public short getWord(int n) {
            int n2 = 0xFF & this.getByte(n);
            return (short)(n2 |= this.getByte(n + 1) << 8);
        }

        @Override
        public int getDoubleWord(int n) {
            int n2 = 0xFF & this.getByte(n);
            n2 |= (0xFF & this.getByte(n + 1)) << 8;
            n2 |= (0xFF & this.getByte(n + 2)) << 16;
            return n2 |= (0xFF & this.getByte(n + 3)) << 24;
        }

        @Override
        public long getQuadWord(int n) {
            long l = 0xFFL & (long)this.getByte(n);
            l |= (0xFFL & (long)this.getByte(n + 1)) << 8;
            l |= (0xFFL & (long)this.getByte(n + 2)) << 16;
            l |= (0xFFL & (long)this.getByte(n + 3)) << 24;
            l |= (0xFFL & (long)this.getByte(n + 4)) << 32;
            l |= (0xFFL & (long)this.getByte(n + 5)) << 40;
            l |= (0xFFL & (long)this.getByte(n + 6)) << 48;
            return l |= (0xFFL & (long)this.getByte(n + 7)) << 56;
        }

        @Override
        public long getLowerDoubleQuadWord(int n) {
            return this.getQuadWord(n);
        }

        @Override
        public long getUpperDoubleQuadWord(int n) {
            return this.getQuadWord(n + 8);
        }

        @Override
        public void setByte(int n, byte by) {
            Video.this.writeMode(n + 655360, by);
        }

        @Override
        public void setWord(int n, short s) {
            this.setByte(n++, (byte)s);
            s = (short)(s >>> 8);
            this.setByte(n, (byte)s);
        }

        @Override
        public void setDoubleWord(int n, int n2) {
            this.setByte(n++, (byte)n2);
            this.setByte(n++, (byte)(n2 >>>= 8));
            this.setByte(n++, (byte)(n2 >>>= 8));
            this.setByte(n, (byte)(n2 >>>= 8));
        }

        @Override
        public void setQuadWord(int n, long l) {
            this.setDoubleWord(n, (int)l);
            this.setDoubleWord(n + 4, (int)(l >> 32));
        }

        @Override
        public void setLowerDoubleQuadWord(int n, long l) {
            this.setDoubleWord(n, (int)l);
            this.setDoubleWord(n + 4, (int)(l >> 32));
        }

        @Override
        public void setUpperDoubleQuadWord(int n, long l) {
            this.setDoubleWord(n += 8, (int)l);
            this.setDoubleWord(n + 4, (int)(l >> 32));
        }

        @Override
        public void clear() {
        }

        @Override
        public void clear(int n, int n2) {
            this.clear();
        }

        @Override
        public int execute(Processor processor, int n) {
            throw new IllegalStateException("Invalid Operation");
        }

        @Override
        public CodeBlock decodeCodeBlockAt(Processor processor, int n) {
            throw new IllegalStateException("Invalid Operation");
        }
    }
}

