/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.clock.Clock;
import dioscuri.module.cpu32.BackgroundCompiler;
import dioscuri.module.cpu32.ByteSource;
import dioscuri.module.cpu32.ByteSourceWrappedMemory;
import dioscuri.module.cpu32.CodeBlockCombiner;
import dioscuri.module.cpu32.CodeBlockFactory;
import dioscuri.module.cpu32.DefaultCodeBlockFactory;
import dioscuri.module.cpu32.FASTCompiler;
import dioscuri.module.cpu32.LazyCodeBlockMemory;
import dioscuri.module.cpu32.Memory;
import dioscuri.module.cpu32.OptimisedCompiler;
import dioscuri.module.cpu32.ProtectedModeCodeBlock;
import dioscuri.module.cpu32.ProtectedModeUDecoder;
import dioscuri.module.cpu32.RealModeCodeBlock;
import dioscuri.module.cpu32.RealModeUDecoder;
import dioscuri.module.cpu32.SpanningProtectedModeCodeBlock;
import dioscuri.module.cpu32.SpanningRealModeCodeBlock;
import dioscuri.module.cpu32.SpanningVirtual8086ModeCodeBlock;
import dioscuri.module.cpu32.Virtual8086ModeCodeBlock;

public class CodeBlockManager {
    private CodeBlockFactory realModeChain;
    private CodeBlockFactory protectedModeChain;
    private CodeBlockFactory virtual8086ModeChain;
    private CodeBlockFactory compilingRealModeChain;
    private CodeBlockFactory compilingProtectedModeChain;
    private CodeBlockCombiner combiner;
    private ByteSourceWrappedMemory byteSource;
    private SpanningRealModeCodeBlock spanningRealMode;
    private SpanningProtectedModeCodeBlock spanningProtectedMode;
    private SpanningVirtual8086ModeCodeBlock spanningVirtual8086Mode;
    private BackgroundCompiler bgc;
    private Clock clock;

    public CodeBlockManager(Clock clock) {
        this.clock = clock;
        this.byteSource = new ByteSourceWrappedMemory();
        this.realModeChain = new DefaultCodeBlockFactory(new RealModeUDecoder(), new OptimisedCompiler(clock));
        this.protectedModeChain = new DefaultCodeBlockFactory(new ProtectedModeUDecoder(), new OptimisedCompiler(clock));
        this.virtual8086ModeChain = new DefaultCodeBlockFactory(new RealModeUDecoder(), new OptimisedCompiler(clock));
        this.spanningRealMode = new SpanningRealModeCodeBlock(new CodeBlockFactory[]{this.realModeChain});
        this.spanningProtectedMode = new SpanningProtectedModeCodeBlock(new CodeBlockFactory[]{this.protectedModeChain});
        this.spanningVirtual8086Mode = new SpanningVirtual8086ModeCodeBlock(new CodeBlockFactory[]{this.virtual8086ModeChain});
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkCreateClassLoader();
            }
            System.out.println("Security Manager allows creation of classloader: attempting to use advanced compilers.");
            this.bgc = new BackgroundCompiler(new OptimisedCompiler(clock), new FASTCompiler());
            this.compilingRealModeChain = new DefaultCodeBlockFactory(new RealModeUDecoder(), this.bgc);
            this.compilingProtectedModeChain = new DefaultCodeBlockFactory(new ProtectedModeUDecoder(), this.bgc);
        }
        catch (SecurityException securityException) {
            System.out.println("Security Manager doesn't allow creation of classloader: Not using advanced compilers.");
            this.bgc = null;
            this.compilingRealModeChain = this.realModeChain;
            this.compilingProtectedModeChain = this.protectedModeChain;
        }
        this.combiner = new CodeBlockCombiner(new CompositeFactory());
    }

    private RealModeCodeBlock tryRealModeFactory(CodeBlockFactory codeBlockFactory, Memory memory, int n, SpanningRealModeCodeBlock spanningRealModeCodeBlock) {
        try {
            this.byteSource.set(memory, n & 0xFFF);
            return codeBlockFactory.getRealModeCodeBlock(this.byteSource);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return spanningRealModeCodeBlock;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ProtectedModeCodeBlock tryProtectedModeFactory(CodeBlockFactory codeBlockFactory, Memory memory, int n, boolean bl, SpanningProtectedModeCodeBlock spanningProtectedModeCodeBlock) {
        try {
            this.byteSource.set(memory, n & 0xFFF);
            return codeBlockFactory.getProtectedModeCodeBlock(this.byteSource, bl);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return spanningProtectedModeCodeBlock;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Virtual8086ModeCodeBlock tryVirtual8086ModeFactory(CodeBlockFactory codeBlockFactory, Memory memory, int n, SpanningVirtual8086ModeCodeBlock spanningVirtual8086ModeCodeBlock) {
        try {
            this.byteSource.set(memory, n & 0xFFF);
            return codeBlockFactory.getVirtual8086ModeCodeBlock(this.byteSource);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return spanningVirtual8086ModeCodeBlock;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RealModeCodeBlock getRealModeCodeBlockAt(Memory memory, int n) {
        RealModeCodeBlock realModeCodeBlock = null;
        realModeCodeBlock = this.combiner.getRealModeCodeBlockAt(memory, n);
        if (realModeCodeBlock == null && (realModeCodeBlock = this.tryRealModeFactory(this.compilingRealModeChain, memory, n, this.spanningRealMode)) == null && (realModeCodeBlock = this.tryRealModeFactory(this.realModeChain, memory, n, this.spanningRealMode)) == null) {
            throw new IllegalStateException("Couldn't find capable block");
        }
        ((LazyCodeBlockMemory)memory).setRealCodeBlockAt(n & 0xFFF, realModeCodeBlock);
        return realModeCodeBlock;
    }

    public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(Memory memory, int n, boolean bl) {
        ProtectedModeCodeBlock protectedModeCodeBlock = null;
        protectedModeCodeBlock = this.tryProtectedModeFactory(this.compilingProtectedModeChain, memory, n, bl, this.spanningProtectedMode);
        if (protectedModeCodeBlock == null && (protectedModeCodeBlock = this.tryProtectedModeFactory(this.protectedModeChain, memory, n, bl, this.spanningProtectedMode)) == null) {
            throw new IllegalStateException("Couldn't find capable block");
        }
        ((LazyCodeBlockMemory)memory).setProtectedCodeBlockAt(n & 0xFFF, protectedModeCodeBlock);
        return protectedModeCodeBlock;
    }

    public Virtual8086ModeCodeBlock getVirtual8086ModeCodeBlockAt(Memory memory, int n) {
        Virtual8086ModeCodeBlock virtual8086ModeCodeBlock = null;
        virtual8086ModeCodeBlock = this.tryVirtual8086ModeFactory(this.virtual8086ModeChain, memory, n, this.spanningVirtual8086Mode);
        if (virtual8086ModeCodeBlock == null) {
            throw new IllegalStateException("Couldn't find capable block");
        }
        ((LazyCodeBlockMemory)memory).setVirtual8086CodeBlockAt(n & 0xFFF, virtual8086ModeCodeBlock);
        return virtual8086ModeCodeBlock;
    }

    public void dispose() {
        if (this.bgc != null) {
            this.bgc.stop();
        }
        this.bgc = null;
    }

    class CompositeFactory
    implements CodeBlockFactory {
        CompositeFactory() {
        }

        private RealModeCodeBlock tryFactory(CodeBlockFactory codeBlockFactory, ByteSource byteSource, RealModeCodeBlock realModeCodeBlock) {
            try {
                return codeBlockFactory.getRealModeCodeBlock(byteSource);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return realModeCodeBlock;
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public RealModeCodeBlock getRealModeCodeBlock(ByteSource byteSource) {
            RealModeCodeBlock realModeCodeBlock = this.tryFactory(CodeBlockManager.this.compilingRealModeChain, byteSource, CodeBlockManager.this.spanningRealMode);
            if (realModeCodeBlock != null) {
                return realModeCodeBlock;
            }
            byteSource.reset();
            return this.tryFactory(CodeBlockManager.this.realModeChain, byteSource, CodeBlockManager.this.spanningRealMode);
        }

        @Override
        public ProtectedModeCodeBlock getProtectedModeCodeBlock(ByteSource byteSource, boolean bl) {
            return null;
        }

        @Override
        public Virtual8086ModeCodeBlock getVirtual8086ModeCodeBlock(ByteSource byteSource) {
            return null;
        }
    }
}

