/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_BOUND_GvMa
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    int arrayIndex;
    int lowerBoundary;
    int higherBoundary;

    public Instruction_BOUND_GvMa() {
    }

    public Instruction_BOUND_GvMa(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        this.arrayIndex = (this.sourceValue[0] << 8) + this.sourceValue[1];
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
        this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        this.lowerBoundary = (this.sourceValue[0] << 8) + this.sourceValue[1];
        this.memoryReferenceLocation = Util.addWords(this.memoryReferenceLocation, new byte[]{0, 2}, 0);
        this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        this.higherBoundary = (this.sourceValue[0] << 8) + this.sourceValue[1];
        if (this.arrayIndex < this.lowerBoundary || this.arrayIndex > this.higherBoundary) {
            // empty if block
        }
    }
}

