/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ByteSourceWrappedMemory;
import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.CodeBlockFactory;
import dioscuri.module.cpu32.LinearAddressSpace;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.SpanningCodeBlock;
import dioscuri.module.cpu32.Virtual8086ModeCodeBlock;

public class SpanningVirtual8086ModeCodeBlock
extends SpanningCodeBlock
implements Virtual8086ModeCodeBlock {
    private ByteSourceWrappedMemory byteSource = new ByteSourceWrappedMemory();
    private CodeBlockFactory[] factories;

    public SpanningVirtual8086ModeCodeBlock(CodeBlockFactory[] codeBlockFactoryArray) {
        this.factories = codeBlockFactoryArray;
    }

    @Override
    protected CodeBlock decode(Processor processor) {
        Virtual8086ModeCodeBlock virtual8086ModeCodeBlock = null;
        LinearAddressSpace linearAddressSpace = processor.linearMemory;
        int n = processor.getInstructionPointer();
        for (int i = 0; i < this.factories.length && virtual8086ModeCodeBlock == null; ++i) {
            try {
                this.byteSource.set(linearAddressSpace, n);
                virtual8086ModeCodeBlock = this.factories[i].getVirtual8086ModeCodeBlock(this.byteSource);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return virtual8086ModeCodeBlock;
    }

    @Override
    public String getDisplayString() {
        return "Spanning Virtual8086 Mode CodeBlock";
    }
}

