/*
 * Decompiled with CFR 0.152.
 */
package dioscuri;

import dioscuri.CommandLineInterface;
import dioscuri.Constants;
import dioscuri.GUI;
import dioscuri.StartupPanel;
import dioscuri.config.ConfigController;
import dioscuri.config.ConfigDialog;
import dioscuri.config.Emulator;
import dioscuri.datatransfer.TextTransfer;
import dioscuri.vnc.VNCTopFrame;
import dioscuri.vnc.VNCUtil;
import gnu.rfb.server.DefaultRFBAuthenticator;
import gnu.rfb.server.RFBAuthenticator;
import gnu.rfb.server.RFBHost;
import gnu.vnc.WebServer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

public class DioscuriFrame
extends JFrame
implements GUI,
ActionListener,
KeyListener {
    private dioscuri.Emulator emu;
    private TextTransfer textTransfer;
    boolean readOnlyConfig = false;
    private JScrollPane screenPane;
    private JPanel statusPanel;
    private JPanel scrolllockPanel;
    private JPanel numlockPanel;
    private JPanel capslockPanel;
    private JPanel floppyAPanel;
    private JPanel hd1Panel;
    private JPanel hd2Panel;
    JMenuBar menuBar;
    JMenu menuEmulator;
    JMenu menuEdit;
    JMenu menuMedia;
    JMenu menuDevices;
    JMenu menuConfig;
    JMenu menuHelp;
    JMenuItem miEmulatorStart;
    JMenuItem miEmulatorStop;
    JMenuItem miEmulatorReset;
    JMenuItem miEmulatorQuit;
    JMenuItem miEditCopyText;
    JMenuItem miEditScreenShot;
    JMenuItem miMediaEjectA;
    JMenuItem miMediaInsertA;
    JMenuItem miDevicesMouseEnabled;
    JMenuItem miDevicesMouseDisabled;
    JMenuItem miEditConfig;
    JMenuItem miHelpAbout;
    private JPanel screen;
    private MouseHandler mouseHandler;
    private JFileChooser fcFloppy;
    private JLabel cpuTypeLabel;
    private static final Logger logger = Logger.getLogger(DioscuriFrame.class.getName());
    private String configFilePath;
    Emulator emuConfig;
    CommandLineInterface cli;
    private RFBHost rfbHost;
    VNCTopFrame vncTopFrame;

    public DioscuriFrame() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DioscuriFrame.this.exitDioscuri();
            }
        });
        super.setIconImage(new ImageIcon(Constants.EMULATOR_ICON_IMAGE).getImage());
        this.initMenuBar();
        this.screenPane = new JScrollPane();
        this.screenPane.setBackground(Color.BLACK);
        this.setScreen(this.getStartupScreen());
        this.statusPanel = new JPanel(new FlowLayout(3, 0, 0));
        this.initStatusBar();
        this.getContentPane().add((Component)this.screenPane, "Center");
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.fcFloppy = new JFileChooser();
        int n = this.screenPane.getWidth() + 10;
        int n2 = this.screenPane.getHeight() + 76 + 5;
        this.addKeyListener(this);
        this.setLocation(200, 200);
        this.setSize(n, n2 + 10);
        this.setTitle(this.getEmulatorName());
        this.setResizable(false);
        this.updateGUI(99);
        this.textTransfer = new TextTransfer(this);
        super.setFocusTraversalKeysEnabled(false);
        System.out.println(this);
    }

    public DioscuriFrame(String[] stringArray) {
        this();
        try {
            this.cli = new CommandLineInterface(stringArray);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Error while paring the command line parameters:");
            exception.printStackTrace();
        }
        this.configFilePath = this.cli.configFilePath;
        this.setVisible(this.cli.visible);
        logger.log(Level.INFO, this.cli.visible ? "[gui] GUI is visible and has focus" : "[gui] GUI is hidden");
        if (this.cli.autorun) {
            this.emu = new dioscuri.Emulator(this);
            new Thread(this.emu).start();
            this.updateGUI(0);
        }
    }

    private void initMenuBar() {
        this.menuBar = new JMenuBar();
        this.menuEmulator = new JMenu("Emulator");
        this.miEmulatorStart = new JMenuItem("Start process (power on)");
        this.miEmulatorStop = new JMenuItem("Stop process (shutdown)");
        this.miEmulatorReset = new JMenuItem("Reset process (warm reset)");
        this.miEmulatorQuit = new JMenuItem("Quit");
        this.menuEmulator.add(this.miEmulatorStart);
        this.menuEmulator.add(this.miEmulatorStop);
        this.menuEmulator.add(this.miEmulatorReset);
        this.menuEmulator.add(this.miEmulatorQuit);
        this.menuEdit = new JMenu("Edit");
        this.miEditCopyText = new JMenuItem("Copy text");
        this.miEditScreenShot = new JMenuItem("Make screen shot");
        this.menuEdit.add(this.miEditCopyText);
        this.menuEdit.add(this.miEditScreenShot);
        this.menuMedia = new JMenu("Media");
        this.miMediaEjectA = new JMenuItem("Eject floppy A:");
        this.miMediaInsertA = new JMenuItem("Insert floppy A:");
        this.menuMedia.add(this.miMediaEjectA);
        this.menuMedia.add(this.miMediaInsertA);
        this.menuDevices = new JMenu("Devices");
        this.miDevicesMouseEnabled = new JMenuItem("Mouse: enable");
        this.miDevicesMouseDisabled = new JMenuItem("Mouse: disable");
        this.menuDevices.add(this.miDevicesMouseEnabled);
        this.menuDevices.add(this.miDevicesMouseDisabled);
        this.menuConfig = new JMenu("Configure");
        this.miEditConfig = new JMenuItem("Edit Config");
        this.menuConfig.add(this.miEditConfig);
        this.menuHelp = new JMenu("Help");
        this.miHelpAbout = new JMenuItem("About..");
        this.menuHelp.add(this.miHelpAbout);
        this.menuBar.add(this.menuEmulator);
        this.menuBar.add(this.menuEdit);
        this.menuBar.add(this.menuMedia);
        this.menuBar.add(this.menuDevices);
        this.menuBar.add(this.menuConfig);
        this.menuBar.add(this.menuHelp);
        this.miEmulatorStart.addActionListener(this);
        this.miEmulatorStop.addActionListener(this);
        this.miEmulatorReset.addActionListener(this);
        this.miEmulatorQuit.addActionListener(this);
        this.miEditCopyText.addActionListener(this);
        this.miMediaEjectA.addActionListener(this);
        this.miMediaInsertA.addActionListener(this);
        this.miDevicesMouseEnabled.addActionListener(this);
        this.miDevicesMouseDisabled.addActionListener(this);
        this.miEditConfig.addActionListener(this);
        this.miHelpAbout.addActionListener(this);
        this.miEditScreenShot.addActionListener(this);
        this.setJMenuBar(this.menuBar);
        this.menuBar.getInputMap(2).put(KeyStroke.getKeyStroke(121, 0), "none");
    }

    private void initStatusBar() {
        Border border = BorderFactory.createLineBorder(Color.black);
        this.numlockPanel = new JPanel();
        JLabel jLabel = new JLabel("1");
        jLabel.setAlignmentX(0.0f);
        this.numlockPanel.add(jLabel);
        this.numlockPanel.setBorder(border);
        this.numlockPanel.setSize(20, 20);
        this.capslockPanel = new JPanel();
        JLabel jLabel2 = new JLabel("A");
        jLabel2.setHorizontalAlignment(0);
        this.capslockPanel.add(jLabel2);
        this.capslockPanel.setBorder(border);
        this.scrolllockPanel = new JPanel();
        JLabel jLabel3 = new JLabel("S");
        jLabel3.setHorizontalAlignment(0);
        this.scrolllockPanel.add(jLabel3);
        this.scrolllockPanel.setBorder(border);
        this.floppyAPanel = new JPanel();
        JLabel jLabel4 = new JLabel("A:");
        jLabel4.setHorizontalAlignment(0);
        this.floppyAPanel.add(jLabel4);
        this.floppyAPanel.setBorder(border);
        this.hd1Panel = new JPanel();
        JLabel jLabel5 = new JLabel("HD1");
        jLabel5.setHorizontalAlignment(0);
        this.hd1Panel.add(jLabel5);
        this.hd1Panel.setBorder(border);
        this.hd2Panel = new JPanel();
        JLabel jLabel6 = new JLabel("HD2");
        jLabel6.setHorizontalAlignment(0);
        this.hd2Panel.add(jLabel6);
        this.hd2Panel.setBorder(border);
        this.statusPanel.add(Box.createHorizontalGlue());
        this.statusPanel.add(this.numlockPanel);
        this.statusPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.statusPanel.add(this.capslockPanel);
        this.statusPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.statusPanel.add(this.scrolllockPanel);
        this.statusPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.statusPanel.add(this.floppyAPanel);
        this.statusPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.statusPanel.add(this.hd1Panel);
        this.statusPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.statusPanel.add(this.hd2Panel);
        this.statusPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.cpuTypeLabel = new JLabel("");
        this.statusPanel.add(this.cpuTypeLabel);
    }

    public String getEmulatorName() {
        return "Dioscuri - modular emulator for digital preservation";
    }

    public String getEmulatorVersion() {
        return "0.7.0";
    }

    public String getEmulatorDate() {
        return "January, 2011";
    }

    private JPanel getStartupScreen() {
        StartupPanel startupPanel = new StartupPanel();
        startupPanel.setSize(710, 401);
        ImageIcon imageIcon = new ImageIcon(Constants.EMULATOR_SPLASHSCREEN_IMAGE);
        startupPanel.add(new JLabel(imageIcon));
        return startupPanel;
    }

    @Override
    public void setScreen(JPanel jPanel) {
        this.screenPane.removeAll();
        this.screenPane.add(jPanel);
        this.screen = jPanel;
        this.updateScreenPanel();
    }

    @Override
    public boolean setMouseEnabled() {
        this.mouseHandler = new MouseHandler();
        this.screen.addMouseListener(this.mouseHandler);
        this.screen.addMouseMotionListener(this.mouseHandler);
        logger.log(Level.INFO, "[gui] Mouse in GUI enabled");
        return true;
    }

    @Override
    public boolean setMouseDisabled() {
        if (this.mouseHandler != null) {
            this.screen.removeMouseListener(this.mouseHandler);
            this.screen.removeMouseMotionListener(this.mouseHandler);
            this.mouseHandler.setMouseCursorVisibility(true);
            this.mouseHandler = null;
            logger.log(Level.INFO, "[gui] Mouse in GUI disabled");
            return true;
        }
        logger.log(Level.INFO, "[gui] Mouse does not exist or is already disabled");
        return true;
    }

    private BufferedImage getImageFromFile(URL uRL) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "GUI error: problem during loading image.");
        }
        return bufferedImage;
    }

    protected void updateScreenPanel() {
        this.screenPane.setSize(this.screen.getWidth(), this.screen.getHeight());
        this.screen.repaint();
    }

    protected void updateStatusPanel() {
        this.statusPanel.repaint();
    }

    @Override
    public void updateGUI(int n) {
        switch (n) {
            case 0: {
                this.miEmulatorStart.setEnabled(false);
                this.miEmulatorStop.setEnabled(true);
                this.miEmulatorReset.setEnabled(true);
                this.miEditScreenShot.setEnabled(true);
                this.miEditConfig.setEnabled(false);
                this.miEditCopyText.setEnabled(true);
                break;
            }
            case 1: {
                this.miEmulatorStart.setEnabled(true);
                this.miEmulatorStop.setEnabled(false);
                this.miEmulatorReset.setEnabled(false);
                this.miMediaEjectA.setEnabled(false);
                this.miMediaInsertA.setEnabled(false);
                this.miEditCopyText.setEnabled(false);
                this.miDevicesMouseEnabled.setEnabled(false);
                this.miDevicesMouseDisabled.setEnabled(false);
                this.floppyAPanel.setVisible(false);
                this.hd1Panel.setVisible(false);
                this.hd2Panel.setVisible(false);
                this.miEditConfig.setEnabled(true);
                this.cpuTypeLabel.setText("");
                break;
            }
            case 2: {
                this.miEmulatorStart.setEnabled(false);
                this.miEmulatorStop.setEnabled(true);
                this.miEmulatorReset.setEnabled(true);
                this.miEditConfig.setEnabled(false);
                break;
            }
            case 3: {
                this.miMediaEjectA.setEnabled(true);
                this.miMediaInsertA.setEnabled(false);
                this.floppyAPanel.setVisible(true);
                break;
            }
            case 4: {
                this.miMediaEjectA.setEnabled(false);
                this.miMediaInsertA.setEnabled(true);
                this.floppyAPanel.setVisible(false);
                break;
            }
            case 15: {
                this.floppyAPanel.setBackground(Color.GREEN);
                break;
            }
            case 16: {
                this.floppyAPanel.setBackground(Color.LIGHT_GRAY);
                break;
            }
            case 5: {
                this.hd1Panel.setVisible(true);
                break;
            }
            case 21: {
                this.hd2Panel.setVisible(true);
                break;
            }
            case 6: {
                this.hd1Panel.setVisible(false);
                break;
            }
            case 22: {
                this.hd2Panel.setVisible(false);
                break;
            }
            case 7: {
                this.hd1Panel.setBackground(Color.GREEN);
                break;
            }
            case 19: {
                this.hd2Panel.setBackground(Color.GREEN);
                break;
            }
            case 8: {
                this.hd1Panel.setBackground(Color.LIGHT_GRAY);
                break;
            }
            case 20: {
                this.hd2Panel.setBackground(Color.LIGHT_GRAY);
                break;
            }
            case 9: {
                this.numlockPanel.setBackground(Color.YELLOW);
                break;
            }
            case 10: {
                this.numlockPanel.setBackground(Color.LIGHT_GRAY);
                break;
            }
            case 11: {
                this.capslockPanel.setBackground(Color.YELLOW);
                break;
            }
            case 12: {
                this.capslockPanel.setBackground(Color.LIGHT_GRAY);
                break;
            }
            case 13: {
                this.scrolllockPanel.setBackground(Color.YELLOW);
                break;
            }
            case 14: {
                this.scrolllockPanel.setBackground(Color.LIGHT_GRAY);
                break;
            }
            case 17: {
                this.miDevicesMouseEnabled.setEnabled(false);
                this.miDevicesMouseDisabled.setEnabled(true);
                break;
            }
            case 18: {
                this.miDevicesMouseEnabled.setEnabled(true);
                this.miDevicesMouseDisabled.setEnabled(false);
                break;
            }
            case 99: {
                this.miEmulatorStop.setEnabled(false);
                this.miEmulatorReset.setEnabled(false);
                this.miEditCopyText.setEnabled(false);
                this.miEditScreenShot.setEnabled(false);
                this.miMediaInsertA.setEnabled(false);
                this.miMediaEjectA.setEnabled(false);
                this.miDevicesMouseEnabled.setEnabled(false);
                this.miDevicesMouseDisabled.setEnabled(false);
                this.floppyAPanel.setVisible(false);
                this.hd1Panel.setVisible(false);
                this.hd2Panel.setVisible(false);
                this.cpuTypeLabel.setText("");
                break;
            }
            default: {
                logger.log(Level.WARNING, "No update on GUI could be performed.");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        if (jComponent == this.miEmulatorStart) {
            this.loadConfigFile();
            boolean bl = this.emuConfig.getArchitecture().getModules().getVnc().isEnabled();
            if (bl) {
                this.startVncServer();
            } else {
                this.emu = new dioscuri.Emulator(this);
                new Thread(this.emu).start();
                this.updateGUI(0);
            }
        } else if (jComponent == this.miEmulatorStop) {
            this.emu.stop();
            this.setMouseDisabled();
            if (this.rfbHost != null) {
                this.stopVncServer();
            }
            this.updateGUI(1);
        } else if (jComponent == this.miEmulatorReset) {
            this.emu.reset();
            this.updateGUI(2);
        } else if (jComponent == this.miEmulatorQuit) {
            this.exitDioscuri();
        } else if (jComponent == this.miEditCopyText) {
            String string;
            if (this.emu != null && (string = this.emu.getScreenText()) != null) {
                this.textTransfer.setClipboardContents(string);
            }
        } else if (jComponent == this.miMediaEjectA) {
            if (this.emu.ejectFloppy("A")) {
                this.updateGUI(4);
            }
        } else if (jComponent == this.miMediaInsertA) {
            int n = this.fcFloppy.showOpenDialog(this);
            if (n == 0) {
                boolean bl;
                File file = this.fcFloppy.getSelectedFile();
                if (this.emu.insertFloppy("A", (byte)4, file, bl = false)) {
                    this.updateGUI(3);
                }
            } else if (n == -1) {
                JOptionPane.showMessageDialog(this, "Could not select image from file system.");
            }
        } else if (jComponent == this.miDevicesMouseEnabled) {
            this.setMouseEnabled();
            this.updateGUI(17);
        } else if (jComponent == this.miDevicesMouseDisabled) {
            this.setMouseDisabled();
            this.updateGUI(18);
        } else if (jComponent == this.miEditConfig) {
            if (this.emuConfig == null) {
                File file = new File(this.configFilePath);
                try {
                    this.emuConfig = ConfigController.loadFromXML(file);
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "[GUI] Config file not readable: " + exception.toString());
                    return;
                }
            }
            if (this.readOnlyConfig) {
                JOptionPane.showMessageDialog(this, "No editable configuration found.\nDefault configuration loaded from jar file and is read-only", "Configuration", 2);
            } else {
                new ConfigDialog(this);
            }
        } else if (jComponent == this.miHelpAbout) {
            JOptionPane.showMessageDialog(this, this.getEmulatorName() + "\n" + "Version " + this.getEmulatorVersion() + ", Copyright (C) " + this.getEmulatorDate() + " by " + "\n\n" + " Koninklijke Bibliotheek (KB, the national Library of the Netherlands)\n" + " The Nationaal Archief of the Netherlands\n" + " Planets project\n" + " KEEP project\n" + "\n" + " This program is free software; you can redistribute it and/or\n" + " modify it under the terms of the GNU General Public License\n" + " as published by the Free Software Foundation; either version 2\n" + " of the License, or (at your option) any later version.\n" + "\n" + " This program is distributed in the hope that it will be useful,\n" + " but WITHOUT ANY WARRANTY; without even the implied warranty of\n" + " MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" + " GNU General Public License for more details.\n\n\n" + " Credits: Bram Lohman, Chris Rose, Bart Kiers, Jeffrey van der Hoeven", "About", 1);
        } else if (jComponent == this.miEditScreenShot) {
            String string = "Screenshot_" + System.currentTimeMillis() + ".png";
            File file = new File(string);
            BufferedImage bufferedImage = new BufferedImage(this.screen.getWidth(), this.screen.getHeight(), 1);
            this.screen.paint(bufferedImage.createGraphics());
            try {
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                JOptionPane.showMessageDialog(this, "An image was created and saved as:\n\n" + file.getAbsolutePath());
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Could not create an image at:\n\n" + file.getAbsolutePath() + "\n\n" + iOException.getMessage());
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        logger.log(Level.INFO, this.displayInfo(keyEvent, "KEY TYPED: "));
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        logger.log(Level.INFO, this.displayInfo(keyEvent, "KEY PRESSED: "));
        if (this.emu != null) {
            this.emu.notifyKeyboard(keyEvent, 0);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        logger.log(Level.INFO, this.displayInfo(keyEvent, "KEY RELEASED: "));
        if (this.emu != null) {
            this.emu.notifyKeyboard(keyEvent, 1);
        }
    }

    protected String displayInfo(KeyEvent keyEvent, String string) {
        String string2 = "\n";
        int n = keyEvent.getKeyCode();
        String string3 = "key code = " + n + " (" + KeyEvent.getKeyText(n) + ")";
        int n2 = keyEvent.getModifiersEx();
        String string4 = "modifiers = " + n2;
        String string5 = KeyEvent.getModifiersExText(n2);
        string4 = string5.length() > 0 ? string4 + " (" + string5 + ")" : string4 + " (no modifiers)";
        String string6 = "action key? ";
        string6 = keyEvent.isActionKey() ? string6 + "YES" : string6 + "NO";
        String string7 = "key location: ";
        int n3 = keyEvent.getKeyLocation();
        string7 = n3 == 1 ? string7 + "standard" : (n3 == 2 ? string7 + "left" : (n3 == 3 ? string7 + "right" : (n3 == 4 ? string7 + "numpad" : string7 + "unknown")));
        String string8 = "[GUI] " + string + string2 + "    " + string3 + string2 + "    " + string4 + string2 + "    " + string6 + string2 + "    " + string7 + string2;
        return string8;
    }

    @Override
    public Emulator getEmuConfig() {
        return this.emuConfig;
    }

    @Override
    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public boolean saveXML(Emulator emulator) {
        try {
            ConfigController.saveToXML(emulator, new File(this.configFilePath));
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, " [gui] Failed to save config file");
            return false;
        }
        return true;
    }

    @Override
    public void notifyGUI(int n) {
        if (n == 1) {
            if (this.cli.autoshutdown) {
                this.exitDioscuri();
            } else {
                this.updateGUI(1);
            }
        }
    }

    private void exitDioscuri() {
        this.dispose();
        if (this.emu != null) {
            this.emu.setActive(false);
        }
        System.exit(0);
    }

    private void startVncServer() {
        int n = Integer.parseInt(this.emuConfig.getArchitecture().getModules().getVnc().getPort().toString());
        String string = this.emuConfig.getArchitecture().getModules().getVnc().getPassword();
        int n2 = 5900 + n;
        String string2 = "VNCTopFrame";
        JLabel jLabel = null;
        boolean bl = VNCUtil.available(n2);
        if (!bl) {
            jLabel = new JLabel("Port " + n2 + " occupied. Please choose another port!");
            JOptionPane.showMessageDialog(this, jLabel);
        } else {
            DefaultRFBAuthenticator defaultRFBAuthenticator = new DefaultRFBAuthenticator(string);
            try {
                this.rfbHost = new RFBHost(n, string2, VNCTopFrame.class, (RFBAuthenticator)defaultRFBAuthenticator);
                new WebServer(n, string2, this.screenPane.getWidth(), this.screenPane.getHeight());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("  Unsupported class: " + string2);
                Logger.getLogger(VNCUtil.class.getName()).log(Level.SEVERE, null, noSuchMethodException);
            }
            this.vncTopFrame = null;
            while (this.vncTopFrame == null) {
                this.vncTopFrame = (VNCTopFrame)this.rfbHost.getSharedServer();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.vncTopFrame.setInternalFrame(this.screenPane, this, this.mouseHandler);
            this.setTitle("Dioscuri - modular emulator for digital preservation -= VNC Mode =-");
            JPanel jPanel = new JPanel(new GridLayout(0, 1));
            jPanel.setPreferredSize(new Dimension(200, 100));
            jPanel.add(new JLabel(""));
            jPanel.add(new JLabel(""));
            jPanel.add(new JLabel(""));
            jPanel.add(new JLabel("             Emulator is in VNC mode listening on port: " + n2));
            jPanel.add(new JLabel("             Connect to this VNC session by pointing a VNC viewer to:"));
            String string3 = VNCUtil.getHostIP();
            String string4 = VNCUtil.getHostName();
            if (string3 != null) {
                jPanel.add(new JLabel("                              " + string3 + ":" + n2));
            }
            if (string4 != null) {
                if (string3 != null) {
                    jPanel.add(new JLabel("                          or"));
                }
                jPanel.add(new JLabel("                              " + string4 + ":" + n2));
            }
            jPanel.add(new JLabel("             using 'password' (without the single quotes) as the password."));
            jPanel.add(new JLabel("             "));
            jPanel.add(new JLabel("             "));
            jPanel.add(new JLabel("             "));
            this.emu = new dioscuri.Emulator(this);
            new Thread(this.emu).start();
            this.updateGUI(0);
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setSize(200, 100);
            this.getContentPane().add((Component)jScrollPane, "Center");
        }
    }

    private void stopVncServer() {
        this.getContentPane().add(this.screenPane);
        this.rfbHost.stop();
        this.rfbHost = null;
    }

    private void loadConfigFile() {
        if (this.emuConfig == null) {
            File file = new File(this.configFilePath);
            try {
                this.emuConfig = ConfigController.loadFromXML(file);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "[GUI] Config file not readable: " + exception.toString());
            }
        }
    }

    @Override
    public String toString() {
        String string = "+-------------------------------------------------------------------------------------+";
        return "\r\n" + string + String.format("%n| %1$-" + (string.length() - 4) + "s |%n", "Dioscuri - modular emulator for digital preservation") + String.format("| %1$-" + (string.length() - 4) + "s |%n", "Copyright (C) January, 2011") + String.format("| %1$-" + (string.length() - 4) + "s |%n", "Koninklijke Bibliotheek (KB), Nationaal Archief of the Netherlands, Planets, KEEP") + string + "\r\n";
    }

    @Override
    public JFrame asJFrame() {
        return this;
    }

    @Override
    public void setCpuTypeLabel(String string) {
        this.cpuTypeLabel.setText("  " + string);
    }

    public static void main(final String[] stringArray) {
        try {
            File file = new File(Constants.EMULATOR_LOGGING_PROPERTIES);
            if (file.exists() && file.canRead()) {
                LogManager.getLogManager().readConfiguration(new BufferedInputStream(new FileInputStream(file)));
                logger.log(Level.INFO, "Logging.properties loaded from local file " + file);
            } else {
                logger.log(Level.WARNING, "No logging.properties file found locally: " + file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Error initialising the logging system: " + exception.toString());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new DioscuriFrame(stringArray);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Wrong command line option(s): " + exception.toString());
                }
            }
        });
    }

    private class MouseHandler
    implements MouseInputListener {
        Cursor invisibleCursor;

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (DioscuriFrame.this.emu != null) {
                DioscuriFrame.this.emu.notifyMouse(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (DioscuriFrame.this.emu != null) {
                DioscuriFrame.this.emu.notifyMouse(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.setMouseCursorVisibility(false);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (DioscuriFrame.this.emu != null) {
                DioscuriFrame.this.emu.notifyMouse(mouseEvent);
            }
        }

        public void setMouseCursorVisibility(boolean bl) {
            if (!bl) {
                ImageIcon imageIcon = new ImageIcon(new byte[0]);
                this.invisibleCursor = DioscuriFrame.this.getToolkit().createCustomCursor(imageIcon.getImage(), new Point(0, 0), "Invisible");
                DioscuriFrame.this.screen.setCursor(this.invisibleCursor);
            } else {
                DioscuriFrame.this.screen.setCursor(new Cursor(0));
            }
        }
    }
}

