/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.pit;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.UnknownPortException;
import dioscuri.exception.WriteOnlyPortException;
import dioscuri.interfaces.Module;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModulePIC;
import dioscuri.module.ModulePIT;
import dioscuri.module.pit.Counter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PIT
extends ModulePIT {
    private Counter[] counters = new Counter[3];
    protected int irqNumber;
    private int updateInterval = -1;
    private static final Logger logger = Logger.getLogger(PIT.class.getName());
    private static final int PORT_PIT_COUNTER0 = 64;
    private static final int PORT_PIT_COUNTER1 = 65;
    private static final int PORT_PIT_COUNTER2 = 66;
    private static final int PORT_PIT_CONTROLWORD1 = 67;
    private static final int PORT_PIT_COUNTER3 = 68;
    private static final int PORT_PIT_CONTROLWORD2 = 71;
    private static final int PORT_PIT_EISA = 72;
    private static final int PORT_PIT_TIMER2 = 73;
    private static final int PORT_PIT_EISA_PIT2A = 74;
    private static final int PORT_PIT_EISA_PIT2B = 75;
    private static final int PORT_KB_CTRL_B = 97;

    public PIT(Emulator emulator) {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = new Counter(this, i);
        }
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] " + this.getClass().getName() + " -> AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        moduleMotherboard.setIOPort(64, this);
        moduleMotherboard.setIOPort(65, this);
        moduleMotherboard.setIOPort(66, this);
        moduleMotherboard.setIOPort(67, this);
        moduleMotherboard.setIOPort(68, this);
        moduleMotherboard.setIOPort(71, this);
        moduleMotherboard.setIOPort(72, this);
        moduleMotherboard.setIOPort(73, this);
        moduleMotherboard.setIOPort(74, this);
        moduleMotherboard.setIOPort(75, this);
        this.irqNumber = modulePIC.requestIRQNumber(this);
        if (this.irqNumber > -1) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] IRQ number set to: " + this.irqNumber);
        } else {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Request of IRQ number failed.");
        }
        if (moduleMotherboard.requestTimer(this, this.updateInterval, true)) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " Timer requested successfully.");
        } else {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Failed to request a timer.");
        }
        moduleMotherboard.setTimerActiveState(this, true);
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] AbstractModule has been reset.");
        return true;
    }

    @Override
    public String getDump() {
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        string = "PIT dump:" + string2;
        string = string + "Update interval is " + this.updateInterval + " instructions/update." + string2;
        string = string + "In total " + this.counters.length + " counters exist:" + string2;
        for (int i = 0; i < this.counters.length; ++i) {
            if (this.counters[i].isEnabled()) {
                string = string + "Counter " + i + string3 + ": mode " + this.counters[i].counterMode;
                string = string + ", count: start=" + (((this.counters[i].cr[0] & 0xFF) << 8) + (this.counters[i].cr[1] & 0xFF));
                string = string + ", current=" + (((this.counters[i].ce[0] & 0xFF) << 8) + (this.counters[i].ce[1] & 0xFF));
                string = string + ", R/W-mode=" + this.counters[i].rwMode;
                string = string + ", signals: OUT=" + this.counters[i].getGateSignal() + " GATE=" + this.counters[i].getOutSignal();
                string = string + ", parity: " + (this.counters[i].getParity() ? "EVEN" : "ODD");
                string = string + ", bcd: " + (this.counters[i].getBCD() ? "BCD mode" : "Decimal mode") + string2;
                continue;
            }
            string = string + "Counter " + i + string3 + ": mode " + this.counters[i].counterMode + ", not used" + string2;
        }
        return string;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setUpdateInterval(int n) {
        this.updateInterval = n > 0 ? n : 1000;
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        moduleMotherboard.resetTimer(this, this.updateInterval);
    }

    @Override
    public void update() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i].clockPulse();
        }
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleException, UnknownPortException {
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " I/O read from address 0x" + Integer.toHexString(n));
        byte by = 0;
        switch (n) {
            case 64: {
                by = this.counters[0].getCounterValue();
                break;
            }
            case 65: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Attempted read of Counter 1 [0x41]");
                by = this.counters[1].getCounterValue();
                break;
            }
            case 66: {
                by = this.counters[2].getCounterValue();
                break;
            }
            case 67: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Attempted read of control word port [0x43]");
                break;
            }
            case 97: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Attempted read of KB_CTRL_B [0x61]");
                break;
            }
            default: {
                throw new UnknownPortException("[" + (Object)((Object)super.getType()) + "] Unknown I/O port requested");
            }
        }
        return by;
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleException, UnknownPortException {
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " I/O write to 0x" + Integer.toHexString(n) + " = 0x" + Integer.toHexString(by));
        block0 : switch (n) {
            case 64: {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Counter 0: value set to 0x" + Integer.toHexString(by & 0xFF));
                this.counters[0].setCounterValue(by);
                break;
            }
            case 65: {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Counter 1: value set to 0x" + Integer.toHexString(by & 0xFF));
                this.counters[1].setCounterValue(by);
                break;
            }
            case 66: {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Counter 2: value set to 0x" + Integer.toHexString(by & 0xFF));
                this.counters[2].setCounterValue(by);
                break;
            }
            case 67: {
                int n2 = by & 0xFF;
                int n3 = n2 >> 6;
                int n4 = n2 >> 4 & 3;
                int n5 = n2 >> 1 & 7;
                int n6 = n2 & 1;
                if (n5 > 6 || n4 > 4) {
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "] ControlWord counterMode (" + n5 + ") / rwMode (" + n4 + ") out of range");
                    break;
                }
                if (n3 == 3) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Read-Back Command is not implemented");
                    break;
                }
                switch (n4) {
                    case 0: {
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Counter " + n3 + " in latch mode.");
                        this.counters[n3].latchCounter();
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] LSB/MSB command not implemented");
                        break block0;
                    }
                    case 3: {
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Counter " + n3 + " in 16-bit mode.");
                        this.counters[n3].setCounterMode(n5);
                        this.counters[n3].rwMode = n4;
                        break block0;
                    }
                }
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] rwMode [" + n4 + "] not recognised");
                break;
            }
            default: {
                throw new UnknownPortException("[" + (Object)((Object)super.getType()) + "] Unknown I/O port requested");
            }
        }
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, WriteOnlyPortException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] IN command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Returned default value 0xFFFF to AX");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, WriteOnlyPortException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] IN command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Returned default value 0xFFFFFFFF to eAX");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    protected void raiseIRQ(Counter counter) {
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        modulePIC.setIRQ(this.irqNumber);
    }

    protected void lowerIRQ(Counter counter) {
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        modulePIC.clearIRQ(this.irqNumber);
    }
}

