/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;

public class Instruction_MOV_EvGv
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceRegister = new byte[2];
    byte[] destinationRegister = new byte[2];
    byte[] eSourceRegister = new byte[2];
    byte[] eDestinationRegister = new byte[2];

    public Instruction_MOV_EvGv() {
    }

    public Instruction_MOV_EvGv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.sourceRegister = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        if ((this.addressByte >> 6 & 3) == 3) {
            this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
            System.arraycopy(this.sourceRegister, 0, this.destinationRegister, 0, this.sourceRegister.length);
            if (this.cpu.doubleWord) {
                this.eSourceRegister = this.cpu.decodeExtraRegister((this.addressByte & 0x38) >> 3);
                this.eDestinationRegister = this.cpu.decodeExtraRegister(this.addressByte & 7);
                System.arraycopy(this.eSourceRegister, 0, this.eDestinationRegister, 0, this.eSourceRegister.length);
            }
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceRegister);
            if (this.cpu.doubleWord) {
                this.eSourceRegister = this.cpu.decodeExtraRegister((this.addressByte & 0x38) >> 3);
                this.memoryReferenceLocation[1] = (byte)(this.memoryReferenceLocation[1] + 2);
                if (this.memoryReferenceLocation[1] == 0 || this.memoryReferenceLocation[1] == 1) {
                    this.memoryReferenceLocation[0] = (byte)(this.memoryReferenceLocation[0] + 1);
                }
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.eSourceRegister);
            }
        }
    }
}

