/*
 * Decompiled with CFR 0.152.
 */
package gnu.vnc.awt.swing;

import gnu.awt.PixelsOwner;
import gnu.rfb.server.RFBClient;
import gnu.rfb.server.RFBClients;
import gnu.vnc.VNCQueue;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class VNCRepaintManager
extends RepaintManager {
    private PixelsOwner pixelsOwner;
    private VNCQueue queue;

    public VNCRepaintManager(PixelsOwner pixelsOwner, RFBClients clients) {
        this.pixelsOwner = pixelsOwner;
        this.queue = new VNCQueue(clients);
    }

    public VNCRepaintManager(PixelsOwner pixelsOwner, VNCQueue queue) {
        this.pixelsOwner = pixelsOwner;
        this.queue = queue;
    }

    public void frameBufferUpdate(RFBClient client, boolean incremental, int x, int y, int w, int h) throws IOException {
        this.queue.frameBufferUpdate(client, incremental, x, y, w, h);
    }

    public static void convertPointToScreen(Point p, Component c) {
        do {
            int y;
            int x;
            if (c instanceof JComponent) {
                x = ((JComponent)c).getX();
                y = ((JComponent)c).getY();
            } else if (c instanceof Applet) {
                if (c.isShowing()) {
                    Point pp = c.getLocationOnScreen();
                    x = pp.x;
                    y = pp.y;
                } else {
                    x = 0;
                    y = 0;
                }
            } else {
                Rectangle b = c.getBounds();
                x = b.x;
                y = b.y;
            }
            p.x += x;
            p.y += y;
        } while (!(c instanceof Window) && !(c instanceof Applet) && (c = c.getParent()) != null);
    }

    @Override
    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        super.addDirtyRegion(c, x, y, w, h);
        Point location = new Point(x, y);
        VNCRepaintManager.convertPointToScreen(location, c);
        this.queue.addRectangle(location.x, location.y, w, h, this.pixelsOwner);
    }

    @Override
    public void addInvalidComponent(JComponent c) {
        super.addInvalidComponent(c);
        Point location = new Point();
        Dimension size = c.getSize();
        try {
            SwingUtilities.convertPointToScreen(location, c);
        }
        catch (IllegalComponentStateException x) {
            throw new IllegalComponentStateException(String.valueOf(x.getMessage()) + " component=[" + c.getClass().getName() + "] parent=" + c.getParent());
        }
        this.queue.addRectangle(location.x, location.y, size.width, size.height, this.pixelsOwner);
    }

    @Override
    public void paintDirtyRegions() {
        System.out.println("painting");
        super.paintDirtyRegions();
        System.out.println("done painting, sending to vnc");
        this.queue.takeSnapshot(this.pixelsOwner);
    }
}

