/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.BytecodeFragments;
import dioscuri.module.cpu32.ClassFile;
import dioscuri.module.cpu32.CountingOutputStream;
import dioscuri.module.cpu32.RPNNode;
import java.io.IOException;
import java.util.Map;

public abstract class ExceptionHandler {
    private Map<Integer, RPNNode> rootNodes;
    private RPNNode initialNode;
    private int minPC;
    private int maxPC;
    private int lastX86Position;

    public ExceptionHandler(int n, RPNNode rPNNode, Map<Integer, RPNNode> map) {
        this.rootNodes = map;
        for (int i = 39; i < 46; ++i) {
            this.rootNodes.remove(new Integer(i));
        }
        this.lastX86Position = n;
        this.initialNode = rPNNode;
        this.minPC = Integer.MAX_VALUE;
        this.maxPC = Integer.MIN_VALUE;
    }

    public int getX86Index() {
        return this.initialNode.getX86Index();
    }

    public void assignRange(int n, int n2) {
        this.minPC = Math.min(this.minPC, n);
        this.maxPC = Math.max(this.maxPC, n2);
    }

    public boolean used() {
        return this.minPC != Integer.MAX_VALUE;
    }

    public int start() {
        return this.minPC;
    }

    public int end() {
        return this.maxPC;
    }

    public void write(CountingOutputStream countingOutputStream, ClassFile classFile) throws IOException {
        int n;
        int n2 = 0;
        for (RPNNode rPNNodeArray2 : this.rootNodes.values()) {
            if (rPNNodeArray2.getMicrocode() == -1) continue;
            rPNNodeArray2.reset(this.minPC);
            ++n2;
        }
        int n3 = 0;
        RPNNode[] rPNNodeArray = new RPNNode[n2];
        for (RPNNode rPNNode : this.rootNodes.values()) {
            if (rPNNode.getMicrocode() == -1 || rPNNode.getID() == 8) continue;
            rPNNode.writeExceptionCleanup(countingOutputStream, classFile, true);
            rPNNodeArray[n3++] = rPNNode;
        }
        for (n = n3 - 1; n >= 0; --n) {
            RPNNode.writeBytecodes(countingOutputStream, classFile, BytecodeFragments.popCode(rPNNodeArray[n].getID()));
        }
        RPNNode.writeBytecodes(countingOutputStream, classFile, BytecodeFragments.pushCode(8));
        n = classFile.addToConstantPool(new Integer(this.lastX86Position));
        if (n < 255) {
            countingOutputStream.write(18);
            countingOutputStream.write(n);
        } else {
            countingOutputStream.write(19);
            countingOutputStream.write(n >>> 8);
            countingOutputStream.write(n & 0xFF);
        }
        countingOutputStream.write(96);
        RPNNode.writeBytecodes(countingOutputStream, classFile, BytecodeFragments.popCode(8));
        this.writeHandlerRoutine(countingOutputStream, classFile);
        countingOutputStream.write(21);
        countingOutputStream.write(10);
        countingOutputStream.write(172);
    }

    protected abstract void writeHandlerRoutine(CountingOutputStream var1, ClassFile var2) throws IOException;
}

