/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.AddressSpace;
import dioscuri.module.cpu32.LinearAddressSpace;
import dioscuri.module.cpu32.Memory;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.ProcessorException;
import dioscuri.module.cpu32.Segment;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SegmentFactory {
    private static final long DESCRIPTOR_TYPE = 0x100000000000L;
    private static final long SEGMENT_TYPE = 0xF0000000000L;
    public static final Segment NULL_SEGMENT = new NullSegment();
    public static final int DESCRIPTOR_TYPE_CODE_DATA = 16;
    public static final int TYPE_ACCESSED = 1;
    public static final int TYPE_CODE = 8;
    public static final int TYPE_DATA_WRITABLE = 2;
    public static final int TYPE_DATA_EXPAND_DOWN = 4;
    public static final int TYPE_CODE_READABLE = 2;
    public static final int TYPE_CODE_CONFORMING = 4;

    public static Segment createRealModeSegment(Memory memory, int n) {
        if (memory == null) {
            throw new NullPointerException("Null reference to memory");
        }
        return new RealModeSegment(memory, n);
    }

    public static Segment createDescriptorTableSegment(Memory memory, int n, int n2) {
        if (memory == null) {
            throw new NullPointerException("Null reference to memory");
        }
        return new DescriptorTableSegment(memory, n, n2);
    }

    public static Segment createProtectedModeSegment(Memory memory, int n, long l) {
        switch ((int)((l & 0x1F0000000000L) >>> 40)) {
            default: {
                System.out.println(Integer.toHexString(n) + "  " + Long.toString(l, 16));
                throw new IllegalStateException("Attempted To Construct Reserved Segment Type");
            }
            case 1: {
                return new Available16BitTSS(memory, n, l);
            }
            case 2: {
                return new LDT(memory, n, l);
            }
            case 3: {
                return new Busy16BitTSS(memory, n, l);
            }
            case 4: {
                return new CallGate16Bit(memory, n, l);
            }
            case 5: {
                return new TaskGate(memory, n, l);
            }
            case 6: {
                return new InterruptGate16Bit(memory, n, l);
            }
            case 7: {
                return new TrapGate16Bit(memory, n, l);
            }
            case 9: {
                return new Available32BitTSS(memory, n, l);
            }
            case 11: {
                return new Busy32BitTSS(memory, n, l);
            }
            case 12: {
                return new CallGate32Bit(memory, n, l);
            }
            case 14: {
                return new InterruptGate32Bit(memory, n, l);
            }
            case 15: {
                return new TrapGate32Bit(memory, n, l);
            }
            case 16: {
                return new ReadOnlyDataSegment(memory, n, l);
            }
            case 17: {
                return new ReadOnlyAccessedDataSegment(memory, n, l);
            }
            case 18: {
                return new ReadWriteDataSegment(memory, n, l);
            }
            case 19: {
                return new ReadWriteAccessedDataSegment(memory, n, l);
            }
            case 20: {
                throw new IllegalStateException("Unimplemented Data Segment: Read-Only, Expand-Down");
            }
            case 21: {
                throw new IllegalStateException("Unimplemented Data Segment: Read-Only, Expand-Down, Accessed");
            }
            case 22: {
                throw new IllegalStateException("Unimplemented Data Segment: Read/Write, Expand-Down");
            }
            case 23: {
                throw new IllegalStateException("Unimplemented Data Segment: Read/Write, Expand-Down, Accessed");
            }
            case 24: {
                return new ExecuteOnlyCodeSegment(memory, n, l);
            }
            case 25: {
                throw new IllegalStateException("Unimplemented Code Segment: Execute-Only, Accessed");
            }
            case 26: {
                return new ExecuteReadCodeSegment(memory, n, l);
            }
            case 27: {
                return new ExecuteReadAccessedCodeSegment(memory, n, l);
            }
            case 28: {
                throw new IllegalStateException("Unimplemented Code Segment: Execute-Only, Conforming");
            }
            case 29: {
                return new ExecuteOnlyConformingAccessedCodeSegment(memory, n, l);
            }
            case 30: {
                return new ExecuteReadConformingCodeSegment(memory, n, l);
            }
            case 31: 
        }
        return new ExecuteReadConformingAccessedCodeSegment(memory, n, l);
    }

    static final class NullSegment
    extends DefaultSegment {
        public NullSegment() {
            super(null);
        }

        @Override
        public int dumpState(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(4);
            return 0;
        }

        public void loadState(DataInput dataInput) {
        }

        @Override
        public int getType() {
            throw new ProcessorException(13, 0, true);
        }

        @Override
        public int getSelector() {
            return 0;
        }

        @Override
        public void checkAddress(int n) {
            throw new ProcessorException(13, 0, true);
        }

        @Override
        public int translateAddressRead(int n) {
            throw new ProcessorException(13, 0, true);
        }

        @Override
        public int translateAddressWrite(int n) {
            throw new ProcessorException(13, 0, true);
        }

        @Override
        public void invalidateAddress(int n) {
            throw new ProcessorException(13, 0, true);
        }
    }

    static final class Busy16BitTSS
    extends DefaultProtectedModeSegment {
        public Busy16BitTSS(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 3;
        }
    }

    static final class Available16BitTSS
    extends DefaultProtectedModeSegment {
        public Available16BitTSS(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 1;
        }
    }

    public static final class CallGate16Bit
    extends GateSegment {
        private int parameterCount;

        public CallGate16Bit(Memory memory, int n, long l) {
            super(memory, n, l);
            this.parameterCount = (int)(l >> 32 & 0xFL);
        }

        @Override
        public int getType() {
            return 4;
        }

        public final int getParameterCount() {
            return this.parameterCount;
        }
    }

    public static final class CallGate32Bit
    extends GateSegment {
        private int parameterCount;

        public CallGate32Bit(Memory memory, int n, long l) {
            super(memory, n, l);
            this.parameterCount = (int)(l >> 32 & 0xFL);
        }

        @Override
        public int getType() {
            return 12;
        }

        public final int getParameterCount() {
            return this.parameterCount;
        }
    }

    static final class TrapGate16Bit
    extends GateSegment {
        public TrapGate16Bit(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 7;
        }
    }

    static final class TrapGate32Bit
    extends GateSegment {
        public TrapGate32Bit(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 15;
        }
    }

    static final class InterruptGate16Bit
    extends GateSegment {
        public InterruptGate16Bit(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 6;
        }
    }

    static final class InterruptGate32Bit
    extends GateSegment {
        public InterruptGate32Bit(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 14;
        }
    }

    static final class TaskGate
    extends GateSegment {
        public TaskGate(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public final int getTargetOffset() {
            throw new IllegalStateException();
        }

        @Override
        public int getType() {
            return 5;
        }
    }

    public static class GateSegment
    extends ReadOnlyProtectedModeSegment {
        private int targetSegment;
        private int targetOffset;

        public GateSegment(Memory memory, int n, long l) {
            super(memory, n, l);
            this.targetSegment = (int)(l >> 16 & 0xFFFFL);
            this.targetOffset = (int)(l & 0xFFFFL | l >>> 32 & 0xFFFFFFFFFFFF0000L);
        }

        public int getTargetSegment() {
            return this.targetSegment;
        }

        public int getTargetOffset() {
            return this.targetOffset;
        }
    }

    static final class LDT
    extends ReadOnlyProtectedModeSegment {
        public LDT(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 2;
        }
    }

    static final class Busy32BitTSS
    extends AbstractTSS {
        public Busy32BitTSS(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 11;
        }
    }

    static final class Available32BitTSS
    extends AbstractTSS {
        public Available32BitTSS(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 9;
        }
    }

    public static abstract class AbstractTSS
    extends ReadOnlyProtectedModeSegment {
        public AbstractTSS(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        public void saveCPUState(Processor processor) {
            int n = this.translateAddressWrite(0);
            this.memory.setDoubleWord(n + 32, processor.eip);
            this.memory.setDoubleWord(n + 36, processor.getEFlags());
            this.memory.setDoubleWord(n + 40, processor.eax);
            this.memory.setDoubleWord(n + 44, processor.ecx);
            this.memory.setDoubleWord(n + 48, processor.edx);
            this.memory.setDoubleWord(n + 52, processor.ebx);
            this.memory.setDoubleWord(n + 56, processor.esp);
            this.memory.setDoubleWord(n + 60, processor.ebp);
            this.memory.setDoubleWord(n + 64, processor.esi);
            this.memory.setDoubleWord(n + 68, processor.edi);
            this.memory.setDoubleWord(n + 72, processor.es.getSelector());
            this.memory.setDoubleWord(n + 76, processor.cs.getSelector());
            this.memory.setDoubleWord(n + 80, processor.ss.getSelector());
            this.memory.setDoubleWord(n + 84, processor.ds.getSelector());
            this.memory.setDoubleWord(n + 88, processor.fs.getSelector());
            this.memory.setDoubleWord(n + 92, processor.gs.getSelector());
        }

        public void restoreCPUState(Processor processor) {
            int n = this.translateAddressRead(0);
            processor.eip = this.memory.getDoubleWord(n + 32);
            processor.setEFlags(this.memory.getDoubleWord(n + 36));
            processor.eax = this.memory.getDoubleWord(n + 40);
            processor.ecx = this.memory.getDoubleWord(n + 44);
            processor.edx = this.memory.getDoubleWord(n + 48);
            processor.ebx = this.memory.getDoubleWord(n + 52);
            processor.esp = this.memory.getDoubleWord(n + 56);
            processor.ebp = this.memory.getDoubleWord(n + 60);
            processor.esi = this.memory.getDoubleWord(n + 64);
            processor.edi = this.memory.getDoubleWord(n + 68);
            processor.es = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 72));
            processor.cs = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 76));
            processor.ss = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 80));
            processor.ds = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 84));
            processor.fs = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 88));
            processor.gs = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 92));
            processor.ldtr = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 96));
            processor.setCR3(this.memory.getDoubleWord(n + 28));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte getByte(int n) {
            boolean bl = ((LinearAddressSpace)this.memory).isSupervisor();
            try {
                ((LinearAddressSpace)this.memory).setSupervisor(true);
                byte by = super.getByte(n);
                return by;
            }
            finally {
                ((LinearAddressSpace)this.memory).setSupervisor(bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short getWord(int n) {
            boolean bl = ((LinearAddressSpace)this.memory).isSupervisor();
            try {
                ((LinearAddressSpace)this.memory).setSupervisor(true);
                short s = super.getWord(n);
                return s;
            }
            finally {
                ((LinearAddressSpace)this.memory).setSupervisor(bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDoubleWord(int n) {
            boolean bl = ((LinearAddressSpace)this.memory).isSupervisor();
            try {
                ((LinearAddressSpace)this.memory).setSupervisor(true);
                int n2 = super.getDoubleWord(n);
                return n2;
            }
            finally {
                ((LinearAddressSpace)this.memory).setSupervisor(bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getQuadWord(int n) {
            boolean bl = ((LinearAddressSpace)this.memory).isSupervisor();
            try {
                ((LinearAddressSpace)this.memory).setSupervisor(true);
                long l = super.getQuadWord(n);
                return l;
            }
            finally {
                ((LinearAddressSpace)this.memory).setSupervisor(bl);
            }
        }
    }

    static final class ExecuteReadConformingCodeSegment
    extends DefaultProtectedModeSegment {
        public ExecuteReadConformingCodeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 30;
        }
    }

    static final class ExecuteReadConformingAccessedCodeSegment
    extends DefaultProtectedModeSegment {
        public ExecuteReadConformingAccessedCodeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 31;
        }
    }

    static final class ExecuteOnlyConformingAccessedCodeSegment
    extends ReadOnlyProtectedModeSegment {
        public ExecuteOnlyConformingAccessedCodeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 29;
        }
    }

    static final class ExecuteReadCodeSegment
    extends DefaultProtectedModeSegment {
        public ExecuteReadCodeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 26;
        }
    }

    static final class ExecuteReadAccessedCodeSegment
    extends DefaultProtectedModeSegment {
        public ExecuteReadAccessedCodeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 27;
        }
    }

    static final class ExecuteOnlyCodeSegment
    extends ReadOnlyProtectedModeSegment {
        public ExecuteOnlyCodeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 24;
        }
    }

    static final class ReadWriteAccessedDataSegment
    extends DefaultProtectedModeSegment {
        public ReadWriteAccessedDataSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 19;
        }
    }

    static final class ReadWriteDataSegment
    extends DefaultProtectedModeSegment {
        public ReadWriteDataSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 18;
        }
    }

    static final class ReadOnlyAccessedDataSegment
    extends ReadOnlyProtectedModeSegment {
        public ReadOnlyAccessedDataSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 17;
        }

        @Override
        void writeAttempted() {
            throw new ProcessorException(13, 0, true);
        }
    }

    static final class ReadOnlyDataSegment
    extends ReadOnlyProtectedModeSegment {
        public ReadOnlyDataSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        @Override
        public int getType() {
            return 16;
        }

        @Override
        void writeAttempted() {
            throw new ProcessorException(13, 0, true);
        }
    }

    static abstract class ReadOnlyProtectedModeSegment
    extends DefaultProtectedModeSegment {
        public ReadOnlyProtectedModeSegment(Memory memory, int n, long l) {
            super(memory, n, l);
        }

        void writeAttempted() {
            throw new IllegalStateException();
        }

        @Override
        public void setByte(int n, byte by) {
            this.writeAttempted();
        }

        @Override
        public void setWord(int n, short s) {
            this.writeAttempted();
        }

        @Override
        public void setDoubleWord(int n, int n2) {
            this.writeAttempted();
        }

        @Override
        public void setQuadWord(int n, long l) {
            this.writeAttempted();
        }
    }

    static abstract class DefaultProtectedModeSegment
    extends DefaultSegment {
        private boolean defaultSize;
        private boolean granularity;
        private boolean present;
        private int selector;
        private int limit;
        private int base;
        private int rpl;
        private int dpl;
        private long longLimit;
        private long descriptor;

        public DefaultProtectedModeSegment(Memory memory, int n, long l) {
            super(memory);
            this.selector = n;
            this.descriptor = l;
            this.granularity = (l & 0x80000000000000L) != 0L;
            this.limit = (int)(l & 0xFFFFL | l >>> 32 & 0xF0000L);
            if (this.granularity) {
                this.limit = this.limit << 12 | 0xFFF;
            }
            this.longLimit = 0xFFFFFFFFL & (long)this.limit;
            this.base = (int)(0xFFFFFFL & l >> 16 | l >> 32 & 0xFFFFFFFFFF000000L);
            this.rpl = n & 3;
            this.dpl = (int)(l >> 45 & 3L);
            this.defaultSize = (l & 0x40000000000000L) != 0L;
            this.present = (l & 0x800000000000L) != 0L;
        }

        @Override
        public int dumpState(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(3);
            dataOutput.writeInt(this.selector);
            dataOutput.writeLong(this.descriptor);
            return 12;
        }

        @Override
        public boolean isPresent() {
            return this.present;
        }

        @Override
        public final int translateAddressRead(int n) {
            this.checkAddress(n);
            return this.base + n;
        }

        @Override
        public final int translateAddressWrite(int n) {
            this.checkAddress(n);
            return this.base + n;
        }

        @Override
        public final void checkAddress(int n) {
            if ((0xFFFFFFFFL & (long)n) > this.longLimit) {
                System.err.println("Segment limit exceeded: " + Integer.toHexString(n) + " > " + Integer.toHexString((int)this.longLimit));
                throw new ProcessorException(13, 0, true);
            }
        }

        @Override
        public boolean getDefaultSizeFlag() {
            return this.defaultSize;
        }

        @Override
        public int getLimit() {
            return this.limit;
        }

        @Override
        public int getBase() {
            return this.base;
        }

        @Override
        public int getSelector() {
            return this.selector;
        }

        @Override
        public int getRPL() {
            return this.rpl;
        }

        @Override
        public int getDPL() {
            return this.dpl;
        }

        @Override
        public void setRPL(int n) {
            this.rpl = n;
        }
    }

    static final class DescriptorTableSegment
    extends DefaultSegment {
        private int base;
        private long limit;

        public DescriptorTableSegment(Memory memory, int n, int n2) {
            super(memory);
            this.base = n;
            this.limit = 0xFFFFFFFFL & (long)n2;
        }

        @Override
        public int dumpState(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(2);
            dataOutput.writeInt(this.base);
            dataOutput.writeInt((int)this.limit);
            return 12;
        }

        @Override
        public int getLimit() {
            return (int)this.limit;
        }

        @Override
        public int getBase() {
            return this.base;
        }

        @Override
        public int getSelector() {
            throw new IllegalStateException("No selector for a descriptor table segment");
        }

        @Override
        public boolean setSelector(int n) {
            throw new IllegalStateException("Cannot set a selector for a descriptor table segment");
        }

        @Override
        public void checkAddress(int n) {
            if ((0xFFFFFFFFL & (long)n) > this.limit) {
                throw new ProcessorException(13, n, true);
            }
        }

        @Override
        public int translateAddressRead(int n) {
            return this.base + n;
        }

        @Override
        public int translateAddressWrite(int n) {
            return this.base + n;
        }
    }

    static final class RealModeSegment
    extends DefaultSegment {
        private int selector;
        private int base;
        private int limit;

        public RealModeSegment(Memory memory, int n) {
            super(memory);
            this.selector = n;
            this.base = n << 4;
            this.limit = 65535;
        }

        @Override
        public int dumpState(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(1);
            dataOutput.writeInt(this.selector);
            return 8;
        }

        @Override
        public boolean getDefaultSizeFlag() {
            return false;
        }

        @Override
        public int getLimit() {
            return this.limit;
        }

        @Override
        public int getBase() {
            return this.base;
        }

        @Override
        public int getSelector() {
            return this.selector;
        }

        @Override
        public boolean setSelector(int n) {
            this.selector = n;
            this.base = n << 4;
            return true;
        }

        @Override
        public void checkAddress(int n) {
        }

        @Override
        public int translateAddressRead(int n) {
            return this.base + n;
        }

        @Override
        public int translateAddressWrite(int n) {
            return this.base + n;
        }

        @Override
        public int getRPL() {
            return 0;
        }
    }

    static abstract class DefaultSegment
    extends Segment {
        Memory memory;

        public DefaultSegment(Memory memory) {
            this.memory = memory;
        }

        @Override
        public void setAddressSpace(AddressSpace addressSpace) {
            this.memory = addressSpace;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        public void invalidateAddress(int n) {
        }

        @Override
        public int getType() {
            throw new IllegalStateException(this.getClass().toString());
        }

        @Override
        public boolean getDefaultSizeFlag() {
            throw new IllegalStateException(this.getClass().toString());
        }

        @Override
        public int getLimit() {
            throw new IllegalStateException(this.getClass().toString());
        }

        @Override
        public int getBase() {
            throw new IllegalStateException(this.getClass().toString());
        }

        @Override
        public int getSelector() {
            throw new IllegalStateException(this.getClass().toString());
        }

        @Override
        public boolean setSelector(int n) {
            throw new IllegalStateException(this.getClass().toString());
        }

        @Override
        public int getRPL() {
            throw new IllegalStateException(this.getClass().toString());
        }

        @Override
        public void setRPL(int n) {
            throw new IllegalStateException(this.getClass().toString());
        }

        @Override
        public int getDPL() {
            throw new IllegalStateException(this.getClass().toString());
        }

        @Override
        public abstract void checkAddress(int var1);

        @Override
        public abstract int translateAddressRead(int var1);

        @Override
        public abstract int translateAddressWrite(int var1);

        @Override
        public byte getByte(int n) {
            return this.memory.getByte(this.translateAddressRead(n));
        }

        @Override
        public short getWord(int n) {
            return this.memory.getWord(this.translateAddressRead(n));
        }

        @Override
        public int getDoubleWord(int n) {
            return this.memory.getDoubleWord(this.translateAddressRead(n));
        }

        @Override
        public long getQuadWord(int n) {
            int n2 = this.translateAddressRead(n);
            long l = 0xFFFFFFFFL & (long)this.memory.getDoubleWord(n2);
            n2 = this.translateAddressRead(n + 4);
            return l |= (long)this.memory.getDoubleWord(n2) << 32;
        }

        @Override
        public void setByte(int n, byte by) {
            this.memory.setByte(this.translateAddressWrite(n), by);
        }

        @Override
        public void setWord(int n, short s) {
            this.memory.setWord(this.translateAddressWrite(n), s);
        }

        @Override
        public void setDoubleWord(int n, int n2) {
            this.memory.setDoubleWord(this.translateAddressWrite(n), n2);
        }

        @Override
        public void setQuadWord(int n, long l) {
            int n2 = this.translateAddressWrite(n);
            this.memory.setDoubleWord(n2, (int)l);
            n2 = this.translateAddressWrite(n + 4);
            this.memory.setDoubleWord(n2, (int)(l >>> 32));
        }
    }
}

