/*
 * Decompiled with CFR 0.152.
 */
package dioscuri;

import dioscuri.exception.CommandException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IO {
    private String[] cmd = null;
    private String[] prevCmd = null;
    private int cmdPointer = 0;
    public String imageFilename = "";
    private String[] arguments = null;
    private static final Logger logger = Logger.getLogger(IO.class.getName());

    public byte[] importBinaryStream(String string) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(new FileInputStream(new File(string))));
        byte[] byArray = new byte[bufferedInputStream.available()];
        bufferedInputStream.read(byArray, 0, byArray.length);
        bufferedInputStream.close();
        return byArray;
    }

    public void exportBinaryStream(String string, String string2) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(new File(string)));
        dataOutputStream.writeChars(string2);
        dataOutputStream.close();
    }

    public String getInput() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.print(">");
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Unable to read input.");
            return null;
        }
    }

    public void setOutput(String string) {
        System.out.println(string);
    }

    public int getCommand() {
        int n = -1;
        this.arguments = null;
        if (this.cmd == null) {
            this.cmd = this.getInput().split(" ");
            this.cmdPointer = 0;
        }
        try {
            if (this.cmd[0].equals("") && this.prevCmd != null) {
                this.cmd = new String[this.prevCmd.length];
                System.arraycopy(this.prevCmd, 0, this.cmd, 0, this.prevCmd.length);
            }
            this.prevCmd = new String[this.cmd.length];
            if (this.cmd[0].equals("h")) {
                if (this.cmd.length > 1) {
                    throw new CommandException("Debug command h: wrong number of arguments supplied.\n Usage is: h");
                }
                n = 3;
                System.arraycopy(this.cmd, 0, this.prevCmd, 0, this.cmd.length);
                this.cmd = null;
            } else if (this.cmd[this.cmdPointer].equals("s")) {
                if (this.cmd.length > 2) {
                    throw new CommandException("Debug command s: wrong number of arguments supplied.\n Usage is: s [number].");
                }
                if (this.cmd.length > 1) {
                    try {
                        this.arguments = new String[]{this.cmd[1]};
                        n = 16;
                        System.arraycopy(this.cmd, 0, this.prevCmd, 0, this.cmd.length);
                        this.cmd = null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.log(Level.WARNING, numberFormatException.getMessage());
                        n = 255;
                        System.arraycopy(this.cmd, 0, this.prevCmd, 0, this.cmd.length);
                        this.cmd = null;
                    }
                } else {
                    n = 16;
                    System.arraycopy(this.cmd, 0, this.prevCmd, 0, this.cmd.length);
                    this.cmd = null;
                }
            } else if (this.cmd[0].equals("r")) {
                if (this.cmd.length > 1) {
                    throw new CommandException("Debug command r: wrong number of arguments supplied.\n Usage is: r");
                }
                n = 20;
                System.arraycopy(this.cmd, 0, this.prevCmd, 0, this.cmd.length);
                this.cmd = null;
            } else if (this.cmd[0].equals("d")) {
                if (this.cmd.length != 2) {
                    throw new CommandException("Debug command d: wrong number of arguments supplied.\n Usage is: d <MODULE>.");
                }
                this.arguments = new String[]{this.cmd[1]};
                n = 17;
                System.arraycopy(this.cmd, 0, this.prevCmd, 0, this.cmd.length);
                this.cmd = null;
            } else if (this.cmd[0].equals("m")) {
                if (this.cmd.length < 2 || this.cmd.length > 3) {
                    throw new CommandException("Debug command m: wrong number of arguments supplied.\n Usage is: m <address> [bytes].");
                }
                this.arguments = this.cmd.length == 3 ? new String[]{this.cmd[1], this.cmd[2]} : new String[]{this.cmd[1]};
                n = 21;
                System.arraycopy(this.cmd, 0, this.prevCmd, 0, this.cmd.length);
                this.cmd = null;
            }
            if (n == -1) {
                throw new CommandException("Syntax error.");
            }
        }
        catch (CommandException commandException) {
            logger.log(Level.WARNING, commandException.getMessage());
            n = 255;
            System.arraycopy(this.cmd, 0, this.prevCmd, 0, this.cmd.length);
            this.cmd = null;
        }
        ++this.cmdPointer;
        return n;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    void showHelp() {
        logger.log(Level.SEVERE, this.toString());
    }

    public String toString() {
        String string = "Emulator help\r\n";
        string = string + "--------------------------------------------------------------------------------------------------\r\n";
        string = string + "In debug mode, the following commands may be used:\r\n";
        string = string + "h                      = show this help information\r\n";
        string = string + "r                      = show current contents of all CPU registers\r\n";
        string = string + "s [NUMBER]             = step through the execution process [NUMBER] steps\r\n";
        string = string + "                         (default is 1 step)\r\n";
        string = string + "m <address> [NUMBER]   = show contents of [NUMBER] bytes at memory location <address>\r\n";
        string = string + "                         (default is 2 bytes)\r\n";
        string = string + "d <MODULE>             = show current contents of <MODULE>\r\n";
        string = string + "                         valid modules are  ata, bios, clock, cpu, dma, fdc, keyboard,\r\n";
        string = string + "                         memory, motherboard, parallelport, pic, pit, screen, serialport, vga\r\n";
        string = string + "--------------------------------------------------------------------------------------------------\r\n";
        return string;
    }
}

