/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.Emulator;
import dioscuri.util.Utilities;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class AbstractModulePanel
extends JPanel {
    final GUI parent;
    final Emulator emuConfig;

    AbstractModulePanel(GUI gUI, Emulator emulator) {
        this.parent = gUI;
        this.emuConfig = emulator;
    }

    File chooseFile() {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        return file;
    }

    abstract void save() throws Exception;

    final void saveAndWrite() {
        try {
            this.save();
            this.writeXML();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error saving parameter to configuration file.\n\n" + exception.getMessage(), "DIOSCURI", 2);
        }
    }

    void writeXML() {
        if (!Utilities.saveXML(this.emuConfig, this.parent.getConfigFilePath())) {
            JOptionPane.showMessageDialog(this, "Error saving parameter to configuration file.", "DIOSCURI", 2);
        }
    }
}

