/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.bios;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.module.ModuleBIOS;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BIOS
extends ModuleBIOS {
    private static final Logger logger = Logger.getLogger(BIOS.class.getName());
    private byte[] systemROM = new byte[65536];
    private byte[] videoROM = new byte[32768];
    private static final int SYSTEMBIOS_ROM_SIZE = 65536;
    private static final int VIDEOBIOS_ROM_SIZE = 32768;

    public BIOS(Emulator emulator) {
        Arrays.fill(this.systemROM, (byte)0);
        Arrays.fill(this.videoROM, (byte)0);
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] " + this.getClass().getName() + " -> AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] AbstractModule has been reset.");
        return true;
    }

    @Override
    public String getDump() {
        int n;
        int n2;
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        String string4 = " ";
        string = "System BIOS dump of first 800 bytes as stored in ROM:" + string2;
        for (n2 = 0; n2 < 50; ++n2) {
            string = string + n2 + string3 + ": ";
            for (n = 0; n < 16; ++n) {
                string = string + Integer.toHexString(0x100 | this.systemROM[n2 * 16 + n] & 0xFF).substring(1).toUpperCase() + string4;
            }
            string = string + string2;
        }
        string = string + string2;
        string = string + "Video BIOS dump of first 800 bytes as stored in ROM:" + string2;
        for (n2 = 0; n2 < 50; ++n2) {
            string = string + n2 + string3 + ": ";
            for (n = 0; n < 16; ++n) {
                string = string + Integer.toHexString(0x100 | this.videoROM[n2 * 16 + n] & 0xFF).substring(1).toUpperCase() + string4;
            }
            string = string + string2;
        }
        return string;
    }

    @Override
    public byte[] getSystemBIOS() {
        byte[] byArray = new byte[65536];
        for (int i = 0; i < 65536; ++i) {
            byArray[i] = this.systemROM[i];
        }
        return byArray;
    }

    @Override
    public boolean setSystemBIOS(byte[] byArray) throws ModuleException {
        if (byArray.length == 65536) {
            try {
                for (int i = 0; i < 65536; ++i) {
                    this.systemROM[i] = byArray[i];
                }
                return true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " System BIOS is larger than " + 65536 + " bytes");
                throw new ModuleException("[" + (Object)((Object)super.getType()) + "]" + " System BIOS is larger than " + 65536 + " bytes");
            }
        }
        throw new ModuleException("[" + (Object)((Object)super.getType()) + "]" + " System BIOS is not " + 65536 + " bytes");
    }

    @Override
    public byte[] getVideoBIOS() {
        byte[] byArray = new byte[32768];
        for (int i = 0; i < 32768; ++i) {
            byArray[i] = this.videoROM[i];
        }
        return byArray;
    }

    @Override
    public boolean setVideoBIOS(byte[] byArray) throws ModuleException {
        if (byArray.length == 32768) {
            try {
                for (int i = 0; i < 32768; ++i) {
                    this.videoROM[i] = byArray[i];
                }
                return true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + " Video BIOS is larger than " + 65536 + " bytes");
                throw new ModuleException("[" + (Object)((Object)super.getType()) + " Video BIOS is larger than " + 65536 + " bytes");
            }
        }
        throw new ModuleException("[" + (Object)((Object)super.getType()) + " Video BIOS is not " + 65536 + " bytes");
    }
}

