/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_ADC_EvGv
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] sourceValue2 = new byte[2];
    byte[] destinationValue = new byte[2];
    byte[] destinationRegister = new byte[2];
    int intermediateResult;
    byte iCarryFlag;
    byte[] temp = new byte[2];
    byte[] oldDest = new byte[2];
    byte[] oldSource = new byte[2];

    public Instruction_ADC_EvGv() {
    }

    public Instruction_ADC_EvGv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.iCarryFlag = (byte)(this.cpu.flags[0] ? 1 : 0);
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        if ((this.addressByte >> 6 & 3) == 3) {
            this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
            System.arraycopy(this.destinationRegister, 0, this.oldDest, 0, this.destinationRegister.length);
            System.arraycopy(this.sourceValue, 0, this.oldSource, 0, this.sourceValue.length);
            this.temp = Util.addWords(this.destinationRegister, this.sourceValue, this.iCarryFlag);
            System.arraycopy(this.temp, 0, this.destinationRegister, 0, this.temp.length);
            this.cpu.flags[4] = Util.test_AF_ADD(this.oldDest[1], this.destinationRegister[1]);
            this.cpu.flags[0] = Util.test_CF_ADD(this.oldDest, this.oldSource, (int)this.iCarryFlag);
            this.cpu.flags[11] = Util.test_OF_ADD(this.oldDest, this.oldSource, this.destinationRegister, (int)this.iCarryFlag);
            this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
            this.cpu.flags[7] = this.destinationRegister[0] < 0;
            this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.sourceValue2 = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
            this.temp = Util.addWords(this.sourceValue, this.sourceValue2, this.iCarryFlag);
            System.arraycopy(this.temp, 0, this.destinationValue, 0, this.temp.length);
            this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.destinationValue);
            this.cpu.flags[4] = Util.test_AF_ADD(this.sourceValue2[1], this.destinationValue[1]);
            this.cpu.flags[0] = Util.test_CF_ADD(this.sourceValue2, this.sourceValue, (int)this.iCarryFlag);
            this.cpu.flags[11] = Util.test_OF_ADD(this.sourceValue2, this.sourceValue, this.destinationValue, (int)this.iCarryFlag);
            this.cpu.flags[6] = this.destinationValue[0] == 0 && this.destinationValue[1] == 0;
            this.cpu.flags[7] = this.destinationValue[0] < 0;
            this.cpu.flags[2] = Util.checkParityOfByte(this.destinationValue[1]);
        }
    }
}

