/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_AND_GvEv
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] destinationRegister = new byte[2];

    public Instruction_AND_GvEv() {
    }

    public Instruction_AND_GvEv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.cpu.flags[11] = false;
        this.cpu.flags[0] = false;
        this.cpu.flags[4] = false;
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        if ((this.addressByte >> 6 & 3) == 3) {
            this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        }
        this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        this.destinationRegister[0] = (byte)(this.destinationRegister[0] & this.sourceValue[0]);
        this.destinationRegister[1] = (byte)(this.destinationRegister[1] & this.sourceValue[1]);
        this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
        this.cpu.flags[7] = this.destinationRegister[0] < 0;
        this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
    }
}

