/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_CMP_GvEv
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] destinationValue = new byte[2];
    byte[] tempResult = new byte[2];
    byte[] temp;
    int intermediateResult = 0;

    public Instruction_CMP_GvEv() {
    }

    public Instruction_CMP_GvEv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        if ((this.addressByte >> 6 & 3) == 3) {
            this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        }
        this.destinationValue = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        this.tempResult = Util.subtractWords(this.destinationValue, this.sourceValue, 0);
        this.cpu.flags[4] = Util.test_AF_SUB(this.destinationValue[1], this.tempResult[1]);
        this.cpu.flags[0] = Util.test_CF_SUB(this.destinationValue, this.sourceValue, 0);
        this.cpu.flags[11] = Util.test_OF_SUB(this.destinationValue, this.sourceValue, this.tempResult, 0);
        this.cpu.flags[6] = this.tempResult[0] == 0 && this.tempResult[1] == 0;
        this.cpu.flags[7] = this.tempResult[0] < 0;
        this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult[1]);
    }
}

