/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_DEC_DX
implements Instruction {
    private CPU cpu;
    private byte[] oldDest;
    private byte[] decWord;
    private byte[] temp;

    public Instruction_DEC_DX() {
    }

    public Instruction_DEC_DX(CPU cPU) {
        this.cpu = cPU;
        this.oldDest = new byte[2];
        this.temp = new byte[2];
        this.decWord = new byte[]{0, 1};
    }

    @Override
    public void execute() {
        System.arraycopy(this.cpu.dx, 0, this.oldDest, 0, this.cpu.dx.length);
        this.temp = Util.subtractWords(this.cpu.dx, this.decWord, 0);
        System.arraycopy(this.temp, 0, this.cpu.dx, 0, this.temp.length);
        this.cpu.flags[4] = Util.test_AF_SUB(this.oldDest[1], this.cpu.dx[1]);
        this.cpu.flags[11] = Util.test_OF_SUB(this.oldDest, this.decWord, this.cpu.dx, 0);
        this.cpu.flags[6] = this.cpu.dx[0] == 0 && this.cpu.dx[1] == 0;
        this.cpu.flags[7] = this.cpu.dx[0] < 0;
        this.cpu.flags[2] = Util.checkParityOfByte(this.cpu.dx[1]);
    }
}

