/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.CPUInstructionException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;

public class Instruction_GRP11_MOV_EvIv
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] memoryReferenceLocation = new byte[2];
    byte[] destinationRegister = new byte[2];
    int intermediateResult;
    byte displacement;

    public Instruction_GRP11_MOV_EvIv() {
    }

    public Instruction_GRP11_MOV_EvIv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() throws CPUInstructionException {
        this.addressByte = this.cpu.getByteFromCode();
        if ((this.addressByte & 0x38) >> 3 == 0) {
            if ((this.addressByte >> 6 & 3) == 3) {
                this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                this.destinationRegister = this.cpu.getWordFromCode();
            } else {
                this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.cpu.getWordFromCode());
            }
        } else {
            throw new CPUInstructionException("Group 11 (0xC7) instruction illegal nnn bits.");
        }
    }
}

