/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.CPUInstructionException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;

public class Instruction_GRP6
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] sourceValue2 = new byte[2];
    byte[] oldDest = new byte[2];
    byte[] destinationRegister = new byte[2];
    int intermediateResult = 0;
    int iCarryFlag = 0;
    byte[] tempResult = new byte[2];
    byte[] temp = new byte[2];

    public Instruction_GRP6() {
    }

    public Instruction_GRP6(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() throws CPUInstructionException {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        switch ((this.addressByte & 0x38) >> 3) {
            case 0: {
                throw new CPUInstructionException("Group 6 (0x0F00) instruction SLDT not implemented.");
            }
            case 1: {
                throw new CPUInstructionException("Group 6 (0x0F00) instruction STR not implemented.");
            }
            case 2: {
                throw new CPUInstructionException("Group 6 (0x0F00) instruction LLDT not implemented.");
            }
            case 3: {
                throw new CPUInstructionException("Group 6 (0x0F00) instruction LTR not implemented.");
            }
            case 4: {
                throw new CPUInstructionException("Group 6 (0x0F00) instruction VERR not implemented.");
            }
            case 5: {
                throw new CPUInstructionException("Group 6 (0x0F00) instruction VERW not implemented.");
            }
        }
        throw new CPUInstructionException("Group 6 (0x0F00) instruction no case match.");
    }
}

