/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_SUB_EvGv
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] sourceValue2 = new byte[2];
    byte[] oldSource = new byte[2];
    byte[] destinationRegister = new byte[2];
    byte[] oldDest = new byte[2];
    int intermediateResult;
    byte[] tempResult = new byte[2];
    byte[] temp = new byte[2];

    public Instruction_SUB_EvGv() {
    }

    public Instruction_SUB_EvGv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        System.arraycopy(this.sourceValue, 0, this.oldSource, 0, this.sourceValue.length);
        if ((this.addressByte >> 6 & 3) == 3) {
            this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
            System.arraycopy(this.destinationRegister, 0, this.oldDest, 0, this.destinationRegister.length);
            this.temp = Util.subtractWords(this.destinationRegister, this.sourceValue, 0);
            System.arraycopy(this.temp, 0, this.destinationRegister, 0, this.temp.length);
            this.cpu.flags[4] = Util.test_AF_SUB(this.oldDest[1], this.destinationRegister[1]);
            this.cpu.flags[0] = Util.test_CF_SUB(this.oldDest, this.oldSource, 0);
            this.cpu.flags[11] = Util.test_OF_SUB(this.oldDest, this.oldSource, this.destinationRegister, 0);
            this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
            this.cpu.flags[7] = this.destinationRegister[0] < 0;
            this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.sourceValue2 = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
            this.temp = Util.subtractWords(this.sourceValue2, this.sourceValue, 0);
            System.arraycopy(this.temp, 0, this.tempResult, 0, this.temp.length);
            this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResult);
            this.cpu.flags[4] = Util.test_AF_SUB(this.sourceValue2[1], this.tempResult[1]);
            this.cpu.flags[0] = Util.test_CF_SUB(this.sourceValue2, this.oldSource, 0);
            this.cpu.flags[11] = Util.test_OF_SUB(this.sourceValue2, this.oldSource, this.tempResult, 0);
            this.cpu.flags[6] = this.tempResult[0] == 0 && this.tempResult[1] == 0;
            this.cpu.flags[7] = this.tempResult[0] < 0;
            this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult[1]);
        }
    }
}

