/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ClassFile;
import dioscuri.module.cpu32.ConstantPoolInfo;
import dioscuri.module.cpu32.JavaCodeAnalyser;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class AttributeInfo {
    public abstract void write(DataOutputStream var1) throws IOException;

    public static AttributeInfo construct(DataInputStream dataInputStream, ConstantPoolInfo[] constantPoolInfoArray) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int n2 = constantPoolInfoArray[n].getTag();
        if (n2 == 1) {
            String string = ((ConstantPoolInfo.Utf8Info)constantPoolInfoArray[n]).getBytes();
            if (string.equals("SourceFile")) {
                return new SourceFileAttribute(dataInputStream, n);
            }
            if (string.equals("ConstantValue")) {
                return new ConstantValueAttribute(dataInputStream, n);
            }
            if (string.equals("Code")) {
                return new CodeAttribute(dataInputStream, n, constantPoolInfoArray);
            }
            if (string.equals("StackMapTable")) {
                return new StackMapTableAttribute(dataInputStream, n);
            }
            if (string.equals("Exceptions")) {
                return new ExceptionsAttribute(dataInputStream, n);
            }
            if (string.equals("InnerClasses")) {
                return new InnerClassesAttribute(dataInputStream, n);
            }
            if (string.equals("EnclosingMethod")) {
                return new EnclosingMethodAttribute(dataInputStream, n);
            }
            if (string.equals("Synthetic")) {
                return new SyntheticAttribute(dataInputStream, n);
            }
            if (string.equals("Signature")) {
                return new SignatureAttribute(dataInputStream, n);
            }
            if (string.equals("LineNumberTable")) {
                return new LineNumberTableAttribute(dataInputStream, n);
            }
            if (string.equals("LocalVariableTable")) {
                return new LocalVariableTableAttribute(dataInputStream, n);
            }
            if (string.equals("Deprecated")) {
                return new DeprecatedAttribute(dataInputStream, n);
            }
            return new UnknownAttribute(dataInputStream, n);
        }
        return null;
    }

    static class UnknownAttribute
    extends Attribute {
        int[] bytes;

        UnknownAttribute(DataInputStream dataInputStream, int n) throws IOException {
            super(dataInputStream, n);
            this.bytes = new int[this.attributeLength];
            for (int i = 0; i < this.attributeLength; ++i) {
                this.bytes[i] = dataInputStream.readUnsignedByte();
            }
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            for (int i = 0; i < this.attributeLength; ++i) {
                dataOutputStream.writeByte(this.bytes[i]);
            }
        }
    }

    static class DeprecatedAttribute
    extends Attribute {
        DeprecatedAttribute(DataInputStream dataInputStream, int n) throws IOException {
            super(dataInputStream, n);
        }
    }

    static class LocalVariableTableAttribute
    extends Attribute {
        private int localVariableTableLength;
        private LocalVariableEntry[] localVariableTable;

        LocalVariableTableAttribute(DataInputStream dataInputStream, int n) throws IOException {
            super(dataInputStream, n);
            this.localVariableTableLength = dataInputStream.readUnsignedShort();
            this.localVariableTable = new LocalVariableEntry[this.localVariableTableLength];
            for (int i = 0; i < this.localVariableTableLength; ++i) {
                this.localVariableTable[i] = new LocalVariableEntry(dataInputStream);
            }
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeShort(this.localVariableTableLength);
            for (int i = 0; i < this.localVariableTableLength; ++i) {
                this.localVariableTable[i].write(dataOutputStream);
            }
        }

        public static class LocalVariableEntry {
            private int startPC;
            private int length;
            private int nameIndex;
            private int descriptorIndex;
            private int index;

            LocalVariableEntry(DataInputStream dataInputStream) throws IOException {
                this.startPC = dataInputStream.readUnsignedShort();
                this.length = dataInputStream.readUnsignedShort();
                this.nameIndex = dataInputStream.readUnsignedShort();
                this.descriptorIndex = dataInputStream.readUnsignedShort();
                this.index = dataInputStream.readUnsignedShort();
            }

            public void write(DataOutputStream dataOutputStream) throws IOException {
                dataOutputStream.writeShort(this.startPC);
                dataOutputStream.writeShort(this.length);
                dataOutputStream.writeShort(this.nameIndex);
                dataOutputStream.writeShort(this.descriptorIndex);
                dataOutputStream.writeShort(this.index);
            }
        }
    }

    static class LineNumberTableAttribute
    extends Attribute {
        private int lineNumberTableLength;
        private LineNumberEntry[] lineNumberTable;

        LineNumberTableAttribute(DataInputStream dataInputStream, int n) throws IOException {
            super(dataInputStream, n);
            this.lineNumberTableLength = dataInputStream.readUnsignedShort();
            this.lineNumberTable = new LineNumberEntry[this.lineNumberTableLength];
            for (int i = 0; i < this.lineNumberTableLength; ++i) {
                this.lineNumberTable[i] = new LineNumberEntry(dataInputStream);
            }
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeShort(this.lineNumberTableLength);
            for (int i = 0; i < this.lineNumberTableLength; ++i) {
                this.lineNumberTable[i].write(dataOutputStream);
            }
        }

        public static class LineNumberEntry {
            private int startPC;
            private int lineNumber;

            LineNumberEntry(DataInputStream dataInputStream) throws IOException {
                this.startPC = dataInputStream.readUnsignedShort();
                this.lineNumber = dataInputStream.readUnsignedShort();
            }

            public void write(DataOutputStream dataOutputStream) throws IOException {
                dataOutputStream.writeShort(this.startPC);
                dataOutputStream.writeShort(this.lineNumber);
            }
        }
    }

    static class SourceFileAttribute
    extends Attribute {
        private int sourceFileIndex;

        SourceFileAttribute(DataInputStream dataInputStream, int n) throws IOException {
            super(dataInputStream, n);
            this.sourceFileIndex = dataInputStream.readUnsignedShort();
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeShort(this.sourceFileIndex);
        }
    }

    static class SignatureAttribute
    extends Attribute {
        private int classIndex;

        SignatureAttribute(DataInputStream dataInputStream, int n) throws IOException {
            super(dataInputStream, n);
            this.classIndex = dataInputStream.readUnsignedShort();
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeShort(this.classIndex);
        }
    }

    static class SyntheticAttribute
    extends Attribute {
        SyntheticAttribute(DataInputStream dataInputStream, int n) throws IOException {
            super(dataInputStream, n);
        }
    }

    static class EnclosingMethodAttribute
    extends Attribute {
        private int classIndex;
        private int methodIndex;

        EnclosingMethodAttribute(DataInputStream dataInputStream, int n) throws IOException {
            super(dataInputStream, n);
            this.classIndex = dataInputStream.readUnsignedShort();
            this.methodIndex = dataInputStream.readUnsignedShort();
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeShort(this.classIndex);
            dataOutputStream.writeShort(this.methodIndex);
        }
    }

    static class InnerClassesAttribute
    extends Attribute {
        private int numberOfClasses;
        private ClassEntry[] classes;

        InnerClassesAttribute(DataInputStream dataInputStream, int n) throws IOException {
            super(dataInputStream, n);
            this.numberOfClasses = dataInputStream.readUnsignedShort();
            this.classes = new ClassEntry[this.numberOfClasses];
            for (int i = 0; i < this.numberOfClasses; ++i) {
                this.classes[i] = new ClassEntry(dataInputStream);
            }
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeShort(this.numberOfClasses);
            for (int i = 0; i < this.numberOfClasses; ++i) {
                this.classes[i].write(dataOutputStream);
            }
        }

        public static class ClassEntry {
            private int innnerClassInfoIndex;
            private int outerClassInfoIndex;
            private int innnerNameIndex;
            private int innnerClassAccessFlags;
            public static final int PUBLIC = 1;
            public static final int PRIVATE = 2;
            public static final int PROTECTED = 4;
            public static final int STATIC = 8;
            public static final int FINAL = 16;
            public static final int INTERFACE = 512;
            public static final int ABSTRACT = 1024;
            public static final int SYNTHETIC = 4096;
            public static final int ANNOTATION = 8192;
            public static final int ENUM = 16384;

            ClassEntry(DataInputStream dataInputStream) throws IOException {
                this.innnerClassInfoIndex = dataInputStream.readUnsignedShort();
                this.outerClassInfoIndex = dataInputStream.readUnsignedShort();
                this.innnerNameIndex = dataInputStream.readUnsignedShort();
                this.innnerClassAccessFlags = dataInputStream.readUnsignedShort();
            }

            void write(DataOutputStream dataOutputStream) throws IOException {
                dataOutputStream.writeShort(this.innnerClassInfoIndex);
                dataOutputStream.writeShort(this.outerClassInfoIndex);
                dataOutputStream.writeShort(this.innnerNameIndex);
                dataOutputStream.writeShort(this.innnerClassAccessFlags);
            }
        }
    }

    static class ExceptionsAttribute
    extends Attribute {
        private int numberOfExceptions;
        private int[] exceptionIndexTable;

        ExceptionsAttribute(DataInputStream dataInputStream, int n) throws IOException {
            super(dataInputStream, n);
            this.numberOfExceptions = dataInputStream.readUnsignedShort();
            this.exceptionIndexTable = new int[this.numberOfExceptions];
            for (int i = 0; i < this.numberOfExceptions; ++i) {
                this.exceptionIndexTable[i] = dataInputStream.readUnsignedShort();
            }
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeShort(this.numberOfExceptions);
            for (int i = 0; i < this.numberOfExceptions; ++i) {
                dataOutputStream.writeShort(this.exceptionIndexTable[i]);
            }
        }
    }

    static class StackMapTableAttribute
    extends Attribute {
        private int numberOfEntries;
        private StackMapFrame[] entries;

        StackMapTableAttribute(DataInputStream dataInputStream, int n) throws IOException {
            super(dataInputStream, n);
            this.numberOfEntries = dataInputStream.readUnsignedShort();
            this.entries = new StackMapFrame[this.numberOfEntries];
            for (int i = 0; i < this.numberOfEntries; ++i) {
                this.entries[i] = StackMapFrame.construct(dataInputStream);
            }
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeInt(this.numberOfEntries);
            for (int i = 0; i < this.numberOfEntries; ++i) {
                this.entries[i].write(dataOutputStream);
            }
        }

        public static abstract class StackMapFrame {
            protected int frameType;
            public static final int SAME_L = 0;
            public static final int SAME_H = 63;
            public static final int SAME_LOCALS_1_STACK_ITEM_L = 64;
            public static final int SAME_LOCALS_1_STACK_ITEM_H = 127;
            public static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
            public static final int CHOP_L = 248;
            public static final int CHOP_H = 250;
            public static final int SAME_FRAME_EXTENDED = 251;
            public static final int APPEND_L = 252;
            public static final int APPEND_H = 254;
            public static final int FULL_FRAME = 255;

            abstract void write(DataOutputStream var1) throws IOException;

            static StackMapFrame construct(DataInputStream dataInputStream) throws IOException {
                int n = dataInputStream.readUnsignedByte();
                if (n >= 0 && n <= 63) {
                    return new SameFrame(dataInputStream, n);
                }
                if (n >= 64 && n <= 127) {
                    return new SameLocals1StackItemFrame(dataInputStream, n);
                }
                if (n == 247) {
                    return new SameLocals1StackItemFrameExtended(dataInputStream, n);
                }
                if (n >= 248 && n <= 250) {
                    return new ChopFrame(dataInputStream, n);
                }
                if (n == 251) {
                    return new SameFrameExtended(dataInputStream, n);
                }
                if (n >= 252 && n <= 254) {
                    return new AppendFrame(dataInputStream, n);
                }
                if (n == 255) {
                    return new FullFrame(dataInputStream, n);
                }
                return null;
            }

            public int getFrameType() {
                return this.frameType;
            }

            public static abstract class VerificationTypeInfo {
                protected int tag;
                public static final int TOP = 0;
                public static final int INTEGER = 1;
                public static final int FLOAT = 2;
                public static final int LONG = 4;
                public static final int DOUBLE = 3;
                public static final int NULL = 5;
                public static final int UNINITIALIZEDTHIS = 6;
                public static final int OBJECT = 7;
                public static final int UNINITIALIZED = 8;

                static VerificationTypeInfo construct(DataInputStream dataInputStream) throws IOException {
                    int n = dataInputStream.readUnsignedByte();
                    switch (n) {
                        case 0: {
                            return new TopVariableInfo(n);
                        }
                        case 1: {
                            return new IntegerVariableInfo(n);
                        }
                        case 2: {
                            return new FloatVariableInfo(n);
                        }
                        case 4: {
                            return new LongVariableInfo(n);
                        }
                        case 3: {
                            return new DoubleVariableInfo(n);
                        }
                        case 5: {
                            return new NullVariableInfo(n);
                        }
                        case 6: {
                            return new UninitializedThisVariableInfo(n);
                        }
                        case 7: {
                            return new ObjectVariableInfo(dataInputStream, n);
                        }
                        case 8: {
                            return new UninitializedVariableInfo(dataInputStream, n);
                        }
                    }
                    return null;
                }

                public int getTag() {
                    return this.tag;
                }

                public void write(DataOutputStream dataOutputStream) throws IOException {
                    dataOutputStream.writeByte(this.tag);
                }

                public static class UninitializedVariableInfo
                extends VerificationTypeInfo {
                    private int offset;

                    UninitializedVariableInfo(DataInputStream dataInputStream, int n) throws IOException {
                        this.tag = n;
                        this.offset = dataInputStream.readUnsignedShort();
                    }

                    @Override
                    public void write(DataOutputStream dataOutputStream) throws IOException {
                        dataOutputStream.writeByte(this.tag);
                        dataOutputStream.writeShort(this.offset);
                    }
                }

                public static class ObjectVariableInfo
                extends VerificationTypeInfo {
                    private int cpoolIndex;

                    ObjectVariableInfo(DataInputStream dataInputStream, int n) throws IOException {
                        this.tag = n;
                        this.cpoolIndex = dataInputStream.readUnsignedShort();
                    }

                    @Override
                    public void write(DataOutputStream dataOutputStream) throws IOException {
                        dataOutputStream.writeByte(this.tag);
                        dataOutputStream.writeShort(this.cpoolIndex);
                    }
                }

                public static class UninitializedThisVariableInfo
                extends TopVariableInfo {
                    UninitializedThisVariableInfo(int n) throws IOException {
                        super(n);
                    }
                }

                public static class NullVariableInfo
                extends TopVariableInfo {
                    NullVariableInfo(int n) throws IOException {
                        super(n);
                    }
                }

                public static class DoubleVariableInfo
                extends TopVariableInfo {
                    DoubleVariableInfo(int n) throws IOException {
                        super(n);
                    }
                }

                public static class LongVariableInfo
                extends TopVariableInfo {
                    LongVariableInfo(int n) throws IOException {
                        super(n);
                    }
                }

                public static class FloatVariableInfo
                extends TopVariableInfo {
                    FloatVariableInfo(int n) throws IOException {
                        super(n);
                    }
                }

                public static class IntegerVariableInfo
                extends TopVariableInfo {
                    IntegerVariableInfo(int n) throws IOException {
                        super(n);
                    }
                }

                public static class TopVariableInfo
                extends VerificationTypeInfo {
                    TopVariableInfo(int n) throws IOException {
                        this.tag = n;
                    }
                }
            }

            public static class FullFrame
            extends StackMapFrame {
                private int offsetDelta;
                private int numberOfLocals;
                private VerificationTypeInfo[] locals;
                private int numberOfStackItems;
                private VerificationTypeInfo[] stack;

                FullFrame(DataInputStream dataInputStream, int n) throws IOException {
                    int n2;
                    this.frameType = n;
                    this.offsetDelta = dataInputStream.readUnsignedShort();
                    this.numberOfLocals = dataInputStream.readUnsignedShort();
                    this.locals = new VerificationTypeInfo[this.numberOfLocals];
                    for (n2 = 0; n2 < this.numberOfLocals; ++n2) {
                        this.locals[n2] = VerificationTypeInfo.construct(dataInputStream);
                    }
                    this.numberOfStackItems = dataInputStream.readUnsignedShort();
                    this.stack = new VerificationTypeInfo[this.numberOfStackItems];
                    for (n2 = 0; n2 < this.numberOfStackItems; ++n2) {
                        this.stack[n2] = VerificationTypeInfo.construct(dataInputStream);
                    }
                }

                @Override
                void write(DataOutputStream dataOutputStream) throws IOException {
                    int n;
                    dataOutputStream.writeByte(this.frameType);
                    dataOutputStream.writeShort(this.offsetDelta);
                    dataOutputStream.writeShort(this.numberOfLocals);
                    for (n = 0; n < this.numberOfLocals; ++n) {
                        this.locals[n].write(dataOutputStream);
                    }
                    dataOutputStream.writeShort(this.numberOfStackItems);
                    for (n = 0; n < this.numberOfStackItems; ++n) {
                        this.stack[n].write(dataOutputStream);
                    }
                }
            }

            public static class AppendFrame
            extends StackMapFrame {
                private int offsetDelta;
                private VerificationTypeInfo[] locals;

                AppendFrame(DataInputStream dataInputStream, int n) throws IOException {
                    this.frameType = n;
                    this.offsetDelta = dataInputStream.readUnsignedShort();
                    this.locals = new VerificationTypeInfo[this.frameType - 251];
                    for (int i = 0; i < this.locals.length; ++i) {
                        this.locals[i] = VerificationTypeInfo.construct(dataInputStream);
                    }
                }

                @Override
                void write(DataOutputStream dataOutputStream) throws IOException {
                    dataOutputStream.writeByte(this.frameType);
                    dataOutputStream.writeShort(this.offsetDelta);
                    for (int i = 0; i < this.locals.length; ++i) {
                        this.locals[i].write(dataOutputStream);
                    }
                }
            }

            public static class SameFrameExtended
            extends ChopFrame {
                SameFrameExtended(DataInputStream dataInputStream, int n) throws IOException {
                    super(dataInputStream, n);
                }
            }

            public static class ChopFrame
            extends StackMapFrame {
                private int offsetDelta;

                ChopFrame(DataInputStream dataInputStream, int n) throws IOException {
                    this.frameType = n;
                    this.offsetDelta = dataInputStream.readUnsignedShort();
                }

                @Override
                void write(DataOutputStream dataOutputStream) throws IOException {
                    dataOutputStream.writeByte(this.frameType);
                    dataOutputStream.writeShort(this.offsetDelta);
                }
            }

            public static class SameLocals1StackItemFrameExtended
            extends StackMapFrame {
                private int offsetDelta;
                private VerificationTypeInfo[] stack;

                SameLocals1StackItemFrameExtended(DataInputStream dataInputStream, int n) throws IOException {
                    this.frameType = n;
                    this.offsetDelta = dataInputStream.readUnsignedShort();
                    this.stack = new VerificationTypeInfo[1];
                    this.stack[0] = VerificationTypeInfo.construct(dataInputStream);
                }

                @Override
                void write(DataOutputStream dataOutputStream) throws IOException {
                    dataOutputStream.writeByte(this.frameType);
                    dataOutputStream.writeShort(this.offsetDelta);
                    this.stack[0].write(dataOutputStream);
                }
            }

            public static class SameLocals1StackItemFrame
            extends StackMapFrame {
                private VerificationTypeInfo[] stack;

                SameLocals1StackItemFrame(DataInputStream dataInputStream, int n) throws IOException {
                    this.frameType = n;
                    this.stack = new VerificationTypeInfo[1];
                    this.stack[0] = VerificationTypeInfo.construct(dataInputStream);
                }

                @Override
                void write(DataOutputStream dataOutputStream) throws IOException {
                    dataOutputStream.writeByte(this.frameType);
                    this.stack[0].write(dataOutputStream);
                }
            }

            public static class SameFrame
            extends StackMapFrame {
                SameFrame(DataInputStream dataInputStream, int n) throws IOException {
                    this.frameType = n;
                }

                @Override
                void write(DataOutputStream dataOutputStream) throws IOException {
                    dataOutputStream.writeByte(this.frameType);
                }
            }
        }
    }

    static class CodeAttribute
    extends Attribute {
        private int maxStack;
        private int maxLocals;
        private int codeLength;
        private int[] code;
        private int exceptionTableLength;
        private ExceptionEntry[] exceptionTable;
        private int attributesCount;
        private AttributeInfo[] attributes;

        CodeAttribute(DataInputStream dataInputStream, int n, ConstantPoolInfo[] constantPoolInfoArray) throws IOException {
            super(dataInputStream, n);
            int n2;
            this.maxStack = dataInputStream.readUnsignedShort();
            this.maxLocals = dataInputStream.readUnsignedShort();
            this.codeLength = dataInputStream.readInt();
            this.code = new int[this.codeLength];
            for (n2 = 0; n2 < this.codeLength; ++n2) {
                this.code[n2] = dataInputStream.readUnsignedByte();
            }
            this.exceptionTableLength = dataInputStream.readUnsignedShort();
            this.exceptionTable = new ExceptionEntry[this.exceptionTableLength];
            for (n2 = 0; n2 < this.exceptionTableLength; ++n2) {
                this.exceptionTable[n2] = new ExceptionEntry(dataInputStream);
            }
            this.attributesCount = dataInputStream.readUnsignedShort();
            this.attributes = new AttributeInfo[this.attributesCount];
            for (n2 = 0; n2 < this.attributesCount; ++n2) {
                this.attributes[n2] = AttributeInfo.construct(dataInputStream, constantPoolInfoArray);
            }
        }

        public int getMaxStack() {
            return this.maxStack;
        }

        public int getMaxLocals() {
            return this.maxLocals;
        }

        public int[] getCode() {
            int[] nArray = new int[this.code.length];
            System.arraycopy(this.code, 0, nArray, 0, nArray.length);
            return nArray;
        }

        public void setCode(int[] nArray, ClassFile classFile, int n) {
            this.setCode(nArray, nArray.length, classFile, n);
        }

        public void setCode(int[] nArray, int n, ClassFile classFile, int n2) {
            this.code = new int[n];
            System.arraycopy(nArray, 0, this.code, 0, this.code.length);
            this.attributeLength += n - this.codeLength;
            this.codeLength = n;
            this.maxStack = JavaCodeAnalyser.getMaxStackDepth(this.code, 0, classFile);
            this.maxLocals = Math.max(JavaCodeAnalyser.getMaxLocalVariables(this.code), n2 + 1);
        }

        public ExceptionEntry[] getExceptionTable() {
            ExceptionEntry[] exceptionEntryArray = new ExceptionEntry[this.exceptionTable.length];
            System.arraycopy(this.exceptionTable, 0, exceptionEntryArray, 0, exceptionEntryArray.length);
            return exceptionEntryArray;
        }

        public void setExceptionTable(ExceptionEntry[] exceptionEntryArray, ClassFile classFile) {
            this.setExceptionTable(exceptionEntryArray, exceptionEntryArray.length, classFile);
        }

        public void setExceptionTable(ExceptionEntry[] exceptionEntryArray, int n, ClassFile classFile) {
            for (int i = 0; i < n; ++i) {
                ExceptionEntry exceptionEntry = exceptionEntryArray[i];
                if (exceptionEntry.handlerPC >= this.code.length) continue;
                this.maxStack = Math.max(this.maxStack, JavaCodeAnalyser.getMaxStackDepth(this.code, exceptionEntry.handlerPC, classFile) + 1);
            }
            this.exceptionTable = new ExceptionEntry[n];
            System.arraycopy(exceptionEntryArray, 0, this.exceptionTable, 0, this.exceptionTable.length);
            this.attributeLength += 8 * (n - this.exceptionTableLength);
            this.exceptionTableLength = n;
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            int n;
            super.write(dataOutputStream);
            dataOutputStream.writeShort(this.maxStack);
            dataOutputStream.writeShort(this.maxLocals);
            dataOutputStream.writeInt(this.codeLength);
            for (n = 0; n < this.codeLength; ++n) {
                dataOutputStream.writeByte(this.code[n]);
            }
            dataOutputStream.writeShort(this.exceptionTableLength);
            for (n = 0; n < this.exceptionTableLength; ++n) {
                this.exceptionTable[n].write(dataOutputStream);
            }
            dataOutputStream.writeShort(this.attributesCount);
            for (n = 0; n < this.attributesCount; ++n) {
                this.attributes[n].write(dataOutputStream);
            }
        }

        public static class ExceptionEntry {
            private final int startPC;
            private final int endPC;
            private final int handlerPC;
            private final int catchType;

            public ExceptionEntry(int n, int n2, int n3, int n4) {
                this.startPC = n;
                this.endPC = n2;
                this.handlerPC = n3;
                this.catchType = n4;
            }

            ExceptionEntry(DataInputStream dataInputStream) throws IOException {
                this.startPC = dataInputStream.readUnsignedShort();
                this.endPC = dataInputStream.readUnsignedShort();
                this.handlerPC = dataInputStream.readUnsignedShort();
                this.catchType = dataInputStream.readUnsignedShort();
            }

            void write(DataOutputStream dataOutputStream) throws IOException {
                dataOutputStream.writeShort(this.startPC);
                dataOutputStream.writeShort(this.endPC);
                dataOutputStream.writeShort(this.handlerPC);
                dataOutputStream.writeShort(this.catchType);
            }
        }
    }

    static class ConstantValueAttribute
    extends Attribute {
        private int constantValueIndex;

        ConstantValueAttribute(DataInputStream dataInputStream, int n) throws IOException {
            super(dataInputStream, n);
            this.constantValueIndex = dataInputStream.readUnsignedShort();
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeShort(this.constantValueIndex);
        }
    }

    static abstract class Attribute
    extends AttributeInfo {
        protected int attributeNameIndex;
        protected int attributeLength;

        Attribute(DataInputStream dataInputStream, int n) throws IOException {
            this.attributeNameIndex = n;
            this.attributeLength = dataInputStream.readInt();
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.attributeNameIndex);
            dataOutputStream.writeInt(this.attributeLength);
        }
    }
}

