/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ClassFile;
import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.ProtectedModeSkeletonBlock;
import dioscuri.module.cpu32.RealModeSkeletonBlock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class ClassFileBuilder {
    private static final int CLASSES_PER_LOADER = 10;
    private static final InputStream realModeSkeleton = ClassFileBuilder.loadSkeletonClass(RealModeSkeletonBlock.class);
    private static final InputStream protectedModeSkeleton = ClassFileBuilder.loadSkeletonClass(ProtectedModeSkeletonBlock.class);
    private static CustomClassLoader currentClassLoader;

    private static InputStream loadSkeletonClass(Class<?> clazz) {
        byte[] byArray = null;
        String string = clazz.getName().replace('.', '/') + ".class";
        try {
            int n;
            ClassLoader classLoader = ClassFileBuilder.class.getClassLoader();
            if (classLoader == null) {
                System.err.println("ClassFileBuilder failed to get the classloader.");
            }
            InputStream inputStream = classLoader.getResourceAsStream(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write((byte)n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            System.out.println("Exception reading in skeleton class " + clazz + " into ClassFileBuilder: " + exception);
        }
        return new ByteArrayInputStream(byArray);
    }

    private ClassFileBuilder() {
    }

    public static ClassFile createNewRealModeSkeletonClass() {
        ClassFile classFile = new ClassFile();
        try {
            realModeSkeleton.reset();
            DataInputStream dataInputStream = new DataInputStream(realModeSkeleton);
            classFile.read(dataInputStream);
        }
        catch (IOException iOException) {
            System.out.println("read error: " + iOException);
        }
        return classFile;
    }

    public static ClassFile createNewProtectedModeSkeletonClass() {
        ClassFile classFile = new ClassFile();
        try {
            protectedModeSkeleton.reset();
            DataInputStream dataInputStream = new DataInputStream(protectedModeSkeleton);
            classFile.read(dataInputStream);
        }
        catch (IOException iOException) {
            System.out.println("read error: " + iOException);
        }
        return classFile;
    }

    public static CodeBlock instantiateClass(ClassFile classFile) {
        classFile.update();
        String string = classFile.getClassName();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            classFile.write(new DataOutputStream(byteArrayOutputStream));
        }
        catch (IOException iOException) {
            System.out.println("write error: " + iOException);
        }
        catch (Exception exception) {
            System.out.println("cb ic error: " + exception);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Class<?> clazz = currentClassLoader.createClass(string, byArray, 0, byArray.length);
        CodeBlock codeBlock = null;
        try {
            codeBlock = (CodeBlock)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Could not instantiate class", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Could not instantiate class", illegalAccessException);
        }
        return codeBlock;
    }

    private static void newClassLoader() {
        currentClassLoader = new CustomClassLoader();
    }

    static {
        ClassFileBuilder.newClassLoader();
    }

    static class CustomClassLoader
    extends ClassLoader {
        private Hashtable<String, Class<?>> classes = new Hashtable();
        private int classesCount;

        public CustomClassLoader() {
            super(ClassFileBuilder.class.getClassLoader());
        }

        public Class<?> createClass(String string, byte[] byArray, int n, int n2) {
            if (++this.classesCount == 10) {
                ClassFileBuilder.newClassLoader();
            }
            Class<?> clazz = this.defineClass(string, byArray, n, n2);
            this.classes.put(string, clazz);
            return clazz;
        }

        @Override
        public Class<?> findClass(String string) throws ClassNotFoundException {
            Class<?> clazz = this.classes.get(string);
            if (clazz != null) {
                return clazz;
            }
            throw new ClassNotFoundException(string);
        }
    }
}

