/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ConstantPoolSymbol;
import dioscuri.module.cpu32.FASTCompiler;
import dioscuri.module.cpu32.JavaOpcode;
import dioscuri.module.cpu32.MicrocodeSet;
import dioscuri.module.cpu32.ProcessorException;
import dioscuri.module.cpu32.ProtectedModeBytecodeFragments;
import dioscuri.module.cpu32.UCodeStaticMethods;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UCodeMethodParser
implements MicrocodeSet {
    private Object[][][] operations;
    private int[][][] operandArray;
    private boolean[][] externalEffectsArray;
    private boolean[][] explicitThrowArray;
    private static Hashtable<String, Integer> microcodeIndex;
    private static Hashtable<String, Integer> elementIndex;
    private static Hashtable<String, Integer> opcodeIndex;
    private static Hashtable<String, Object> constantPoolIndex;

    public UCodeMethodParser(Object[][][] objectArray, int[][][] nArray, boolean[][] blArray, boolean[][] blArray2) {
        this.operations = objectArray;
        this.operandArray = nArray;
        this.externalEffectsArray = blArray;
        this.explicitThrowArray = blArray2;
    }

    private void syntaxError(String string) {
        throw new IllegalStateException(string);
    }

    private void printFragmentArrays() {
        for (int i = 0; i < 753; ++i) {
            for (int j = 0; j < 46; ++j) {
                int n;
                if (this.operations[i][j] != null) {
                    for (n = 0; n < this.operations[i][j].length; ++n) {
                        System.out.println("operations " + i + "," + j + ":" + this.operations[i][j][n]);
                    }
                    System.out.println("exef " + this.externalEffectsArray[i][j]);
                    System.out.println("excp " + this.explicitThrowArray[i][j]);
                }
                if (this.operandArray[i][j] == null) continue;
                for (n = 0; n < this.operandArray[i][j].length; ++n) {
                    System.out.println("operandArray " + i + "," + j + ":" + this.operandArray[i][j][n]);
                }
            }
        }
    }

    private void printIndexs() {
        System.out.println();
        System.out.println("microcodeIndex");
        Enumeration<String> enumeration = microcodeIndex.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
        System.out.println();
        System.out.println("elementIndex");
        enumeration = elementIndex.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
        System.out.println();
        System.out.println("opcodeIndex");
        enumeration = opcodeIndex.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
        System.out.println();
        System.out.println("constantPoolIndex");
        enumeration = constantPoolIndex.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
        System.out.println();
    }

    private void insertIntoFragmentArrays(String string, String string2, String[] stringArray, boolean bl, boolean bl2, Vector<Integer> vector) {
        try {
            Integer n;
            int n2;
            Integer n3 = microcodeIndex.get(string);
            if (n3 == null) {
                this.syntaxError("Unknown microcode " + string);
            }
            if (this.operations[n2 = n3.intValue()] == null) {
                this.operations[n2] = new Object[46][];
            }
            if (this.operandArray[n2] == null) {
                this.operandArray[n2] = new int[46][];
            }
            if ((n = elementIndex.get(string2)) == null) {
                this.syntaxError("Unknown PROCESSOR_ELEMENT " + string2);
            }
            int n4 = n;
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = elementIndex.get(stringArray[i]);
            }
            this.operandArray[n2][n4] = nArray;
            this.operations[n2][n4] = vector.toArray();
            this.externalEffectsArray[n2][n4] = bl;
            this.explicitThrowArray[n2][n4] = bl2;
        }
        catch (Exception exception) {
            System.out.println("Warning: exception loading uCode fragments");
            System.out.print("Fragment: " + string2 + " " + string + " ");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.print(stringArray[i] + " ");
            }
            System.out.println();
            exception.printStackTrace();
        }
    }

    private void parseMethod(Method method) {
        String[] stringArray;
        int n;
        String string = method.getName();
        int n2 = 0;
        String string2 = null;
        n2 = string.indexOf(95);
        string2 = string.substring(0, n2).toUpperCase();
        int n3 = ++n2;
        boolean bl = false;
        n2 = string.indexOf(95, n3);
        if (string.substring(n3, n2).equals("hef")) {
            bl = true;
        }
        n3 = ++n2;
        boolean bl2 = false;
        Class<?>[] classArray = method.getExceptionTypes();
        for (n = 0; n < classArray.length; ++n) {
            if (classArray[n] != ProcessorException.class) continue;
            bl2 = true;
            break;
        }
        n = method.getParameterTypes().length;
        String[] stringArray2 = new String[n];
        int n4 = string.length();
        for (int i = n - 1; i >= 0; --i) {
            n2 = string.lastIndexOf(95, n4 - 1);
            stringArray2[i] = string.substring(n2 + 1, n4).toUpperCase();
            n4 = n2;
        }
        String string3 = string.substring(n3, n4);
        Vector<Integer> vector = new Vector<Integer>();
        int n5 = n;
        for (int i = 0; i < n; ++i) {
            if (!constantPoolIndex.containsKey(stringArray2[i])) continue;
            vector.add(new Integer(18));
            vector.add((Integer)constantPoolIndex.get(stringArray2[i]));
            stringArray2[i] = null;
            --n5;
        }
        vector.add(new Integer(184));
        vector.add((Integer)constantPoolIndex.get(string));
        if (string2.equals("EXECUTECOUNT")) {
            vector.add(new Integer(21));
            vector.add(new Integer(10));
            vector.add(new Integer(96));
            vector.add(new Integer(54));
            vector.add(new Integer(10));
        }
        if (n5 < n) {
            stringArray = new String[n5];
            int n6 = 0;
            for (int i = 0; i < n; ++i) {
                if (stringArray2[i] == null) continue;
                stringArray[n6++] = stringArray2[i];
            }
        } else {
            stringArray = stringArray2;
        }
        this.insertIntoFragmentArrays(string3, string2, stringArray, bl, bl2, vector);
    }

    public int parse() {
        Method[] methodArray = UCodeStaticMethods.class.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (Modifier.isPrivate(methodArray[i].getModifiers())) continue;
            this.parseMethod(methodArray[i]);
        }
        return methodArray.length;
    }

    public static void main(String[] stringArray) {
        UCodeMethodParser uCodeMethodParser = new UCodeMethodParser(new Object[753][46][], new int[753][46][], new boolean[753][46], new boolean[753][46]);
        uCodeMethodParser.printIndexs();
        System.out.println(uCodeMethodParser.parse());
        uCodeMethodParser.printFragmentArrays();
    }

    static {
        int n;
        int n2;
        AccessibleObject[] accessibleObjectArray;
        microcodeIndex = new Hashtable();
        elementIndex = new Hashtable();
        opcodeIndex = new Hashtable();
        constantPoolIndex = new Hashtable();
        try {
            accessibleObjectArray = MicrocodeSet.class.getDeclaredFields();
            for (n2 = 0; n2 < accessibleObjectArray.length; ++n2) {
                n = accessibleObjectArray[n2].getModifiers();
                if (!Modifier.isStatic(n) || !Modifier.isPublic(n) || !Modifier.isFinal(n)) continue;
                microcodeIndex.put(accessibleObjectArray[n2].getName(), new Integer(accessibleObjectArray[n2].getInt(null)));
            }
        }
        catch (Throwable throwable) {
            System.out.println("Warning: microcode lookup table not completed");
            throwable.printStackTrace();
        }
        try {
            accessibleObjectArray = FASTCompiler.class.getDeclaredFields();
            for (n2 = 0; n2 < accessibleObjectArray.length; ++n2) {
                String string;
                int n3;
                n = accessibleObjectArray[n2].getModifiers();
                if (!Modifier.isStatic(n) || !Modifier.isFinal(n) || Modifier.isPrivate(n) || (n3 = accessibleObjectArray[n2].getInt(null)) < 0 || n3 >= 46 || !(string = ((Field)accessibleObjectArray[n2]).getName()).startsWith("PROCESSOR_ELEMENT_")) continue;
                string = string.substring("PROCESSOR_ELEMENT_".length());
                elementIndex.put(string, new Integer(n3));
            }
        }
        catch (Throwable throwable) {
            System.out.println("Warning: element lookup table not completed");
            throwable.printStackTrace();
        }
        try {
            accessibleObjectArray = JavaOpcode.class.getDeclaredFields();
            for (n2 = 0; n2 < accessibleObjectArray.length; ++n2) {
                n = accessibleObjectArray[n2].getModifiers();
                if (!Modifier.isStatic(n) || !Modifier.isPublic(n) || !Modifier.isFinal(n) || ((Field)accessibleObjectArray[n2]).getType() != Integer.TYPE) continue;
                opcodeIndex.put(((Field)accessibleObjectArray[n2]).getName(), new Integer(((Field)accessibleObjectArray[n2]).getInt(null)));
            }
        }
        catch (Throwable throwable) {
            System.out.println("Warning: opcode lookup table not completed");
            throwable.printStackTrace();
        }
        try {
            constantPoolIndex.put("IMMEDIATE", ProtectedModeBytecodeFragments.IMMEDIATE);
            constantPoolIndex.put("X86LENGTH", ProtectedModeBytecodeFragments.X86LENGTH);
            accessibleObjectArray = UCodeStaticMethods.class.getDeclaredMethods();
            for (n2 = 0; n2 < accessibleObjectArray.length; ++n2) {
                constantPoolIndex.put(((Method)accessibleObjectArray[n2]).getName(), new ConstantPoolSymbol(accessibleObjectArray[n2]));
            }
        }
        catch (Throwable throwable) {
            System.out.println("Warning: constant pool lookup table not completed");
            throwable.printStackTrace();
        }
    }
}

