/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.virtual.swing;

import gnu.awt.virtual.VirtualToolkit;
import gnu.awt.virtual.swing.VirtualDesktop;
import java.awt.Toolkit;
import java.io.PrintStream;
import java.lang.reflect.Method;
import javax.swing.JFrame;

public class ToolkitJFrame
extends JFrame {
    public static VirtualToolkit defaultToolkit;
    static Object log;
    static Method logmethod;
    private Toolkit toolkit;

    private void logDebug(String msg) {
        try {
            if (log == null) {
                try {
                    Class<?> c = Class.forName("org.apache.log4j.Category");
                    if (c == null) {
                        throw new ClassNotFoundException();
                    }
                    log = c.getMethod("getInstance", String.class).invoke(null, ToolkitJFrame.class.getName());
                    logmethod = c.getMethod("debug", Object.class);
                }
                catch (ClassNotFoundException x) {
                    log = System.err;
                    logmethod = PrintStream.class.getMethod("println", String.class);
                }
            }
            logmethod.invoke(log, msg);
        }
        catch (Exception x) {
            x.printStackTrace();
            System.err.println(msg);
        }
    }

    public ToolkitJFrame(String name) {
        super(name);
        if (defaultToolkit != null) {
            this.toolkit = defaultToolkit;
            defaultToolkit = null;
        } else {
            this.toolkit = new VirtualDesktop(name, 10000, 10000);
        }
    }

    public ToolkitJFrame() {
        this((String)null);
    }

    @Override
    public Toolkit getToolkit() {
        if (this.toolkit == null) {
            this.toolkit = defaultToolkit;
        }
        if (this.toolkit == null) {
            this.toolkit = new VirtualToolkit();
        }
        return this.toolkit;
    }
}

