/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.virtual.swing;

import gnu.awt.virtual.VirtualToolkit;
import gnu.awt.virtual.swing.SwingButtonPeer;
import gnu.awt.virtual.swing.SwingCanvasPeer;
import gnu.awt.virtual.swing.SwingCheckboxMenuItemPeer;
import gnu.awt.virtual.swing.SwingCheckboxPeer;
import gnu.awt.virtual.swing.SwingChoicePeer;
import gnu.awt.virtual.swing.SwingDialogPeer;
import gnu.awt.virtual.swing.SwingFramePeer;
import gnu.awt.virtual.swing.SwingLabelPeer;
import gnu.awt.virtual.swing.SwingListPeer;
import gnu.awt.virtual.swing.SwingMenuBarPeer;
import gnu.awt.virtual.swing.SwingMenuItemPeer;
import gnu.awt.virtual.swing.SwingMenuPeer;
import gnu.awt.virtual.swing.SwingPanelPeer;
import gnu.awt.virtual.swing.SwingPopupMenuPeer;
import gnu.awt.virtual.swing.SwingScrollPanePeer;
import gnu.awt.virtual.swing.SwingScrollbarPeer;
import gnu.awt.virtual.swing.SwingTextAreaPeer;
import gnu.awt.virtual.swing.SwingTextFieldPeer;
import gnu.awt.virtual.swing.SwingWindowPeer;
import gnu.awt.virtual.swing.VirtualJFrame;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.image.DirectColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import javax.swing.JDesktopPane;

public class VirtualDesktop
extends VirtualToolkit {
    protected VirtualJFrame desktopFrame = null;
    protected JDesktopPane desktop = null;
    private boolean initialized = false;

    public VirtualDesktop(DirectColorModel colorModel, String title, int width, int height) {
        super(colorModel, width, height);
        this.init(title);
    }

    public VirtualDesktop(int bitsPerPixel, int rMask, int gMask, int bMask, String title, int width, int height) {
        super(bitsPerPixel, rMask, gMask, bMask, width, height);
        this.init(title);
    }

    public VirtualDesktop(String title, int width, int height) {
        super(width, height);
        this.init(title);
    }

    public void show() {
        this.desktopFrame.show();
    }

    public void dispose() {
        this.desktopFrame.dispose();
    }

    @Override
    public ButtonPeer createButton(Button target) {
        return new SwingButtonPeer(target);
    }

    @Override
    public CanvasPeer createCanvas(Canvas target) {
        return new SwingCanvasPeer(target);
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox target) {
        return new SwingCheckboxPeer(target);
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem target) {
        return new SwingCheckboxMenuItemPeer(target);
    }

    @Override
    public ChoicePeer createChoice(Choice target) {
        return new SwingChoicePeer(target);
    }

    @Override
    public LightweightPeer createComponent(Component target) {
        return super.createComponent(target);
    }

    @Override
    public DialogPeer createDialog(Dialog target) {
        return new SwingDialogPeer(target);
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dge) {
        return null;
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog target) {
        return null;
    }

    @Override
    public FramePeer createFrame(Frame target) {
        if (!this.initialized) {
            this.initialized = true;
            return super.createFrame(target);
        }
        return new SwingFramePeer(this.desktop, target);
    }

    @Override
    public LabelPeer createLabel(Label target) {
        return new SwingLabelPeer(target);
    }

    @Override
    public ListPeer createList(List target) {
        return new SwingListPeer(target);
    }

    @Override
    public MenuPeer createMenu(Menu target) {
        return new SwingMenuPeer(target);
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar target) {
        return new SwingMenuBarPeer(target);
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem target) {
        return new SwingMenuItemPeer(target);
    }

    @Override
    public PanelPeer createPanel(Panel target) {
        return new SwingPanelPeer(target);
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu target) {
        return new SwingPopupMenuPeer(target);
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar target) {
        return new SwingScrollbarPeer(target);
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane target) {
        return new SwingScrollPanePeer(target);
    }

    @Override
    public TextAreaPeer createTextArea(TextArea target) {
        return new SwingTextAreaPeer(target);
    }

    @Override
    public TextFieldPeer createTextField(TextField target) {
        return new SwingTextFieldPeer(target);
    }

    @Override
    public WindowPeer createWindow(Window target) {
        return new SwingWindowPeer(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String title) {
        Class<VirtualJFrame> clazz = VirtualJFrame.class;
        synchronized (VirtualJFrame.class) {
            VirtualJFrame.defaultToolkit = this;
            this.desktopFrame = new VirtualJFrame(title);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.desktopFrame.setSize(this.getScreenSize().width, this.getScreenSize().height);
            this.desktop = new JDesktopPane();
            this.desktopFrame.getContentPane().add(this.desktop);
            return;
        }
    }
}

