/*
 * Decompiled with CFR 0.152.
 */
package gnu.rfb;

import gnu.rfb.PixelFormat;
import gnu.rfb.Rect;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

public class Hextile
extends Rect {
    public PixelFormat pixelFormat;
    public Object[] tiles;

    public Hextile(int[] pixels, PixelFormat pixelFormat, int offsetX, int offsetY, int scanline, int x, int y, int w, int h) {
        super(x, y, w, h);
        this.pixelFormat = pixelFormat;
        int[] workPixels = Hextile.copyPixels(pixels, scanline, x - offsetX, y - offsetY, w, h);
        Vector<Object> vector = new Vector<Object>();
        int pixelSize = pixelFormat.bitsPerPixel >> 3;
        int rawMaxSize = pixelSize << 8;
        int currentY = 0;
        while (currentY < h) {
            int currentX = 0;
            while (currentX < w) {
                int tileH;
                int tileW = w - currentX;
                if (tileW > 16) {
                    tileW = 16;
                }
                if ((tileH = h - currentY) > 16) {
                    tileH = 16;
                }
                Tile tile = this.tile(workPixels, w, currentX, currentY, tileW, tileH);
                int tileMaxSize = tile.subrects.length * (2 + pixelSize) + 2 * pixelSize + 1;
                if (tileMaxSize < rawMaxSize) {
                    vector.addElement(tile);
                } else {
                    vector.addElement(this.raw(pixels, scanline, currentX + x, currentY + y, tileW, tileH));
                }
                currentX += 16;
            }
            currentY += 16;
        }
        this.tiles = new Object[vector.size()];
        vector.toArray(this.tiles);
    }

    public Hextile(int x, int y, int w, int h, PixelFormat pixelFormat, Object[] tiles) {
        super(x, y, w, h);
        this.pixelFormat = pixelFormat;
        this.tiles = tiles;
    }

    @Override
    public void writeData(DataOutput output) throws IOException {
        super.writeData(output);
        output.writeInt(5);
        int oldBgpixel = 0x10000000;
        int fgpixel = 0x10000000;
        int i = 0;
        while (i < this.tiles.length) {
            if (this.tiles[i] instanceof Tile) {
                int j;
                Tile tile = (Tile)this.tiles[i];
                int mask = 0;
                if (tile.subrects.length > 0) {
                    mask |= 8;
                    fgpixel = tile.subrects[0].pixel;
                    j = 1;
                    while (j < tile.subrects.length) {
                        if (tile.subrects[j].pixel != fgpixel) {
                            mask |= 0x10;
                            break;
                        }
                        ++j;
                    }
                    if ((mask & 0x10) == 0) {
                        mask |= 4;
                    }
                }
                if (tile.bgpixel != oldBgpixel) {
                    oldBgpixel = tile.bgpixel;
                    mask |= 2;
                }
                output.writeByte(mask);
                if ((mask & 2) != 0) {
                    Hextile.writePixel(output, this.pixelFormat, tile.bgpixel);
                }
                if ((mask & 4) != 0) {
                    Hextile.writePixel(output, this.pixelFormat, fgpixel);
                }
                if ((mask & 8) != 0) {
                    output.writeByte(tile.subrects.length);
                    if ((mask & 0x10) != 0) {
                        j = 0;
                        while (j < tile.subrects.length) {
                            Hextile.writePixel(output, this.pixelFormat, tile.subrects[j].pixel);
                            output.writeByte(tile.subrects[j].x << 4 | tile.subrects[j].y);
                            output.writeByte(tile.subrects[j].w - 1 << 4 | tile.subrects[j].h - 1);
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < tile.subrects.length) {
                            output.writeByte(tile.subrects[j].x << 4 | tile.subrects[j].y);
                            output.writeByte(tile.subrects[j].w - 1 << 4 | tile.subrects[j].h - 1);
                            ++j;
                        }
                    }
                }
            } else {
                output.writeByte(1);
                output.write((byte[])this.tiles[i]);
            }
            ++i;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object[] tilesClone = new Object[this.tiles.length];
        int i = 0;
        while (i < this.tiles.length) {
            if (this.tiles[i] instanceof Tile) {
                Tile tile = (Tile)this.tiles[i];
                Tile tileClone = new Tile();
                tilesClone[i] = tileClone;
                tileClone.bgpixel = tile.bgpixel;
                tileClone.subrects = new SubRect[tile.subrects.length];
                int j = 0;
                while (j < tile.subrects.length) {
                    tileClone.subrects[j] = new SubRect();
                    tileClone.subrects[j].pixel = tile.subrects[j].pixel;
                    tileClone.subrects[j].x = tile.subrects[j].x;
                    tileClone.subrects[j].y = tile.subrects[j].y;
                    tileClone.subrects[j].w = tile.subrects[j].w;
                    tileClone.subrects[j].h = tile.subrects[j].h;
                    ++j;
                }
            } else {
                tilesClone[i] = ((byte[])this.tiles[i]).clone();
            }
            ++i;
        }
        return new Hextile(this.x, this.y, this.w, this.h, this.pixelFormat, tilesClone);
    }

    private Tile tile(int[] pixels, int scanline, int x, int y, int w, int h) {
        Tile tile = new Tile();
        Vector<SubRect> vector = new Vector<SubRect>();
        int firstX = 0;
        int secondX = 0;
        tile.bgpixel = Hextile.getBackground(pixels, scanline, x, y, w, h);
        int currentY = 0;
        while (currentY < h) {
            int line = (currentY + y) * scanline + x;
            int currentX = 0;
            while (currentX < w) {
                if (pixels[line + currentX] != tile.bgpixel) {
                    int runningX;
                    int currentPixel = pixels[line + currentX];
                    int firstY = currentY - 1;
                    boolean firstYflag = true;
                    int runningY = currentY;
                    while (runningY < h) {
                        int segment = (runningY + y) * scanline + x;
                        if (pixels[segment + currentX] != currentPixel) break;
                        runningX = currentX;
                        while (runningX < w && pixels[segment + runningX] == currentPixel) {
                            ++runningX;
                        }
                        --runningX;
                        if (runningY == currentY) {
                            secondX = firstX = runningX;
                        }
                        if (runningX < secondX) {
                            secondX = runningX;
                        }
                        if (firstYflag && runningX >= firstX) {
                            ++firstY;
                        } else {
                            firstYflag = false;
                        }
                        ++runningY;
                    }
                    int secondY = runningY - 1;
                    int firstW = firstX - currentX + 1;
                    int firstH = firstY - currentY + 1;
                    int secondW = secondX - currentX + 1;
                    int secondH = secondY - currentY + 1;
                    SubRect subrect = new SubRect();
                    vector.addElement(subrect);
                    subrect.pixel = currentPixel;
                    subrect.x = currentX;
                    subrect.y = currentY;
                    if (firstW * firstH > secondW * secondH) {
                        subrect.w = firstW;
                        subrect.h = firstH;
                    } else {
                        subrect.w = secondW;
                        subrect.h = secondH;
                    }
                    runningY = subrect.y;
                    while (runningY < subrect.y + subrect.h) {
                        runningX = subrect.x;
                        while (runningX < subrect.x + subrect.w) {
                            pixels[(runningY + y) * scanline + x + runningX] = tile.bgpixel;
                            ++runningX;
                        }
                        ++runningY;
                    }
                }
                ++currentX;
            }
            ++currentY;
        }
        tile.subrects = new SubRect[vector.size()];
        vector.toArray(tile.subrects);
        return tile;
    }

    private byte[] raw(int[] pixels, int scanline, int x, int y, int w, int h) {
        byte[] bytes = null;
        int b = 0;
        int i = 0;
        int s = 0;
        int size = w * h;
        int jump = scanline - w;
        int p = y * scanline + x;
        switch (this.pixelFormat.bitsPerPixel) {
            case 32: {
                bytes = new byte[size << 2];
                while (i < size) {
                    if (s == w) {
                        s = 0;
                        p += jump;
                    }
                    int pixel = this.pixelFormat.translatePixel(pixels[p]);
                    bytes[b++] = (byte)(pixel & 0xFF);
                    bytes[b++] = (byte)(pixel >> 8 & 0xFF);
                    bytes[b++] = (byte)(pixel >> 16 & 0xFF);
                    bytes[b++] = (byte)(pixel >> 24 & 0xFF);
                    ++i;
                    ++s;
                    ++p;
                }
                break;
            }
            case 16: {
                bytes = new byte[size << 1];
                while (i < size) {
                    if (s == w) {
                        s = 0;
                        p += jump;
                    }
                    int pixel = this.pixelFormat.translatePixel(pixels[p]);
                    bytes[b++] = (byte)(pixel & 0xFF);
                    bytes[b++] = (byte)(pixel >> 8 & 0xFF);
                    ++i;
                    ++s;
                    ++p;
                }
                break;
            }
            case 8: {
                bytes = new byte[size];
                while (i < size) {
                    if (s == w) {
                        s = 0;
                        p += jump;
                    }
                    bytes[i] = (byte)this.pixelFormat.translatePixel(pixels[p]);
                    ++i;
                    ++s;
                    ++p;
                }
                break;
            }
        }
        return bytes;
    }

    public static class SubRect {
        public int pixel;
        public int x;
        public int y;
        public int w;
        public int h;
    }

    public static class Tile {
        public int bgpixel;
        public SubRect[] subrects;
    }
}

