/*
 * Decompiled with CFR 0.152.
 */
package gnu.rfb;

import java.awt.color.ColorSpace;
import java.awt.image.DirectColorModel;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;

public class PixelFormat {
    public static final PixelFormat BGR233 = new PixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6);
    public static final PixelFormat RGB888 = new PixelFormat(32, 24, false, true, 255, 255, 255, 16, 8, 0);
    public int bitsPerPixel;
    public int depth;
    public boolean bigEndian;
    public boolean trueColour;
    public int redMax;
    public int greenMax;
    public int blueMax;
    public int redShift;
    public int greenShift;
    public int blueShift;
    private DirectColorModel directColorModel = null;
    private int redMask = -1;
    private int greenMask = -1;
    private int blueMask = -1;
    private int redFix = -1;
    private int greenFix = -1;
    private int blueFix = -1;

    public PixelFormat() {
    }

    public PixelFormat(int bitsPerPixel, int depth, boolean bigEndian, boolean trueColour, int redMax, int greenMax, int blueMax, int redShift, int greenShift, int blueShift) {
        this.bitsPerPixel = bitsPerPixel;
        this.depth = depth;
        this.bigEndian = bigEndian;
        this.trueColour = trueColour;
        this.redMax = redMax;
        this.greenMax = greenMax;
        this.blueMax = blueMax;
        this.redShift = redShift;
        this.greenShift = greenShift;
        this.blueShift = blueShift;
    }

    public PixelFormat(DataInput input) throws IOException {
        this.bitsPerPixel = input.readUnsignedByte();
        this.depth = input.readUnsignedByte();
        this.bigEndian = input.readUnsignedByte() == 1;
        this.trueColour = input.readUnsignedByte() == 1;
        this.redMax = input.readUnsignedShort();
        this.greenMax = input.readUnsignedShort();
        this.blueMax = input.readUnsignedShort();
        this.redShift = input.readUnsignedByte();
        this.greenShift = input.readUnsignedByte();
        this.blueShift = input.readUnsignedByte();
    }

    public PixelFormat(PixelFormat pixelFormat) {
        this.bitsPerPixel = pixelFormat.bitsPerPixel;
        this.depth = pixelFormat.depth;
        this.bigEndian = pixelFormat.bigEndian;
        this.trueColour = pixelFormat.trueColour;
        this.redMax = pixelFormat.redMax;
        this.greenMax = pixelFormat.greenMax;
        this.blueMax = pixelFormat.blueMax;
        this.redShift = pixelFormat.redShift;
        this.greenShift = pixelFormat.greenShift;
        this.blueShift = pixelFormat.blueShift;
    }

    public void writeData(DataOutput output) throws IOException {
        output.writeByte(this.bitsPerPixel);
        output.writeByte(this.depth);
        output.writeByte(this.bigEndian ? 1 : 0);
        output.writeByte(this.trueColour ? 1 : 0);
        output.writeShort(this.redMax);
        output.writeShort(this.greenMax);
        output.writeShort(this.blueMax);
        output.writeByte(this.redShift);
        output.writeByte(this.greenShift);
        output.writeByte(this.blueShift);
    }

    public void print(PrintStream stream) {
        stream.println("Bits-per-pixel: " + this.bitsPerPixel);
        stream.println("Depth:          " + this.depth);
        stream.println("Big Endian:     " + this.bigEndian);
        stream.println("True Colour:    " + this.trueColour);
        if (this.trueColour) {
            stream.println("R max:   " + this.redMax);
            stream.println("G max:   " + this.greenMax);
            stream.println("B max:   " + this.blueMax);
            stream.println("R shift: " + this.redShift);
            stream.println("G shift: " + this.greenShift);
            stream.println("B shift: " + this.blueShift);
        }
    }

    public int translatePixel(int pixel) {
        if (this.redFix != -1) {
            return (pixel & this.redMask) >> this.redFix << this.redShift | (pixel & this.greenMask) >> this.greenFix << this.greenShift | (pixel & this.blueMask) >> this.blueFix << this.blueShift;
        }
        return pixel;
    }

    public DirectColorModel toDirectColorModel() {
        return new DirectColorModel(ColorSpace.getInstance(1000), this.depth, this.redMax << this.redShift, this.greenMax << this.greenShift, this.blueMax << this.blueShift, 0, true, 3);
    }

    public DirectColorModel getDirectColorModel() {
        return this.directColorModel;
    }

    public void setDirectColorModel(DirectColorModel directColorModel) {
        this.directColorModel = directColorModel;
        this.redMask = directColorModel.getRedMask();
        this.greenMask = directColorModel.getGreenMask();
        this.blueMask = directColorModel.getBlueMask();
        this.redFix = PixelFormat.fixColorModel(255, this.redMax, this.redMask);
        this.greenFix = PixelFormat.fixColorModel(255, this.greenMax, this.greenMask);
        this.blueFix = PixelFormat.fixColorModel(255, this.blueMax, this.blueMask);
    }

    private static int fixColorModel(int max1, int max2, int mask) {
        int fix = 0;
        while (fix < 8) {
            if (max1 == max2) break;
            max1 >>= 1;
            ++fix;
        }
        while ((mask & 1) == 0) {
            ++fix;
            mask >>= 1;
        }
        return fix;
    }
}

