/*
 * Decompiled with CFR 0.152.
 */
package gnu.rfb;

import gnu.rfb.PixelFormat;
import gnu.rfb.Rect;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

public class RRE
extends Rect {
    public PixelFormat pixelFormat;
    public int bgpixel;
    public SubRect[] subrects;

    public RRE(int[] pixels, PixelFormat pixelFormat, int offsetX, int offsetY, int scanline, int x, int y, int w, int h) {
        super(x, y, w, h);
        this.pixelFormat = pixelFormat;
        pixels = RRE.copyPixels(pixels, scanline, x - offsetX, y - offsetY, w, h);
        Vector<SubRect> vector = new Vector<SubRect>();
        int firstX = 0;
        int secondX = 0;
        this.bgpixel = RRE.getBackground(pixels, w, 0, 0, w, h);
        int currentY = 0;
        while (currentY < h) {
            int line = currentY * w;
            int currentX = 0;
            while (currentX < w) {
                if (pixels[line + currentX] != this.bgpixel) {
                    int runningX;
                    int currentPixel = pixels[line + currentX];
                    int firstY = currentY - 1;
                    boolean firstYflag = true;
                    int runningY = currentY;
                    while (runningY < h) {
                        int segment = runningY * w;
                        if (pixels[segment + currentX] != currentPixel) break;
                        runningX = currentX;
                        while (runningX < w && pixels[segment + runningX] == currentPixel) {
                            ++runningX;
                        }
                        --runningX;
                        if (runningY == currentY) {
                            secondX = firstX = runningX;
                        }
                        if (runningX < secondX) {
                            secondX = runningX;
                        }
                        if (firstYflag && runningX >= firstX) {
                            ++firstY;
                        } else {
                            firstYflag = false;
                        }
                        ++runningY;
                    }
                    int secondY = runningY - 1;
                    int firstW = firstX - currentX + 1;
                    int firstH = firstY - currentY + 1;
                    int secondW = secondX - currentX + 1;
                    int secondH = secondY - currentY + 1;
                    SubRect subrect = new SubRect();
                    vector.addElement(subrect);
                    subrect.pixel = currentPixel;
                    subrect.x = currentX;
                    subrect.y = currentY;
                    if (firstW * firstH > secondW * secondH) {
                        subrect.w = firstW;
                        subrect.h = firstH;
                    } else {
                        subrect.w = secondW;
                        subrect.h = secondH;
                    }
                    runningY = subrect.y;
                    while (runningY < subrect.y + subrect.h) {
                        runningX = subrect.x;
                        while (runningX < subrect.x + subrect.w) {
                            pixels[runningY * w + runningX] = this.bgpixel;
                            ++runningX;
                        }
                        ++runningY;
                    }
                }
                ++currentX;
            }
            ++currentY;
        }
        this.subrects = new SubRect[vector.size()];
        vector.toArray(this.subrects);
    }

    public RRE(int x, int y, int w, int h, PixelFormat pixelFormat, int bgpixel, SubRect[] subrects) {
        super(x, y, w, h);
        this.pixelFormat = pixelFormat;
        this.bgpixel = bgpixel;
        this.subrects = subrects;
    }

    @Override
    public void writeData(DataOutput output) throws IOException {
        super.writeData(output);
        output.writeInt(2);
        output.writeInt(this.subrects.length);
        RRE.writePixel(output, this.pixelFormat, this.bgpixel);
        int i = 0;
        while (i < this.subrects.length) {
            RRE.writePixel(output, this.pixelFormat, this.subrects[i].pixel);
            output.writeShort(this.subrects[i].x);
            output.writeShort(this.subrects[i].y);
            output.writeShort(this.subrects[i].w);
            output.writeShort(this.subrects[i].h);
            ++i;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SubRect[] subrectsClone = new SubRect[this.subrects.length];
        int i = 0;
        while (i < this.subrects.length) {
            subrectsClone[i] = new SubRect();
            subrectsClone[i].pixel = this.subrects[i].pixel;
            subrectsClone[i].x = this.subrects[i].x;
            subrectsClone[i].y = this.subrects[i].y;
            subrectsClone[i].w = this.subrects[i].w;
            subrectsClone[i].h = this.subrects[i].h;
            ++i;
        }
        return new RRE(this.x, this.y, this.w, this.h, this.pixelFormat, this.bgpixel, subrectsClone);
    }

    public static class SubRect {
        public int pixel;
        public int x;
        public int y;
        public int w;
        public int h;
    }
}

