/*
 * Decompiled with CFR 0.152.
 */
package gnu.vnc;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class WebServer
implements Runnable {
    private int display;
    private String title;
    private int height;
    private int width;
    private URL url;
    private static String serverName = "VNCj";
    private static String[] allowed = new String[]{"/vncviewer.jar", "/animatedMemoryImageSource.class", "/authenticationPanel.class", "/clipboardFrame.class", "/DesCipher.class", "/optionsFrame.class", "/rfbProto.class", "/vncCanvas.class", "/vncviewer.class", "/ButtonPanel.class", "/optionsFrame$1.class", "/optionsFrame$2.class", "/optionsFrame$3.class", "/optionsFrame.class", "/TimeEvent.class", "/TimeOut.class", "/vncviewer$1.class"};

    public WebServer(int display, String title, int width, int height) {
        this.display = display;
        this.title = title;
        this.width = width;
        this.height = height;
        try {
            this.url = new URL("http", InetAddress.getLocalHost().getHostAddress(), 5800 + display, "/");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new Thread(this).start();
    }

    @Override
    public void run() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.url.getPort());
            while (true) {
                new WebServerSocket(serverSocket.accept());
            }
        }
        catch (IOException x) {
            x.printStackTrace();
            return;
        }
    }

    private class WebServerSocket
    implements Runnable {
        private Socket socket;
        private BufferedReader reader;
        private PrintStream print;

        public WebServerSocket(Socket socket) throws IOException {
            this.socket = socket;
            this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.print = new PrintStream(socket.getOutputStream());
            new Thread(this).start();
        }

        @Override
        public void run() {
            try {
                String line;
                Vector<String> request = new Vector<String>();
                String content = null;
                boolean post = false;
                int contentLength = -1;
                while ((line = this.reader.readLine()) != null) {
                    if (line.length() == 0) {
                        if (!post || contentLength <= -1) break;
                        char[] array = new char[contentLength];
                        this.reader.read(array);
                        content = new String(array);
                        request.addElement(content);
                        break;
                    }
                    String lineU = line.toUpperCase();
                    StringTokenizer tokenizer = new StringTokenizer(line);
                    tokenizer.nextToken();
                    if (lineU.startsWith("GET")) {
                        content = tokenizer.nextToken();
                    } else if (lineU.startsWith("POST")) {
                        post = true;
                    } else if (lineU.startsWith("CONTENT-LENGTH")) {
                        contentLength = Integer.parseInt(tokenizer.nextToken());
                    }
                    request.addElement(line);
                }
                this.processRequest(post, content);
                this.print.close();
                this.socket.close();
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }

        private void processRequest(boolean post, String content) throws IOException {
            if (content.equals("/")) {
                this.printApplet();
                return;
            }
            int i = 0;
            while (i < allowed.length) {
                if (allowed[i].equals(content)) {
                    this.printResource(content);
                    return;
                }
                ++i;
            }
            this.printNotFound();
        }

        private void printApplet() {
            this.print.print("HTTP/1.0 200 Document follows\r\nServer: " + serverName + "\r\n" + "Content-Type: text/html\r\n" + "\r\n" + "<!DOCTYPE HTML PUBLIC " + "\"-//W3C//DTD HTML 3.2//EN\">\n" + "<HTML>\n" + "<HEAD>\n" + "<TITLE>" + serverName + " [" + WebServer.this.title + "]</TITLE>\n" + "</HEAD>\n" + "\n" + "<BODY>\n" + "<APPLET CODE=\"vncviewer.class\" HEIGHT=\"" + WebServer.this.height + "\" WIDTH=\"" + WebServer.this.width + "\" ARCHIVE=\"vncviewer.jar\">" + "<PARAM NAME=\"PORT\" VALUE=\"" + (5900 + WebServer.this.display) + "\">\n" + "</APPLET>\n" + "</BODY>\n" + "</HTML>\n");
        }

        private void printNotFound() {
            this.print.print("HTTP/1.0 404 Not found\r\nServer: " + serverName + "\r\n" + "Content-Type: text/html\r\n" + "\r\n" + "<HEAD><TITLE>File Not Found</TITLE></HEAD>\n" + "<BODY><H1>The requested file could not be found</H1></BODY>\n");
        }

        private void printResource(String name) throws IOException {
            InputStream stream;
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if ((name = "resource/" + name).substring(name.length() - 6).equals(".class")) {
                name = String.valueOf(name.substring(0, name.length() - 6)) + ".data";
            }
            if ((stream = ClassLoader.getSystemResourceAsStream(name)) == null) {
                this.printNotFound();
                return;
            }
            this.print.print("HTTP/1.0 200 OK\r\nServer: " + serverName + "\r\n" + "\r\n");
            this.print.write(this.toByteArray(stream));
        }

        private byte[] toByteArray(InputStream stream) throws IOException {
            int bytes;
            int blockSize = 4096;
            ByteArrayOutputStream bytestream = new ByteArrayOutputStream(blockSize);
            byte[] block = new byte[blockSize];
            boolean totalBytes = false;
            while ((bytes = stream.read(block, 0, blockSize)) > -1) {
                bytestream.write(block, 0, bytes);
            }
            return bytestream.toByteArray();
        }
    }
}

